/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// cssgeneratorfactory.cc

#include <assert.h>

#include "cssgeneratorfactory.h"

#include "cssdecorator.h"

// the createXXXXDecorator must not be called, since the more general
// method, createGenerator, is redefined for CSS.

TextGenerator *
CssGeneratorFactory::createBoldDecorator(TextGenerator *gen)
{
  assert (0);

  return 0;
}

TextGenerator *
CssGeneratorFactory::createItalicDecorator(TextGenerator *gen)
{
  assert (0);

  return 0;
}

TextGenerator *
CssGeneratorFactory::createUnderlineDecorator(TextGenerator *gen)
{
  assert (0);

  return 0;
}

TextGenerator *
CssGeneratorFactory::createColorDecorator(TextGenerator *gen, const string &color)
{
  assert (0);

  return 0;
}

TextGenerator *
CssGeneratorFactory::createGenerator( TextGenerator *final_dec, const string &key )
{
  return new SpanDecorator( final_dec, char_translator, key ) ;
}
