/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import {
  FormMetadata,
  InternationalizationAPI,
} from "@gnu-taler/web-util/browser";
import { simplest } from "./simplest.js";
import { personalInfo } from "./personal-info.js";
import { nameAndDob } from "./nameAndBirthdate.js";

export const preloadedForms: (
  i18n: InternationalizationAPI,
) => Array<FormMetadata> = (i18n) => [
  {
    label: i18n.str`Simple comment`,
    id: "__simple_comment",
    version: 1,
    config: simplest(i18n),
  },
  {
    label: i18n.str`Personal info`,
    id: "personal-info",
    version: 1,
    config: personalInfo(i18n),
  },
  {
    label: i18n.str`Name and birthdate`,
    id: "name_and_dob",
    version: 1,
    config: nameAndDob(i18n),
  },
];
