/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.IOException;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.core.index.impl.EntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.WordEntry;

public abstract class IndexInput {
    protected int filePosition = 1;
    protected WordEntry currentWordEntry;
    protected int wordPosition = 1;

    public abstract void clearCache();

    public abstract void close() throws IOException;

    public abstract IndexedFile getCurrentFile() throws IOException;

    public WordEntry getCurrentWordEntry() {
        if (!this.hasMoreWords()) {
            return null;
        }
        return this.currentWordEntry;
    }

    public int getFilePosition() {
        return this.filePosition;
    }

    public abstract IndexedFile getIndexedFile(int var1) throws IOException;

    public abstract IndexedFile getIndexedFile(SearchDocument var1) throws IOException;

    public abstract int getNumFiles();

    public abstract int getNumWords();

    public abstract Object getSource();

    public boolean hasMoreFiles() {
        return this.getFilePosition() <= this.getNumFiles();
    }

    public boolean hasMoreWords() {
        return this.wordPosition <= this.getNumWords();
    }

    public abstract void moveToNextFile();

    public abstract void moveToNextWordEntry() throws IOException;

    public abstract void open() throws IOException;

    public abstract String[] query(String var1) throws IOException;

    public abstract EntryResult[] queryEntries(char[] var1, int var2) throws IOException;

    public abstract EntryResult[] queryEntriesPrefixedBy(char[] var1) throws IOException;

    public abstract String[] queryFilesReferringToPrefix(char[] var1) throws IOException;

    public abstract String[] queryInDocumentNames(String var1) throws IOException;

    protected abstract void setFirstFile() throws IOException;

    protected abstract void setFirstWord() throws IOException;
}

