/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ChildDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;

public class ParentChildMapping
implements IDocumentInformationMapping {
    private IDocument fParentDocument;
    private ChildDocument fChildDocument;

    public ParentChildMapping(ChildDocument childDocument) {
        this.fParentDocument = childDocument.getParentDocument();
        this.fChildDocument = childDocument;
    }

    public IRegion getCoverage() {
        Position p = this.fChildDocument.getParentDocumentRange();
        return new Region(p.getOffset(), p.getLength());
    }

    public int toOriginOffset(int imageOffset) throws BadLocationException {
        int anchorOffset = this.fChildDocument.getParentDocumentRange().getOffset();
        return anchorOffset + imageOffset;
    }

    public IRegion toOriginRegion(IRegion imageRegion) throws BadLocationException {
        int anchorOffset = this.fChildDocument.getParentDocumentRange().getOffset();
        return new Region(anchorOffset + imageRegion.getOffset(), imageRegion.getLength());
    }

    public IRegion toOriginLines(int imageLine) throws BadLocationException {
        IRegion imageDocumentRegion = this.fChildDocument.getLineInformation(imageLine);
        IRegion originDocumentRegion = this.toOriginRegion(imageDocumentRegion);
        int startLine = this.fParentDocument.getLineOfOffset(originDocumentRegion.getOffset());
        if (originDocumentRegion.getLength() == 0) {
            return new Region(startLine, 0);
        }
        int endLine = this.fParentDocument.getLineOfOffset(originDocumentRegion.getOffset() + originDocumentRegion.getLength() - 1);
        return new Region(startLine, endLine - startLine);
    }

    public int toOriginLine(int imageLine) throws BadLocationException {
        int anchorOffset = this.fChildDocument.getParentDocumentRange().getOffset();
        return this.fParentDocument.getLineOfOffset(anchorOffset) + imageLine;
    }

    public int toImageOffset(int originOffset) throws BadLocationException {
        Position p = this.fChildDocument.getParentDocumentRange();
        if (p.includes(originOffset)) {
            return originOffset - p.getOffset();
        }
        return -1;
    }

    public IRegion toImageRegion(IRegion originRegion) throws BadLocationException {
        Position p;
        int offset = originRegion.getOffset();
        int length = originRegion.getLength();
        if (length < 0) {
            length = -length;
            offset -= length;
        }
        if ((p = this.fChildDocument.getParentDocumentRange()).overlapsWith(offset, length)) {
            int e;
            int end;
            if (offset < p.getOffset()) {
                offset = p.getOffset();
            }
            if ((end = offset + length) > (e = p.getOffset() + p.getLength())) {
                end = e;
            }
            offset -= p.getOffset();
            end -= p.getOffset();
            if (originRegion.getLength() < 0) {
                return new Region(end, offset - end);
            }
            return new Region(offset, end - offset);
        }
        return null;
    }

    public int toImageLine(int originLine) throws BadLocationException {
        int anchorOffset = this.fChildDocument.getParentDocumentRange().getOffset();
        int startLine = this.fParentDocument.getLineOfOffset(anchorOffset);
        int imageLine = originLine - startLine;
        if (imageLine < 0 || imageLine > this.fChildDocument.getNumberOfLines()) {
            return -1;
        }
        return imageLine;
    }

    public int toClosestImageLine(int originLine) throws BadLocationException {
        int anchorOffset = this.fChildDocument.getParentDocumentRange().getOffset();
        int startLine = this.fParentDocument.getLineOfOffset(anchorOffset);
        int imageLine = originLine - startLine;
        if (imageLine < 0) {
            return 0;
        }
        int maxLine = this.fChildDocument.getNumberOfLines();
        if (imageLine > maxLine) {
            return maxLine;
        }
        return imageLine;
    }
}

