/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class VersionedStringProperty {
    int majorVersion;
    int minorVersion;
    int subminorVersion;
    boolean preferredValue = false;
    String propertyInfo;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    VersionedStringProperty(String property) {
        property = property.trim();
        if (property.startsWith("*")) {
            property = property.substring(1);
            this.preferredValue = true;
        }
        if (property.startsWith(">")) {
            property = property.substring(1);
            int charPos = 0;
            charPos = 0;
            while (charPos < property.length()) {
                char c = property.charAt(charPos);
                if (!Character.isWhitespace(c) && !Character.isDigit(c) && c != '.') break;
                ++charPos;
            }
            String versionInfo = property.substring(0, charPos);
            List versionParts = StringUtils.split(versionInfo, ".", true);
            this.majorVersion = Integer.parseInt(versionParts.get(0).toString());
            this.minorVersion = versionParts.size() > 1 ? Integer.parseInt(versionParts.get(1).toString()) : 0;
            this.subminorVersion = versionParts.size() > 2 ? Integer.parseInt(versionParts.get(2).toString()) : 0;
            this.propertyInfo = property.substring(charPos);
        } else {
            this.subminorVersion = 0;
            this.minorVersion = 0;
            this.majorVersion = 0;
            this.propertyInfo = property;
        }
    }

    VersionedStringProperty(String property, int major, int minor, int subminor) {
        this.propertyInfo = property;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.subminorVersion = subminor;
    }

    /*
     * WARNING - void declaration
     */
    boolean isOkayForVersion(Connection connection) throws SQLException {
        void conn;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)connection2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = conn.versionMeetsMinimum(this.majorVersion, this.minorVersion, this.subminorVersion);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.propertyInfo;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    static {
        Factory factory = new Factory("CharsetMapping.java", Class.forName("com.mysql.jdbc.VersionedStringProperty"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isOkayForVersion-com.mysql.jdbc.VersionedStringProperty-com.mysql.jdbc.Connection:-conn:-java.sql.SQLException:-boolean-"), 620);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.VersionedStringProperty----java.lang.String-"), 625);
    }
}

