/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IDependent;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class ReferenceBinding
extends TypeBinding
implements IDependent {
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return !this.isAbstract() && !this.isInterface();
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        boolean ret = this.innerCanBeSeenBy(receiverType, invocationType);
        if (ret) {
            return true;
        }
        if (Scope.findPrivilegedHandler(invocationType) != null) {
            Scope.findPrivilegedHandler(invocationType).notePrivilegedTypeAccess(this, null);
            return true;
        }
        return false;
    }

    private final boolean innerCanBeSeenBy(ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        ReferenceBinding declaringClass;
        if (this.isPublic()) {
            return true;
        }
        if (invocationType == this && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this) {
                return true;
            }
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass2 = this.enclosingType();
            if (declaringClass2 == null) {
                return false;
            }
            do {
                if (declaringClass2 == invocationType) {
                    return true;
                }
                if (!declaringClass2.isSuperclassOf(currentType)) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (receiverType != this && receiverType != this.enclosingType()) {
                return false;
            }
            if (invocationType != this) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding type = receiverType;
        ReferenceBinding referenceBinding = declaringClass = this.enclosingType() == null ? this : this.enclosingType();
        do {
            if (declaringClass == type) {
                return true;
            }
            if (this.fPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        boolean ret = this.innerCanBeSeenBy(scope);
        if (ret) {
            return true;
        }
        SourceTypeBinding invocationType = scope.invocationType();
        if (Scope.findPrivilegedHandler(invocationType) != null) {
            Scope.findPrivilegedHandler(invocationType).notePrivilegedTypeAccess(this, null);
            return true;
        }
        return false;
    }

    private final boolean innerCanBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        if (scope.kind == 4) {
            return this.canBeSeenBy(((CompilationUnitScope)scope).fPackage);
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass = this.enclosingType();
            if (declaringClass == null) {
                return false;
            }
            do {
                if (declaringClass == invocationType) {
                    return true;
                }
                if (!declaringClass.isSuperclassOf(currentType)) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = this;
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.fPackage;
    }

    public void computeId() {
        if (this.compoundName.length != 3) {
            if (this.compoundName.length == 4 && CharOperation.equals(TypeConstants.JAVA_LANG_REFLECT_CONSTRUCTOR, this.compoundName)) {
                this.id = 20;
                return;
            }
            return;
        }
        if (!CharOperation.equals(TypeConstants.JAVA, this.compoundName[0])) {
            return;
        }
        if (!CharOperation.equals(TypeConstants.LANG, this.compoundName[1])) {
            if (CharOperation.equals(TypeConstants.JAVA_IO_PRINTSTREAM, this.compoundName)) {
                this.id = 24;
                return;
            }
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_OBJECT, this.compoundName)) {
            this.id = 1;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_STRING, this.compoundName)) {
            this.id = 11;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_THROWABLE, this.compoundName)) {
            this.id = 21;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_ERROR, this.compoundName)) {
            this.id = 19;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_EXCEPTION, this.compoundName)) {
            this.id = 25;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_CLASSNOTFOUNDEXCEPTION, this.compoundName)) {
            this.id = 23;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_NOCLASSDEFERROR, this.compoundName)) {
            this.id = 22;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_CLASS, this.compoundName)) {
            this.id = 16;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_STRINGBUFFER, this.compoundName)) {
            this.id = 17;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_SYSTEM, this.compoundName)) {
            this.id = 18;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_INTEGER, this.compoundName)) {
            this.id = 29;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_BYTE, this.compoundName)) {
            this.id = 26;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_CHARACTER, this.compoundName)) {
            this.id = 28;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_FLOAT, this.compoundName)) {
            this.id = 31;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_DOUBLE, this.compoundName)) {
            this.id = 32;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_BOOLEAN, this.compoundName)) {
            this.id = 33;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_SHORT, this.compoundName)) {
            this.id = 27;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_LONG, this.compoundName)) {
            this.id = 30;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_VOID, this.compoundName)) {
            this.id = 34;
            return;
        }
        if (CharOperation.equals(TypeConstants.JAVA_LANG_ASSERTIONERROR, this.compoundName)) {
            this.id = 35;
            return;
        }
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int depth = 0;
        ReferenceBinding current = this;
        while ((current = current.enclosingType()) != null) {
            ++depth;
        }
        return depth;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public final ReferenceBinding enclosingTypeAt(int relativeDepth) {
        ReferenceBinding current = this;
        while (relativeDepth-- > 0 && current != null) {
            current = current.enclosingType();
        }
        return current;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return TypeConstants.NoFields;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean resolve, InvocationSite site, Scope scope) {
        return this.getField(fieldName, resolve);
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding[] memberTypes = this.memberTypes();
        int i = memberTypes.length;
        while (--i >= 0) {
            if (!CharOperation.equals(memberTypes[i].sourceName, typeName)) continue;
            return memberTypes[i];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        return TypeConstants.NoMethods;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public boolean implementsInterface(ReferenceBinding anInterface, boolean searchHierarchy) {
        if (this == anInterface) {
            return true;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        ReferenceBinding currentType = this;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == TypeConstants.NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while (searchHierarchy && (currentType = currentType.superclass()) != null);
        int i = 0;
        while (i <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType == anInterface) {
                    return true;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding method) {
        ReferenceBinding type = this;
        while (type != null) {
            MethodBinding[] methods = type.getMethods(method.selector);
            int i = methods.length;
            while (--i >= 0) {
                if (!methods[i].areParametersEqual(method)) continue;
                return true;
            }
            type = type.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40) != 0;
    }

    public final boolean isClass() {
        return (this.modifiers & 0x200) == 0;
    }

    public boolean isCompatibleWith(TypeBinding right) {
        if (right == this) {
            return true;
        }
        if (right.id == 1) {
            return true;
        }
        if (!(right instanceof ReferenceBinding)) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)right;
        if (referenceBinding.isInterface()) {
            return this.implementsInterface(referenceBinding, true);
        }
        if (this.isInterface()) {
            return false;
        }
        return referenceBinding.isSuperclassOf(this);
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10) != 0;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8) != 0;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPrivateUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4) == 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding type) {
        do {
            if (this != (type = type.superclass())) continue;
            return true;
        } while (type != null);
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x100000) != 0 || (this.modifiers & 0x200000) != 0;
    }

    public ReferenceBinding[] memberTypes() {
        return TypeConstants.NoMemberTypes;
    }

    public MethodBinding[] methods() {
        return TypeConstants.NoMethods;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.');
        }
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public char[] shortReadableName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.');
        }
        return this.sourceName;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return TypeConstants.NoSuperInterfaces;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType == null) {
            return null;
        }
        return new ReferenceBinding[]{enclosingType};
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }
}

