/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.EscapeTokenizer;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class EscapeProcessor {
    private static Map JDBC_CONVERT_TO_MYSQL_TYPE_MAP;
    private static Map JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    static {
        Factory factory = new Factory("EscapeProcessor.java", Class.forName("com.mysql.jdbc.EscapeProcessor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("19-escapeSQL-com.mysql.jdbc.EscapeProcessor-java.lang.String:boolean:-sql:serverSupportsConvertFn:-java.sql.SQLException:-java.lang.Object-"), 99);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-processConvertToken-com.mysql.jdbc.EscapeProcessor-java.lang.String:boolean:-functionToken:serverSupportsConvertFn:-java.sql.SQLException:-java.lang.String-"), 430);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-removeWhitespace-com.mysql.jdbc.EscapeProcessor-java.lang.String:-toCollapse:--java.lang.String-"), 534);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("BIGINT", "0 + ?");
        tempMap.put("BINARY", "BINARY");
        tempMap.put("BIT", "0 + ?");
        tempMap.put("CHAR", "CHAR");
        tempMap.put("DATE", "DATE");
        tempMap.put("DECIMAL", "0.0 + ?");
        tempMap.put("DOUBLE", "0.0 + ?");
        tempMap.put("FLOAT", "0.0 + ?");
        tempMap.put("INTEGER", "0 + ?");
        tempMap.put("LONGVARBINARY", "BINARY");
        tempMap.put("LONGVARCHAR", "CONCAT(?)");
        tempMap.put("REAL", "0.0 + ?");
        tempMap.put("SMALLINT", "CONCAT(?)");
        tempMap.put("TIME", "TIME");
        tempMap.put("TIMESTAMP", "DATETIME");
        tempMap.put("TINYINT", "CONCAT(?)");
        tempMap.put("VARBINARY", "BINARY");
        tempMap.put("VARCHAR", "CONCAT(?)");
        JDBC_CONVERT_TO_MYSQL_TYPE_MAP = Collections.unmodifiableMap(tempMap);
        tempMap = new HashMap(JDBC_CONVERT_TO_MYSQL_TYPE_MAP);
        tempMap.put("BINARY", "CONCAT(?)");
        tempMap.put("CHAR", "CONCAT(?)");
        tempMap.remove("DATE");
        tempMap.put("LONGVARBINARY", "CONCAT(?)");
        tempMap.remove("TIME");
        tempMap.remove("TIMESTAMP");
        tempMap.put("VARBINARY", "CONCAT(?)");
        JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP = Collections.unmodifiableMap(tempMap);
    }

    EscapeProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    public static final Object escapeSQL(String string, boolean bl) throws SQLException {
        Object object;
        String sql;
        String string2 = string;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        if (sql == null) {
            object = null;
        } else {
            int nextEndBrace;
            int beginBrace = sql.indexOf(123);
            int n = nextEndBrace = beginBrace == -1 ? -1 : sql.indexOf(125, beginBrace);
            if (nextEndBrace == -1) {
                object = sql;
            } else {
                StringBuffer newSql = new StringBuffer();
                EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
                byte usesVariables = 0;
                boolean callingStoredFunction = false;
                while (escapeTokenizer.hasMoreTokens()) {
                    String token = escapeTokenizer.nextToken();
                    if (token.length() == 0) continue;
                    if (token.charAt(0) == '{') {
                        String day2;
                        String month2;
                        String year4;
                        StringTokenizer st;
                        String argument;
                        String collapsedToken;
                        void serverSupportsConvertFn;
                        int nestedBrace;
                        if (!token.endsWith("}")) {
                            throw new SQLException("Not a valid escape sequence: " + token);
                        }
                        if (token.length() > 2 && (nestedBrace = token.indexOf(123, 2)) != -1) {
                            StringBuffer buf = new StringBuffer(token.substring(0, 1));
                            Object remainingResults = EscapeProcessor.escapeSQL(token.substring(1, token.length() - 1), (boolean)serverSupportsConvertFn);
                            String remaining = null;
                            if (remainingResults instanceof String) {
                                remaining = (String)remainingResults;
                            } else {
                                remaining = ((EscapeProcessorResult)remainingResults).escapedSql;
                                if (usesVariables != 1) {
                                    usesVariables = ((EscapeProcessorResult)remainingResults).usesVariables;
                                }
                            }
                            buf.append(remaining);
                            buf.append('}');
                            token = buf.toString();
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken = EscapeProcessor.removeWhitespace(token), "{escape")) {
                            try {
                                StringTokenizer st2 = new StringTokenizer(token, " '");
                                st2.nextToken();
                                escapeSequence = st2.nextToken();
                                if (escapeSequence.length() < 3) {
                                    throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                                }
                                escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                                replaceEscapeSequence = true;
                                continue;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw new SQLException("Syntax error for escape sequence '" + token + "'", "42000");
                            }
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{fn")) {
                            int endPos;
                            int startPos = token.toLowerCase().indexOf("fn ") + 3;
                            String fnToken = token.substring(startPos, endPos = token.length() - 1);
                            if (StringUtils.startsWithIgnoreCaseAndWs(fnToken, "convert")) {
                                newSql.append(EscapeProcessor.processConvertToken(fnToken, (boolean)serverSupportsConvertFn));
                                continue;
                            }
                            newSql.append(fnToken);
                            continue;
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{d")) {
                            int startPos = token.indexOf(39) + 1;
                            int endPos = token.lastIndexOf(39);
                            if (startPos == -1 || endPos == -1) {
                                throw new SQLException("Syntax error for DATE escape sequence '" + token + "'", "42000");
                            }
                            argument = token.substring(startPos, endPos);
                            try {
                                st = new StringTokenizer(argument, " -");
                                year4 = st.nextToken();
                                month2 = st.nextToken();
                                day2 = st.nextToken();
                                String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                                newSql.append(dateString);
                                continue;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw new SQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000");
                            }
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{ts")) {
                            int startPos = token.indexOf(39) + 1;
                            int endPos = token.lastIndexOf(39);
                            if (startPos == -1 || endPos == -1) {
                                throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + token + "'", "42000");
                            }
                            argument = token.substring(startPos, endPos);
                            try {
                                st = new StringTokenizer(argument, " .-:");
                                year4 = st.nextToken();
                                month2 = st.nextToken();
                                day2 = st.nextToken();
                                String hour = st.nextToken();
                                String minute = st.nextToken();
                                String second = st.nextToken();
                                newSql.append("'").append(year4).append("-").append(month2).append("-").append(day2).append(" ").append(hour).append(":").append(minute).append(":").append(second).append("'");
                                continue;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000");
                            }
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{t")) {
                            int startPos = token.indexOf(39) + 1;
                            int endPos = token.lastIndexOf(39);
                            if (startPos == -1 || endPos == -1) {
                                throw new SQLException("Syntax error for TIME escape sequence '" + token + "'", "42000");
                            }
                            argument = token.substring(startPos, endPos);
                            try {
                                st = new StringTokenizer(argument, " :");
                                String hour = st.nextToken();
                                String minute = st.nextToken();
                                String second = st.nextToken();
                                String timeString = "'" + hour + ":" + minute + ":" + second + "'";
                                newSql.append(timeString);
                                continue;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw new SQLException("Syntax error for escape sequence '" + argument + "'", "42000");
                            }
                        }
                        if (StringUtils.startsWithIgnoreCase(collapsedToken, "{call") || StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                            int startPos = StringUtils.indexOfIgnoreCase(token, "CALL") + 5;
                            int endPos = token.length() - 1;
                            if (StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                                callingStoredFunction = true;
                                newSql.append("SELECT ");
                                newSql.append(token.substring(startPos, endPos));
                                continue;
                            }
                            callingStoredFunction = false;
                            newSql.append("CALL ");
                            newSql.append(token.substring(startPos, endPos));
                            continue;
                        }
                        if (!StringUtils.startsWithIgnoreCase(collapsedToken, "{oj")) continue;
                        newSql.append(token);
                        continue;
                    }
                    newSql.append(token);
                }
                String escapedSql = newSql.toString();
                if (replaceEscapeSequence) {
                    String currentSql = escapedSql;
                    while (currentSql.indexOf(escapeSequence) != -1) {
                        int escapePos = currentSql.indexOf(escapeSequence);
                        String lhs = currentSql.substring(0, escapePos);
                        String rhs = currentSql.substring(escapePos + 1, currentSql.length());
                        currentSql = String.valueOf(lhs) + "\\" + rhs;
                    }
                    escapedSql = currentSql;
                }
                EscapeProcessorResult epr = new EscapeProcessorResult();
                epr.escapedSql = escapedSql;
                epr.callingStoredFunction = callingStoredFunction;
                if (usesVariables != 1) {
                    epr.usesVariables = escapeTokenizer.sawVariableUse() ? (byte)1 : 0;
                }
                object = epr;
            }
        }
        String string3 = object;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string3, joinPoint);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static String processConvertToken(String string, boolean bl) throws SQLException {
        String string2;
        void serverSupportsConvertFn;
        String functionToken;
        String string3 = string;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string3, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int firstIndexOfParen = functionToken.indexOf("(");
        if (firstIndexOfParen == -1) {
            throw new SQLException("Syntax error while processing {fn convert (... , ...)} token, missing opening parenthesis in token '" + functionToken + "'.", "42000");
        }
        functionToken.length();
        int indexOfComma = functionToken.lastIndexOf(",");
        if (indexOfComma == -1) {
            throw new SQLException("Syntax error while processing {fn convert (... , ...)} token, missing comma in token '" + functionToken + "'.", "42000");
        }
        int indexOfCloseParen = functionToken.indexOf(41, indexOfComma);
        if (indexOfCloseParen == -1) {
            throw new SQLException("Syntax error while processing {fn convert (... , ...)} token, missing closing parenthesis in token '" + functionToken + "'.", "42000");
        }
        String expression = functionToken.substring(firstIndexOfParen + 1, indexOfComma);
        String type = functionToken.substring(indexOfComma + 1, indexOfCloseParen);
        String newType = null;
        String trimmedType = type.trim();
        if (StringUtils.startsWithIgnoreCase(trimmedType, "SQL_")) {
            trimmedType = trimmedType.substring(4, trimmedType.length());
        }
        if (serverSupportsConvertFn != false) {
            newType = (String)JDBC_CONVERT_TO_MYSQL_TYPE_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
        } else {
            newType = (String)JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
            if (newType == null) {
                throw new SQLException("Can't find conversion re-write for type '" + type + "' that is applicable for this server version while processing escape tokens.", "S1000");
            }
        }
        if (newType == null) {
            throw new SQLException("Unsupported conversion type '" + type.trim() + "' found while processing escape token.", "S1000");
        }
        int replaceIndex = newType.indexOf("?");
        if (replaceIndex != -1) {
            StringBuffer convertRewrite = new StringBuffer(newType.substring(0, replaceIndex));
            convertRewrite.append(expression);
            convertRewrite.append(newType.substring(replaceIndex + 1, newType.length()));
            string2 = convertRewrite.toString();
        } else {
            StringBuffer castRewrite = new StringBuffer("CAST(");
            castRewrite.append(expression);
            castRewrite.append(" AS ");
            castRewrite.append(newType);
            castRewrite.append(")");
            string2 = castRewrite.toString();
        }
        String string4 = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string4, joinPoint);
        return string2;
    }

    private static String removeWhitespace(String string) {
        String string2;
        String toCollapse;
        String string3 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)string3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (toCollapse == null) {
            string2 = null;
        } else {
            int length = toCollapse.length();
            StringBuffer collapsed = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                char c = toCollapse.charAt(i);
                if (!Character.isWhitespace(c)) {
                    collapsed.append(c);
                }
                ++i;
            }
            string2 = collapsed.toString();
        }
        String string4 = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string4, joinPoint);
        return string2;
    }
}

