/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class StandardSocketFactory
implements SocketFactory {
    protected String host = null;
    protected int port = 3306;
    protected Socket rawSocket = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public Socket afterHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket connect(String string, int n, Properties properties) throws SocketException, IOException {
        void portNumber;
        void hostname;
        void props;
        String string2 = string;
        int n2 = n;
        Properties properties2 = properties;
        Object[] objectArray = new Object[]{string2, Conversions.intObject((int)n2), properties2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (props == null) throw new SocketException("Unable to create socket");
        this.host = hostname;
        this.port = portNumber;
        boolean hasConnectTimeoutMethod = false;
        Method connectWithTimeoutMethod = null;
        try {
            Class<?> socketAddressClass = Class.forName("java.net.SocketAddress");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            connectWithTimeoutMethod = clazz.getMethod("connect", socketAddressClass, Integer.TYPE);
            hasConnectTimeoutMethod = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            hasConnectTimeoutMethod = false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            hasConnectTimeoutMethod = false;
        }
        catch (Throwable throwable) {
            hasConnectTimeoutMethod = false;
        }
        int connectTimeout = 0;
        String connectTimeoutStr = props.getProperty("connectTimeout");
        if (connectTimeoutStr != null) {
            try {
                connectTimeout = Integer.parseInt(connectTimeoutStr);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
            }
        }
        if (this.host == null) throw new SocketException("Unable to create socket");
        if (!hasConnectTimeoutMethod || connectTimeout == 0) {
            InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
            Exception caughtWhileConnecting = null;
            int i = 0;
            while (i < possibleAddresses.length) {
                try {
                    this.rawSocket = new Socket(possibleAddresses[i], this.port);
                    break;
                }
                catch (Exception ex) {
                    caughtWhileConnecting = ex;
                    ++i;
                }
            }
            if (this.rawSocket == null) {
                throw new SocketException(caughtWhileConnecting.toString());
            }
        } else {
            try {
                Class<?> inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.net.InetAddress");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                classArray[1] = Integer.TYPE;
                Constructor<?> addrConstructor = inetSocketAddressClass.getConstructor(classArray);
                InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                Throwable caughtWhileConnecting = null;
                int i = 0;
                while (i < possibleAddresses.length) {
                    try {
                        Object sockAddr = addrConstructor.newInstance(possibleAddresses[i], new Integer(this.port));
                        this.rawSocket = new Socket();
                        connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                        break;
                    }
                    catch (Exception ex) {
                        this.rawSocket = null;
                        caughtWhileConnecting = ex;
                        ++i;
                    }
                }
                if (this.rawSocket == null) {
                    throw new SocketException(caughtWhileConnecting.toString());
                }
            }
            catch (Throwable t) {
                if (t instanceof SocketException) throw (SocketException)t;
                throw new SocketException(t.toString());
            }
        }
        try {
            this.rawSocket.setTcpNoDelay(true);
        }
        catch (Exception exception) {}
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    static {
        Factory factory = new Factory("StandardSocketFactory.java", Class.forName("com.mysql.jdbc.StandardSocketFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-com.mysql.jdbc.StandardSocketFactory-java.lang.String:int:java.util.Properties:-hostname:portNumber:props:-java.net.SocketException:java.io.IOException:-java.net.Socket-"), 96);
    }
}

