/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;

public class ObjectID
implements Insertable {
    private static final int Size = 8;
    private static final int ObjectNumberOffset = 0;
    private long objectNumber;

    public ObjectID(byte[] b) throws IndexedStoreException {
        if (b.length != 8) {
            throw new IndexedStoreException(31);
        }
        Buffer buf = new Buffer(b);
        this.objectNumber = buf.getLong(0, 8);
    }

    public ObjectID(long objectNumber) {
        this.objectNumber = objectNumber;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof ObjectID)) {
            return false;
        }
        ObjectID id = (ObjectID)anObject;
        return this.objectNumber == id.objectNumber;
    }

    public int hashCode() {
        return (int)this.objectNumber;
    }

    public byte[] toByteArray() {
        Buffer buf = new Buffer(8);
        buf.put(0, 8, this.objectNumber);
        return buf.get();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("id(");
        b.append(this.objectNumber);
        b.append(")");
        return b.toString();
    }
}

