/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.jdom.DOMNode;
import org.eclipse.jdt.internal.core.util.Util;

public class CreatePackageDeclarationOperation
extends CreateElementInCUOperation {
    protected String fName = null;

    public CreatePackageDeclarationOperation(String name, ICompilationUnit parentElement) {
        super(parentElement);
        this.fName = name;
    }

    protected IDOMNode generateElementDOM() throws JavaModelException {
        IJavaElement[] children = this.getCompilationUnit().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 11) {
                IPackageDeclaration pck = (IPackageDeclaration)children[i];
                IDOMPackage pack = (IDOMPackage)((JavaElement)((Object)pck)).findNode(this.fCUDOM);
                if (!pack.getName().equals(this.fName)) {
                    DOMNode node = (DOMNode)((Object)pack);
                    this.fInsertionPosition = node.getStartPosition();
                    this.fReplacementLength = node.getEndPosition() - this.fInsertionPosition + 1;
                    pack.setName(this.fName);
                    this.fCreatedElement = (DOMNode)((Object)pack);
                } else {
                    this.fCreationOccurred = false;
                }
                return null;
            }
            ++i;
        }
        IDOMPackage pack = new DOMFactory().createPackage();
        pack.setName(this.fName);
        return pack;
    }

    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getPackageDeclaration(this.fName);
    }

    public String getMainTaskName() {
        return Util.bind("operation.createPackageProgress");
    }

    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createBefore(imports[0]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (JavaConventions.validatePackageName(this.fName).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

