/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BindValue;
import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.CallableStatement;
import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.ConnectionProperties;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.LicenseConfiguration;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.MysqlSavepoint;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.ServerPreparedStatement;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.log.LogFactory;
import com.mysql.jdbc.log.NullLogger;
import com.mysql.jdbc.profiler.ProfileEventSink;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.util.LRUCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;

public class Connection
extends ConnectionProperties
implements java.sql.Connection {
    private static final String PING_COMMAND = "SELECT 1";
    private static Map mapTransIsolationNameToValue = null;
    private static final Map serverConfigByUrl = new HashMap();
    private static final Map serverCollationByUrl = new HashMap();
    public static Map charsetMap;
    private Map charsetToNumBytesMap;
    private static Map multibyteCharsetsMap;
    protected static final String DEFAULT_LOGGER_CLASS = "com.mysql.jdbc.log.StandardLogger";
    private static final String LOGGER_INSTANCE_NAME = "MySQL";
    private static final Log NULL_LOGGER;
    private static final Object CHARSET_CONVERTER_NOT_AVAILABLE_MARKER;
    private static Map roundRobinStatsMap;
    private static final int HISTOGRAM_BUCKETS = 20;
    private DatabaseMetaData dbmd = null;
    private LRUCache parsedCallableStatementCache;
    private List hostList = null;
    private Log log = NULL_LOGGER;
    private Map cachedPreparedStatementParams;
    private Map charsetConverterMap = new HashMap(CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.size());
    private Map openStatements;
    private Map serverVariables = null;
    private Map statementsUsingMaxRows;
    private Map typeMap;
    private MysqlIO io = null;
    private final Object mutex = new Object();
    private ProfileEventSink eventSink;
    private Properties props = null;
    private String database = null;
    private String host = null;
    private String myURL = null;
    private String password = null;
    private String user = null;
    private Throwable forceClosedReason;
    private Throwable forcedClosedLocation;
    private Throwable pointOfOrigin;
    private TimeZone defaultTimeZone;
    private TimeZone serverTimezoneTZ = null;
    private boolean isServerTzUTC = false;
    private String[] indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
    private long[] perfMetricsHistBreakpoints;
    private int[] perfMetricsHistCounts;
    private boolean autoCommit = true;
    private boolean failedOver = false;
    private boolean hasIsolationLevels = false;
    private boolean hasQuotedIdentifiers = false;
    private boolean isClosed = true;
    private boolean lowerCaseTableNames = false;
    private boolean maxRowsChanged = false;
    private boolean needsPing = false;
    private boolean parserKnowsUnicode = false;
    private boolean readInfoMsg = false;
    private boolean readOnly = false;
    private boolean transactionsSupported = false;
    private boolean useAnsiQuotes = false;
    private boolean useFastPing = false;
    private boolean useServerPreparedStmts = false;
    private double totalQueryTimeMs = 0.0;
    private int connectionId;
    private int hostListSize = 0;
    private int isolationLevel = 2;
    private int maxAllowedPacket = 65536;
    private int netBufferLength = 16384;
    private int port = 3306;
    private long connectionCreationTimeMillis = 0L;
    private long lastQueryFinishedTime = 0L;
    private long longestQueryTimeMs = 0L;
    private long masterFailTimeMillis = 0L;
    private long metricsLastReportedMs;
    private long numberOfPreparedExecutes = 0L;
    private long numberOfPrepares = 0L;
    private long numberOfQueriesIssued = 0L;
    private long numberOfResultSetsFetched = 0L;
    private long queriesIssuedFailedOver = 0L;
    private long shortestQueryTimeMs = Long.MAX_VALUE;
    private Calendar dateTimeBindingCal;
    private boolean isAborted = false;
    static /* synthetic */ Class class$java$lang$Throwable;

    Connection(String hostToConnectTo, int portToConnectTo, Properties info, String databaseToConnectTo, String url, NonRegisteringDriver d) throws SQLException {
        this.connectionCreationTimeMillis = System.currentTimeMillis();
        this.pointOfOrigin = new Throwable();
        this.log = LogFactory.getLogger(this.getLogger(), LOGGER_INSTANCE_NAME);
        this.defaultTimeZone = TimeZone.getDefault();
        this.openStatements = new HashMap();
        this.serverVariables = new HashMap();
        this.hostList = new ArrayList();
        if (hostToConnectTo == null) {
            this.host = "localhost";
            this.hostList.add(this.host);
        } else if (hostToConnectTo.indexOf(",") != -1) {
            StringTokenizer hostTokenizer = new StringTokenizer(hostToConnectTo, ",", false);
            while (hostTokenizer.hasMoreTokens()) {
                this.hostList.add(hostTokenizer.nextToken().trim());
            }
        } else {
            this.host = hostToConnectTo;
            this.hostList.add(this.host);
        }
        this.hostListSize = this.hostList.size();
        this.port = portToConnectTo;
        if (databaseToConnectTo == null) {
            databaseToConnectTo = "";
        }
        this.database = databaseToConnectTo;
        this.myURL = url;
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        if (this.user == null || this.user.equals("")) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.props = info;
        this.initializeDriverProperties(info);
        try {
            this.createNewIO(false);
            this.dbmd = new DatabaseMetaData(this, this.database);
        }
        catch (SQLException ex) {
            this.cleanup(new Throwable(), ex);
            throw ex;
        }
        catch (Exception ex) {
            this.cleanup(new Throwable(), ex);
            StringBuffer mesg = new StringBuffer();
            if (this.getParanoid()) {
                mesg.append("Cannot connect to MySQL server on ");
                mesg.append(this.host);
                mesg.append(":");
                mesg.append(this.port);
                mesg.append(".\n\n");
                mesg.append("Make sure that there is a MySQL server ");
                mesg.append("running on the machine/port you are trying ");
                mesg.append("to connect to and that the machine this software is running on ");
                mesg.append("is able to connect to this host/port (i.e. not firewalled). ");
                mesg.append("Also make sure that the server has not been started with the --skip-networking ");
                mesg.append("flag.\n\n");
            } else {
                mesg.append("Unable to connect to database.");
            }
            mesg.append("Underlying exception: \n\n");
            mesg.append(ex.getClass().getName());
            if (!this.getParanoid()) {
                mesg.append(Util.stackTraceToString(ex));
            }
            throw new SQLException(mesg.toString(), "08S01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean autoCommitFlag) throws SQLException {
        this.checkClosed();
        if (this.getAutoReconnectForPools()) {
            this.setHighAvailability(true);
        }
        try {
            if (this.transactionsSupported) {
                this.autoCommit = autoCommitFlag;
                boolean needsSetOnServer = true;
                if (!this.getHighAvailability()) {
                    needsSetOnServer = this.io.isSetNeededForAutoCommitMode(autoCommitFlag);
                }
                if (needsSetOnServer) {
                    this.execSQL(null, autoCommitFlag ? "SET autocommit=1" : "SET autocommit=0", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                }
            } else {
                if (!autoCommitFlag && !this.getRelaxAutoCommit()) {
                    throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
                }
                this.autoCommit = autoCommitFlag;
            }
        }
        finally {
            if (this.getAutoReconnectForPools()) {
                this.setHighAvailability(false);
            }
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        String quotedId = this.dbmd.getIdentifierQuoteString();
        if (quotedId == null || quotedId.equals(" ")) {
            quotedId = "";
        }
        StringBuffer query = new StringBuffer("USE ");
        query.append(quotedId);
        query.append(catalog);
        query.append(quotedId);
        this.execSQL(null, query.toString(), -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
        this.database = catalog;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setHoldability(int arg0) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public Log getLog() throws SQLException {
        return this.log;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new DatabaseMetaData(this, this.database);
    }

    public void setReadOnly(boolean readOnlyFlag) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnlyFlag;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public Savepoint setSavepoint() throws SQLException {
        MysqlSavepoint savepoint = new MysqlSavepoint();
        this.setSavepoint(savepoint);
        return savepoint;
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        MysqlSavepoint savepoint = new MysqlSavepoint(name);
        this.setSavepoint(savepoint);
        return savepoint;
    }

    public TimeZone getServerTimezoneTZ() {
        return this.serverTimezoneTZ;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String sql;
        this.checkClosed();
        if (this.hasIsolationLevels) {
            sql = null;
            switch (level) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ COMMITTED";
                    break;
                }
                case 1: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL READ UNCOMMITTED";
                    break;
                }
                case 4: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL REPEATABLE READ";
                    break;
                }
                case 8: {
                    sql = "SET SESSION TRANSACTION ISOLATION LEVEL SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + level + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(null, sql, -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
        this.isolationLevel = level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransactionIsolation() throws SQLException {
        String s;
        block10: {
            Exception ex22;
            int n;
            java.sql.Statement stmt;
            block11: {
                if (!this.hasIsolationLevels) return this.isolationLevel;
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    Integer intTI;
                    stmt = this.createStatement();
                    stmt.setEscapeProcessing(false);
                    String query = null;
                    query = this.versionMeetsMinimum(4, 0, 3) ? "SHOW VARIABLES LIKE 'tx_isolation'" : "SHOW VARIABLES LIKE 'transaction_isolation'";
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) throw new SQLException("Could not retrieve transaction isolation level from server", "S1000");
                    s = rs.getString(2);
                    if (s == null || (intTI = (Integer)mapTransIsolationNameToValue.get(s)) == null) break block10;
                    n = intTI;
                    Object var8_7 = null;
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var8_8 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
                rs = null;
            }
            if (stmt == null) return n;
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
            return n;
        }
        throw new SQLException("Could not map transaction isolation '" + s + " to a valid JDBC level.", "S1000");
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public synchronized Map getTypeMap() throws SQLException {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void changeUser(String userName, String newPassword) throws SQLException {
        if (userName == null || userName.equals("")) {
            userName = "";
        }
        if (newPassword == null) {
            newPassword = "";
        }
        this.io.changeUser(userName, newPassword, this.database);
        this.user = userName;
        this.password = newPassword;
        if (this.versionMeetsMinimum(4, 1, 0)) {
            this.configureClientCharacterSet();
        }
    }

    public void clearWarnings() throws SQLException {
    }

    public PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        return this.clientPrepareStatement(sql, 1005, 1007);
    }

    public synchronized PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        PreparedStatement pStmt = null;
        if (this.getCachePreparedStatements()) {
            PreparedStatement.ParseInfo pStmtInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(sql);
            if (pStmtInfo == null) {
                pStmt = new PreparedStatement(this, sql, this.database);
                PreparedStatement.ParseInfo parseInfo = pStmt.getParseInfo();
                if (parseInfo.statementLength < this.getPreparedStatementCacheSqlLimit()) {
                    if (this.cachedPreparedStatementParams.size() >= this.getPreparedStatementCacheSize()) {
                        Iterator oldestIter = this.cachedPreparedStatementParams.keySet().iterator();
                        long lruTime = Long.MAX_VALUE;
                        String oldestSql = null;
                        while (oldestIter.hasNext()) {
                            String sqlKey = (String)oldestIter.next();
                            PreparedStatement.ParseInfo lruInfo = (PreparedStatement.ParseInfo)this.cachedPreparedStatementParams.get(sqlKey);
                            if (lruInfo.lastUsed >= lruTime) continue;
                            lruTime = lruInfo.lastUsed;
                            oldestSql = sqlKey;
                        }
                        if (oldestSql != null) {
                            this.cachedPreparedStatementParams.remove(oldestSql);
                        }
                    }
                    this.cachedPreparedStatementParams.put(sql, pStmt.getParseInfo());
                }
            } else {
                pStmtInfo.lastUsed = System.currentTimeMillis();
                pStmt = new PreparedStatement(this, sql, this.database, pStmtInfo);
            }
        } else {
            pStmt = new PreparedStatement(this, sql, this.database);
        }
        pStmt.setResultSetType(1005);
        pStmt.setResultSetConcurrency(1007);
        return pStmt;
    }

    public void close() throws SQLException {
        this.realClose(true, true);
    }

    public void commit() throws SQLException {
        this.checkClosed();
        try {
            if (this.autoCommit && !this.getRelaxAutoCommit()) {
                throw new SQLException("Can't call commit when autocommit=true");
            }
            if (this.transactionsSupported) {
                this.execSQL(null, "commit", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
            }
        }
        catch (SQLException sqlException) {
            if ("08S01".equals(sqlException.getSQLState())) {
                throw new SQLException("Communications link failure during commit(). Transaction resolution unknown.", "08007");
            }
            throw sqlException;
        }
        finally {
            this.needsPing = this.getReconnectAtTxEnd();
        }
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Statement stmt = new Statement(this, this.database);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean lowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    public String nativeSQL(String sql) throws SQLException {
        if (sql == null) {
            return null;
        }
        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql);
        if (escapedSqlResult instanceof String) {
            return (String)escapedSqlResult;
        }
        return ((EscapeProcessorResult)escapedSqlResult).escapedSql;
    }

    public boolean parserKnowsUnicode() {
        return this.parserKnowsUnicode;
    }

    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        if (this.getUseUltraDevWorkAround()) {
            return new UltraDevWorkAround(this.prepareStatement(sql));
        }
        return this.prepareCall(sql, 1003, 1007);
    }

    public synchronized java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.versionMeetsMinimum(5, 0, 0)) {
            CallableStatement cStmt = null;
            if (!this.getCacheCallableStatements()) {
                cStmt = new CallableStatement(this, sql, this.database);
            } else {
                CompoundCacheKey key;
                CallableStatement.CallableStatementParamInfo cachedParamInfo;
                if (this.parsedCallableStatementCache == null) {
                    this.parsedCallableStatementCache = new LRUCache(this.getCallableStatementCacheSize());
                }
                if ((cachedParamInfo = (CallableStatement.CallableStatementParamInfo)this.parsedCallableStatementCache.get(key = new CompoundCacheKey(this.getCatalog(), sql))) != null) {
                    cStmt = new CallableStatement(this, cachedParamInfo);
                } else {
                    cStmt = new CallableStatement(this, sql, this.database);
                    cachedParamInfo = cStmt.paramInfo;
                    this.parsedCallableStatementCache.put(key, cachedParamInfo);
                }
            }
            cStmt.setResultSetType(resultSetType);
            cStmt.setResultSetConcurrency(resultSetConcurrency);
            return cStmt;
        }
        throw new SQLException("Callable statements not supported.", "S1C00");
    }

    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        CallableStatement cStmt = (CallableStatement)this.prepareCall(sql, resultSetType, resultSetConcurrency);
        return cStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        PreparedStatement pStmt = null;
        pStmt = this.useServerPreparedStmts ? this.serverPrepare(null, sql) : new PreparedStatement(this, sql, this.database);
        pStmt.setResultSetType(resultSetType);
        pStmt.setResultSetConcurrency(resultSetConcurrency);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.getPedantic() && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndex == 1);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyIndexes != null && autoGenKeyIndexes.length > 0);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        java.sql.PreparedStatement pStmt = this.prepareStatement(sql);
        ((PreparedStatement)pStmt).setRetrieveGeneratedKeys(autoGenKeyColNames != null && autoGenKeyColNames.length > 0);
        return pStmt;
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
    }

    public void resetServerState() throws SQLException {
        if (!this.getParanoid() && this.io != null & this.versionMeetsMinimum(4, 0, 6)) {
            this.changeUser(this.user, this.password);
        }
    }

    public void rollback() throws SQLException {
        block10: {
            this.checkClosed();
            try {
                if (this.autoCommit && !this.getRelaxAutoCommit()) {
                    throw new SQLException("Can't call rollback when autocommit=true", "08003");
                }
                if (!this.transactionsSupported) break block10;
                try {
                    this.rollbackNoChecks();
                }
                catch (SQLException sqlEx) {
                    if (this.getIgnoreNonTxTables() && sqlEx.getErrorCode() != 1196) {
                        throw sqlEx;
                    }
                }
            }
            catch (SQLException sqlException) {
                if ("08S01".equals(sqlException.getSQLState())) {
                    throw new SQLException("Communications link failure during rollback(). Transaction resolution unknown.", "08007");
                }
                throw sqlException;
            }
            finally {
                this.needsPing = this.getReconnectAtTxEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.versionMeetsMinimum(4, 0, 14) && !this.versionMeetsMinimum(4, 1, 1)) throw new NotImplemented();
        this.checkClosed();
        try {
            StringBuffer rollbackQuery = new StringBuffer("ROLLBACK TO SAVEPOINT ");
            rollbackQuery.append('`');
            rollbackQuery.append(savepoint.getSavepointName());
            rollbackQuery.append('`');
            java.sql.Statement stmt = null;
            stmt = this.createStatement();
            stmt.executeUpdate(rollbackQuery.toString());
            Object var9_4 = null;
            if (stmt == null) return;
            try {
                stmt.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
            stmt = null;
            {
                return;
                catch (SQLException sqlEx) {
                    int indexOfError153;
                    String msg;
                    int errno = sqlEx.getErrorCode();
                    if (errno == 1181 && (msg = sqlEx.getMessage()) != null && (indexOfError153 = msg.indexOf("153")) != -1) {
                        throw new SQLException("Savepoint '" + savepoint.getSavepointName() + "' does not exist", "S1009", errno);
                    }
                    if (this.getIgnoreNonTxTables() && sqlEx.getErrorCode() != 1196) {
                        throw sqlEx;
                    }
                    if (!"08S01".equals(sqlEx.getSQLState())) throw sqlEx;
                    throw new SQLException("Communications link failure during rollback(). Transaction resolution unknown.", "08007");
                }
            }
            catch (Throwable throwable) {
                Object var9_5 = null;
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                stmt = null;
                throw throwable;
            }
        }
        finally {
            this.needsPing = this.getReconnectAtTxEnd();
        }
    }

    public void shutdownServer() throws SQLException {
        try {
            this.io.sendCommand(8, null, null, false, null);
        }
        catch (Exception ex) {
            throw new SQLException("Unhandled exception '" + ex.toString() + "'", "S1000");
        }
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this.hasQuotedIdentifiers;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    public boolean versionMeetsMinimum(int major, int minor, int subminor) throws SQLException {
        if (this.io == null) {
            throw new SQLException("Illegal operation on already closed connection", "08003");
        }
        return this.io.versionMeetsMinimum(major, minor, subminor);
    }

    protected String getCharsetNameForIndex(int charsetIndex) throws SQLException {
        String charsetName = null;
        if (charsetIndex != -1) {
            try {
                charsetName = this.indexToCharsetMapping[charsetIndex];
            }
            catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                throw new SQLException("Unknown character set index for field '" + charsetIndex + "' received from server.", "S1000");
            }
            if (charsetName == null) {
                charsetName = this.getEncoding();
            }
        } else {
            charsetName = this.getEncoding();
        }
        return charsetName;
    }

    protected TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    protected synchronized void checkClosedConnection() throws SQLException {
        if (this.io == null || this.isClosed) {
            throw new SQLException("Operation not allowed on closed connection", "08003");
        }
    }

    protected MysqlIO createNewIO(boolean isForReconnect) throws SQLException {
        MysqlIO newIo = null;
        Properties mergedProps = new Properties();
        mergedProps = this.exposeAsProperties(this.props);
        if (!this.getHighAvailability() && !this.failedOver) {
            int hostIndex = 0;
            if (this.getRoundRobinLoadBalance()) {
                hostIndex = Connection.getNextRoundRobinHostIndex(this.getURL(), this.hostList);
            }
            while (hostIndex < this.hostListSize) {
                block45: {
                    try {
                        String newHostPortPair = (String)this.hostList.get(hostIndex);
                        int newPort = 3306;
                        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(newHostPortPair);
                        String newHost = hostPortPair[0];
                        if (newHost == null || newHost.trim().length() == 0) {
                            newHost = "localhost";
                        }
                        if (hostPortPair[1] != null) {
                            try {
                                newPort = Integer.parseInt(hostPortPair[1]);
                            }
                            catch (NumberFormatException nfe) {
                                throw new SQLException("Illegal connection port value '" + hostPortPair[1] + "'", "01S00");
                            }
                        }
                        this.io = new MysqlIO(newHost, newPort, mergedProps, this.getSocketFactoryClassName(), this, this.getSocketTimeout());
                        this.io.doHandshake(this.user, this.password, this.database);
                        this.isClosed = false;
                        boolean oldAutoCommit = this.getAutoCommit();
                        int oldIsolationLevel = this.getTransactionIsolation();
                        boolean oldReadOnly = this.isReadOnly();
                        String oldCatalog = this.getCatalog();
                        this.initializePropsFromServer(this.props);
                        if (isForReconnect) {
                            this.setAutoCommit(oldAutoCommit);
                            if (this.hasIsolationLevels) {
                                this.setTransactionIsolation(oldIsolationLevel);
                            }
                            this.setCatalog(oldCatalog);
                        }
                        if (hostIndex != 0) {
                            this.setFailedOverState();
                        } else {
                            this.failedOver = false;
                            if (this.hostListSize > 1) {
                                this.setReadOnly(false);
                            } else {
                                this.setReadOnly(oldReadOnly);
                            }
                        }
                        break;
                    }
                    catch (SQLException sqlEx) {
                        String sqlState;
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if ((sqlState = sqlEx.getSQLState()) == null || !sqlState.equals("08S01")) {
                            throw sqlEx;
                        }
                        if (this.hostListSize - 1 == hostIndex) {
                            throw sqlEx;
                        }
                    }
                    catch (Exception unknownException) {
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if (this.hostListSize - 1 != hostIndex) break block45;
                        throw new CommunicationsException(this, this.io != null ? this.io.getLastPacketSentTimeMs() : 0L, unknownException);
                    }
                }
                ++hostIndex;
            }
        } else {
            double timeout = this.getInitialTimeout();
            boolean connectionGood = false;
            Exception connectionException = null;
            int hostIndex = 0;
            if (this.getRoundRobinLoadBalance()) {
                hostIndex = Connection.getNextRoundRobinHostIndex(this.getURL(), this.hostList);
            }
            while (hostIndex < this.hostListSize && !connectionGood) {
                for (int attemptCount = 0; attemptCount < this.getMaxReconnects() && !connectionGood; ++attemptCount) {
                    try {
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        String newHostPortPair = (String)this.hostList.get(hostIndex);
                        int newPort = 3306;
                        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(newHostPortPair);
                        String newHost = hostPortPair[0];
                        if (newHost == null || newHost.trim().length() == 0) {
                            newHost = "localhost";
                        }
                        if (hostPortPair[1] != null) {
                            try {
                                newPort = Integer.parseInt(hostPortPair[1]);
                            }
                            catch (NumberFormatException nfe) {
                                throw new SQLException("Illegal connection port value '" + hostPortPair[1] + "'", "01S00");
                            }
                        }
                        this.io = new MysqlIO(newHost, newPort, mergedProps, this.getSocketFactoryClassName(), this, this.getSocketTimeout());
                        this.io.doHandshake(this.user, this.password, this.database);
                        this.ping();
                        this.isClosed = false;
                        boolean oldAutoCommit = this.getAutoCommit();
                        int oldIsolationLevel = this.getTransactionIsolation();
                        boolean oldReadOnly = this.isReadOnly();
                        String oldCatalog = this.getCatalog();
                        this.initializePropsFromServer(this.props);
                        if (isForReconnect) {
                            this.setAutoCommit(oldAutoCommit);
                            if (this.hasIsolationLevels) {
                                this.setTransactionIsolation(oldIsolationLevel);
                            }
                            this.setCatalog(oldCatalog);
                        }
                        connectionGood = true;
                        if (hostIndex != 0) {
                            this.setFailedOverState();
                            break;
                        }
                        this.failedOver = false;
                        if (this.hostListSize > 1) {
                            this.setReadOnly(false);
                            break;
                        }
                        this.setReadOnly(oldReadOnly);
                        break;
                    }
                    catch (Exception EEE) {
                        connectionException = EEE;
                        connectionGood = false;
                        if (connectionGood) break;
                        try {
                            Thread.sleep((long)timeout * 1000L);
                            timeout *= 2.0;
                        }
                        catch (InterruptedException IE) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                ++hostIndex;
            }
            if (!connectionGood) {
                throw new SQLException("Server connection failure during transaction. Due to underlying exception: '" + connectionException + "'." + (this.getParanoid() ? "" : Util.stackTraceToString(connectionException)) + "\nAttempted reconnect " + this.getMaxReconnects() + " times. Giving up.", "08001");
            }
        }
        if (this.getParanoid() && !this.getHighAvailability() && this.hostListSize <= 1) {
            this.password = null;
            this.user = null;
        }
        if (isForReconnect) {
            Iterator statementIter = this.openStatements.values().iterator();
            Stack serverPreparedStatements = null;
            while (statementIter.hasNext()) {
                Object statementObj = statementIter.next();
                if (!(statementObj instanceof ServerPreparedStatement)) continue;
                if (serverPreparedStatements == null) {
                    serverPreparedStatements = new Stack();
                }
                serverPreparedStatements.add(statementObj);
            }
            if (serverPreparedStatements != null) {
                while (!serverPreparedStatements.isEmpty()) {
                    ServerPreparedStatement pstmt = (ServerPreparedStatement)serverPreparedStatements.pop();
                    this.serverPrepare(pstmt, pstmt.getOriginalSql());
                }
            }
        }
        return newIo;
    }

    protected void finalize() throws Throwable {
        this.cleanup(new Throwable(), null);
    }

    protected void incrementNumberOfPreparedExecutes() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfPreparedExecutes;
            ++this.numberOfQueriesIssued;
        }
    }

    protected void incrementNumberOfPrepares() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfPrepares;
        }
    }

    protected void incrementNumberOfResultSetsFetched() {
        if (this.getGatherPerformanceMetrics()) {
            ++this.numberOfResultSetsFetched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realClose(boolean calledExplicitly, boolean issueRollback) throws SQLException {
        SQLException sqlEx = null;
        if (this.isAborted) {
            this.localCleanupNonBlocking();
            return;
        }
        try {
            if (!this.isClosed()) {
                if (!this.getAutoCommit() && issueRollback) {
                    try {
                        this.rollback();
                    }
                    catch (SQLException ex) {
                        sqlEx = ex;
                    }
                }
                this.reportMetrics();
                if (this.getUseUsageAdvisor()) {
                    long connectionLifeTime;
                    if (!calledExplicitly) {
                        String message = "Connection implicitly closed by Driver. You should call Connection.close() from your code to free resources more efficiently and avoid resource leaks.";
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
                    }
                    if ((connectionLifeTime = System.currentTimeMillis() - this.connectionCreationTimeMillis) < 500L) {
                        String message = "Connection lifetime of < .5 seconds. You might be un-necessarily creating short-lived connections and should investigate connection pooling to be more efficient.";
                        this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), 0, null, this.pointOfOrigin, message));
                    }
                }
            }
            try {
                this.closeAllOpenStatements();
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            if (this.io != null) {
                try {
                    this.io.quit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (sqlEx != null) {
                throw sqlEx;
            }
        }
        finally {
            this.isClosed = true;
            this.localCleanupNonBlocking();
        }
    }

    private void localCleanupNonBlocking() {
        this.openStatements = null;
        this.io = null;
    }

    protected void registerQueryExecutionTime(long queryTimeMs) {
        if (queryTimeMs > this.longestQueryTimeMs) {
            this.longestQueryTimeMs = queryTimeMs;
            this.repartitionHistogram();
        }
        this.addToHistogram(queryTimeMs, 1);
        if (queryTimeMs < this.shortestQueryTimeMs) {
            this.shortestQueryTimeMs = queryTimeMs == 0L ? 1L : queryTimeMs;
        }
        ++this.numberOfQueriesIssued;
        this.totalQueryTimeMs += (double)queryTimeMs;
    }

    synchronized SingleByteCharsetConverter getCharsetConverter(String javaEncodingName) {
        if (javaEncodingName == null) {
            return null;
        }
        SingleByteCharsetConverter converter = (SingleByteCharsetConverter)this.charsetConverterMap.get(javaEncodingName);
        if (converter == CHARSET_CONVERTER_NOT_AVAILABLE_MARKER) {
            return null;
        }
        if (converter == null) {
            try {
                converter = SingleByteCharsetConverter.getInstance(javaEncodingName);
                if (converter == null) {
                    this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                }
                this.charsetConverterMap.put(javaEncodingName, converter);
            }
            catch (UnsupportedEncodingException unsupEncEx) {
                this.charsetConverterMap.put(javaEncodingName, CHARSET_CONVERTER_NOT_AVAILABLE_MARKER);
                converter = null;
            }
        }
        return converter;
    }

    int getId() {
        return this.connectionId;
    }

    int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    Object getMutex() throws SQLException {
        if (this.io == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        this.reportMetricsIfNeeded();
        return this.mutex;
    }

    int getNetBufferLength() {
        return this.netBufferLength;
    }

    void setReadInfoMsgEnabled(boolean flag) {
        this.readInfoMsg = flag;
    }

    boolean isReadInfoMsgEnabled() {
        return this.readInfoMsg;
    }

    int getServerMajorVersion() {
        return this.io.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this.io.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this.io.getServerSubMinorVersion();
    }

    String getServerVariable(String variableName) {
        if (this.serverVariables != null) {
            return (String)this.serverVariables.get(variableName);
        }
        return null;
    }

    String getServerVersion() {
        return this.io.getServerVersion();
    }

    String getURL() {
        return this.myURL;
    }

    String getUser() {
        return this.user;
    }

    ResultSet execSQL(Statement callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, boolean queryIsSelectOnly, String catalog, boolean unpackFields) throws SQLException {
        return this.execSQL(callingStatement, sql, maxRows, packet, resultSetType, resultSetConcurrency, streamResults, queryIsSelectOnly, catalog, unpackFields, (byte)0);
    }

    /*
     * Exception decompiling
     */
    ResultSet execSQL(Statement callingStatement, String sql, int maxRows, Buffer packet, int resultSetType, int resultSetConcurrency, boolean streamResults, boolean queryIsSelectOnly, String catalog, boolean unpackFields, byte queryUsesVariables) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maxRowsChanged(Statement stmt) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.statementsUsingMaxRows == null) {
                this.statementsUsingMaxRows = new HashMap();
            }
            this.statementsUsingMaxRows.put(stmt, stmt);
            this.maxRowsChanged = true;
        }
    }

    synchronized void registerStatement(Statement stmt) {
        this.openStatements.put(stmt, stmt);
    }

    synchronized void unregisterStatement(Statement stmt) {
        this.openStatements.remove(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetMaxRows(Statement stmt) throws SQLException {
        Object object = this.mutex;
        synchronized (object) {
            Object found;
            if (this.statementsUsingMaxRows != null && (found = this.statementsUsingMaxRows.remove(stmt)) != null && this.statementsUsingMaxRows.size() == 0) {
                this.execSQL(null, "SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                this.maxRowsChanged = false;
            }
        }
    }

    boolean useAnsiQuotedIdentifiers() {
        return this.useAnsiQuotes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean useMaxRows() {
        Object object = this.mutex;
        synchronized (object) {
            return this.maxRowsChanged;
        }
    }

    private void setFailedOverState() throws SQLException {
        if (this.getFailOverReadOnly()) {
            this.setReadOnly(true);
        }
        this.queriesIssuedFailedOver = 0L;
        this.failedOver = true;
        this.masterFailTimeMillis = System.currentTimeMillis();
    }

    private static synchronized int getNextRoundRobinHostIndex(String url, List hostList) {
        int[] index;
        if (roundRobinStatsMap == null) {
            roundRobinStatsMap = new HashMap();
        }
        if ((index = (int[])roundRobinStatsMap.get(url)) == null) {
            index = new int[]{-1};
            roundRobinStatsMap.put(url, index);
        }
        index[0] = index[0] + 1;
        if (index[0] > hostList.size()) {
            index[0] = 0;
        }
        return index[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSavepoint(MysqlSavepoint savepoint) throws SQLException {
        block7: {
            if (this.versionMeetsMinimum(4, 0, 14) || this.versionMeetsMinimum(4, 1, 1)) {
                this.checkClosed();
                StringBuffer savePointQuery = new StringBuffer("SAVEPOINT ");
                savePointQuery.append('`');
                savePointQuery.append(savepoint.getSavepointName());
                savePointQuery.append('`');
                java.sql.Statement stmt = null;
                try {
                    stmt = this.createStatement();
                    stmt.executeUpdate(savePointQuery.toString());
                    Object var5_4 = null;
                    if (stmt == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlEx) {
                            // empty catch block
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                stmt = null;
                {
                    break block7;
                }
            }
            throw new NotImplemented();
        }
    }

    private void addToHistogram(long value, int numberOfTimes) {
        if (this.perfMetricsHistCounts == null) {
            this.createInitialHistogram();
        }
        for (int i = 0; i < 20; ++i) {
            if (this.perfMetricsHistBreakpoints[i] < value) continue;
            int n = i;
            this.perfMetricsHistCounts[n] = this.perfMetricsHistCounts[n] + numberOfTimes;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buildCollationMapping() throws SQLException {
        block29: {
            block28: {
                SQLException sqlE22;
                ResultSet results;
                Statement stmt;
                block27: {
                    int highestIndex;
                    if (!this.versionMeetsMinimum(4, 1, 0)) break block28;
                    TreeMap<Integer, Object> sortedCollationMap = null;
                    if (this.getCacheServerConfiguration()) {
                        Map map = serverConfigByUrl;
                        synchronized (map) {
                            sortedCollationMap = (TreeMap)serverCollationByUrl.get(this.getURL());
                        }
                    }
                    stmt = null;
                    results = null;
                    if (sortedCollationMap == null) {
                        Object charsetName;
                        sortedCollationMap = new TreeMap<Integer, Object>();
                        stmt = (Statement)this.createStatement();
                        if (stmt.getMaxRows() != 0) {
                            stmt.setMaxRows(0);
                        }
                        results = (ResultSet)stmt.executeQuery("SHOW COLLATION");
                        while (results.next()) {
                            charsetName = results.getString(2);
                            Integer charsetIndex = new Integer(results.getInt(3));
                            sortedCollationMap.put(charsetIndex, charsetName);
                        }
                        if (this.getCacheServerConfiguration()) {
                            charsetName = serverConfigByUrl;
                            synchronized (charsetName) {
                                serverCollationByUrl.put(this.getURL(), sortedCollationMap);
                            }
                        }
                    }
                    if (CharsetMapping.INDEX_TO_CHARSET.length > (highestIndex = ((Integer)sortedCollationMap.lastKey()).intValue())) {
                        highestIndex = CharsetMapping.INDEX_TO_CHARSET.length;
                    }
                    this.indexToCharsetMapping = new String[highestIndex + 1];
                    for (int i = 0; i < CharsetMapping.INDEX_TO_CHARSET.length; ++i) {
                        this.indexToCharsetMapping[i] = CharsetMapping.INDEX_TO_CHARSET[i];
                    }
                    Iterator indexIter = sortedCollationMap.entrySet().iterator();
                    while (indexIter.hasNext()) {
                        Map.Entry indexEntry = indexIter.next();
                        String mysqlCharsetName = (String)indexEntry.getValue();
                        this.indexToCharsetMapping[((Integer)indexEntry.getKey()).intValue()] = (String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlCharsetName);
                    }
                    Object var9_14 = null;
                    if (results == null) break block27;
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {}
                }
                break block29;
                {
                    catch (SQLException e) {
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    SQLException sqlE22;
                    Object var9_15 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.indexToCharsetMapping = CharsetMapping.INDEX_TO_CHARSET;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            StringBuffer messageBuf = new StringBuffer("No operations allowed after connection closed.");
            if (this.forcedClosedLocation != null) {
                messageBuf.append("\n\n");
                messageBuf.append("Connection was implicitly closed at (stack trace):\n");
                messageBuf.append(Util.stackTraceToString(this.forcedClosedLocation));
            }
            if (this.forceClosedReason != null) {
                messageBuf.append("\n\nDue to underlying exception/error:\n");
                messageBuf.append(Util.stackTraceToString(this.forceClosedReason));
            }
            throw new SQLException(messageBuf.toString(), "08003");
        }
    }

    private void checkServerEncoding() throws SQLException {
        SingleByteCharsetConverter converter;
        if (this.getUseUnicode() && this.getEncoding() != null) {
            return;
        }
        String serverEncoding = (String)this.serverVariables.get("character_set");
        if (serverEncoding == null) {
            serverEncoding = (String)this.serverVariables.get("character_set_server");
        }
        String mappedServerEncoding = null;
        if (serverEncoding != null) {
            mappedServerEncoding = (String)charsetMap.get(serverEncoding.toUpperCase(Locale.ENGLISH));
        }
        if (!this.getUseUnicode() && mappedServerEncoding != null && (converter = this.getCharsetConverter(mappedServerEncoding)) != null) {
            this.setDoUnicode(true);
            this.setEncoding(mappedServerEncoding);
            return;
        }
        if (serverEncoding != null) {
            if (mappedServerEncoding == null && Character.isLowerCase(serverEncoding.charAt(0))) {
                char[] ach = serverEncoding.toCharArray();
                ach[0] = Character.toUpperCase(serverEncoding.charAt(0));
                this.setEncoding(new String(ach));
            }
            try {
                "abc".getBytes(mappedServerEncoding);
                this.setEncoding(mappedServerEncoding);
                this.setDoUnicode(true);
            }
            catch (UnsupportedEncodingException UE) {
                throw new SQLException("The driver can not map the character encoding '" + this.getEncoding() + "' that your server is using " + "to a character encoding your JVM understands. You " + "can specify this mapping manually by adding \"useUnicode=true\" " + "as well as \"characterEncoding=[an_encoding_your_jvm_understands]\" " + "to your JDBC URL.", "0S100");
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String txIsolationName = null;
        txIsolationName = this.versionMeetsMinimum(4, 0, 3) ? "tx_isolation" : "transaction_isolation";
        String s = (String)this.serverVariables.get(txIsolationName);
        if (s != null && (intTI = (Integer)mapTransIsolationNameToValue.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    private void cleanup(Throwable fromWhere, Throwable whyCleanedUp) {
        try {
            if (this.io != null && !this.isClosed()) {
                this.realClose(false, false);
            } else if (this.io != null) {
                this.io.forceClose();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    private void closeAllOpenStatements() throws SQLException {
        SQLException postponedException = null;
        if (this.openStatements != null) {
            ArrayList currentlyOpenStatements = new ArrayList();
            Iterator iter = this.openStatements.keySet().iterator();
            while (iter.hasNext()) {
                currentlyOpenStatements.add(iter.next());
            }
            int numStmts = currentlyOpenStatements.size();
            for (int i = 0; i < numStmts; ++i) {
                Statement stmt = (Statement)currentlyOpenStatements.get(i);
                try {
                    stmt.realClose(false);
                    continue;
                }
                catch (SQLException sqlEx) {
                    postponedException = sqlEx;
                }
            }
            if (postponedException != null) {
                throw postponedException;
            }
        }
    }

    private void configureCharsetProperties() throws SQLException {
        if (this.getEncoding() != null) {
            try {
                String testString = "abc";
                testString.getBytes(this.getEncoding());
            }
            catch (UnsupportedEncodingException UE) {
                String oldEncoding = this.getEncoding();
                this.setEncoding((String)CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(oldEncoding));
                if (this.getEncoding() == null) {
                    throw new SQLException("Java does not support the MySQL character encoding  encoding '" + oldEncoding + "'.", "01S00");
                }
                try {
                    String testString = "abc";
                    testString.getBytes(this.getEncoding());
                }
                catch (UnsupportedEncodingException encodingEx) {
                    throw new SQLException("Unsupported character encoding '" + this.getEncoding() + "'.", "01S00");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureClientCharacterSet() throws SQLException {
        boolean characterSetAlreadyConfigured;
        block19: {
            String realJavaEncoding = this.getEncoding();
            characterSetAlreadyConfigured = false;
            try {
                if (this.versionMeetsMinimum(4, 1, 0)) {
                    StringBuffer setBuf;
                    characterSetAlreadyConfigured = true;
                    this.setUseUnicode(true);
                    this.configureCharsetProperties();
                    realJavaEncoding = this.getEncoding();
                    try {
                        this.setEncoding(CharsetMapping.INDEX_TO_CHARSET[this.io.serverCharsetIndex]);
                    }
                    catch (ArrayIndexOutOfBoundsException outOfBoundsEx) {
                        if (realJavaEncoding != null) {
                            this.setEncoding(realJavaEncoding);
                        }
                        throw new SQLException("Unknown initial character set index '" + this.io.serverCharsetIndex + "' received from server. Initial client character set can be forced via the 'characterEncoding' property.", "S1000");
                    }
                    if (this.getEncoding() == null) {
                        this.setEncoding("ISO8859_1");
                    }
                    if (this.getUseUnicode()) {
                        String mysqlEncodingName;
                        if (realJavaEncoding != null) {
                            if (!this.getUseOldUTF8Behavior()) {
                                this.execSQL(null, "SET NAMES utf8", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                            } else {
                                mysqlEncodingName = (String)CharsetMapping.JAVA_UC_TO_MYSQL_CHARSET_MAP.get(realJavaEncoding.toUpperCase(Locale.ENGLISH));
                                if ("koi8_ru".equals(mysqlEncodingName)) {
                                    mysqlEncodingName = "ko18r";
                                }
                                if (mysqlEncodingName != null) {
                                    this.execSQL(null, "SET NAMES " + mysqlEncodingName, -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                                }
                            }
                            this.setEncoding(realJavaEncoding);
                        } else if (this.getEncoding() != null) {
                            mysqlEncodingName = (String)CharsetMapping.JAVA_UC_TO_MYSQL_CHARSET_MAP.get(this.getEncoding().toUpperCase(Locale.ENGLISH));
                            this.execSQL(null, "SET NAMES " + mysqlEncodingName, -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                            realJavaEncoding = this.getEncoding();
                        }
                    }
                    if (this.getCharacterSetResults() == null) {
                        this.execSQL(null, "SET character_set_results = NULL", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                    } else {
                        setBuf = new StringBuffer("SET character_set_results = ".length() + this.getCharacterSetResults().length());
                        setBuf.append("SET character_set_results = ").append(this.getCharacterSetResults());
                        this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                    }
                    if (this.getConnectionCollation() != null) {
                        setBuf = new StringBuffer("SET collation_connection = ".length() + this.getConnectionCollation().length());
                        setBuf.append("SET collation_connection = ").append(this.getConnectionCollation());
                        this.execSQL(null, setBuf.toString(), -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
                    }
                    break block19;
                }
                realJavaEncoding = this.getEncoding();
            }
            finally {
                this.setEncoding(realJavaEncoding);
            }
        }
        return characterSetAlreadyConfigured;
    }

    private void configureTimezone() throws SQLException {
        String configuredTimeZoneOnServer = (String)this.serverVariables.get("timezone");
        if (configuredTimeZoneOnServer == null && "SYSTEM".equalsIgnoreCase(configuredTimeZoneOnServer = (String)this.serverVariables.get("time_zone"))) {
            configuredTimeZoneOnServer = (String)this.serverVariables.get("system_time_zone");
        }
        if (this.getUseTimezone() && configuredTimeZoneOnServer != null) {
            String canoncicalTimezone = this.getServerTimezone();
            if (canoncicalTimezone == null || canoncicalTimezone.length() == 0) {
                String serverTimezoneStr = configuredTimeZoneOnServer;
                try {
                    canoncicalTimezone = TimeUtil.getCanoncialTimezone(serverTimezoneStr);
                    if (canoncicalTimezone == null) {
                        throw new SQLException("Can't map timezone '" + serverTimezoneStr + "' to " + " canonical timezone.", "S1009");
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new SQLException(iae.getMessage(), "S1000");
                }
            }
            this.serverTimezoneTZ = TimeZone.getTimeZone(canoncicalTimezone);
            if (!canoncicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezoneTZ.getID().equals("GMT")) {
                throw new SQLException("No timezone mapping entry for '" + canoncicalTimezone + "'", "S1009");
            }
            this.isServerTzUTC = "GMT".equalsIgnoreCase(this.serverTimezoneTZ.getID());
        }
    }

    private void createInitialHistogram() {
        this.perfMetricsHistCounts = new int[20];
        this.perfMetricsHistBreakpoints = new long[20];
        long lowerBound = this.shortestQueryTimeMs;
        if (lowerBound == Long.MAX_VALUE) {
            lowerBound = 0L;
        }
        double bucketSize = ((double)this.longestQueryTimeMs - (double)lowerBound) / 20.0 * 1.25;
        for (int i = 0; i < 20; ++i) {
            this.perfMetricsHistBreakpoints[i] = lowerBound;
            lowerBound = (long)((double)lowerBound + bucketSize);
        }
    }

    private void initializeDriverProperties(Properties info) throws SQLException {
        this.initializeProperties(info);
        this.log = LogFactory.getLogger(this.getLogger(), LOGGER_INSTANCE_NAME);
        if (this.getProfileSql() || this.getUseUsageAdvisor()) {
            this.eventSink = ProfileEventSink.getInstance(this);
        }
        if (this.getCachePreparedStatements()) {
            this.cachedPreparedStatementParams = new HashMap(this.getPreparedStatementCacheSize());
        }
    }

    private void initializePropsFromServer(Properties info) throws SQLException {
        boolean clientCharsetIsConfigured = this.configureClientCharacterSet();
        this.useFastPing = this.versionMeetsMinimum(3, 22, 1);
        this.parserKnowsUnicode = this.versionMeetsMinimum(4, 1, 0);
        if (this.getUseServerPreparedStmts() && this.versionMeetsMinimum(4, 1, 0)) {
            this.useServerPreparedStmts = true;
            if (this.versionMeetsMinimum(5, 0, 0) && !this.versionMeetsMinimum(5, 0, 2)) {
                this.useServerPreparedStmts = false;
            }
        }
        this.serverVariables.clear();
        if (this.versionMeetsMinimum(3, 21, 22)) {
            this.loadServerVariables();
            this.buildCollationMapping();
            LicenseConfiguration.checkLicenseType(this.serverVariables);
            String lowerCaseTables = (String)this.serverVariables.get("lower_case_table_names");
            this.lowerCaseTableNames = "on".equalsIgnoreCase(lowerCaseTables) || "1".equalsIgnoreCase(lowerCaseTables) || "2".equalsIgnoreCase(lowerCaseTables);
            this.configureTimezone();
            if (this.serverVariables.containsKey("max_allowed_packet")) {
                this.maxAllowedPacket = Integer.parseInt((String)this.serverVariables.get("max_allowed_packet"));
            }
            if (this.serverVariables.containsKey("net_buffer_length")) {
                this.netBufferLength = Integer.parseInt((String)this.serverVariables.get("net_buffer_length"));
            }
            this.checkTransactionIsolationLevel();
            if (!clientCharsetIsConfigured) {
                this.checkServerEncoding();
            }
            this.io.checkForCharsetMismatch();
            if (this.serverVariables.containsKey("sql_mode")) {
                int sqlMode = 0;
                try {
                    sqlMode = Integer.parseInt((String)this.serverVariables.get("sql_mode"));
                }
                catch (NumberFormatException nfe) {
                    sqlMode = 0;
                }
                this.useAnsiQuotes = (sqlMode & 4) > 0;
            }
        }
        if (this.versionMeetsMinimum(3, 23, 15)) {
            this.transactionsSupported = true;
            this.setAutoCommit(true);
        } else {
            this.transactionsSupported = false;
        }
        this.hasIsolationLevels = this.versionMeetsMinimum(3, 23, 36);
        this.hasQuotedIdentifiers = this.versionMeetsMinimum(3, 23, 6);
        this.io.resetMaxBuf();
    }

    private static void loadCharacterSetMapping() {
        multibyteCharsetsMap = new HashMap();
        Iterator multibyteCharsets = CharsetMapping.MULTIBYTE_CHARSETS.keySet().iterator();
        while (multibyteCharsets.hasNext()) {
            String charset = ((String)multibyteCharsets.next()).toUpperCase(Locale.ENGLISH);
            multibyteCharsetsMap.put(charset, charset);
        }
        Iterator keys = CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.keySet().iterator();
        charsetMap = new HashMap();
        while (keys.hasNext()) {
            String mysqlCharsetName = ((String)keys.next()).trim();
            String javaCharsetName = CharsetMapping.MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlCharsetName).toString().trim();
            charsetMap.put(mysqlCharsetName.toUpperCase(Locale.ENGLISH), javaCharsetName);
            charsetMap.put(mysqlCharsetName, javaCharsetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadServerVariables() throws SQLException {
        block24: {
            SQLException sqlE22;
            ResultSet results;
            Statement stmt;
            block23: {
                if (this.getCacheServerConfiguration()) {
                    Map map = serverConfigByUrl;
                    synchronized (map) {
                        Map cachedVariableMap = (Map)serverConfigByUrl.get(this.getURL());
                        if (cachedVariableMap != null) {
                            this.serverVariables = cachedVariableMap;
                            return;
                        }
                    }
                }
                stmt = null;
                results = null;
                stmt = (Statement)this.createStatement();
                stmt.setEscapeProcessing(false);
                results = (ResultSet)stmt.executeQuery("SHOW VARIABLES");
                while (results.next()) {
                    this.serverVariables.put(results.getString(1), results.getString(2));
                }
                if (this.getCacheServerConfiguration()) {
                    Map map = serverConfigByUrl;
                    synchronized (map) {
                        serverConfigByUrl.put(this.getURL(), this.serverVariables);
                    }
                }
                Object var6_7 = null;
                if (results == null) break block23;
                try {
                    results.close();
                }
                catch (SQLException sqlE22) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlE22) {}
            }
            break block24;
            {
                catch (SQLException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                SQLException sqlE22;
                Object var6_8 = null;
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void ping() throws Exception {
        if (this.useFastPing) {
            this.io.sendCommand(14, null, null, false, null);
        } else {
            this.io.sqlQueryDirect(null, PING_COMMAND, this.getEncoding(), null, 50000000, this, 1003, 1007, false, this.database, true);
        }
    }

    private void repartitionHistogram() {
        int i;
        long lowerBound;
        int[] oldHistCounts = this.perfMetricsHistCounts;
        long[] oldHistBreakpoints = this.perfMetricsHistBreakpoints;
        if (this.perfMetricsHistCounts == null) {
            this.createInitialHistogram();
        }
        if ((lowerBound = this.shortestQueryTimeMs) == Long.MAX_VALUE) {
            lowerBound = 0L;
        }
        double bucketSize = ((double)this.longestQueryTimeMs - (double)lowerBound) / 20.0 * 1.25;
        for (i = 0; i < 20; ++i) {
            this.perfMetricsHistBreakpoints[i] = lowerBound;
            lowerBound = (long)((double)lowerBound + bucketSize);
        }
        if (oldHistCounts != null) {
            for (i = 0; i < 20; ++i) {
                this.addToHistogram(oldHistBreakpoints[i], oldHistCounts[i]);
            }
        }
    }

    private void reportMetrics() {
        if (this.getGatherPerformanceMetrics()) {
            StringBuffer logMessage = new StringBuffer(256);
            logMessage.append("** Performance Metrics Report **\n");
            logMessage.append("\nLongest reported query: " + this.longestQueryTimeMs + " ms");
            logMessage.append("\nShortest reported query: " + this.shortestQueryTimeMs + " ms");
            logMessage.append("\nAverage query execution time: " + this.totalQueryTimeMs / (double)this.numberOfQueriesIssued + " ms");
            logMessage.append("\nNumber of queries executed: " + this.numberOfQueriesIssued);
            logMessage.append("\nNumber of queries prepared: " + this.numberOfPrepares);
            logMessage.append("\nNumber of prepared statement executions: " + this.numberOfPreparedExecutes);
            if (this.perfMetricsHistBreakpoints != null) {
                logMessage.append("\n\n\tHistogram:\n");
                for (int i = 0; i < 19; ++i) {
                    logMessage.append("\n\tQueries taking between " + this.perfMetricsHistBreakpoints[i] + " and " + this.perfMetricsHistBreakpoints[i + 1] + ": " + this.perfMetricsHistCounts[i]);
                }
                logMessage.append("\n\tQueries taking between ");
                logMessage.append(this.perfMetricsHistBreakpoints[18]);
                logMessage.append(" and ");
                logMessage.append(this.perfMetricsHistBreakpoints[19]);
                logMessage.append(" ");
                logMessage.append(this.perfMetricsHistCounts[19]);
            }
            this.log.logInfo(logMessage);
            this.metricsLastReportedMs = System.currentTimeMillis();
        }
    }

    private void reportMetricsIfNeeded() {
        if (this.getGatherPerformanceMetrics() && System.currentTimeMillis() - this.metricsLastReportedMs > (long)this.getReportMetricsIntervalMillis()) {
            this.reportMetrics();
        }
    }

    private void rollbackNoChecks() throws SQLException {
        this.execSQL(null, "rollback", -1, null, 1003, 1007, false, false, this.database, true, (byte)0);
    }

    private boolean shouldFallBack() {
        long secondsSinceFailedOver = (System.currentTimeMillis() - this.masterFailTimeMillis) / 1000L;
        return secondsSinceFailedOver >= (long)this.getSecondsBeforeRetryMaster() || this.queriesIssuedFailedOver % (long)this.getQueriesBeforeRetryMaster() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int getMaxBytesPerChar(String charset) throws SQLException {
        block9: {
            Integer mbPerChar;
            if (!this.versionMeetsMinimum(4, 1, 0)) break block9;
            if (this.charsetToNumBytesMap == null) {
                java.sql.Statement stmt;
                block8: {
                    this.charsetToNumBytesMap = new HashMap();
                    stmt = null;
                    java.sql.ResultSet rs = null;
                    try {
                        stmt = this.getMetadataSafeStatement();
                        rs = stmt.executeQuery("SHOW CHARACTER SET");
                        while (rs.next()) {
                            this.charsetToNumBytesMap.put(rs.getString("Charset"), new Integer(rs.getInt("Maxlen")));
                        }
                        rs.close();
                        rs = null;
                        stmt.close();
                        stmt = null;
                        Object var5_4 = null;
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                        throw throwable;
                    }
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            if ((mbPerChar = (Integer)this.charsetToNumBytesMap.get(charset)) != null) {
                return mbPerChar;
            }
            return 1;
        }
        return 1;
    }

    protected String extractSqlFromPacket(String possibleSqlQuery, Buffer queryPacket, int endOfQueryPacketPosition) throws SQLException {
        String extractedSql = null;
        if (possibleSqlQuery != null) {
            if (possibleSqlQuery.length() > this.getMaxQuerySizeToLog()) {
                StringBuffer truncatedQueryBuf = new StringBuffer(possibleSqlQuery.substring(0, this.getMaxQuerySizeToLog()));
                truncatedQueryBuf.append(Messages.getString("MysqlIO.25"));
                extractedSql = truncatedQueryBuf.toString();
            } else {
                extractedSql = possibleSqlQuery;
            }
        }
        if (extractedSql == null) {
            int extractPosition = endOfQueryPacketPosition;
            boolean truncated = false;
            if (endOfQueryPacketPosition > this.getMaxQuerySizeToLog()) {
                extractPosition = this.getMaxQuerySizeToLog();
                truncated = true;
            }
            extractedSql = new String(queryPacket.getByteBuffer(), 5, extractPosition - 5);
            if (truncated) {
                extractedSql = extractedSql + Messages.getString("MysqlIO.25");
            }
        }
        return extractedSql;
    }

    protected static SQLException appendMessageToException(SQLException sqlEx, String messageToAppend) {
        String origMessage = sqlEx.getMessage();
        String sqlState = sqlEx.getSQLState();
        int vendorErrorCode = sqlEx.getErrorCode();
        StringBuffer messageBuf = new StringBuffer(origMessage.length() + messageToAppend.length());
        messageBuf.append(origMessage);
        messageBuf.append(messageToAppend);
        SQLException sqlExceptionWithNewMessage = new SQLException(messageBuf.toString(), sqlState, vendorErrorCode);
        try {
            Method getStackTraceMethod = null;
            Method setStackTraceMethod = null;
            Object theStackTraceAsObject = null;
            Class<?> stackTraceElementClass = Class.forName("java.lang.StackTraceElement");
            Class<?> stackTraceElementArrayClass = Array.newInstance(stackTraceElementClass, new int[]{0}).getClass();
            getStackTraceMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Connection.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getStackTrace", new Class[0]);
            setStackTraceMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Connection.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("setStackTrace", stackTraceElementArrayClass);
            if (getStackTraceMethod != null && setStackTraceMethod != null) {
                theStackTraceAsObject = getStackTraceMethod.invoke((Object)sqlEx, new Object[0]);
                setStackTraceMethod.invoke((Object)sqlExceptionWithNewMessage, theStackTraceAsObject);
            }
        }
        catch (NoClassDefFoundError noClassDefFound) {
        }
        catch (NoSuchMethodException noSuchMethodEx) {
        }
        catch (Throwable catchAll) {
            // empty catch block
        }
        return sqlExceptionWithNewMessage;
    }

    protected String getServerCharacterEncoding() {
        return (String)this.serverVariables.get("character_set");
    }

    protected java.sql.Statement getMetadataSafeStatement() throws SQLException {
        java.sql.Statement stmt = this.createStatement();
        if (stmt.getMaxRows() != 0) {
            stmt.setMaxRows(0);
        }
        stmt.setEscapeProcessing(false);
        return stmt;
    }

    protected boolean isServerTzUTC() {
        return this.isServerTzUTC;
    }

    protected Buffer fillSendPacket(PreparedStatement pstmt, byte[][] staticSqlStrings, byte[][] batchedParameterStrings, InputStream[] batchedParameterStreams, boolean[] batchedIsStream, int[] batchedStreamLengths) throws SQLException {
        int i;
        this.checkClosedConnection();
        Buffer sendPacket = this.io.getSharedSendPacket();
        sendPacket.clear();
        sendPacket.writeByte((byte)3);
        boolean useStreamLengths = this.getUseStreamLengthsInPrepStmts();
        int ensurePacketSize = 0;
        for (i = 0; i < batchedParameterStrings.length; ++i) {
            if (!batchedIsStream[i] || !useStreamLengths) continue;
            ensurePacketSize += batchedStreamLengths[i];
        }
        if (ensurePacketSize != 0) {
            sendPacket.ensureCapacity(ensurePacketSize);
        }
        for (i = 0; i < batchedParameterStrings.length; ++i) {
            if (batchedParameterStrings[i] == null && batchedParameterStreams[i] == null) {
                throw new SQLException(Messages.getString("PreparedStatement.40") + (i + 1), "07001");
            }
            sendPacket.writeBytesNoNull(staticSqlStrings[i]);
            if (batchedIsStream[i]) {
                pstmt.streamToBytes(sendPacket, batchedParameterStreams[i], true, batchedStreamLengths[i], useStreamLengths);
                continue;
            }
            sendPacket.writeBytesNoNull(batchedParameterStrings[i]);
        }
        sendPacket.writeBytesNoNull(staticSqlStrings[batchedParameterStrings.length]);
        return sendPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeServerPreparedStatement(long serverStatementId) throws SQLException {
        this.checkClosed();
        Object object = this.getMutex();
        synchronized (object) {
            Buffer packet = this.io.getSharedSendPacket();
            packet.writeByte((byte)25);
            packet.writeLong(serverStatementId);
            this.io.sendCommand(25, null, packet, true, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet serverExecute(ServerPreparedStatement pstmt, BindValue[] parameterBindings, int fieldCount, int maxRowsToRetrieve, boolean sendTypesToServer, boolean createStreamingResultSet) throws SQLException {
        try {
            Object object = this.getMutex();
            synchronized (object) {
                int i;
                this.checkClosed();
                Buffer packet = this.io.getSharedSendPacket();
                packet.clear();
                packet.writeByte((byte)23);
                packet.writeLong(pstmt.getServerStatementId());
                boolean usingCursor = false;
                if (this.versionMeetsMinimum(4, 1, 2)) {
                    if (this.versionMeetsMinimum(5, 0, 2) && pstmt.getResultSetType() == 1003 && pstmt.getFetchSize() > 0) {
                        packet.writeByte((byte)1);
                        usingCursor = true;
                    } else {
                        packet.writeByte((byte)0);
                    }
                    packet.writeLong(1L);
                }
                int parameterCount = parameterBindings.length;
                int nullCount = (parameterCount + 7) / 8;
                int nullBitsPosition = packet.getPosition();
                for (int i2 = 0; i2 < nullCount; ++i2) {
                    packet.writeByte((byte)0);
                }
                byte[] nullBitsBuffer = new byte[nullCount];
                packet.writeByte(sendTypesToServer ? (byte)1 : 0);
                if (sendTypesToServer) {
                    for (i = 0; i < parameterCount; ++i) {
                        packet.writeInt(parameterBindings[i].bufferType);
                    }
                }
                for (i = 0; i < parameterCount; ++i) {
                    if (parameterBindings[i].isLongData) continue;
                    if (!parameterBindings[i].isNull) {
                        this.storeBinding(pstmt, packet, parameterBindings[i]);
                        continue;
                    }
                    int n = i / 8;
                    nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << (i & 7));
                }
                int endPosition = packet.getPosition();
                packet.setPosition(nullBitsPosition);
                packet.writeBytesNoNull(nullBitsBuffer);
                packet.setPosition(endPosition);
                long begin = 0L;
                if (this.getProfileSql() || this.getLogSlowQueries() || this.getGatherPerformanceMetrics()) {
                    begin = System.currentTimeMillis();
                }
                Buffer resultPacket = this.io.sendCommand(23, null, packet, false, null);
                if (this.getLogSlowQueries() || this.getGatherPerformanceMetrics()) {
                    long elapsedTime = System.currentTimeMillis() - begin;
                    if (this.getLogSlowQueries() && elapsedTime > (long)this.getSlowQueryThresholdMillis()) {
                        String originalSql = pstmt.getOriginalSql();
                        StringBuffer mesgBuf = new StringBuffer(48 + originalSql.length());
                        mesgBuf.append(Messages.getString("ServerPreparedStatement.15"));
                        mesgBuf.append(this.getSlowQueryThresholdMillis());
                        mesgBuf.append(Messages.getString("ServerPreparedStatement.16"));
                        mesgBuf.append(originalSql);
                        this.getLog().logWarn(mesgBuf.toString());
                        if (this.getExplainSlowQueries()) {
                            String queryAsString = pstmt.asSql(true);
                            this.io.explainSlowQuery(queryAsString.getBytes(), queryAsString);
                        }
                    }
                    if (this.getGatherPerformanceMetrics()) {
                        this.registerQueryExecutionTime(elapsedTime);
                    }
                }
                this.incrementNumberOfPreparedExecutes();
                if (this.getProfileSql()) {
                    this.eventSink = ProfileEventSink.getInstance(this);
                    this.eventSink.consumeEvent(new ProfilerEvent(4, "", pstmt.getCurrentCatalog(), this.getId(), pstmt.getId(), -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), null));
                }
                ResultSet rs = null;
                rs = this.io.readAllResults(pstmt, maxRowsToRetrieve, pstmt.getResultSetType(), pstmt.getResultSetConcurrency(), createStreamingResultSet, pstmt.getCurrentCatalog(), resultPacket, true, fieldCount, true);
                if (!createStreamingResultSet) {
                    this.serverResetStatement(pstmt);
                }
                return rs;
            }
        }
        catch (SQLException sqlEx) {
            if (this.getEnablePacketDebug()) {
                this.io.dumpPacketRingBuffer();
            }
            if (this.getDumpQueriesOnException()) {
                String extractedSql = pstmt.asSql();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
        catch (Exception ex) {
            if (this.getEnablePacketDebug()) {
                this.io.dumpPacketRingBuffer();
            }
            SQLException sqlEx = new SQLException(ex.toString(), "S1000");
            if (this.getDumpQueriesOnException()) {
                String extractedSql = pstmt.asSql();
                StringBuffer messageBuf = new StringBuffer(extractedSql.length() + 32);
                messageBuf.append("\n\nQuery being executed when exception was thrown:\n\n");
                messageBuf.append(extractedSql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
            }
            throw sqlEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverLongData(ServerPreparedStatement pstmt, int parameterIndex, BindValue longData) throws SQLException {
        Object object = this.getMutex();
        synchronized (object) {
            this.checkClosed();
            Buffer packet = this.io.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)24);
            packet.writeLong(pstmt.getServerStatementId());
            packet.writeInt(parameterIndex - 1);
            Object value = longData.value;
            if (value instanceof byte[]) {
                packet.writeBytesNoNull((byte[])longData.value);
            } else if (value instanceof InputStream) {
                this.storeStream(packet, (InputStream)value);
            } else if (value instanceof Blob) {
                this.storeStream(packet, ((Blob)value).getBinaryStream());
            } else if (value instanceof Reader) {
                this.storeReader(packet, (Reader)value);
            } else {
                throw new SQLException(Messages.getString("ServerPreparedStatement.18") + value.getClass().getName() + "'", "S1009");
            }
            this.io.sendCommand(24, null, packet, true, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ServerPreparedStatement serverPrepare(ServerPreparedStatement existingStatement, String sql) throws SQLException {
        Object object = this.getMutex();
        synchronized (object) {
            try {
                ServerPreparedStatement serverPreparedStatement;
                int i;
                Statement.checkNullOrEmptyQuery(sql);
                long begin = 0L;
                boolean isLoadDataQuery = false;
                isLoadDataQuery = StringUtils.startsWithIgnoreCaseAndWs(sql, "LOAD DATA");
                if (this.getProfileSql()) {
                    begin = System.currentTimeMillis();
                }
                String characterEncoding = null;
                String connectionEncoding = this.getEncoding();
                if (!isLoadDataQuery && this.getUseUnicode() && connectionEncoding != null) {
                    characterEncoding = connectionEncoding;
                }
                Buffer prepareResultPacket = this.io.sendCommand(22, sql, null, false, characterEncoding);
                if (this.versionMeetsMinimum(4, 1, 1)) {
                    prepareResultPacket.setPosition(1);
                } else {
                    prepareResultPacket.setPosition(0);
                }
                long serverStatementId = prepareResultPacket.readLong();
                int fieldCount = prepareResultPacket.readInt();
                int parameterCount = prepareResultPacket.readInt();
                this.incrementNumberOfPrepares();
                if (this.getProfileSql()) {
                    this.eventSink = ProfileEventSink.getInstance(this);
                    this.eventSink.consumeEvent(new ProfilerEvent(2, "", this.getCatalog(), this.getId(), -1, -1, System.currentTimeMillis(), (int)(System.currentTimeMillis() - begin), null, new Throwable(), sql));
                }
                Field[] parameterFields = null;
                Field[] resultFields = null;
                if (parameterCount > 0 && this.versionMeetsMinimum(4, 1, 2) && !this.isVersion(5, 0, 0)) {
                    parameterFields = new Field[parameterCount];
                    Buffer metaDataPacket = this.io.readPacket();
                    i = 0;
                    while (!metaDataPacket.isLastDataPacket() && i < parameterCount) {
                        parameterFields[i++] = this.io.unpackField(metaDataPacket, false);
                        metaDataPacket = this.io.readPacket();
                    }
                }
                if (fieldCount > 0) {
                    resultFields = new Field[fieldCount];
                    Buffer fieldPacket = this.io.readPacket();
                    i = 0;
                    while (!fieldPacket.isLastDataPacket() && i < fieldCount) {
                        resultFields[i++] = this.io.unpackField(fieldPacket, false);
                        fieldPacket = this.io.readPacket();
                    }
                }
                if (existingStatement == null) {
                    serverPreparedStatement = new ServerPreparedStatement(this, this.database, sql, serverStatementId, parameterCount, fieldCount, parameterFields, resultFields);
                    return serverPreparedStatement;
                }
                existingStatement.setServersideState(true, serverStatementId, parameterCount, fieldCount, parameterFields, resultFields);
                serverPreparedStatement = existingStatement;
                return serverPreparedStatement;
            }
            catch (SQLException sqlEx) {
                if (!this.getDumpQueriesOnException()) throw sqlEx;
                StringBuffer messageBuf = new StringBuffer(sql.length() + 32);
                messageBuf.append("\n\nQuery being prepared when exception was thrown:\n\n");
                messageBuf.append(sql);
                sqlEx = Connection.appendMessageToException(sqlEx, messageBuf.toString());
                throw sqlEx;
            }
            finally {
                this.io.clearInputStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverResetStatement(ServerPreparedStatement pstmt) throws SQLException {
        Object object = this.getMutex();
        synchronized (object) {
            Buffer packet = this.io.getSharedSendPacket();
            packet.clear();
            packet.writeByte((byte)26);
            packet.writeLong(pstmt.getServerStatementId());
            try {
                this.io.sendCommand(26, null, packet, !this.versionMeetsMinimum(4, 1, 2), null);
            }
            catch (SQLException sqlEx) {
                throw sqlEx;
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString(), "S1000");
            }
            finally {
                this.io.clearInputStream();
            }
        }
    }

    protected boolean isVersion(int major, int minor, int subminor) {
        return this.io.isVersion(major, minor, subminor);
    }

    protected void storeBinding(ServerPreparedStatement pstmt, Buffer packet, BindValue bindValue) throws SQLException {
        try {
            Object value = bindValue.value;
            switch (bindValue.bufferType) {
                case 1: {
                    packet.writeByte(bindValue.byteBinding);
                    return;
                }
                case 2: {
                    packet.ensureCapacity(2);
                    packet.writeInt(bindValue.shortBinding);
                    return;
                }
                case 3: {
                    packet.ensureCapacity(4);
                    packet.writeLong(bindValue.intBinding);
                    return;
                }
                case 8: {
                    packet.ensureCapacity(8);
                    packet.writeLongLong(bindValue.longBinding);
                    return;
                }
                case 4: {
                    packet.ensureCapacity(4);
                    packet.writeFloat(bindValue.floatBinding);
                    return;
                }
                case 5: {
                    packet.ensureCapacity(8);
                    packet.writeDouble(bindValue.doubleBinding);
                    return;
                }
                case 11: {
                    this.storeTime(packet, (Time)value);
                    return;
                }
                case 7: 
                case 10: 
                case 12: {
                    this.storeDateTime(packet, (java.util.Date)value);
                    return;
                }
                case 253: 
                case 254: {
                    if (!pstmt.isLoadDataQuery()) {
                        packet.writeLenString((String)value, pstmt.getCharEncoding(), this.getServerCharacterEncoding(), pstmt.getCharConverter(), this.parserKnowsUnicode());
                    } else {
                        packet.writeLenBytes(((String)value).getBytes());
                    }
                    return;
                }
            }
            if (value instanceof byte[]) {
                packet.writeLenBytes((byte[])value);
            }
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException(Messages.getString("ServerPreparedStatement.22") + this.getEncoding() + "'", "S1000");
        }
    }

    private void storeDateTime412AndOlder(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        intoBuf.ensureCapacity(8);
        intoBuf.writeByte((byte)7);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
    }

    private void storeDateTime(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.versionMeetsMinimum(4, 1, 3)) {
            this.storeDateTime413AndNewer(intoBuf, dt);
        } else {
            this.storeDateTime412AndOlder(intoBuf, dt);
        }
    }

    private void storeDateTime413AndNewer(Buffer intoBuf, java.util.Date dt) throws SQLException {
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(dt);
        byte length = 7;
        intoBuf.ensureCapacity(length);
        if (dt instanceof Timestamp) {
            length = 11;
        }
        intoBuf.writeByte(length);
        int year = this.dateTimeBindingCal.get(1);
        int month = this.dateTimeBindingCal.get(2) + 1;
        int date = this.dateTimeBindingCal.get(5);
        intoBuf.writeInt(year);
        intoBuf.writeByte((byte)month);
        intoBuf.writeByte((byte)date);
        if (dt instanceof Date) {
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
            intoBuf.writeByte((byte)0);
        } else {
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
            intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
        }
        if (length == 11) {
            intoBuf.writeLong(((Timestamp)dt).getNanos());
        }
    }

    private void storeTime(Buffer intoBuf, Time tm) throws SQLException {
        intoBuf.ensureCapacity(9);
        intoBuf.writeByte((byte)8);
        intoBuf.writeByte((byte)0);
        intoBuf.writeLong(0L);
        if (this.dateTimeBindingCal == null) {
            this.dateTimeBindingCal = Calendar.getInstance();
        }
        this.dateTimeBindingCal.setTime(tm);
        intoBuf.writeByte((byte)this.dateTimeBindingCal.get(11));
        intoBuf.writeByte((byte)this.dateTimeBindingCal.get(12));
        intoBuf.writeByte((byte)this.dateTimeBindingCal.get(13));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeReader(Buffer packet, Reader inStream) throws SQLException {
        StringBuffer valueAsString;
        block8: {
            char[] buf = new char[4096];
            valueAsString = new StringBuffer();
            int numRead = 0;
            try {
                try {
                    while ((numRead = inStream.read(buf)) != -1) {
                        valueAsString.append(buf, 0, numRead);
                    }
                    Object var8_6 = null;
                    if (inStream == null) break block8;
                }
                catch (IOException ioEx) {
                    throw new SQLException(Messages.getString("ServerPreparedStatement.24") + ioEx.toString(), "S1000");
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (inStream == null) throw throwable;
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioEx) {}
            inStream.close();
        }
        byte[] valueAsBytes = StringUtils.getBytes(valueAsString.toString(), this.getEncoding(), this.getServerCharacterEncoding(), this.parserKnowsUnicode());
        packet.writeBytesNoNull(valueAsBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeStream(Buffer packet, InputStream inStream) throws SQLException {
        byte[] buf = new byte[4096];
        int numRead = 0;
        try {
            try {
                while ((numRead = inStream.read(buf)) != -1) {
                    packet.writeBytesNoNull(buf, 0, numRead);
                }
                Object var7_5 = null;
                if (inStream == null) return;
            }
            catch (IOException ioEx) {
                throw new SQLException(Messages.getString("ServerPreparedStatement.25") + ioEx.toString(), "S1000");
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioEx) {}
        inStream.close();
        return;
    }

    protected boolean hasLongColumnInfo() {
        return this.io.hasLongColumnInfo();
    }

    public String getDatabase() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws SQLException {
        SQLException caughtWhileClosing = null;
        if (!this.isClosed) {
            try {
                this.io.forceClose();
            }
            catch (Exception ex) {
                caughtWhileClosing = new SQLException(ex.toString());
            }
            finally {
                this.isAborted = true;
            }
        }
        if (caughtWhileClosing != null) {
            throw caughtWhileClosing;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NULL_LOGGER = new NullLogger(LOGGER_INSTANCE_NAME);
        Connection.loadCharacterSetMapping();
        mapTransIsolationNameToValue = new HashMap(8);
        mapTransIsolationNameToValue.put("READ-UNCOMMITED", new Integer(1));
        mapTransIsolationNameToValue.put("READ-UNCOMMITTED", new Integer(1));
        mapTransIsolationNameToValue.put("READ-COMMITTED", new Integer(2));
        mapTransIsolationNameToValue.put("REPEATABLE-READ", new Integer(4));
        mapTransIsolationNameToValue.put("SERIALIZABLE", new Integer(8));
        CHARSET_CONVERTER_NOT_AVAILABLE_MARKER = new Object();
    }

    class UltraDevWorkAround
    implements java.sql.CallableStatement {
        private java.sql.PreparedStatement delegate = null;

        UltraDevWorkAround(java.sql.PreparedStatement pstmt) {
            this.delegate = pstmt;
        }

        public void setArray(int p1, java.sql.Array p2) throws SQLException {
            this.delegate.setArray(p1, p2);
        }

        public java.sql.Array getArray(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public java.sql.Array getArray(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setAsciiStream(p1, p2, p3);
        }

        public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBigDecimal(int p1, BigDecimal p2) throws SQLException {
            this.delegate.setBigDecimal(p1, p2);
        }

        public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
            throw new NotImplemented();
        }

        public BigDecimal getBigDecimal(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(String arg0) throws SQLException {
            return null;
        }

        public void setBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setBinaryStream(p1, p2, p3);
        }

        public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBlob(int p1, Blob p2) throws SQLException {
            this.delegate.setBlob(p1, p2);
        }

        public Blob getBlob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Blob getBlob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBoolean(int p1, boolean p2) throws SQLException {
            this.delegate.setBoolean(p1, p2);
        }

        public void setBoolean(String arg0, boolean arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean getBoolean(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getBoolean(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setByte(int p1, byte p2) throws SQLException {
            this.delegate.setByte(p1, p2);
        }

        public void setByte(String arg0, byte arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte getByte(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte getByte(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBytes(int p1, byte[] p2) throws SQLException {
            this.delegate.setBytes(p1, p2);
        }

        public void setBytes(String arg0, byte[] arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte[] getBytes(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte[] getBytes(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setCharacterStream(int p1, Reader p2, int p3) throws SQLException {
            this.delegate.setCharacterStream(p1, p2, p3);
        }

        public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setClob(int p1, Clob p2) throws SQLException {
            this.delegate.setClob(p1, p2);
        }

        public Clob getClob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Clob getClob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.Connection getConnection() throws SQLException {
            return this.delegate.getConnection();
        }

        public void setCursorName(String p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setDate(int p1, Date p2) throws SQLException {
            this.delegate.setDate(p1, p2);
        }

        public void setDate(int p1, Date p2, Calendar p3) throws SQLException {
            this.delegate.setDate(p1, p2, p3);
        }

        public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setDate(String arg0, Date arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setDouble(int p1, double p2) throws SQLException {
            this.delegate.setDouble(p1, p2);
        }

        public void setDouble(String arg0, double arg1) throws SQLException {
            throw new NotImplemented();
        }

        public double getDouble(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public double getDouble(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setEscapeProcessing(boolean p1) throws SQLException {
            this.delegate.setEscapeProcessing(p1);
        }

        public void setFetchDirection(int p1) throws SQLException {
            this.delegate.setFetchDirection(p1);
        }

        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        public void setFetchSize(int p1) throws SQLException {
            this.delegate.setFetchSize(p1);
        }

        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        public void setFloat(int p1, float p2) throws SQLException {
            this.delegate.setFloat(p1, p2);
        }

        public void setFloat(String arg0, float arg1) throws SQLException {
            throw new NotImplemented();
        }

        public float getFloat(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public float getFloat(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        public void setInt(int p1, int p2) throws SQLException {
            this.delegate.setInt(p1, p2);
        }

        public void setInt(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public int getInt(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getInt(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setLong(int p1, long p2) throws SQLException {
            this.delegate.setLong(p1, p2);
        }

        public void setLong(String arg0, long arg1) throws SQLException {
            throw new NotImplemented();
        }

        public long getLong(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public long getLong(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setMaxFieldSize(int p1) throws SQLException {
            this.delegate.setMaxFieldSize(p1);
        }

        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        public void setMaxRows(int p1) throws SQLException {
            this.delegate.setMaxRows(p1);
        }

        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        public boolean getMoreResults(int arg0) throws SQLException {
            return this.delegate.getMoreResults();
        }

        public void setNull(int p1, int p2) throws SQLException {
            this.delegate.setNull(p1, p2);
        }

        public void setNull(int p1, int p2, String p3) throws SQLException {
            this.delegate.setNull(p1, p2, p3);
        }

        public void setNull(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setNull(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(int p1, Object p2) throws SQLException {
            this.delegate.setObject(p1, p2);
        }

        public void setObject(int p1, Object p2, int p3) throws SQLException {
            this.delegate.setObject(p1, p2, p3);
        }

        public void setObject(int p1, Object p2, int p3, int p4) throws SQLException {
            this.delegate.setObject(p1, p2, p3, p4);
        }

        public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(int p1, Map p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(String arg0, Map arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        public void setQueryTimeout(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        public void setRef(int p1, Ref p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        public void setShort(int p1, short p2) throws SQLException {
            this.delegate.setShort(p1, p2);
        }

        public void setShort(String arg0, short arg1) throws SQLException {
            throw new NotImplemented();
        }

        public short getShort(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public short getShort(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setString(int p1, String p2) throws SQLException {
            this.delegate.setString(p1, p2);
        }

        public void setString(String arg0, String arg1) throws SQLException {
            throw new NotImplemented();
        }

        public String getString(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public String getString(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(int p1, Time p2) throws SQLException {
            this.delegate.setTime(p1, p2);
        }

        public void setTime(int p1, Time p2, Calendar p3) throws SQLException {
            this.delegate.setTime(p1, p2, p3);
        }

        public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(String arg0, Time arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(int p1, Timestamp p2) throws SQLException {
            this.delegate.setTimestamp(p1, p2);
        }

        public void setTimestamp(int p1, Timestamp p2, Calendar p3) throws SQLException {
            this.delegate.setTimestamp(p1, p2, p3);
        }

        public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(String arg0, URL arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(int arg0, URL arg1) throws SQLException {
            this.delegate.setURL(arg0, arg1);
        }

        public URL getURL(int arg0) throws SQLException {
            throw new NotImplemented();
        }

        public URL getURL(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setUnicodeStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setUnicodeStream(p1, p2, p3);
        }

        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        public void addBatch(String p1) throws SQLException {
            this.delegate.addBatch(p1);
        }

        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        public void close() throws SQLException {
            this.delegate.close();
        }

        public boolean execute() throws SQLException {
            return this.delegate.execute();
        }

        public boolean execute(String p1) throws SQLException {
            return this.delegate.execute(p1);
        }

        public boolean execute(String arg0, int arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, int[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, String[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public int[] executeBatch() throws SQLException {
            return this.delegate.executeBatch();
        }

        public java.sql.ResultSet executeQuery() throws SQLException {
            return this.delegate.executeQuery();
        }

        public java.sql.ResultSet executeQuery(String p1) throws SQLException {
            return this.delegate.executeQuery(p1);
        }

        public int executeUpdate() throws SQLException {
            return this.delegate.executeUpdate();
        }

        public int executeUpdate(String p1) throws SQLException {
            return this.delegate.executeUpdate(p1);
        }

        public int executeUpdate(String arg0, int arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public void registerOutParameter(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, int p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, String p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(String arg0, int arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean wasNull() throws SQLException {
            throw new SQLException("Not supported");
        }
    }

    class CompoundCacheKey {
        String componentOne;
        String componentTwo;
        int hashCode;

        CompoundCacheKey(String partOne, String partTwo) {
            this.componentOne = partOne;
            this.componentTwo = partTwo;
            this.hashCode = ((this.componentOne != null ? this.componentOne : "") + this.componentTwo).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompoundCacheKey) {
                CompoundCacheKey another = (CompoundCacheKey)obj;
                boolean firstPartEqual = false;
                firstPartEqual = this.componentOne == null ? another.componentOne == null : this.componentOne.equals(another.componentOne);
                return firstPartEqual && this.componentTwo.equals(another.componentTwo);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

