/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.util;

import java.io.IOException;
import java.io.InputStream;

public class ReadAheadInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private InputStream underlyingStream;
    private byte[] buf;
    protected int endOfCurrentData;
    protected int currentPosition;

    private void fill(int readAtLeastTheseManyBytes) throws IOException {
        int n;
        this.checkClosed();
        this.endOfCurrentData = this.currentPosition = 0;
        int bytesToRead = Math.min(this.buf.length - this.currentPosition, readAtLeastTheseManyBytes);
        int bytesAvailable = this.underlyingStream.available();
        if (bytesAvailable > bytesToRead) {
            bytesToRead = Math.min(this.buf.length - this.currentPosition, bytesAvailable);
        }
        if ((n = this.underlyingStream.read(this.buf, this.currentPosition, bytesToRead)) > 0) {
            this.endOfCurrentData = n + this.currentPosition;
        }
    }

    private int readFromUnderlyingStreamIfNecessary(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int avail = this.endOfCurrentData - this.currentPosition;
        if (avail <= 0) {
            if (len >= this.buf.length) {
                return this.underlyingStream.read(b, off, len);
            }
            this.fill(len);
            avail = this.endOfCurrentData - this.currentPosition;
            if (avail <= 0) {
                return -1;
            }
        }
        int bytesActuallyRead = avail < len ? avail : len;
        System.arraycopy(this.buf, this.currentPosition, b, off, bytesActuallyRead);
        this.currentPosition += bytesActuallyRead;
        return bytesActuallyRead;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int bytesReadThisRound;
        this.checkClosed();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totalBytesRead = 0;
        do {
            if ((bytesReadThisRound = this.readFromUnderlyingStreamIfNecessary(b, off + totalBytesRead, len - totalBytesRead)) > 0) continue;
            if (totalBytesRead != 0) break;
            totalBytesRead = bytesReadThisRound;
            break;
        } while ((totalBytesRead += bytesReadThisRound) < len && this.underlyingStream.available() > 0);
        return totalBytesRead;
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.endOfCurrentData) {
            this.fill(1);
            if (this.currentPosition >= this.endOfCurrentData) {
                return -1;
            }
        }
        return this.buf[this.currentPosition++] & 0xFF;
    }

    public int available() throws IOException {
        this.checkClosed();
        return this.underlyingStream.available() + (this.endOfCurrentData - this.currentPosition);
    }

    private void checkClosed() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    public ReadAheadInputStream(InputStream toBuffer) {
        this(toBuffer, 4096);
    }

    public ReadAheadInputStream(InputStream toBuffer, int bufferSize) {
        this.underlyingStream = toBuffer;
        this.buf = new byte[bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.underlyingStream != null) {
            try {
                this.underlyingStream.close();
                Object var2_1 = null;
                this.underlyingStream = null;
                this.buf = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.underlyingStream = null;
                this.buf = null;
                throw throwable;
            }
        }
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long n) throws IOException {
        this.checkClosed();
        if (n <= 0L) {
            return 0L;
        }
        long bytesAvailInBuffer = this.endOfCurrentData - this.currentPosition;
        if (bytesAvailInBuffer <= 0L) {
            this.fill((int)n);
            bytesAvailInBuffer = this.endOfCurrentData - this.currentPosition;
            if (bytesAvailInBuffer <= 0L) {
                return 0L;
            }
        }
        long bytesSkipped = bytesAvailInBuffer < n ? bytesAvailInBuffer : n;
        this.currentPosition = (int)((long)this.currentPosition + bytesSkipped);
        return bytesSkipped;
    }
}

