/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldDeclaration
extends AbstractVariableDeclaration {
    public FieldBinding binding;
    boolean hasBeenResolved = false;
    public Javadoc javadoc;
    public int endPart1Position;
    public int endPart2Position;

    public FieldDeclaration() {
    }

    public FieldDeclaration(char[] name, int sourceStart, int sourceEnd) {
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(MethodScope initializationScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.binding != null && this.binding.isPrivate() && !this.binding.isPrivateUsed() && !initializationScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            initializationScope.problemReporter().unusedPrivateField(this);
        }
        if (this.binding != null && this.binding.isValidBinding() && this.binding.isStatic() && this.binding.constant == ASTNode.NotAConstant && this.binding.declaringClass.isNestedType() && this.binding.declaringClass.isClass() && !this.binding.declaringClass.isStatic()) {
            initializationScope.problemReporter().unexpectedStaticModifierForField((SourceTypeBinding)this.binding.declaringClass, this);
        }
        if (this.initialization != null) {
            flowInfo = this.initialization.analyseCode(initializationScope, flowContext, flowInfo).unconditionalInits();
            flowInfo.markAsDefinitelyAssigned(this.binding);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean isStatic;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (!(this.initialization == null || (isStatic = this.binding.isStatic()) && this.binding.constant != ASTNode.NotAConstant)) {
            if (!isStatic) {
                codeStream.aload_0();
            }
            this.initialization.generateCode(currentScope, codeStream, true);
            if (isStatic) {
                codeStream.putstatic(this.binding);
            } else {
                codeStream.putfield(this.binding);
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public TypeBinding getTypeBinding(Scope scope) {
        return this.type.getTypeBinding(scope);
    }

    public boolean isField() {
        return true;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope initializationScope) {
        if (this.hasBeenResolved) return;
        if (this.binding == null) return;
        if (!this.binding.isValidBinding()) return;
        this.hasBeenResolved = true;
        ClassScope classScope = initializationScope.enclosingClassScope();
        if (classScope != null) {
            Scope outerScope;
            Binding existingVariable;
            FieldBinding existingVariable2;
            SourceTypeBinding declaringType = classScope.enclosingSourceType();
            boolean checkLocal = true;
            if (declaringType.superclass != null && (existingVariable2 = classScope.findField(declaringType.superclass, this.name, this, true)) != null && existingVariable2.isValidBinding()) {
                initializationScope.problemReporter().fieldHiding(this, existingVariable2);
                checkLocal = false;
            }
            if (checkLocal && (existingVariable = (outerScope = classScope.parent).getBinding(this.name, 3, this, false)) != null && existingVariable.isValidBinding()) {
                initializationScope.problemReporter().fieldHiding(this, existingVariable);
            }
        }
        this.type.resolvedType = this.binding.type;
        FieldBinding previousField = initializationScope.initializedField;
        int previousFieldID = initializationScope.lastVisibleFieldID;
        try {
            initializationScope.initializedField = this.binding;
            initializationScope.lastVisibleFieldID = this.binding.id;
            if (this.isTypeUseDeprecated(this.binding.type, initializationScope)) {
                initializationScope.problemReporter().deprecatedType(this.binding.type, this.type);
            }
            if (this.initialization == null) {
                this.binding.constant = Constant.NotAConstant;
            } else {
                TypeBinding initializationTypeBinding;
                this.binding.constant = Constant.NotAConstant;
                TypeBinding typeBinding = this.binding.type;
                if (this.initialization instanceof ArrayInitializer) {
                    initializationTypeBinding = this.initialization.resolveTypeExpecting(initializationScope, typeBinding);
                    if (initializationTypeBinding != null) {
                        ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initializationTypeBinding;
                        this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                    }
                } else {
                    initializationTypeBinding = this.initialization.resolveType(initializationScope);
                    if (initializationTypeBinding != null) {
                        if (this.initialization.isConstantValueOfTypeAssignableToType(initializationTypeBinding, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, initializationTypeBinding.id)) {
                            this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                        } else if (initializationTypeBinding.isCompatibleWith(typeBinding)) {
                            this.initialization.implicitWidening(typeBinding, initializationTypeBinding);
                        } else {
                            initializationScope.problemReporter().typeMismatchError(initializationTypeBinding, typeBinding, this);
                        }
                        if (this.binding.isFinal()) {
                            this.binding.constant = this.initialization.constant.castTo((this.binding.type.id << 4) + this.initialization.constant.typeID());
                        }
                    } else {
                        this.binding.constant = ASTNode.NotAConstant;
                    }
                }
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(initializationScope);
            } else if (this.binding != null && this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
                initializationScope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
            }
            Object var7_9 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            if (this.binding.constant != null) return;
            this.binding.constant = Constant.NotAConstant;
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            if (this.binding.constant != null) throw throwable;
            this.binding.constant = Constant.NotAConstant;
            throw throwable;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

