/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

class Buffer {
    static final int MAX_BYTES_TO_DUMP = 512;
    static final int NO_LENGTH_LIMIT = -1;
    static final long NULL_LENGTH = -1L;
    private int bufLength = 0;
    private byte[] byteBuffer;
    private int position = 0;
    protected boolean wasMultiPacket = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;
    private static final JoinPoint.StaticPart ajc$tjp_52;
    private static final JoinPoint.StaticPart ajc$tjp_53;

    Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    Buffer(int size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
    }

    final void clear() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.position = 4;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    final void dump() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.dump(this.getBufLength());
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final String dump(int n) {
        void numBytes;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = StringUtils.dumpAsHex(this.getBytes(0, numBytes > this.getBufLength() ? this.getBufLength() : numBytes), numBytes > this.getBufLength() ? this.getBufLength() : numBytes);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    final String dumpClampedBytes(int n) {
        int numBytes;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int numBytesToDump = numBytes < 512 ? numBytes : 512;
        String dumped = StringUtils.dumpAsHex(this.getBytes(0, numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump), numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump);
        String string = numBytesToDump < numBytes ? String.valueOf(dumped) + " ....(packet exceeds max. dump length)" : dumped;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    final void dumpHeader() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = 0;
        while (i < 4) {
            String hexVal = Integer.toHexString(this.readByte(i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            ++i;
        }
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void dumpNBytes(int n, int n2) {
        void nBytes;
        void start;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer asciiBuf = new StringBuffer();
        void i = start;
        while (i < start + nBytes && i < this.getBufLength()) {
            String hexVal = Integer.toHexString(this.readByte((int)i) & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(String.valueOf(hexVal) + " ");
            if (this.readByte((int)i) > 32 && this.readByte((int)i) < 127) {
                asciiBuf.append((char)this.readByte((int)i));
            } else {
                asciiBuf.append(".");
            }
            asciiBuf.append(" ");
            ++i;
        }
        System.out.println("    " + asciiBuf.toString());
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void ensureCapacity(int n) throws SQLException {
        void additionalData;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.position + additionalData > this.getBufLength()) {
            if (this.position + additionalData < this.byteBuffer.length) {
                this.setBufLength(this.byteBuffer.length);
            } else {
                int newLength = (int)((double)this.byteBuffer.length * 1.25);
                if (newLength < this.byteBuffer.length + additionalData) {
                    newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
                }
                if (newLength < this.byteBuffer.length) {
                    newLength = this.byteBuffer.length + additionalData;
                }
                byte[] newBytes = new byte[newLength];
                System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
                this.byteBuffer = newBytes;
                this.setBufLength(this.byteBuffer.length);
            }
        }
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    public int fastSkipLenString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        int n = (int)len;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    protected final byte[] getBufferSource() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] byArray = this.byteBuffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return this.byteBuffer;
    }

    int getBufLength() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.bufLength;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public byte[] getByteBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] byArray = this.byteBuffer;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return this.byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] getBytes(int n) {
        void len;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, (int)len);
        this.position += len;
        byte[] byArray = b;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return b;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytes(int n, int n2) {
        void offset;
        void len;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] dest = new byte[len];
        System.arraycopy(this.byteBuffer, (int)offset, dest, 0, (int)len);
        byte[] byArray = dest;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray, joinPoint);
        return dest;
    }

    int getCapacity() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.byteBuffer.length;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public ByteBuffer getNioBuffer() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new IllegalArgumentException(Messages.getString("ByteArrayBuffer.0"));
    }

    public int getPosition() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.position;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final boolean isLastDataPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.getBufLength() < 9 && (this.byteBuffer[0] & 0xFF) == 254;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    final long newReadLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final byte readByte() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = this.byteBuffer[this.position++];
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    /*
     * WARNING - void declaration
     */
    final byte readByte(int n) {
        void readAt;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte by = this.byteBuffer[readAt];
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.byteObject((byte)by), joinPoint);
        return by;
    }

    final long readFieldLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = -1L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLongLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final int readInt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final int readIntAsLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16 | (b[this.position++] & 0xFF) << 24;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    final byte[] readLenByteArray(int n) {
        byte[] byArray;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long len = this.readFieldLength();
        if (len == -1L) {
            byArray = null;
        } else if (len == 0L) {
            byArray = Constants.EMPTY_BYTE_ARRAY;
        } else {
            void offset;
            this.position += offset;
            byArray = this.getBytes((int)len);
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    final long readLength() {
        long l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                l = 0L;
                break;
            }
            case 252: {
                l = this.readInt();
                break;
            }
            case 253: {
                l = this.readLongInt();
                break;
            }
            case 254: {
                l = this.readLong();
                break;
            }
            default: {
                l = sw;
                break;
            }
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l;
    }

    final long readLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        long l = (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    final int readLongInt() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        int n = b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    final long readLongLong() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = this.byteBuffer;
        long l = (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    final int readnBytes() {
        int n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                n = this.byteBuffer[this.position++] & 0xFF;
                break;
            }
            case 2: {
                n = this.readInt();
                break;
            }
            case 3: {
                n = this.readLongInt();
                break;
            }
            case 4: {
                n = (int)this.readLong();
                break;
            }
            default: {
                n = 255;
                break;
            }
        }
        int n2 = n;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
        return n;
    }

    final String readString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i < maxLen && this.byteBuffer[i] != 0) {
            ++len;
            ++i;
        }
        String s = new String(this.byteBuffer, this.position, len);
        this.position += len + 1;
        String string = s;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String readString(String string) throws SQLException {
        String string2;
        String string3 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)string3);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int i = this.position;
        int len = 0;
        int maxLen = this.getBufLength();
        while (i < maxLen && this.byteBuffer[i] != 0) {
            ++len;
            ++i;
        }
        try {
            void encoding;
            try {
                String string4 = new String(this.byteBuffer, this.position, len, (String)encoding);
                Object var5_8 = null;
                this.position += len + 1;
                string2 = string4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw SQLError.createSQLException(String.valueOf(Messages.getString("ByteArrayBuffer.1")) + (String)encoding + "'", "S1009");
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.position += len + 1;
            throw throwable;
        }
        String string5 = string2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string5, joinPoint);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    void setBufLength(int n) {
        void bufLengthToSet;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.bufLength = bufLengthToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setByteBuffer(byte[] byArray) {
        void byteBufferToSet;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.byteBuffer = byteBufferToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setPosition(int n) {
        void positionToSet;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.position = positionToSet;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    public void setWasMultiPacket(boolean bl) {
        void flag;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.wasMultiPacket = flag;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.dumpClampedBytes(this.getPosition());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String toSuperString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = super.toString();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public boolean wasMultiPacket() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.wasMultiPacket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    final void writeByte(byte by) throws SQLException {
        void b;
        byte by2 = by;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.byteObject((byte)by2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(1);
        this.byteBuffer[this.position++] = b;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray) throws SQLException {
        void bytes;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)bytes).length;
        this.ensureCapacity(len);
        System.arraycopy(bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeBytesNoNull(byte[] byArray, int n, int n2) throws SQLException {
        void offset;
        void bytes;
        void length;
        byte[] byArray2 = byArray;
        int n3 = n;
        int n4 = n2;
        Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity((int)length);
        System.arraycopy(bytes, (int)offset, this.byteBuffer, this.position, (int)length);
        this.position += length;
        Object var9_9 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var9_9, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeDouble(double d) throws SQLException {
        void d2;
        double d3 = d;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)Conversions.doubleObject((double)d3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = Double.doubleToLongBits((double)d2);
        this.writeLongLong(l);
        Object var8_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var8_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFieldLength(long l) throws SQLException {
        void length;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (length < 251L) {
            this.writeByte((byte)length);
        } else if (length < 65536L) {
            this.ensureCapacity(3);
            this.writeByte((byte)-4);
            this.writeInt((int)length);
        } else if (length < 0x1000000L) {
            this.ensureCapacity(4);
            this.writeByte((byte)-3);
            this.writeLongInt((int)length);
        } else {
            this.ensureCapacity(9);
            this.writeByte((byte)-2);
            this.writeLongLong((long)length);
        }
        Object var6_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeFloat(float f) throws SQLException {
        void f2;
        float f3 = f;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this, (Object)Conversions.floatObject((float)f3));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        int i = Float.floatToIntBits((float)f2);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(2);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenBytes(byte[] byArray) throws SQLException {
        void b;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = ((void)b).length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLenString(String string, String string2, String string3, SingleByteCharsetConverter singleByteCharsetConverter, boolean bl, Connection connection) throws UnsupportedEncodingException, SQLException {
        void conn;
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        void converter;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        SingleByteCharsetConverter singleByteCharsetConverter2 = singleByteCharsetConverter;
        boolean bl2 = bl;
        Connection connection2 = connection;
        Object[] objectArray = new Object[]{string4, string5, string6, singleByteCharsetConverter2, Conversions.booleanObject((boolean)bl2), connection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = null;
        b = converter != null ? converter.toBytes((String)s) : StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode, (Connection)conn);
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var17_17 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var17_17, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(4);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        Object var7_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongInt(int n) throws SQLException {
        void i;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(3);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeLongLong(long l) throws SQLException {
        void i;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(8);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        b[this.position++] = (byte)(i >>> 32);
        b[this.position++] = (byte)(i >>> 40);
        b[this.position++] = (byte)(i >>> 48);
        b[this.position++] = (byte)(i >>> 56);
        Object var7_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var7_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeString(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(s.length() * 2 + 1);
        this.writeStringNoNull((String)s);
        this.byteBuffer[this.position++] = 0;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeString(String string, String string2, Connection connection) throws SQLException {
        void s;
        String string3 = string;
        String string4 = string2;
        Connection connection2 = connection;
        Object[] objectArray = new Object[]{string3, string4, connection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.ensureCapacity(s.length() * 2 + 1);
        try {
            void conn;
            void encoding;
            this.writeStringNoNull((String)s, (String)encoding, (String)encoding, false, (Connection)conn);
        }
        catch (UnsupportedEncodingException ue) {
            throw new SQLException(ue.toString(), "S1000");
        }
        this.byteBuffer[this.position++] = 0;
        Object var10_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_10, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string) throws SQLException {
        void s;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, (Object)this, (Object)this, (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int len = s.length();
        this.ensureCapacity(len * 2);
        System.arraycopy(s.getBytes(), 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var5_5 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var5_5, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    final void writeStringNoNull(String string, String string2, String string3, boolean bl, Connection connection) throws UnsupportedEncodingException, SQLException {
        void conn;
        void parserKnowsUnicode;
        void serverEncoding;
        void encoding;
        void s;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        boolean bl2 = bl;
        Connection connection2 = connection;
        Object[] objectArray = new Object[]{string4, string5, string6, Conversions.booleanObject((boolean)bl2), connection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        byte[] b = StringUtils.getBytes((String)s, (String)encoding, (String)serverEncoding, (boolean)parserKnowsUnicode, (Connection)conn);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
        Object var15_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var15_15, joinPoint);
    }

    static {
        Factory factory = new Factory("Buffer.java", Class.forName("com.mysql.jdbc.Buffer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-clear-com.mysql.jdbc.Buffer----void-"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dump-com.mysql.jdbc.Buffer----void-"), 70);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getByteBuffer-com.mysql.jdbc.Buffer----[B-"), 194);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-getBytes-com.mysql.jdbc.Buffer-int:-len:--[B-"), 198);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBytes-com.mysql.jdbc.Buffer-int:int:-offset:len:--[B-"), 211);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getCapacity-com.mysql.jdbc.Buffer----int-"), 218);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getNioBuffer-com.mysql.jdbc.Buffer----java.nio.ByteBuffer-"), 222);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPosition-com.mysql.jdbc.Buffer----int-"), 232);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-isLastDataPacket-com.mysql.jdbc.Buffer----boolean-"), 237);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-newReadLength-com.mysql.jdbc.Buffer----long-"), 241);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.Buffer----byte-"), 262);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readByte-com.mysql.jdbc.Buffer-int:-readAt:--byte-"), 266);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dump-com.mysql.jdbc.Buffer-int:-numBytes:--java.lang.String-"), 74);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readFieldLength-com.mysql.jdbc.Buffer----long-"), 270);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readInt-com.mysql.jdbc.Buffer----int-"), 292);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readIntAsLong-com.mysql.jdbc.Buffer----int-"), 298);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLenByteArray-com.mysql.jdbc.Buffer-int:-offset:--[B-"), 306);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLength-com.mysql.jdbc.Buffer----long-"), 322);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLong-com.mysql.jdbc.Buffer----long-"), 344);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongInt-com.mysql.jdbc.Buffer----int-"), 354);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readLongLong-com.mysql.jdbc.Buffer----long-"), 362);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readnBytes-com.mysql.jdbc.Buffer----int-"), 375);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.Buffer----java.lang.String-"), 402);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpClampedBytes-com.mysql.jdbc.Buffer-int:-numBytes:--java.lang.String-"), 80);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-readString-com.mysql.jdbc.Buffer-java.lang.String:-encoding:-java.sql.SQLException:-java.lang.String-"), 418);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setBufLength-com.mysql.jdbc.Buffer-int:-bufLengthToSet:--void-"), 438);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setByteBuffer-com.mysql.jdbc.Buffer-[B:-byteBufferToSet:--void-"), 448);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPosition-com.mysql.jdbc.Buffer-int:-positionToSet:--void-"), 458);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setWasMultiPacket-com.mysql.jdbc.Buffer-boolean:-flag:--void-"), 468);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.Buffer----java.lang.String-"), 472);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toSuperString-com.mysql.jdbc.Buffer----java.lang.String-"), 476);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-wasMultiPacket-com.mysql.jdbc.Buffer----boolean-"), 485);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeByte-com.mysql.jdbc.Buffer-byte:-b:-java.sql.SQLException:-void-"), 489);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.Buffer-[B:-bytes:-java.sql.SQLException:-void-"), 496);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpHeader-com.mysql.jdbc.Buffer----void-"), 97);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeBytesNoNull-com.mysql.jdbc.Buffer-[B:int:int:-bytes:offset:length:-java.sql.SQLException:-void-"), 505);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeDouble-com.mysql.jdbc.Buffer-double:-d:-java.sql.SQLException:-void-"), 511);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFieldLength-com.mysql.jdbc.Buffer-long:-length:-java.sql.SQLException:-void-"), 516);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeFloat-com.mysql.jdbc.Buffer-float:-f:-java.sql.SQLException:-void-"), 534);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeInt-com.mysql.jdbc.Buffer-int:-i:-java.sql.SQLException:-void-"), 546);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenBytes-com.mysql.jdbc.Buffer-[B:-b:-java.sql.SQLException:-void-"), 556);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLenString-com.mysql.jdbc.Buffer-java.lang.String:java.lang.String:java.lang.String:com.mysql.jdbc.SingleByteCharsetConverter:boolean:com.mysql.jdbc.Connection:-s:encoding:serverEncoding:converter:parserKnowsUnicode:conn:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 569);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLong-com.mysql.jdbc.Buffer-long:-i:-java.sql.SQLException:-void-"), 587);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongInt-com.mysql.jdbc.Buffer-int:-i:-java.sql.SQLException:-void-"), 598);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeLongLong-com.mysql.jdbc.Buffer-long:-i:-java.sql.SQLException:-void-"), 606);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-dumpNBytes-com.mysql.jdbc.Buffer-int:int:-start:nBytes:--void-"), 109);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeString-com.mysql.jdbc.Buffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 620);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeString-com.mysql.jdbc.Buffer-java.lang.String:java.lang.String:com.mysql.jdbc.Connection:-s:encoding:conn:-java.sql.SQLException:-void-"), 627);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.Buffer-java.lang.String:-s:-java.sql.SQLException:-void-"), 639);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-writeStringNoNull-com.mysql.jdbc.Buffer-java.lang.String:java.lang.String:java.lang.String:boolean:com.mysql.jdbc.Connection:-s:encoding:serverEncoding:parserKnowsUnicode:conn:-java.io.UnsupportedEncodingException:java.sql.SQLException:-void-"), 655);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("10-ensureCapacity-com.mysql.jdbc.Buffer-int:-additionalData:-java.sql.SQLException:-void-"), 133);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-fastSkipLenString-com.mysql.jdbc.Buffer----int-"), 173);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("14-getBufferSource-com.mysql.jdbc.Buffer----[B-"), 181);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBufLength-com.mysql.jdbc.Buffer----int-"), 185);
    }
}

