/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.UTFDataFormatException;

public class Field {
    protected byte[] buffer;
    protected int offset;
    protected int length;

    public Field(byte[] bytes) {
        this.buffer = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public Field(byte[] bytes, int length) {
        this.buffer = bytes;
        this.offset = 0;
        this.length = length;
    }

    public Field(byte[] bytes, int offset, int length) {
        this.buffer = bytes;
        this.offset = offset;
        this.length = length;
    }

    public Field(int length) {
        this.buffer = new byte[length];
        this.offset = 0;
        this.length = length;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public Field buffer(byte[] someBuffer) {
        this.buffer = someBuffer;
        return this;
    }

    public Field clear() {
        Field.clear(this.buffer, this.offset, this.length);
        return this;
    }

    protected static void clear(byte[] buffer, int offset, int length) {
        int n = offset;
        int i = 0;
        while (i < length) {
            buffer[n] = 0;
            ++n;
            ++i;
        }
    }

    public Field clear(int someLength) {
        Field.clear(this.buffer, this.offset, someLength);
        return this;
    }

    public Field clear(int someOffset, int someLength) {
        Field.clear(this.buffer, this.offset + someOffset, someLength);
        return this;
    }

    protected static int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        int n = Math.min(length1, length2);
        int i = 0;
        while (i < n) {
            int j1 = buffer1[offset1 + i] & 0xFF;
            int j2 = buffer2[offset2 + i] & 0xFF;
            if (j1 > j2) {
                return 1;
            }
            if (j1 < j2) {
                return -1;
            }
            ++i;
        }
        if (length1 > n) {
            i = n;
            while (i < length1) {
                if (buffer1[offset1 + i] != 0) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        i = n;
        while (i < length2) {
            if (buffer2[offset2 + i] != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public static int compare(Field f1, Field f2) {
        return Field.compare(f1.buffer, f1.offset, f1.length, f2.buffer, f2.offset, f2.length);
    }

    public Field copy(int fromOffset, int toOffset, int someLength) {
        System.arraycopy(this.buffer, this.offset + fromOffset, this.buffer, this.offset + toOffset, someLength);
        return this;
    }

    public Field dec(int n) {
        this.offset -= n;
        return this;
    }

    public byte[] get() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.buffer, this.offset, result, 0, this.length);
        return result;
    }

    public byte[] get(int someOffset, int someLength) {
        byte[] result = new byte[someLength];
        System.arraycopy(this.buffer, this.offset + someOffset, result, 0, someLength);
        return result;
    }

    public Field getField(int someOffset, int someLength) {
        return new Field(this.buffer, this.offset + someOffset, someLength);
    }

    public int getInt1() {
        return this.buffer[this.offset];
    }

    public int getInt1(int someOffset) {
        return this.buffer[this.offset + someOffset];
    }

    public int getInt2() {
        int i = this.offset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getInt2(int someOffset) {
        int i = this.offset + someOffset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getInt3() {
        int i = this.offset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getInt3(int someOffset) {
        int i = this.offset + someOffset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getInt4() {
        int i = this.offset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getInt4(int someOffset) {
        int i = this.offset + someOffset;
        int v = this.buffer[i++];
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getUInt1() {
        return this.buffer[this.offset] & 0xFF;
    }

    public int getUInt1(int someOffset) {
        return this.buffer[this.offset + someOffset] & 0xFF;
    }

    public int getUInt2() {
        int i = this.offset;
        int v = this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getUInt2(int someOffset) {
        int i = this.offset + someOffset;
        int v = this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getUInt3() {
        int i = this.offset;
        int v = this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public int getUInt3(int someOffset) {
        int i = this.offset + someOffset;
        int v = this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        v = v << 8 | this.buffer[i++] & 0xFF;
        return v;
    }

    public char[] getUTF(int someOffset) throws UTFDataFormatException {
        int pos = this.offset + someOffset;
        int utflen = this.getUInt2(pos);
        pos += 2;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = this.buffer[pos++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    int char2;
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    if (((char2 = this.buffer[pos++] & 0xFF) & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.buffer[pos++] & 0xFF;
                    int char3 = this.buffer[pos++] & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public Field inc(int n) {
        this.offset += n;
        return this;
    }

    public int length() {
        return this.length;
    }

    public Field length(int someLength) {
        this.length = someLength;
        return this;
    }

    public int offset() {
        return this.offset;
    }

    public Field offset(int someOffset) {
        this.offset = someOffset;
        return this;
    }

    public Field pointTo(int someOffset) {
        return new Field(this.buffer, this.offset + someOffset, 0);
    }

    public Field put(byte[] b) {
        return this.put(0, b);
    }

    public Field put(int someOffset, byte[] b) {
        System.arraycopy(b, 0, this.buffer, this.offset + someOffset, b.length);
        return this;
    }

    public Field put(int someOffset, Field f) {
        System.arraycopy(f.buffer, f.offset, this.buffer, this.offset + someOffset, f.length);
        return this;
    }

    public Field put(Field f) {
        System.arraycopy(f.buffer, f.offset, this.buffer, this.offset, f.length);
        return this;
    }

    public Field putInt1(int n) {
        this.buffer[this.offset] = (byte)n;
        return this;
    }

    public Field putInt1(int someOffset, int n) {
        this.buffer[this.offset + someOffset] = (byte)n;
        return this;
    }

    public Field putInt2(int n) {
        int i = this.offset;
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt2(int someOffset, int n) {
        int i = this.offset + someOffset;
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt3(int n) {
        int i = this.offset;
        this.buffer[i++] = (byte)(n >> 16);
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt3(int someOffset, int n) {
        int i = this.offset + someOffset;
        this.buffer[i++] = (byte)(n >> 16);
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt4(int n) {
        int i = this.offset;
        this.buffer[i++] = (byte)(n >> 24);
        this.buffer[i++] = (byte)(n >> 16);
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public Field putInt4(int someOffset, int n) {
        int i = this.offset + someOffset;
        this.buffer[i++] = (byte)(n >> 24);
        this.buffer[i++] = (byte)(n >> 16);
        this.buffer[i++] = (byte)(n >> 8);
        this.buffer[i++] = (byte)(n >> 0);
        return this;
    }

    public int putUTF(int someOffset, char[] str) {
        int strlen = str.length;
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            char c = str[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new IllegalArgumentException();
        }
        int pos = this.offset + someOffset;
        this.buffer[pos++] = (byte)(utflen >>> 8 & 0xFF);
        this.buffer[pos++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            char c = str[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer[pos++] = (byte)c;
            } else if (c > '\u07ff') {
                this.buffer[pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                this.buffer[pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[pos++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        return 2 + utflen;
    }
}

