/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.trace.Tracer;
import java.io.UnsupportedEncodingException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    private static final int NO_CHARSET_INFO = -1;
    private byte[] buffer;
    private int charsetIndex = 0;
    private String charsetName = null;
    private int colDecimals;
    private short colFlag;
    private String collationName = null;
    private Connection connection = null;
    private String databaseName = null;
    private int databaseNameLength = -1;
    private int databaseNameStart = -1;
    private int defaultValueLength = -1;
    private int defaultValueStart = -1;
    private String fullName = null;
    private String fullOriginalName = null;
    private boolean isImplicitTempTable = false;
    private long length;
    private int mysqlType = -1;
    private String name;
    private int nameLength;
    private int nameStart;
    private String originalColumnName = null;
    private int originalColumnNameLength = -1;
    private int originalColumnNameStart = -1;
    private String originalTableName = null;
    private int originalTableNameLength = -1;
    private int originalTableNameStart = -1;
    private int precisionAdjustFactor = 0;
    private int sqlType = -1;
    private String tableName;
    private int tableNameLength;
    private int tableNameStart;
    private boolean useOldNameMetadata = false;
    private boolean isSingleBit;
    private int maxBytesPerChar;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;

    Field(Connection conn, byte[] buffer, int databaseNameStart, int databaseNameLength, int tableNameStart, int tableNameLength, int originalTableNameStart, int originalTableNameLength, int nameStart, int nameLength, int originalColumnNameStart, int originalColumnNameLength, long length, int mysqlType, short colFlag, int colDecimals, int defaultValueStart, int defaultValueLength, int charsetIndex) throws SQLException {
        this.connection = conn;
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.mysqlType = mysqlType;
        this.databaseNameStart = databaseNameStart;
        this.databaseNameLength = databaseNameLength;
        this.originalTableNameStart = originalTableNameStart;
        this.originalTableNameLength = originalTableNameLength;
        this.originalColumnNameStart = originalColumnNameStart;
        this.originalColumnNameLength = originalColumnNameLength;
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
        this.charsetIndex = charsetIndex;
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
        this.checkForImplicitTemporaryTable();
        if (this.mysqlType == 252) {
            boolean isFromFunction;
            boolean bl = isFromFunction = this.originalTableNameLength == 0;
            if (this.connection != null && this.connection.getBlobsAreStrings() || this.connection.getFunctionsNeverReturnBlobs() && isFromFunction) {
                this.sqlType = 12;
                this.mysqlType = 15;
            } else if (this.charsetIndex == 63 || !this.connection.versionMeetsMinimum(4, 1, 0)) {
                this.setBlobTypeBasedOnLength();
                this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
            } else {
                this.mysqlType = 253;
                this.sqlType = -1;
            }
        }
        if (this.sqlType == -6 && this.length == 1L && this.connection.getTinyInt1isBit() && conn.getTinyInt1isBit()) {
            this.sqlType = conn.getTransformedBitIsBoolean() ? 16 : -7;
        }
        if (!this.isNativeNumericType() && !this.isNativeDateTimeType()) {
            this.charsetName = this.connection.getCharsetNameForIndex(this.charsetIndex);
            boolean isBinary = this.isBinary();
            if (this.connection.versionMeetsMinimum(4, 1, 0) && this.mysqlType == 253 && isBinary && this.charsetIndex == 63 && this.isOpaqueBinary()) {
                this.sqlType = -3;
            }
            if (this.connection.versionMeetsMinimum(4, 1, 0) && this.mysqlType == 254 && isBinary && this.charsetIndex == 63 && this.isOpaqueBinary() && !this.connection.getBlobsAreStrings()) {
                this.sqlType = -2;
            }
            if (this.mysqlType == 16) {
                boolean bl = this.isSingleBit = this.length == 0L;
                if (this.connection != null && (this.connection.versionMeetsMinimum(5, 0, 21) || this.connection.versionMeetsMinimum(5, 1, 10)) && this.length == 1L) {
                    this.isSingleBit = true;
                }
                if (this.isSingleBit) {
                    this.sqlType = -7;
                } else {
                    this.sqlType = -3;
                    this.colFlag = (short)(this.colFlag | 0x80);
                    this.colFlag = (short)(this.colFlag | 0x10);
                    isBinary = true;
                }
            }
            if (this.sqlType == -4 && !isBinary) {
                this.sqlType = -1;
            } else if (this.sqlType == -3 && !isBinary) {
                this.sqlType = 12;
            }
        } else {
            this.charsetName = "US-ASCII";
        }
        if (!this.isUnsigned()) {
            switch (this.mysqlType) {
                case 0: 
                case 246: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        } else {
            switch (this.mysqlType) {
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        }
    }

    Field(Connection conn, byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, int length, int mysqlType, short colFlag, int colDecimals) throws SQLException {
        this(conn, buffer, -1, -1, tableNameStart, tableNameLength, -1, -1, nameStart, nameLength, -1, -1, length, mysqlType, colFlag, colDecimals, -1, -1, -1);
    }

    Field(String tableName, String columnName, int jdbcType, int length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    private void checkForImplicitTemporaryTable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.isImplicitTempTable = this.tableNameLength > 5 && this.buffer[this.tableNameStart] == 35 && this.buffer[this.tableNameStart + 1] == 115 && this.buffer[this.tableNameStart + 2] == 113 && this.buffer[this.tableNameStart + 3] == 108 && this.buffer[this.tableNameStart + 4] == 95;
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    public String getCharacterSet() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.charsetName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getCollation() throws SQLException {
        JoinPoint joinPoint;
        block9: {
            block10: {
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
                Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                if (this.collationName != null || this.connection == null || !this.connection.versionMeetsMinimum(4, 1, 0)) break block9;
                if (!this.connection.getUseDynamicCharsetInfo()) break block10;
                DatabaseMetaData dbmd = this.connection.getMetaData();
                String quotedIdStr = dbmd.getIdentifierQuoteString();
                if (" ".equals(quotedIdStr)) {
                    quotedIdStr = "";
                }
                String csCatalogName = this.getDatabaseName();
                String csTableName = this.getOriginalTableName();
                String csColumnName = this.getOriginalName();
                if (csCatalogName == null || csCatalogName.length() == 0 || csTableName == null || csTableName.length() == 0 || csColumnName == null || csColumnName.length() == 0) break block9;
                StringBuffer queryBuf = new StringBuffer(csCatalogName.length() + csTableName.length() + 28);
                queryBuf.append("SHOW FULL COLUMNS FROM ");
                queryBuf.append(quotedIdStr);
                queryBuf.append(csCatalogName);
                queryBuf.append(quotedIdStr);
                queryBuf.append(".");
                queryBuf.append(quotedIdStr);
                queryBuf.append(csTableName);
                queryBuf.append(quotedIdStr);
                Statement collationStmt = null;
                ResultSet collationRs = null;
                try {
                    collationStmt = this.connection.createStatement();
                    collationRs = collationStmt.executeQuery(queryBuf.toString());
                    while (collationRs.next()) {
                        if (!csColumnName.equals(collationRs.getString("Field"))) continue;
                        this.collationName = collationRs.getString("Collation");
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (collationRs != null) {
                        collationRs.close();
                        collationRs = null;
                    }
                    if (collationStmt != null) {
                        collationStmt.close();
                        collationStmt = null;
                    }
                    throw throwable;
                }
                {
                    Object var9_12 = null;
                    if (collationRs != null) {
                        collationRs.close();
                        collationRs = null;
                    }
                    if (collationStmt != null) {
                        collationStmt.close();
                        collationStmt = null;
                    }
                    break block9;
                }
            }
            this.collationName = CharsetMapping.INDEX_TO_COLLATION[this.charsetIndex];
        }
        String string = this.collationName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getColumnLabel() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.getName();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getDatabaseName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.databaseName == null && this.databaseNameStart != -1 && this.databaseNameLength != -1) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        String string = this.databaseName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    int getDecimals() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.colDecimals;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public String getFullName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            fullNameBuf = null;
        }
        String string = this.fullName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getFullOriginalName() throws SQLException {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.getOriginalName();
        if (this.originalColumnName == null) {
            string = null;
        } else {
            if (this.fullName == null) {
                StringBuffer fullOriginalNameBuf = new StringBuffer(this.getOriginalTableName().length() + 1 + this.getOriginalName().length());
                fullOriginalNameBuf.append(this.originalTableName);
                fullOriginalNameBuf.append('.');
                fullOriginalNameBuf.append(this.originalColumnName);
                this.fullOriginalName = fullOriginalNameBuf.toString();
                fullOriginalNameBuf = null;
            }
            string = this.fullOriginalName;
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    public long getLength() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l = this.length;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l), joinPoint);
        return l;
    }

    public synchronized int getMaxBytesPerCharacter() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.maxBytesPerChar == 0) {
            this.maxBytesPerChar = this.connection.getMaxBytesPerChar(this.getCharacterSet());
        }
        int n = this.maxBytesPerChar;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public int getMysqlType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.mysqlType;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public String getName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.name == null) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        String string = this.name;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getNameNoAliases() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.useOldNameMetadata ? this.getName() : (this.connection != null && this.connection.versionMeetsMinimum(4, 1, 0) ? this.getOriginalName() : this.getName());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getOriginalName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.originalColumnName == null && this.originalColumnNameStart != -1 && this.originalColumnNameLength != -1) {
            this.originalColumnName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        String string = this.originalColumnName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getOriginalTableName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.originalTableName == null && this.originalTableNameStart != -1 && this.originalTableNameLength != -1) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        String string = this.originalTableName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public int getPrecisionAdjustFactor() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.precisionAdjustFactor;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    public int getSQLType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.sqlType;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private String getStringFromBytes(int n, int n2) throws SQLException {
        String string;
        void stringLength;
        void stringStart;
        int n3 = n;
        int n4 = n2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n3), (Object)Conversions.intObject((int)n4));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (stringStart == -1 || stringLength == -1) {
            string = null;
        } else {
            String stringVal = null;
            if (this.connection != null) {
                if (this.connection.getUseUnicode()) {
                    String encoding = this.connection.getCharacterSetMetadata();
                    if (encoding == null) {
                        encoding = this.connection.getEncoding();
                    }
                    if (encoding != null) {
                        SingleByteCharsetConverter converter = null;
                        if (this.connection != null) {
                            converter = this.connection.getCharsetConverter(encoding);
                        }
                        if (converter != null) {
                            stringVal = converter.toString(this.buffer, (int)stringStart, (int)stringLength);
                        } else {
                            byte[] stringBytes = new byte[stringLength];
                            void endIndex = stringStart + stringLength;
                            int pos = 0;
                            void i = stringStart;
                            while (i < endIndex) {
                                stringBytes[pos++] = this.buffer[i];
                                ++i;
                            }
                            try {
                                stringVal = new String(stringBytes, encoding);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                throw new RuntimeException(String.valueOf(Messages.getString("Field.12")) + encoding + Messages.getString("Field.13"));
                            }
                        }
                    } else {
                        stringVal = StringUtils.toAsciiString(this.buffer, (int)stringStart, (int)stringLength);
                    }
                } else {
                    stringVal = StringUtils.toAsciiString(this.buffer, (int)stringStart, (int)stringLength);
                }
            } else {
                stringVal = StringUtils.toAsciiString(this.buffer, (int)stringStart, (int)stringLength);
            }
            string = stringVal;
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    public String getTable() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.getTableName();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getTableName() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.tableName == null) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        String string = this.tableName;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public String getTableNameNoAliases() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        String string = this.connection.versionMeetsMinimum(4, 1, 0) ? this.getOriginalTableName() : this.getTableName();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string, joinPoint);
        return string;
    }

    public boolean isAutoIncrement() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 0x200) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isBinary() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 0x80) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isBlob() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 0x10) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private boolean isImplicitTemporaryTable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.isImplicitTempTable;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isMultipleKey() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 8) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    boolean isNotNull() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 1) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    boolean isOpaqueBinary() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.charsetIndex == 63 && this.isBinary() && (this.getMysqlType() == 254 || this.getMysqlType() == 253) ? (this.originalTableNameLength == 0 && this.connection != null && !this.connection.versionMeetsMinimum(5, 0, 25) ? false : !this.isImplicitTemporaryTable()) : this.connection.versionMeetsMinimum(4, 1, 0) && "binary".equalsIgnoreCase(this.getCharacterSet());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isPrimaryKey() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 2) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    boolean isReadOnly() throws SQLException {
        boolean bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.connection.versionMeetsMinimum(4, 1, 0)) {
            String orgColumnName = this.getOriginalName();
            String orgTableName = this.getOriginalTableName();
            bl = orgColumnName == null || orgColumnName.length() <= 0 || orgTableName == null || orgTableName.length() <= 0;
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl2), joinPoint);
        return bl;
    }

    public boolean isUniqueKey() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 4) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isUnsigned() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 0x20) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    public boolean isZeroFill() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = (this.colFlag & 0x40) > 0;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private void setBlobTypeBasedOnLength() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (this.length == 255L) {
            this.mysqlType = 249;
        } else if (this.length == 65535L) {
            this.mysqlType = 252;
        } else if (this.length == 0xFFFFFFL) {
            this.mysqlType = 250;
        } else if (this.length == 0xFFFFFFFFL) {
            this.mysqlType = 251;
        }
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    private boolean isNativeNumericType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.mysqlType >= 1 && this.mysqlType <= 5 || this.mysqlType == 8 || this.mysqlType == 13;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private boolean isNativeDateTimeType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.mysqlType == 10 || this.mysqlType == 14 || this.mysqlType == 12 || this.mysqlType == 11 || this.mysqlType == 7;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnection(Connection connection) {
        void conn;
        Connection connection2 = connection;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)connection2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.connection = conn;
        this.charsetName = this.connection.getEncoding();
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    void setMysqlType(int n) {
        void type;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.mysqlType = type;
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    protected void setUseOldNameMetadata(boolean bl) {
        void useOldNameMetadata;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        this.useOldNameMetadata = useOldNameMetadata;
        Object var4_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var4_4, joinPoint);
    }

    public String toString() {
        String string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            StringBuffer asString = new StringBuffer(128);
            asString.append(super.toString());
            asString.append("\n  catalog: ");
            asString.append(this.getDatabaseName());
            asString.append("\n  table name: ");
            asString.append(this.getTableName());
            asString.append("\n  original table name: ");
            asString.append(this.getOriginalTableName());
            asString.append("\n  column name: ");
            asString.append(this.getName());
            asString.append("\n  original column name: ");
            asString.append(this.getOriginalName());
            asString.append("\n  MySQL data type: ");
            asString.append(this.getMysqlType());
            asString.append("(");
            asString.append(MysqlDefs.typeToName(this.getMysqlType()));
            asString.append(")");
            if (this.buffer != null) {
                asString.append("\n\nData as received from server:\n\n");
                asString.append(StringUtils.dumpAsHex(this.buffer, this.buffer.length));
            }
            string = asString.toString();
        }
        catch (Throwable throwable) {
            string = super.toString();
        }
        String string2 = string;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(string2, joinPoint);
        return string;
    }

    protected boolean isSingleBit() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        boolean bl = this.isSingleBit;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    static {
        Factory factory = new Factory("Field.java", Class.forName("com.mysql.jdbc.Field"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkForImplicitTemporaryTable-com.mysql.jdbc.Field----void-"), 308);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCharacterSet-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 322);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getMysqlType-com.mysql.jdbc.Field----int-"), 494);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 503);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getNameNoAliases-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 511);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOriginalName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 529);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOriginalTableName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 545);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrecisionAdjustFactor-com.mysql.jdbc.Field----int-"), 564);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSQLType-com.mysql.jdbc.Field----int-"), 573);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getStringFromBytes-com.mysql.jdbc.Field-int:int:-stringStart:stringLength:-java.sql.SQLException:-java.lang.String-"), 582);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getTable-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 651);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getTableName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 660);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getCollation-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 326);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getTableNameNoAliases-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 669);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isAutoIncrement-com.mysql.jdbc.Field----boolean-"), 682);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isBinary-com.mysql.jdbc.Field----boolean-"), 691);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isBlob-com.mysql.jdbc.Field----boolean-"), 700);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isImplicitTemporaryTable-com.mysql.jdbc.Field----boolean-"), 709);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isMultipleKey-com.mysql.jdbc.Field----boolean-"), 718);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isNotNull-com.mysql.jdbc.Field----boolean-"), 722);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isOpaqueBinary-com.mysql.jdbc.Field---java.sql.SQLException:-boolean-"), 732);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isPrimaryKey-com.mysql.jdbc.Field----boolean-"), 758);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-isReadOnly-com.mysql.jdbc.Field---java.sql.SQLException:-boolean-"), 768);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getColumnLabel-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 400);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isUniqueKey-com.mysql.jdbc.Field----boolean-"), 785);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isUnsigned-com.mysql.jdbc.Field----boolean-"), 794);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isZeroFill-com.mysql.jdbc.Field----boolean-"), 803);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setBlobTypeBasedOnLength-com.mysql.jdbc.Field----void-"), 812);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isNativeNumericType-com.mysql.jdbc.Field----boolean-"), 824);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isNativeDateTimeType-com.mysql.jdbc.Field----boolean-"), 831);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setConnection-com.mysql.jdbc.Field-com.mysql.jdbc.Connection:-conn:--void-"), 845);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-setMysqlType-com.mysql.jdbc.Field-int:-type:--void-"), 851);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setUseOldNameMetadata-com.mysql.jdbc.Field-boolean:-useOldNameMetadata:--void-"), 856);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toString-com.mysql.jdbc.Field----java.lang.String-"), 861);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDatabaseName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 409);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isSingleBit-com.mysql.jdbc.Field----boolean-"), 893);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getDecimals-com.mysql.jdbc.Field----int-"), 419);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFullName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 428);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFullOriginalName-com.mysql.jdbc.Field---java.sql.SQLException:-java.lang.String-"), 449);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getLength-com.mysql.jdbc.Field----long-"), 477);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21-getMaxBytesPerCharacter-com.mysql.jdbc.Field---java.sql.SQLException:-int-"), 481);
    }
}

