/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.InputStream;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;

public class FileState
extends PlatformObject
implements IFileState {
    protected long lastModified;
    protected UniversalUniqueIdentifier uuid;
    protected HistoryStore store;
    protected IPath fullPath;

    public FileState(HistoryStore store, IPath fullPath, long lastModified, UniversalUniqueIdentifier uuid) {
        this.store = store;
        this.lastModified = lastModified;
        this.uuid = uuid;
        this.fullPath = fullPath;
    }

    public boolean exists() {
        return this.store.exists(this);
    }

    public InputStream getContents() throws CoreException {
        return this.store.getContents(this);
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public long getModificationTime() {
        return this.lastModified;
    }

    public String getName() {
        return this.fullPath.lastSegment();
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("uuid: ").append(this.uuid.toString()).append("\n");
        s.append("lastModified: ").append(this.lastModified).append("\n\n");
        return s.toString();
    }
}

