/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;

public class WhileStatement
extends Statement {
    private Expression expression = null;
    private Statement body = null;

    WhileStatement(AST ast) {
        super(ast);
    }

    public int getNodeType() {
        return 61;
    }

    ASTNode clone(AST target) {
        WhileStatement result = new WhileStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.setExpression((Expression)this.getExpression().clone(target));
        result.setBody((Statement)this.getBody().clone(target));
        return result;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getExpression());
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public Expression getExpression() {
        if (this.expression == null) {
            long count = this.getAST().modificationCount();
            this.setExpression(new SimpleName(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.expression, expression, true);
        this.expression = expression;
    }

    public Statement getBody() {
        if (this.body == null) {
            long count = this.getAST().modificationCount();
            this.setBody(new Block(this.getAST()));
            this.getAST().setModificationCount(count);
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        this.replaceChild(this.body, statement, true);
        this.body = statement;
    }

    int memSize() {
        return super.memSize() + 8;
    }

    int treeSize() {
        return this.memSize() + (this.expression == null ? 0 : this.getExpression().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

