/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public interface RuntimeI {
    public void addShutdownHook(Thread var1);

    public int availableProcessors();

    public Process exec(String var1, String[] var2, File var3);

    public Process exec(String var1, String[] var2);

    public Process exec(String var1);

    public Process exec(String[] var1, String[] var2, File var3);

    public Process exec(String[] var1, String[] var2);

    public Process exec(String[] var1);

    public void exit(int var1);

    public long freeMemory();

    public void gc();

    public InputStream getLocalizedInputStream(InputStream var1);

    public OutputStream getLocalizedOutputStream(OutputStream var1);

    public void halt(int var1);

    public void load(String var1);

    public void loadLibrary(String var1);

    public long maxMemory();

    public boolean removeShutdownHook(Thread var1);

    public void runFinalization();

    public long totalMemory();

    public void traceInstructions(boolean var1);

    public void traceMethodCalls(boolean var1);

    public static class Stub
    implements RuntimeI {
        public void addShutdownHook(Thread hook) {
            throw new NotImplementedException(hook);
        }

        public int availableProcessors() {
            throw new NotImplementedException();
        }

        public Process exec(String command, String[] envp, File dir) {
            throw new NotImplementedException(command, envp, dir);
        }

        public Process exec(String cmd, String[] envp) {
            throw new NotImplementedException((Object)cmd, envp);
        }

        public Process exec(String command) {
            throw new NotImplementedException((Object)command);
        }

        public Process exec(String[] cmdarray, String[] envp, File dir) {
            throw new NotImplementedException(cmdarray, envp, dir);
        }

        public Process exec(String[] cmdarray, String[] envp) {
            throw new NotImplementedException(cmdarray, envp);
        }

        public Process exec(String[] cmdarray) {
            throw new NotImplementedException(cmdarray);
        }

        public void exit(int status) {
            throw new NotImplementedException(new Integer(status));
        }

        public long freeMemory() {
            throw new NotImplementedException();
        }

        public void gc() {
            throw new NotImplementedException();
        }

        public InputStream getLocalizedInputStream(InputStream in) {
            throw new NotImplementedException(in);
        }

        public OutputStream getLocalizedOutputStream(OutputStream out) {
            throw new NotImplementedException(out);
        }

        public void halt(int status) {
            throw new NotImplementedException(new Integer(status));
        }

        public void load(String filename) {
            throw new NotImplementedException((Object)filename);
        }

        public void loadLibrary(String libname) {
            throw new NotImplementedException((Object)libname);
        }

        public long maxMemory() {
            throw new NotImplementedException();
        }

        public boolean removeShutdownHook(Thread hook) {
            throw new NotImplementedException(hook);
        }

        public void runFinalization() {
            throw new NotImplementedException();
        }

        public long totalMemory() {
            throw new NotImplementedException();
        }

        public void traceInstructions(boolean on) {
            throw new NotImplementedException(new Boolean(on));
        }

        public void traceMethodCalls(boolean on) {
            throw new NotImplementedException(new Boolean(on));
        }
    }

    public static final class Default
    extends Stub {
        Runtime runtime = Runtime.getRuntime();

        public int availableProcessors() {
            return this.runtime.availableProcessors();
        }

        public Process exec(final String[] cmdarray, final String[] envp, final File dir) {
            Exceptions.Block block = new Exceptions.Block(){

                protected Object inner() throws Exception {
                    return Default.this.runtime.exec(cmdarray, envp, dir);
                }
            };
            return (Process)block.exec();
        }

        public long freeMemory() {
            return this.runtime.freeMemory();
        }

        public long maxMemory() {
            return this.runtime.maxMemory();
        }

        public long totalMemory() {
            return this.runtime.totalMemory();
        }
    }
}

