/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.Driver;
import com.mysql.management.driverlaunched.MysqldResourceNotFoundException;
import com.mysql.management.driverlaunched.ServerLauncherSocketFactory;
import com.mysql.management.util.Files;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.net.URLEncoder;
import java.sql.SQLException;

public class AcceptanceTest
extends QuietTestCase {
    private int port;
    private String orig;
    private File dataDir;
    private TestUtil testUtil;

    protected void setUp() {
        super.setUp();
        try {
            new Driver();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.orig = System.getProperty("c-mxj.files.use-test-dir");
        System.setProperty("c-mxj.files.use-test-dir", Boolean.TRUE.toString());
        this.testUtil = new TestUtil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() {
        super.tearDown();
        try {
            File baseDir = new Files().tmp("mysql-c.mxj");
            ServerLauncherSocketFactory.shutdown(baseDir, this.dataDir, this.testUtil.testKillDelay());
        }
        catch (MysqldResourceNotFoundException e) {
            this.warn(e);
        }
        finally {
            if (this.orig != null) {
                System.setProperty("c-mxj.files.use-test-dir", this.orig);
            } else {
                System.setProperty("c-mxj.files.use-test-dir", "");
            }
            new Files().cleanTestDir();
            if (this.dataDir != null) {
                new Files().deleteTree(this.dataDir);
            }
        }
    }

    public void testServerDriverLauncherFactory() throws Exception {
        this.dataDir = new File(new Files().tmp("TestApp"), "data");
        String safePath = URLEncoder.encode(this.dataDir.getPath(), "UTF-8");
        this.port = this.testUtil.testPort();
        String url = "jdbc:mysql:mxj://localhost:" + this.port + "/alice_db" + "?server.datadir=" + safePath + "&server.initialize-user=true" + "&createDatabaseIfNotExist=true";
        this.testUtil.assertConnectViaJDBC(url, "alice", "opt4g01396");
        this.testUtil.assertConnectViaJDBC(url, "alice", "opt4g01396");
        this.testUtil.assertConnectViaJDBC(url, "alice", "opt4g01396");
    }
}

