/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.Driver;
import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StandardSocketFactory;
import com.mysql.management.MysqldFactory;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.Exceptions;
import com.mysql.management.util.Files;
import com.mysql.management.util.SQLRuntimeException;
import com.mysql.management.util.Str;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public final class ServerLauncherSocketFactory
implements SocketFactory {
    public static final String SERVER_DOT = "server.";
    private static int launchCount = 0;
    private MysqldFactory resourceFactory;
    private SocketFactory socketFactory;
    private boolean throwOnBadPassword;

    public ServerLauncherSocketFactory() {
        this.setResourceFactory(new MysqldFactory.Default());
        this.setSocketFactory((SocketFactory)new StandardSocketFactory());
        this.throwOnBadPassword = true;
    }

    public Socket connect(String host, int portNumber, Properties props) throws SocketException, IOException {
        this.ensureMysqlStarted(portNumber, props);
        return this.getSocketFactory().connect(host, portNumber, props);
    }

    private void ensureMysqlStarted(int port, Properties props) {
        String mysqldVersion;
        MysqldResourceI mysqld;
        String pass;
        String user = props.getProperty("user");
        if (this.alreadyStarted(port, user, pass = props.getProperty("password"))) {
            return;
        }
        HashMap<String, String> serverOpts = new HashMap<String, String>();
        Enumeration<?> enums = props.propertyNames();
        while (enums.hasMoreElements()) {
            String key = enums.nextElement().toString();
            String rawValue = props.getProperty(key);
            if (!key.startsWith(SERVER_DOT)) continue;
            String val = this.replaceNullStringWithNull(rawValue);
            serverOpts.put(key.substring(SERVER_DOT.length()), val);
        }
        serverOpts.put("initialize-user.user", user);
        serverOpts.put("initialize-user.password", pass);
        serverOpts.put("port", Integer.toString(port));
        Object baseDirStr = serverOpts.get("basedir");
        File baseDir = new Files().newFile(baseDirStr);
        String dataDirString = (String)serverOpts.get("datadir");
        File dataDir = null;
        if (dataDirString != null) {
            File ddir = new File(dataDirString);
            dataDir = new Files().validCononicalDir(ddir);
        }
        if ((mysqld = this.resourceFactory.newMysqldResource(baseDir, dataDir, mysqldVersion = (String)serverOpts.get("mysql-version"))).isRunning()) {
            int runningPort = mysqld.getPort();
            if (port != runningPort) {
                new Exceptions.VoidBlock(){

                    public void inner() throws InterruptedException {
                        Thread.sleep(10L);
                    }
                }.exec();
                runningPort = mysqld.getPort();
            }
            if (runningPort <= 0) {
                System.err.println("unable to confirm running port of " + port);
            } else if (port != runningPort) {
                String location = mysqld.getBaseDir().getPath();
                if (dataDir != null) {
                    location = location + " with data at " + dataDir;
                }
                String msg = "Mysqld at " + location + " is running on port " + runningPort + " not " + port;
                throw new RuntimeException(msg);
            }
            return;
        }
        String threadName = "driver_launched_mysqld_" + ++launchCount;
        mysqld.start(threadName, serverOpts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyStarted(int port, String user, String pass) {
        new Str().classForName(Driver.class.getName());
        Connection conn = null;
        String url = "jdbc:mysql://127.0.0.1:" + port + "/" + "?connectTimeout=150";
        try {
            conn = DriverManager.getConnection(url, user, pass);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1045 && this.throwOnBadPassword) {
                throw new SQLRuntimeException(e);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    String replaceNullStringWithNull(String str) {
        return String.valueOf((Object)null).equals(str) ? null : str;
    }

    public Socket afterHandshake() throws SocketException, IOException {
        return this.getSocketFactory().afterHandshake();
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        return this.getSocketFactory().beforeHandshake();
    }

    void setResourceFactory(MysqldFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    MysqldFactory getResourceFactory() {
        return this.resourceFactory;
    }

    void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    void throwOnBadPassword(boolean val) {
        this.throwOnBadPassword = val;
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public static synchronized boolean shutdown(File baseDir, File dataDir) {
        return ServerLauncherSocketFactory.shutdown(baseDir, dataDir, 0);
    }

    public static synchronized boolean shutdown(File baseDir, File dataDir, int killDelay) {
        MysqldResource mysqld = new MysqldResource(baseDir, dataDir);
        if (killDelay > 0) {
            mysqld.setKillDelay(killDelay);
        }
        mysqld.shutdown();
        return mysqld.isRunning();
    }
}

