/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.MapEntry;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class MapEntryTest
extends TestCase {
    private Map.Entry entry;
    private Map.Entry hashMapEntry;

    protected void setUp() throws Exception {
        this.setEntries("foo", "bar");
    }

    private void setEntries(String key, String val) {
        this.entry = new MapEntry(key, val);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, val);
        this.hashMapEntry = map.entrySet().iterator().next();
    }

    public void testGetters() {
        MapEntryTest.assertEquals(this.hashMapEntry.getKey(), this.entry.getKey());
        MapEntryTest.assertEquals(this.hashMapEntry.getValue(), this.entry.getValue());
    }

    public void testEquallity() {
        MapEntryTest.assertTrue((boolean)((Object)this.entry).equals(this.entry));
        MapEntryTest.assertEquals((int)((Object)this.hashMapEntry).hashCode(), (int)((Object)this.entry).hashCode());
        MapEntryTest.assertTrue((boolean)((Object)this.hashMapEntry).equals(this.entry));
        MapEntryTest.assertTrue((boolean)((Object)this.entry).equals(this.hashMapEntry));
        MapEntryTest.assertFalse((boolean)((Object)this.entry).equals(this.hashMapEntry.toString()));
        MapEntryTest.assertFalse((boolean)((Object)this.entry).equals(new MapEntry(this.entry.getKey(), this.entry.getKey())));
        MapEntryTest.assertFalse((boolean)((MapEntry)this.entry).equals(null));
    }

    public void testToString() {
        MapEntryTest.assertEquals((String)this.hashMapEntry.toString(), (String)this.entry.toString());
    }

    public void testHashCode() throws Exception {
        MapEntryTest.assertEquals((int)((Object)this.hashMapEntry).hashCode(), (int)((Object)this.entry).hashCode());
        this.setEntries("foo", null);
        MapEntryTest.assertEquals((int)((Object)this.hashMapEntry).hashCode(), (int)((Object)this.entry).hashCode());
        this.setEntries(null, "bar");
        MapEntryTest.assertEquals((int)((Object)this.hashMapEntry).hashCode(), (int)((Object)this.entry).hashCode());
        this.setEntries(null, null);
        MapEntryTest.assertEquals((int)((Object)this.hashMapEntry).hashCode(), (int)((Object)this.entry).hashCode());
    }

    public void testSetter() {
        this.entry.setValue("baz");
        this.hashMapEntry.setValue("baz");
        this.testGetters();
        this.testEquallity();
    }
}

