/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.ajde.ui.swing.BrowserStructureViewToolPanel;
import org.aspectj.ajde.ui.swing.SimpleStructureViewToolPanel;
import org.aspectj.ajde.ui.swing.StructureTreeManager;
import org.aspectj.asm.IProgramElement;

public class StructureViewPanel
extends JPanel
implements StructureViewRenderer {
    private static final long serialVersionUID = 7549744200612883786L;
    protected StructureTreeManager treeManager = new StructureTreeManager();
    protected StructureView currentView = null;
    protected Border border1;
    protected Border border2;
    JScrollPane tree_ScrollPane = new JScrollPane();
    JPanel structureToolBar_panel = null;
    BorderLayout borderLayout1 = new BorderLayout();

    public StructureViewPanel(FileStructureView structureView) {
        this.currentView = structureView;
        this.initView(structureView);
        this.structureToolBar_panel = new SimpleStructureViewToolPanel(this.currentView);
        this.init();
    }

    public StructureViewPanel(List structureViews) {
        Iterator it = structureViews.iterator();
        while (it.hasNext()) {
            this.initView((StructureView)it.next());
        }
        this.currentView = (StructureView)structureViews.get(0);
        this.structureToolBar_panel = new BrowserStructureViewToolPanel(structureViews, this.currentView, this);
        this.init();
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not initialize view panel.", e);
        }
        this.updateView(this.currentView);
    }

    public void setCurrentView(StructureView view) {
        this.currentView = view;
        this.treeManager.updateTree(view);
    }

    public void updateView(StructureView structureView) {
        if (structureView == this.currentView) {
            this.treeManager.updateTree(structureView);
        }
    }

    private void initView(StructureView view) {
        view.setRenderer(this);
    }

    public void setActiveNode(IStructureViewNode node) {
        this.setActiveNode(node, 0);
    }

    public void setActiveNode(IStructureViewNode node, int lineOffset) {
        if (node == null) {
            return;
        }
        IProgramElement pNode = node.getStructureNode();
        this.treeManager.highlightNode(pNode);
        if (pNode.getSourceLocation() != null) {
            Ajde.getDefault().getEditorAdapter().showSourceLine(pNode.getSourceLocation().getSourceFile().getAbsolutePath(), pNode.getSourceLocation().getLine() + lineOffset, true);
        }
    }

    public void highlightActiveNode() {
        if (this.currentView.getActiveNode() == null) {
            return;
        }
        IProgramElement node = this.currentView.getActiveNode().getStructureNode();
        if (node instanceof IProgramElement) {
            this.treeManager.highlightNode(node);
        }
    }

    protected void jbInit() {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(156, 156, 158), new Color(109, 109, 110));
        this.border2 = BorderFactory.createEmptyBorder(0, 1, 0, 0);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.tree_ScrollPane, "Center");
        this.add((Component)this.structureToolBar_panel, "North");
        this.tree_ScrollPane.getViewport().add((Component)this.treeManager.getStructureTree(), null);
    }
}

