/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.AbstractCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.WeaverAdapter;
import org.aspectj.ajdt.internal.compiler.WeaverMessageHandler;
import org.aspectj.ajdt.internal.compiler.ast.AddAtAspectJAnnotationsVisitor;
import org.aspectj.ajdt.internal.compiler.ast.ValidateAtAspectJAnnotationsVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.patterns.CflowPointcut;

public class AjCompilerAdapter
extends AbstractCompilerAdapter {
    private Compiler compiler;
    private BcelWeaver weaver;
    private EclipseFactory eWorld;
    private boolean isBatchCompile;
    private boolean reportedErrors;
    private boolean isXTerminateAfterCompilation;
    private boolean proceedOnError;
    private boolean inJava5Mode;
    private boolean noAtAspectJAnnotationProcessing;
    private IIntermediateResultsRequestor intermediateResultsRequestor;
    private IProgressListener progressListener;
    private IOutputClassFileNameProvider outputFileNameProvider;
    private IBinarySourceProvider binarySourceProvider;
    private WeaverMessageHandler weaverMessageHandler;
    private Map binarySourceSetForFullWeave = new HashMap();
    private ContextToken processingToken = null;
    private ContextToken resolvingToken = null;
    private ContextToken analysingToken = null;
    private ContextToken generatingToken = null;
    private AjState incrementalCompilationState;
    List resultsPendingWeave = new ArrayList();

    public AjCompilerAdapter(Compiler compiler, boolean isBatchCompile, BcelWorld world, BcelWeaver weaver, EclipseFactory eFactory, IIntermediateResultsRequestor intRequestor, IProgressListener progressListener, IOutputClassFileNameProvider outputFileNameProvider, IBinarySourceProvider binarySourceProvider, Map fullBinarySourceEntries, boolean isXterminateAfterCompilation, boolean proceedOnError, boolean noAtAspectJProcessing, AjState incrementalCompilationState) {
        IMessageHandler msgHandler;
        this.compiler = compiler;
        this.isBatchCompile = isBatchCompile;
        this.weaver = weaver;
        this.intermediateResultsRequestor = intRequestor;
        this.progressListener = progressListener;
        this.outputFileNameProvider = outputFileNameProvider;
        this.binarySourceProvider = binarySourceProvider;
        this.isXTerminateAfterCompilation = isXterminateAfterCompilation;
        this.proceedOnError = proceedOnError;
        this.binarySourceSetForFullWeave = fullBinarySourceEntries;
        this.eWorld = eFactory;
        this.inJava5Mode = false;
        this.noAtAspectJAnnotationProcessing = noAtAspectJProcessing;
        this.incrementalCompilationState = incrementalCompilationState;
        if (compiler.options.complianceLevel == 0x310000L) {
            this.inJava5Mode = true;
        }
        if ((msgHandler = world.getMessageHandler()) instanceof WeaverMessageHandler) {
            ((WeaverMessageHandler)msgHandler).resetCompiler(compiler);
            this.weaverMessageHandler = (WeaverMessageHandler)msgHandler;
        } else {
            this.weaverMessageHandler = new WeaverMessageHandler(msgHandler, compiler);
            world.setMessageHandler(this.weaverMessageHandler);
        }
    }

    public void beforeCompiling(ICompilationUnit[] sourceUnits) {
        this.resultsPendingWeave = new ArrayList();
        this.reportedErrors = false;
    }

    public void beforeProcessing(CompilationUnitDeclaration unit) {
        this.eWorld.showMessage(IMessage.INFO, "compiling " + new String(unit.getFileName()), null, null);
        this.processingToken = CompilationAndWeavingContext.enteringPhase(2, unit.getFileName());
        if (this.inJava5Mode && !this.noAtAspectJAnnotationProcessing) {
            ContextToken tok = CompilationAndWeavingContext.enteringPhase(18, unit.getFileName());
            AddAtAspectJAnnotationsVisitor atAspectJVisitor = new AddAtAspectJAnnotationsVisitor(unit);
            unit.traverse((ASTVisitor)atAspectJVisitor, unit.scope);
            CompilationAndWeavingContext.leavingPhase(tok);
        }
    }

    public void beforeResolving(CompilationUnitDeclaration unit) {
        this.resolvingToken = CompilationAndWeavingContext.enteringPhase(3, unit.getFileName());
    }

    public void afterResolving(CompilationUnitDeclaration unit) {
        if (this.resolvingToken != null) {
            CompilationAndWeavingContext.leavingPhase(this.resolvingToken);
        }
    }

    public void beforeAnalysing(CompilationUnitDeclaration unit) {
        this.analysingToken = CompilationAndWeavingContext.enteringPhase(4, unit.getFileName());
        if (this.inJava5Mode && !this.noAtAspectJAnnotationProcessing) {
            ValidateAtAspectJAnnotationsVisitor atAspectJVisitor = new ValidateAtAspectJAnnotationsVisitor(unit);
            unit.traverse((ASTVisitor)atAspectJVisitor, unit.scope);
        }
    }

    public void afterAnalysing(CompilationUnitDeclaration unit) {
        if (this.analysingToken != null) {
            CompilationAndWeavingContext.leavingPhase(this.analysingToken);
        }
    }

    public void beforeGenerating(CompilationUnitDeclaration unit) {
        this.generatingToken = CompilationAndWeavingContext.enteringPhase(5, unit.getFileName());
    }

    public void afterGenerating(CompilationUnitDeclaration unit) {
        if (this.generatingToken != null) {
            CompilationAndWeavingContext.leavingPhase(this.generatingToken);
        }
    }

    public void afterCompiling(CompilationUnitDeclaration[] units) {
        this.eWorld.cleanup();
        try {
            if (!this.reportedErrors && units != null) {
                for (int i = 0; i < units.length; ++i) {
                    if (units[i] == null || units[i].compilationResult == null || !units[i].compilationResult.hasErrors()) continue;
                    this.reportedErrors = true;
                    break;
                }
            }
            if (this.isXTerminateAfterCompilation || this.reportedErrors && !this.proceedOnError) {
                this.notifyRequestor();
            } else {
                this.weave();
            }
        }
        catch (IOException ex) {
            AbortCompilation ac = new AbortCompilation(null, (Throwable)ex);
            throw ac;
        }
        catch (RuntimeException rEx) {
            if (rEx instanceof AbortCompilation) {
                throw rEx;
            }
            throw new AbortCompilation(true, rEx);
        }
    }

    public void afterProcessing(CompilationUnitDeclaration unit, int unitIndex) {
        CompilationAndWeavingContext.leavingPhase(this.processingToken);
        this.eWorld.finishedCompilationUnit(unit);
        InterimCompilationResult intRes = new InterimCompilationResult(unit.compilationResult, this.outputFileNameProvider);
        if (unit.compilationResult.hasErrors()) {
            this.reportedErrors = true;
        }
        if (this.intermediateResultsRequestor != null) {
            this.intermediateResultsRequestor.acceptResult(intRes);
        }
        if (this.isXTerminateAfterCompilation) {
            this.acceptResult(unit.compilationResult);
        } else {
            this.resultsPendingWeave.add(intRes);
        }
    }

    public void acceptResult(CompilationResult result) {
        this.compiler.requestor.acceptResult(result.tagAsAccepted());
        if (this.compiler.unitsToProcess != null) {
            for (int i = 0; i < this.compiler.unitsToProcess.length; ++i) {
                if (this.compiler.unitsToProcess[i] == null || this.compiler.unitsToProcess[i].compilationResult != result) continue;
                this.compiler.unitsToProcess[i] = null;
            }
        }
    }

    private List getBinarySourcesFrom(Map binarySourceEntries) {
        ArrayList<InterimCompilationResult> ret = new ArrayList<InterimCompilationResult>();
        Iterator binIter = binarySourceEntries.keySet().iterator();
        while (binIter.hasNext()) {
            String sourceFileName = (String)binIter.next();
            List unwovenClassFiles = (List)binarySourceEntries.get(sourceFileName);
            CompilationResult result = new CompilationResult(sourceFileName.toCharArray(), 0, 0, Integer.MAX_VALUE);
            result.noSourceAvailable();
            InterimCompilationResult binarySource = new InterimCompilationResult(result, unwovenClassFiles);
            ret.add(binarySource);
        }
        return ret;
    }

    private void notifyRequestor() {
        Iterator iter = this.resultsPendingWeave.iterator();
        while (iter.hasNext()) {
            InterimCompilationResult iresult = (InterimCompilationResult)iter.next();
            this.compiler.requestor.acceptResult(iresult.result().tagAsAccepted());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void weave() throws IOException {
        Iterator iter = this.resultsPendingWeave.iterator();
        while (iter.hasNext()) {
            InterimCompilationResult iresult = (InterimCompilationResult)iter.next();
            for (int i = 0; i < iresult.unwovenClassFiles().length; ++i) {
                this.weaver.addClassFile(iresult.unwovenClassFiles()[i]);
            }
        }
        this.weaver.setIsBatchWeave(this.isBatchCompile);
        this.weaver.prepareForWeave();
        if (this.weaver.needToReweaveWorld()) {
            if (!this.isBatchCompile) {
                this.incrementalCompilationState.forceBatchBuildNextTimeAround();
                return;
            }
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(this.binarySourceSetForFullWeave));
        } else {
            Map binarySourcesToAdd = this.binarySourceProvider.getBinarySourcesForThisWeave();
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(binarySourcesToAdd));
        }
        try {
            this.weaver.weave(new WeaverAdapter(this, this.weaverMessageHandler, this.progressListener));
        }
        finally {
            CflowPointcut.clearCaches();
            if (this.weaverMessageHandler instanceof WeaverMessageHandler) {
                this.weaverMessageHandler.setCurrentResult(null);
            }
            this.weaver.allWeavingComplete();
            this.weaver.tidyUp();
            IMessageHandler imh = this.weaver.getWorld().getMessageHandler();
            if (imh instanceof WeaverMessageHandler) {
                ((WeaverMessageHandler)imh).resetCompiler(null);
            }
        }
    }

    public void afterDietParsing(CompilationUnitDeclaration[] units) {
    }

    public List getResultsPendingWeave() {
        return this.resultsPendingWeave;
    }
}

