/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.jdbc.Driver;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.trace.Tracer;
import com.mysql.management.util.Files;
import com.mysql.management.util.QueryUtil;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Str;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AcceptanceTest
extends QuietTestCase {
    private Connection conn = null;
    private File tmpDir;
    private MysqldResourceI mysqld;
    private Files fileUtil;
    private TestUtil testUtil;
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    protected void setUp() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        super.setUp();
        this.fileUtil = new Files();
        this.tmpDir = new Files().testDir();
        this.testUtil = new TestUtil();
        Object var2_2 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var2_2, joinPoint);
    }

    protected void tearDown() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        super.tearDown();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.conn = null;
        }
        if (this.mysqld != null) {
            try {
                this.mysqld.setKillDelay(this.testUtil.testKillDelay());
                this.mysqld.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Object var3_4 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var3_4, joinPoint);
    }

    public void testMain() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        int port1 = this.testUtil.testPort();
        File baseDir1 = new File(this.tmpDir, "cmxj-dir.1");
        String url1 = "jdbc:mysql://127.0.0.1:" + port1 + "/test";
        String[] startArgs1 = new String[]{"--port=" + port1, "--basedir=" + baseDir1, "--kill-delay=" + this.testUtil.testKillDelay()};
        String[] stopArgs1 = new String[]{"--basedir=" + baseDir1, "--shutdown", "--kill-delay=" + this.testUtil.testKillDelay()};
        MysqldResource.main(startArgs1);
        int port2 = port1 + 1000;
        String url2 = "jdbc:mysql://127.0.0.1:" + port2 + "/test";
        File baseDir2 = new File(this.tmpDir, "cmxj-dir.2");
        String[] startArgs2 = new String[]{"--port=" + port2, "--basedir=" + baseDir2, "--kill-delay=" + this.testUtil.testKillDelay()};
        String[] stopArgs2 = new String[]{"--basedir=" + baseDir2, "--shutdown", "--kill-delay=" + this.testUtil.testKillDelay()};
        MysqldResource.main(startArgs2);
        this.testUtil.assertConnectViaJDBC(url1);
        this.testUtil.assertConnectViaJDBC(url2);
        MysqldResource.main(stopArgs1);
        this.testUtil.assertConnectViaJDBC(url2);
        SQLException expected = null;
        try {
            this.testUtil.assertConnectViaJDBC(url1);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
        MysqldResource.main(stopArgs2);
        expected = null;
        try {
            this.testUtil.assertConnectViaJDBC(url2);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
        Object var14_15 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var14_15, joinPoint);
    }

    public void testCreateUser() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File baseDir3 = new File(this.tmpDir, "mxj-user-test");
        this.fileUtil.deleteTree(baseDir3);
        this.mysqld = new MysqldResource(baseDir3);
        baseDir3.mkdirs();
        HashMap<String, String> params = new HashMap<String, String>();
        int port = this.testUtil.testPort();
        params.put("port", Integer.toString(port));
        params.put("kill-delay", Integer.toString(this.testUtil.testKillDelay()));
        this.mysqld.start("mxj-user-test", params);
        String url = "jdbc:mysql://localhost:" + port + "/";
        String rootUser = "root";
        String rootPassword = "";
        this.makeDb(String.valueOf(url) + "test", rootUser, rootPassword);
        this.checkVersion(this.mysqld.getVersion());
        this.conn.close();
        this.conn = null;
        Driver driver = new Driver();
        Properties props = new Properties();
        props.setProperty("user", "JAVA");
        props.setProperty("password", "SAPR3");
        Exception exception = null;
        try {
            this.conn = driver.connect(String.valueOf(url) + "MY1", props);
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNull((String)("" + exception), (Object)exception);
        this.checkVersion(this.mysqld.getVersion());
        Object var12_12 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var12_12, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void checkVersion(String string) {
        void version;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)string2);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        QueryUtil util = new QueryUtil(this.conn);
        String searchIn = util.queryForString("SELECT VERSION()");
        AcceptanceTest.assertTrue((String)("<" + (String)version + "> not found in <" + searchIn + ">"), (boolean)new Str().containsIgnoreCase(searchIn, (String)version));
        Object var6_6 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var6_6, joinPoint);
    }

    /*
     * WARNING - void declaration
     */
    private void makeDb(String string, String string2, String string3) throws Exception {
        void password;
        void userName;
        void url;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        this.testUtil.assertConnectViaJDBC((String)url, (String)userName, (String)password, true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.mysql.jdbc.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class.forName(clazz.getName());
        this.conn = DriverManager.getConnection((String)url, (String)userName, (String)password);
        QueryUtil util = new QueryUtil(this.conn);
        util.execute("CREATE DATABASE MY1");
        util.execute("USE MY1");
        String sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'%' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        util.execute(sql);
        sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'localhost' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        util.execute(sql);
        util.execute("commit");
        Object var11_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var11_11, joinPoint);
    }

    public void testInitializeUser() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        Tracer.aspectOf().ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(joinPoint);
        File baseDir4 = new File(this.tmpDir, "mxj-init-user-test");
        this.fileUtil.deleteTree(baseDir4);
        this.mysqld = new MysqldResource(baseDir4);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        HashMap<String, String> params = new HashMap<String, String>();
        int port = this.testUtil.testPort();
        params.put("port", Integer.toString(port));
        String rootUser = "root";
        String rootPass = "";
        String aliceName = "alice";
        String alicePass = "q3htgi98q34";
        this.mysqld.start("init-user", params);
        String url = "jdbc:mysql://127.0.0.1:" + port + "/test";
        this.conn = DriverManager.getConnection(url, rootUser, rootPass);
        QueryUtil util = new QueryUtil(this.conn);
        util.execute("SELECT 1");
        this.conn.close();
        this.conn = null;
        Exception exception = null;
        try {
            this.conn = DriverManager.getConnection(url, aliceName, alicePass);
            AcceptanceTest.fail((String)("Should not be able to connect as " + aliceName));
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNotNull((String)("" + exception), (Object)exception);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        this.mysqld.shutdown();
        AcceptanceTest.assertEquals((boolean)false, (boolean)this.mysqld.isRunning());
        this.fileUtil.deleteTree(baseDir4);
        params.put("initialize-user", Boolean.TRUE.toString());
        params.put("initialize-user.user", aliceName);
        params.put("initialize-user.password", alicePass);
        this.mysqld.start("init-user", params);
        this.conn = DriverManager.getConnection(url, aliceName, alicePass);
        util = new QueryUtil(this.conn);
        util.execute("SELECT 1");
        this.conn.close();
        this.conn = null;
        exception = null;
        try {
            this.conn = DriverManager.getConnection(url, rootUser, rootPass);
            AcceptanceTest.fail((String)("Should not be able to connect as " + rootUser));
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNotNull((String)("" + exception), (Object)exception);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        this.mysqld.shutdown();
        Object var13_14 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(var13_14, joinPoint);
    }

    static {
        Factory factory = new Factory("AcceptanceTest.java", Class.forName("com.mysql.management.AcceptanceTest"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-setUp-com.mysql.management.AcceptanceTest----void-"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-tearDown-com.mysql.management.AcceptanceTest----void-"), 57);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testMain-com.mysql.management.AcceptanceTest---java.lang.Exception:-void-"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testCreateUser-com.mysql.management.AcceptanceTest---java.lang.Exception:-void-"), 138);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkVersion-com.mysql.management.AcceptanceTest-java.lang.String:-version:--void-"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-makeDb-com.mysql.management.AcceptanceTest-java.lang.String:java.lang.String:java.lang.String:-url:userName:password:-java.lang.Exception:-void-"), 187);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testInitializeUser-com.mysql.management.AcceptanceTest---java.lang.Exception:-void-"), 208);
    }
}

