/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.trace;

import com.mysql.jdbc.log.LogUtils;
import java.io.PrintStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;

public class Tracer {
    public static final String TRACE_PROPERTY = "c-mxj_trace";
    private static boolean skipLogging;
    private static PrintStream logErr;
    private ThreadLocal callDepth = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ Tracer ajc$perSingletonInstance;

    static {
        try {
            skipLogging = Boolean.valueOf(System.getProperty(TRACE_PROPERTY, Boolean.FALSE.toString())) == false;
            logErr = System.err;
            Tracer.ajc$perSingletonInstance = new Tracer();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static void setErrStream(PrintStream printStream) {
        logErr = printStream;
    }

    public static void setLogging(boolean b) {
        skipLogging = !b;
    }

    public void ajc$before$com_mysql_management_trace_Tracer$1$f51c62b8(JoinPoint thisJoinPoint) {
        this.entry(thisJoinPoint, false);
    }

    public void ajc$afterReturning$com_mysql_management_trace_Tracer$2$f51c62b8(Object o, JoinPoint thisJoinPoint) {
        this.exit(thisJoinPoint, false, o);
    }

    private int getCallDepth() {
        return (Integer)this.callDepth.get();
    }

    private void setCallDepth(int n) {
        this.callDepth.set(new Integer(n));
    }

    private void entry(JoinPoint jp, boolean isConstructor) {
        this.setCallDepth(this.getCallDepth() + 1);
        this.printEntering(jp, isConstructor);
    }

    private void exit(JoinPoint jp, boolean isConstructor, Object returnValue) {
        this.printExiting(jp, isConstructor, returnValue);
        this.setCallDepth(this.getCallDepth() - 1);
    }

    private void printEntering(JoinPoint jp, boolean isConstructor) {
        if (skipLogging) {
            return;
        }
        StringBuffer buf = new StringBuffer(80);
        this.printCalledFromIfNotMySQL(buf);
        this.printIndent(buf);
        buf.append("--> ");
        buf.append(jp.getSourceLocation().getFileName());
        buf.append(":");
        buf.append(jp.getSourceLocation().getLine());
        buf.append(" ");
        buf.append(jp.getSignature().getDeclaringTypeName());
        buf.append(".");
        buf.append(jp.getSignature().getName());
        this.printParameters(jp, buf);
        logErr.println(buf.toString());
    }

    private void printExiting(JoinPoint jp, boolean isConstructor, Object returnValue) {
        if (skipLogging) {
            return;
        }
        StringBuffer buf = new StringBuffer(80);
        this.printIndent(buf);
        buf.append("<--  ");
        buf.append(jp.getSourceLocation().getFileName());
        buf.append(":");
        buf.append(jp.getSourceLocation().getLine());
        buf.append(" ");
        buf.append(jp.getSignature().getDeclaringTypeName());
        buf.append(".");
        buf.append(jp.getSignature().getName());
        buf.append("(..) returning ");
        boolean isString = returnValue instanceof String;
        if (isString) {
            buf.append("\"");
        }
        buf.append(returnValue);
        if (isString) {
            buf.append("\"");
        }
        logErr.println(buf.toString());
    }

    private void printIndent(StringBuffer buf) {
        buf.append("[mxj-trace]");
        int i = 0;
        while (i < this.getCallDepth()) {
            buf.append(" ");
            ++i;
        }
    }

    private void printCalledFromIfNotMySQL(StringBuffer buf) {
        String callingClassAndMethod = LogUtils.findCallingClassAndMethod((Throwable)new Throwable());
        if (callingClassAndMethod.startsWith("com.mysql.managment")) {
            return;
        }
        if (callingClassAndMethod.indexOf("Caller information not available") >= 0) {
            return;
        }
        this.printIndent(buf);
        buf.append("Caller ");
        buf.append(callingClassAndMethod);
        buf.append(System.getProperty("line.separator"));
    }

    private void printParameters(JoinPoint jp, StringBuffer buf) {
        Object[] params = jp.getArgs();
        buf.append("(");
        int i = 0;
        while (i < params.length) {
            boolean isString = params[i] instanceof String;
            if (isString) {
                buf.append("\"");
            }
            if (params[i] != null) {
                buf.append(params[i]);
            } else {
                buf.append("null");
            }
            if (isString) {
                buf.append("\"");
            }
            if (i < params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(")");
    }

    public static Tracer aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com_mysql_management_trace_Tracer", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

