/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.NullPrintStream;
import java.io.PrintStream;
import junit.framework.TestCase;

public abstract class QuietTestCase
extends TestCase {
    private PrintStream systemDotOut;
    private PrintStream systemDotErr;

    protected void setUp() {
        this.systemDotOut = System.out;
        this.systemDotErr = System.err;
        System.setOut(this.getTestStream(this.systemDotOut));
        System.setErr(this.getTestStream(this.systemDotErr));
    }

    protected void tearDown() {
        this.resetOutAndErr();
    }

    protected void resetOutAndErr() {
        System.setOut(this.systemDotOut);
        System.setErr(this.systemDotErr);
    }

    protected void warn(String msg) {
        this.systemDotErr.println(msg);
    }

    protected void warn(Exception e) {
        e.printStackTrace(this.systemDotErr);
    }

    private PrintStream getTestStream(PrintStream real) {
        String defaultVal = Boolean.TRUE.toString();
        String silentStr = System.getProperty("c-mxj_test_silent", defaultVal);
        Boolean b = Boolean.valueOf(silentStr);
        return b != false ? new NullPrintStream() : real;
    }
}

