/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.EnumAnnotationValue;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;

public class EclipseAnnotationConvertor {
    public static AnnotationX convertEclipseAnnotation(Annotation eclipseAnnotation, World w, EclipseFactory factory) {
        ResolvedType annotationType = factory.fromTypeBindingToRTX(eclipseAnnotation.type.resolvedType);
        long bs = (long)eclipseAnnotation.bits & 0x180000000000L;
        boolean isRuntimeVisible = ((long)eclipseAnnotation.bits & 0x180000000000L) == 0x180000000000L;
        AnnotationAJ annotationAJ = new AnnotationAJ(annotationType.getSignature(), isRuntimeVisible);
        EclipseAnnotationConvertor.generateAnnotation(eclipseAnnotation, annotationAJ);
        return new AnnotationX(annotationAJ, w);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateAnnotation(Annotation annotation, AnnotationAJ annotationAJ) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairs = normalAnnotation.memberValuePairs;
            if (memberValuePairs == null) throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            int memberValuePairsLength = memberValuePairs.length;
            for (int i = 0; i < memberValuePairsLength; ++i) {
                MemberValuePair memberValuePair = memberValuePairs[i];
                MethodBinding methodBinding = memberValuePair.binding;
                if (methodBinding == null) {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
                }
                AnnotationValue av = EclipseAnnotationConvertor.generateElementValue(memberValuePair.value, methodBinding.returnType);
                AnnotationNameValuePair anvp = new AnnotationNameValuePair(new String(memberValuePair.name), av);
                annotationAJ.addNameValuePair(anvp);
            }
            return;
        } else {
            if (!(annotation instanceof SingleMemberAnnotation)) throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation [" + annotation + "]");
            }
            AnnotationValue av = EclipseAnnotationConvertor.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType);
            annotationAJ.addNameValuePair(new AnnotationNameValuePair(new String(singleMemberAnnotation.memberValuePairs()[0].name), av));
        }
    }

    private static AnnotationValue generateElementValue(Expression defaultValue, TypeBinding memberValuePairReturnType) {
        Constant constant = defaultValue.constant;
        TypeBinding defaultValueBinding = defaultValue.resolvedType;
        if (defaultValueBinding == null) {
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        if (memberValuePairReturnType.isArrayType() && !defaultValueBinding.isArrayType()) {
            if (constant != null && constant != Constant.NotAConstant) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            AnnotationValue av = EclipseAnnotationConvertor.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
            return new ArrayAnnotationValue(new AnnotationValue[]{av});
        }
        if (constant != null && constant != Constant.NotAConstant) {
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        AnnotationValue av = EclipseAnnotationConvertor.generateElementValueForNonConstantExpression(defaultValue, defaultValueBinding);
        return av;
    }

    private static AnnotationValue generateElementValueForNonConstantExpression(Expression defaultValue, TypeBinding defaultValueBinding) {
        if (defaultValueBinding != null) {
            if (defaultValueBinding.isEnum()) {
                NameReference nameReference;
                FieldBinding fieldBinding = null;
                if (defaultValue instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (defaultValue instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)defaultValue;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else {
                    throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
                }
                if (fieldBinding != null) {
                    String sig = new String(fieldBinding.type.signature());
                    EnumAnnotationValue enumValue = new EnumAnnotationValue(sig, new String(fieldBinding.name));
                    return enumValue;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValueBinding.isAnnotationType()) {
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            if (defaultValueBinding.isArrayType()) {
                if (defaultValue instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)defaultValue;
                    int arrayLength = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    AnnotationValue[] values = new AnnotationValue[arrayLength];
                    for (int i = 0; i < arrayLength; ++i) {
                        values[i] = EclipseAnnotationConvertor.generateElementValue(arrayInitializer.expressions[i], defaultValueBinding.leafComponentType());
                    }
                    ArrayAnnotationValue aav = new ArrayAnnotationValue(values);
                    return aav;
                }
                throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
            }
            throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
        }
        throw new MissingImplementationException("Please raise an AspectJ bug.  AspectJ does not know how to convert this annotation value [" + defaultValue + "]");
    }

    static class MissingImplementationException
    extends RuntimeException {
        MissingImplementationException(String reason) {
            super(reason);
        }
    }
}

