/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.loadtime.ConcreteAspectCodeGen;
import org.aspectj.weaver.loadtime.DefaultWeavingContext;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.loadtime.Options;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.aspectj.weaver.loadtime.definition.DocumentParser;
import org.aspectj.weaver.ltw.LTWWorld;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.tools.GeneratedClassHandler;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class ClassLoaderWeavingAdaptor
extends WeavingAdaptor {
    private static final String AOP_XML = "META-INF/aop.xml;META-INF/aop-ajc.xml;org/aspectj/aop.xml";
    private boolean initialized;
    private List m_dumpTypePattern = new ArrayList();
    private boolean m_dumpBefore = false;
    private List m_includeTypePattern = new ArrayList();
    private List m_excludeTypePattern = new ArrayList();
    private List m_includeStartsWith = new ArrayList();
    private List m_excludeStartsWith = new ArrayList();
    private List m_aspectExcludeTypePattern = new ArrayList();
    private List m_aspectExcludeStartsWith = new ArrayList();
    private List m_aspectIncludeTypePattern = new ArrayList();
    private List m_aspectIncludeStartsWith = new ArrayList();
    private StringBuffer namespace;
    private IWeavingContext weavingContext;
    private List concreteAspects = new ArrayList();
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$loadtime$ClassLoaderWeavingAdaptor == null ? (class$org$aspectj$weaver$loadtime$ClassLoaderWeavingAdaptor = ClassLoaderWeavingAdaptor.class$("org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor")) : class$org$aspectj$weaver$loadtime$ClassLoaderWeavingAdaptor);
    static /* synthetic */ Class class$org$aspectj$weaver$loadtime$ClassLoaderWeavingAdaptor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public ClassLoaderWeavingAdaptor() {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", this);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public ClassLoaderWeavingAdaptor(ClassLoader deprecatedLoader, IWeavingContext deprecatedContext) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{deprecatedLoader, deprecatedContext});
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    protected void initialize(final ClassLoader classLoader, IWeavingContext context) {
        if (this.initialized) {
            return;
        }
        boolean success = true;
        if (trace.isTraceEnabled()) {
            trace.enter("initialize", (Object)this, new Object[]{classLoader, context});
        }
        this.weavingContext = context;
        if (this.weavingContext == null) {
            this.weavingContext = new DefaultWeavingContext(classLoader);
        }
        this.createMessageHandler();
        this.generatedClassHandler = new GeneratedClassHandler(){

            public void acceptClass(String name, byte[] bytes) {
                try {
                    if (ClassLoaderWeavingAdaptor.this.shouldDump(name.replace('/', '.'), false)) {
                        ClassLoaderWeavingAdaptor.this.dump(name, bytes, false);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ClassLoaderWeavingAdaptor.this.defineClass(classLoader, name, bytes);
            }
        };
        List definitions = this.parseDefinitions(classLoader);
        if (definitions.isEmpty()) {
            this.disable();
            if (trace.isTraceEnabled()) {
                trace.exit("initialize", definitions);
            }
            return;
        }
        this.bcelWorld = new LTWWorld(classLoader, this.weavingContext, this.getMessageHandler(), new ICrossReferenceHandler(){

            public void addCrossReference(ISourceLocation from, ISourceLocation to, IRelationship.Kind kind, boolean runtimeTest) {
            }
        });
        this.weaver = new BcelWeaver(this.bcelWorld);
        success = this.registerDefinitions(this.weaver, classLoader, definitions);
        if (success) {
            this.weaver.prepareForWeave();
            this.enable();
            success = this.weaveAndDefineConceteAspects();
        }
        if (success) {
            this.enable();
        } else {
            this.disable();
            this.bcelWorld = null;
            this.weaver = null;
        }
        this.initialized = true;
        if (trace.isTraceEnabled()) {
            trace.exit("initialize", this.isEnabled());
        }
    }

    private List parseDefinitions(ClassLoader loader) {
        if (trace.isTraceEnabled()) {
            trace.enter("parseDefinitions", (Object)this, loader);
        }
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        try {
            String file;
            this.info("register classloader " + this.getClassLoaderName(loader));
            if (loader.equals(ClassLoader.getSystemClassLoader()) && (file = System.getProperty("aj5.def", null)) != null) {
                this.info("using (-Daj5.def) " + file);
                definitions.add(DocumentParser.parse(new File(file).toURL()));
            }
            String resourcePath = System.getProperty("org.aspectj.weaver.loadtime.configuration", AOP_XML);
            if (trace.isTraceEnabled()) {
                trace.event("parseDefinitions", (Object)this, resourcePath);
            }
            StringTokenizer st = new StringTokenizer(resourcePath, ";");
            while (st.hasMoreTokens()) {
                Enumeration xmls = this.weavingContext.getResources(st.nextToken());
                HashSet<URL> seenBefore = new HashSet<URL>();
                while (xmls.hasMoreElements()) {
                    URL xml = (URL)xmls.nextElement();
                    if (trace.isTraceEnabled()) {
                        trace.event("parseDefinitions", (Object)this, xml);
                    }
                    if (!seenBefore.contains(xml)) {
                        this.info("using configuration " + this.weavingContext.getFile(xml));
                        definitions.add(DocumentParser.parse(xml));
                        seenBefore.add(xml);
                        continue;
                    }
                    this.warn("ignoring duplicate definition: " + xml);
                }
            }
            if (definitions.isEmpty()) {
                this.info("no configuration found. Disabling weaver for class loader " + this.getClassLoaderName(loader));
            }
        }
        catch (Exception e) {
            definitions.clear();
            this.warn("parse definitions failed", e);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("parseDefinitions", definitions);
        }
        return definitions;
    }

    private boolean registerDefinitions(BcelWeaver weaver, ClassLoader loader, List definitions) {
        if (trace.isTraceEnabled()) {
            trace.enter("registerDefinitions", (Object)this, definitions);
        }
        boolean success = true;
        try {
            this.registerOptions(weaver, loader, definitions);
            this.registerAspectExclude(weaver, loader, definitions);
            this.registerAspectInclude(weaver, loader, definitions);
            success = this.registerAspects(weaver, loader, definitions);
            this.registerIncludeExclude(weaver, loader, definitions);
            this.registerDump(weaver, loader, definitions);
        }
        catch (Exception ex) {
            trace.error("register definition failed", ex);
            success = false;
            this.warn("register definition failed", ex instanceof AbortException ? null : ex);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("registerDefinitions", success);
        }
        return success;
    }

    private String getClassLoaderName(ClassLoader loader) {
        return this.weavingContext.getClassLoaderName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOptions(BcelWeaver weaver, ClassLoader loader, List definitions) {
        StringBuffer allOptions = new StringBuffer();
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = (Definition)iterator.next();
            allOptions.append(definition.getWeaverOptions()).append(' ');
        }
        Options.WeaverOption weaverOption = Options.parse(allOptions.toString(), loader, this.getMessageHandler());
        World world = weaver.getWorld();
        this.setMessageHandler(weaverOption.messageHandler);
        world.setXlazyTjp(weaverOption.lazyTjp);
        world.setXHasMemberSupportEnabled(weaverOption.hasMember);
        world.setOptionalJoinpoints(weaverOption.optionalJoinpoints);
        world.setPinpointMode(weaverOption.pinpoint);
        weaver.setReweavableMode(weaverOption.notReWeavable);
        world.performExtraConfiguration(weaverOption.xSet);
        world.setXnoInline(weaverOption.noInline);
        world.setBehaveInJava5Way(LangUtil.is15VMOrGreater());
        world.setAddSerialVerUID(weaverOption.addSerialVersionUID);
        this.bcelWorld.getLint().loadDefaultProperties();
        this.bcelWorld.getLint().adviceDidNotMatch.setKind(null);
        if (weaverOption.lintFile != null) {
            InputStream resource = null;
            try {
                resource = loader.getResourceAsStream(weaverOption.lintFile);
                IOException failure = null;
                if (resource != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(resource);
                        world.getLint().setFromProperties(properties);
                    }
                    catch (IOException e) {
                        failure = e;
                    }
                }
                if (failure != null || resource == null) {
                    this.warn("Cannot access resource for -Xlintfile:" + weaverOption.lintFile, failure);
                }
            }
            finally {
                try {
                    resource.close();
                }
                catch (Throwable t) {}
            }
        }
        if (weaverOption.lint != null) {
            if (weaverOption.lint.equals("default")) {
                this.bcelWorld.getLint().loadDefaultProperties();
            } else {
                this.bcelWorld.getLint().setAll(weaverOption.lint);
            }
        }
    }

    private void registerAspectExclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = (Definition)iterator.next();
            Iterator iterator1 = definition.getAspectExcludePatterns().iterator();
            while (iterator1.hasNext()) {
                String exclude = (String)iterator1.next();
                TypePattern excludePattern = new PatternParser(exclude).parseTypePattern();
                this.m_aspectExcludeTypePattern.add(excludePattern);
                fastMatchInfo = this.looksLikeStartsWith(exclude);
                if (fastMatchInfo == null) continue;
                this.m_aspectExcludeStartsWith.add(fastMatchInfo);
            }
        }
    }

    private void registerAspectInclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = (Definition)iterator.next();
            Iterator iterator1 = definition.getAspectIncludePatterns().iterator();
            while (iterator1.hasNext()) {
                String include = (String)iterator1.next();
                TypePattern includePattern = new PatternParser(include).parseTypePattern();
                this.m_aspectIncludeTypePattern.add(includePattern);
                fastMatchInfo = this.looksLikeStartsWith(include);
                if (fastMatchInfo == null) continue;
                this.m_aspectIncludeStartsWith.add(fastMatchInfo);
            }
        }
    }

    protected void lint(String name, String[] infos) {
        Lint lint = this.bcelWorld.getLint();
        Lint.Kind kind = lint.getLintKind(name);
        kind.signal(infos, null, null);
    }

    public String getContextId() {
        return this.weavingContext.getId();
    }

    private boolean registerAspects(BcelWeaver weaver, ClassLoader loader, List definitions) {
        Iterator aspects;
        Definition definition;
        if (trace.isTraceEnabled()) {
            trace.enter("registerAspects", (Object)this, new Object[]{weaver, loader, definitions});
        }
        boolean success = true;
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            definition = (Definition)iterator.next();
            aspects = definition.getAspectClassNames().iterator();
            while (aspects.hasNext()) {
                String aspectClassName = (String)aspects.next();
                if (this.acceptAspect(aspectClassName)) {
                    this.info("register aspect " + aspectClassName);
                    weaver.addLibraryAspect(aspectClassName);
                    if (this.namespace == null) {
                        this.namespace = new StringBuffer(aspectClassName);
                        continue;
                    }
                    this.namespace = this.namespace.append(";" + aspectClassName);
                    continue;
                }
                this.lint("aspectExcludedByConfiguration", new String[]{aspectClassName, this.getClassLoaderName(loader)});
            }
        }
        iterator = definitions.iterator();
        block2: while (iterator.hasNext()) {
            definition = (Definition)iterator.next();
            aspects = definition.getConcreteAspects().iterator();
            while (aspects.hasNext()) {
                Definition.ConcreteAspect concreteAspect = (Definition.ConcreteAspect)aspects.next();
                if (!this.acceptAspect(concreteAspect.name)) continue;
                this.info("define aspect " + concreteAspect.name);
                ConcreteAspectCodeGen gen = new ConcreteAspectCodeGen(concreteAspect, weaver.getWorld());
                if (!gen.validate()) {
                    this.error("Concrete-aspect '" + concreteAspect.name + "' could not be registered");
                    success = false;
                    continue block2;
                }
                ((BcelWorld)weaver.getWorld()).addSourceObjectType(Utility.makeJavaClass(concreteAspect.name, gen.getBytes()));
                this.concreteAspects.add(gen);
                weaver.addLibraryAspect(concreteAspect.name);
                if (this.namespace == null) {
                    this.namespace = new StringBuffer(concreteAspect.name);
                    continue;
                }
                this.namespace = this.namespace.append(";" + concreteAspect.name);
            }
        }
        if (!success) {
            this.warn("failure(s) registering aspects. Disabling weaver for class loader " + this.getClassLoaderName(loader));
        } else if (this.namespace == null) {
            success = false;
            this.info("no aspects registered. Disabling weaver for class loader " + this.getClassLoaderName(loader));
        }
        if (trace.isTraceEnabled()) {
            trace.exit("registerAspects", success);
        }
        return success;
    }

    private boolean weaveAndDefineConceteAspects() {
        if (trace.isTraceEnabled()) {
            trace.enter("weaveAndDefineConceteAspects", (Object)this, this.concreteAspects);
        }
        boolean success = true;
        Iterator iterator = this.concreteAspects.iterator();
        while (iterator.hasNext()) {
            ConcreteAspectCodeGen gen = (ConcreteAspectCodeGen)iterator.next();
            String name = gen.getClassName();
            byte[] bytes = gen.getBytes();
            try {
                byte[] newBytes = this.weaveClass(name, bytes);
                this.generatedClassHandler.acceptClass(name, newBytes);
            }
            catch (IOException ex) {
                trace.error("weaveAndDefineConceteAspects", ex);
                this.error("exception weaving aspect '" + name + "'", ex);
            }
        }
        if (trace.isTraceEnabled()) {
            trace.exit("weaveAndDefineConceteAspects", success);
        }
        return success;
    }

    private void registerIncludeExclude(BcelWeaver weaver, ClassLoader loader, List definitions) {
        String fastMatchInfo = null;
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = (Definition)iterator.next();
            Iterator iterator1 = definition.getIncludePatterns().iterator();
            while (iterator1.hasNext()) {
                String include = (String)iterator1.next();
                TypePattern includePattern = new PatternParser(include).parseTypePattern();
                this.m_includeTypePattern.add(includePattern);
                fastMatchInfo = this.looksLikeStartsWith(include);
                if (fastMatchInfo == null) continue;
                this.m_includeStartsWith.add(fastMatchInfo);
            }
            iterator1 = definition.getExcludePatterns().iterator();
            while (iterator1.hasNext()) {
                String exclude = (String)iterator1.next();
                TypePattern excludePattern = new PatternParser(exclude).parseTypePattern();
                this.m_excludeTypePattern.add(excludePattern);
                fastMatchInfo = this.looksLikeStartsWith(exclude);
                if (fastMatchInfo == null) continue;
                this.m_excludeStartsWith.add(fastMatchInfo);
            }
        }
    }

    private String looksLikeStartsWith(String typePattern) {
        if (typePattern.indexOf(64) >= 0 || typePattern.indexOf(43) >= 0 || typePattern.indexOf(32) >= 0 || typePattern.charAt(typePattern.length() - 1) != '*') {
            return null;
        }
        int length = typePattern.length();
        if (typePattern.endsWith("..*") && length > 3 && typePattern.indexOf("..") == length - 3 && typePattern.indexOf(42) == length - 1) {
            return typePattern.substring(0, length - 2).replace('$', '.');
        }
        return null;
    }

    private void registerDump(BcelWeaver weaver, ClassLoader loader, List definitions) {
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            Definition definition = (Definition)iterator.next();
            Iterator iterator1 = definition.getDumpPatterns().iterator();
            while (iterator1.hasNext()) {
                String dump = (String)iterator1.next();
                TypePattern pattern = new PatternParser(dump).parseTypePattern();
                this.m_dumpTypePattern.add(pattern);
            }
            if (!definition.shouldDumpBefore()) continue;
            this.m_dumpBefore = true;
        }
    }

    protected boolean accept(String className, byte[] bytes) {
        TypePattern typePattern;
        if (this.m_excludeTypePattern.isEmpty() && this.m_includeTypePattern.isEmpty()) {
            return true;
        }
        String fastClassName = className.replace('/', '.').replace('$', '.');
        for (int i = 0; i < this.m_excludeStartsWith.size(); ++i) {
            if (!fastClassName.startsWith((String)this.m_excludeStartsWith.get(i))) continue;
            return false;
        }
        if (this.m_excludeTypePattern.isEmpty()) {
            boolean fastAccept = false;
            for (int i = 0; i < this.m_includeStartsWith.size() && !(fastAccept = fastClassName.startsWith((String)this.m_includeStartsWith.get(i))); ++i) {
            }
        }
        this.ensureDelegateInitialized(className, bytes);
        ReferenceType classInfo = this.delegateForCurrentClass.getResolvedTypeX();
        Iterator iterator = this.m_excludeTypePattern.iterator();
        while (iterator.hasNext()) {
            TypePattern typePattern2 = (TypePattern)iterator.next();
            if (!typePattern2.matchesStatically(classInfo)) continue;
            return false;
        }
        boolean accept = true;
        Iterator iterator2 = this.m_includeTypePattern.iterator();
        while (iterator2.hasNext() && !(accept = (typePattern = (TypePattern)iterator2.next()).matchesStatically(classInfo))) {
        }
        return accept;
    }

    private boolean acceptAspect(String aspectClassName) {
        TypePattern typePattern;
        int i;
        if (this.m_aspectExcludeTypePattern.isEmpty() && this.m_aspectIncludeTypePattern.isEmpty()) {
            return true;
        }
        String fastClassName = aspectClassName.replace('/', '.').replace('.', '$');
        for (i = 0; i < this.m_aspectExcludeStartsWith.size(); ++i) {
            if (!fastClassName.startsWith((String)this.m_aspectExcludeStartsWith.get(i))) continue;
            return false;
        }
        for (i = 0; i < this.m_aspectIncludeStartsWith.size(); ++i) {
            if (!fastClassName.startsWith((String)this.m_aspectIncludeStartsWith.get(i))) continue;
            return true;
        }
        ResolvedType classInfo = this.weaver.getWorld().resolve(UnresolvedType.forName(aspectClassName), true);
        Iterator iterator = this.m_aspectExcludeTypePattern.iterator();
        while (iterator.hasNext()) {
            TypePattern typePattern2 = (TypePattern)iterator.next();
            if (!typePattern2.matchesStatically(classInfo)) continue;
            return false;
        }
        boolean accept = true;
        Iterator iterator2 = this.m_aspectIncludeTypePattern.iterator();
        while (iterator2.hasNext() && !(accept = (typePattern = (TypePattern)iterator2.next()).matchesStatically(classInfo))) {
        }
        return accept;
    }

    protected boolean shouldDump(String className, boolean before) {
        if (before && !this.m_dumpBefore) {
            return false;
        }
        if (this.m_dumpTypePattern.isEmpty()) {
            return false;
        }
        ResolvedType classInfo = this.weaver.getWorld().resolve(UnresolvedType.forName(className), true);
        Iterator iterator = this.m_dumpTypePattern.iterator();
        while (iterator.hasNext()) {
            TypePattern typePattern = (TypePattern)iterator.next();
            if (!typePattern.matchesStatically(classInfo)) continue;
            return true;
        }
        return false;
    }

    public String getNamespace() {
        if (this.namespace == null) {
            return "";
        }
        return new String(this.namespace);
    }

    public boolean generatedClassesExistFor(String className) {
        if (className == null) {
            return !this.generatedClasses.isEmpty();
        }
        return this.generatedClasses.containsKey(className);
    }

    public void flushGeneratedClasses() {
        this.generatedClasses = new HashMap();
    }

    private void defineClass(ClassLoader loader, String name, byte[] bytes) {
        if (trace.isTraceEnabled()) {
            trace.enter("defineClass", (Object)this, new Object[]{loader, name, bytes});
        }
        Object clazz = null;
        this.debug("generating class '" + name + "'");
        try {
            Method defineClass = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = ClassLoaderWeavingAdaptor.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = ClassLoaderWeavingAdaptor.class$("java.lang.String")) : class$java$lang$String, bytes.getClass(), Integer.TYPE, Integer.TYPE);
            ((AccessibleObject)defineClass).setAccessible(true);
            clazz = defineClass.invoke((Object)loader, name, bytes, new Integer(0), new Integer(bytes.length));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof LinkageError) {
                this.warn("define generated class failed", e.getTargetException());
            } else {
                this.warn("define generated class failed", e.getTargetException());
            }
        }
        catch (Exception e) {
            this.warn("define generated class failed", e);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("defineClass", clazz);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

