/*
 * Copyright (c) 2017, 2021, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var mysqlx_pb = require('./mysqlx_pb.js');
goog.exportSymbol('proto.Mysqlx.Resultset.ColumnMetaData', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.ColumnMetaData.FieldType', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.ContentType_BYTES', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.ContentType_DATETIME', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.FetchDone', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.FetchDoneMoreOutParams', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.FetchDoneMoreResultsets', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.FetchSuspended', null, global);
goog.exportSymbol('proto.Mysqlx.Resultset.Row', null, global);

/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Resultset.FetchDoneMoreOutParams, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.FetchDoneMoreOutParams.displayName = 'proto.Mysqlx.Resultset.FetchDoneMoreOutParams';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.FetchDoneMoreOutParams.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreOutParams} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.FetchDoneMoreOutParams}
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.FetchDoneMoreOutParams;
  return proto.Mysqlx.Resultset.FetchDoneMoreOutParams.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreOutParams} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.FetchDoneMoreOutParams}
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.FetchDoneMoreOutParams.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreOutParams} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDoneMoreOutParams.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Resultset.FetchDoneMoreResultsets, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.FetchDoneMoreResultsets.displayName = 'proto.Mysqlx.Resultset.FetchDoneMoreResultsets';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.FetchDoneMoreResultsets.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreResultsets} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.FetchDoneMoreResultsets}
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.FetchDoneMoreResultsets;
  return proto.Mysqlx.Resultset.FetchDoneMoreResultsets.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreResultsets} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.FetchDoneMoreResultsets}
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.FetchDoneMoreResultsets.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.FetchDoneMoreResultsets} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDoneMoreResultsets.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.FetchDone = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Resultset.FetchDone, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.FetchDone.displayName = 'proto.Mysqlx.Resultset.FetchDone';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.FetchDone.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.FetchDone.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.FetchDone} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDone.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.FetchDone}
 */
proto.Mysqlx.Resultset.FetchDone.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.FetchDone;
  return proto.Mysqlx.Resultset.FetchDone.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.FetchDone} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.FetchDone}
 */
proto.Mysqlx.Resultset.FetchDone.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.FetchDone.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.FetchDone.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.FetchDone} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchDone.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.FetchSuspended = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Resultset.FetchSuspended, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.FetchSuspended.displayName = 'proto.Mysqlx.Resultset.FetchSuspended';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.FetchSuspended.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.FetchSuspended.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.FetchSuspended} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchSuspended.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.FetchSuspended}
 */
proto.Mysqlx.Resultset.FetchSuspended.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.FetchSuspended;
  return proto.Mysqlx.Resultset.FetchSuspended.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.FetchSuspended} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.FetchSuspended}
 */
proto.Mysqlx.Resultset.FetchSuspended.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.FetchSuspended.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.FetchSuspended.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.FetchSuspended} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.FetchSuspended.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.ColumnMetaData = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Resultset.ColumnMetaData, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.ColumnMetaData.displayName = 'proto.Mysqlx.Resultset.ColumnMetaData';
}


if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.ColumnMetaData.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.ColumnMetaData} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.ColumnMetaData.toObject = function(includeInstance, msg) {
  var f, obj = {
    type: jspb.Message.getField(msg, 1),
    name: msg.getName_asB64(),
    originalName: msg.getOriginalName_asB64(),
    table: msg.getTable_asB64(),
    originalTable: msg.getOriginalTable_asB64(),
    schema: msg.getSchema_asB64(),
    catalog: msg.getCatalog_asB64(),
    collation: jspb.Message.getField(msg, 8),
    fractionalDigits: jspb.Message.getField(msg, 9),
    length: jspb.Message.getField(msg, 10),
    flags: jspb.Message.getField(msg, 11),
    contentType: jspb.Message.getField(msg, 12)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.ColumnMetaData}
 */
proto.Mysqlx.Resultset.ColumnMetaData.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.ColumnMetaData;
  return proto.Mysqlx.Resultset.ColumnMetaData.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.ColumnMetaData} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.ColumnMetaData}
 */
proto.Mysqlx.Resultset.ColumnMetaData.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Resultset.ColumnMetaData.FieldType} */ (reader.readEnum());
      msg.setType(value);
      break;
    case 2:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setName(value);
      break;
    case 3:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setOriginalName(value);
      break;
    case 4:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setTable(value);
      break;
    case 5:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setOriginalTable(value);
      break;
    case 6:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setSchema(value);
      break;
    case 7:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setCatalog(value);
      break;
    case 8:
      var value = /** @type {number} */ (reader.readUint64());
      msg.setCollation(value);
      break;
    case 9:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setFractionalDigits(value);
      break;
    case 10:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setLength(value);
      break;
    case 11:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setFlags(value);
      break;
    case 12:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setContentType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.ColumnMetaData.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.ColumnMetaData} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.ColumnMetaData.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Resultset.ColumnMetaData.FieldType} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeBytes(
      2,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeBytes(
      3,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 4));
  if (f != null) {
    writer.writeBytes(
      4,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 5));
  if (f != null) {
    writer.writeBytes(
      5,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 6));
  if (f != null) {
    writer.writeBytes(
      6,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 7));
  if (f != null) {
    writer.writeBytes(
      7,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 8));
  if (f != null) {
    writer.writeUint64(
      8,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 9));
  if (f != null) {
    writer.writeUint32(
      9,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 10));
  if (f != null) {
    writer.writeUint32(
      10,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 11));
  if (f != null) {
    writer.writeUint32(
      11,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 12));
  if (f != null) {
    writer.writeUint32(
      12,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.FieldType = {
  SINT: 1,
  UINT: 2,
  DOUBLE: 5,
  FLOAT: 6,
  BYTES: 7,
  TIME: 10,
  DATETIME: 12,
  SET: 15,
  ENUM: 16,
  BIT: 17,
  DECIMAL: 18
};

/**
 * required FieldType type = 1;
 * @return {!proto.Mysqlx.Resultset.ColumnMetaData.FieldType}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getType = function() {
  return /** @type {!proto.Mysqlx.Resultset.ColumnMetaData.FieldType} */ (jspb.Message.getFieldWithDefault(this, 1, 1));
};


/** @param {!proto.Mysqlx.Resultset.ColumnMetaData.FieldType} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setType = function(value) {
  jspb.Message.setField(this, 1, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearType = function() {
  jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasType = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional bytes name = 2;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getName = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * optional bytes name = 2;
 * This is a type-conversion wrapper around `getName()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getName_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getName()));
};


/**
 * optional bytes name = 2;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getName()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getName_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getName()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setName = function(value) {
  jspb.Message.setField(this, 2, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearName = function() {
  jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasName = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional bytes original_name = 3;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalName = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * optional bytes original_name = 3;
 * This is a type-conversion wrapper around `getOriginalName()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalName_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getOriginalName()));
};


/**
 * optional bytes original_name = 3;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getOriginalName()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalName_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getOriginalName()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setOriginalName = function(value) {
  jspb.Message.setField(this, 3, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearOriginalName = function() {
  jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasOriginalName = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional bytes table = 4;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getTable = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * optional bytes table = 4;
 * This is a type-conversion wrapper around `getTable()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getTable_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getTable()));
};


/**
 * optional bytes table = 4;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getTable()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getTable_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getTable()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setTable = function(value) {
  jspb.Message.setField(this, 4, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearTable = function() {
  jspb.Message.setField(this, 4, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasTable = function() {
  return jspb.Message.getField(this, 4) != null;
};


/**
 * optional bytes original_table = 5;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalTable = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 5, ""));
};


/**
 * optional bytes original_table = 5;
 * This is a type-conversion wrapper around `getOriginalTable()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalTable_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getOriginalTable()));
};


/**
 * optional bytes original_table = 5;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getOriginalTable()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getOriginalTable_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getOriginalTable()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setOriginalTable = function(value) {
  jspb.Message.setField(this, 5, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearOriginalTable = function() {
  jspb.Message.setField(this, 5, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasOriginalTable = function() {
  return jspb.Message.getField(this, 5) != null;
};


/**
 * optional bytes schema = 6;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getSchema = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 6, ""));
};


/**
 * optional bytes schema = 6;
 * This is a type-conversion wrapper around `getSchema()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getSchema_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getSchema()));
};


/**
 * optional bytes schema = 6;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getSchema()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getSchema_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getSchema()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setSchema = function(value) {
  jspb.Message.setField(this, 6, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearSchema = function() {
  jspb.Message.setField(this, 6, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasSchema = function() {
  return jspb.Message.getField(this, 6) != null;
};


/**
 * optional bytes catalog = 7;
 * @return {!(string|Uint8Array)}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getCatalog = function() {
  return /** @type {!(string|Uint8Array)} */ (jspb.Message.getFieldWithDefault(this, 7, ""));
};


/**
 * optional bytes catalog = 7;
 * This is a type-conversion wrapper around `getCatalog()`
 * @return {string}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getCatalog_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getCatalog()));
};


/**
 * optional bytes catalog = 7;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getCatalog()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getCatalog_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getCatalog()));
};


/** @param {!(string|Uint8Array)} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setCatalog = function(value) {
  jspb.Message.setField(this, 7, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearCatalog = function() {
  jspb.Message.setField(this, 7, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasCatalog = function() {
  return jspb.Message.getField(this, 7) != null;
};


/**
 * optional uint64 collation = 8;
 * @return {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getCollation = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 8, 0));
};


/** @param {number} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setCollation = function(value) {
  jspb.Message.setField(this, 8, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearCollation = function() {
  jspb.Message.setField(this, 8, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasCollation = function() {
  return jspb.Message.getField(this, 8) != null;
};


/**
 * optional uint32 fractional_digits = 9;
 * @return {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getFractionalDigits = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 9, 0));
};


/** @param {number} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setFractionalDigits = function(value) {
  jspb.Message.setField(this, 9, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearFractionalDigits = function() {
  jspb.Message.setField(this, 9, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasFractionalDigits = function() {
  return jspb.Message.getField(this, 9) != null;
};


/**
 * optional uint32 length = 10;
 * @return {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getLength = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 10, 0));
};


/** @param {number} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setLength = function(value) {
  jspb.Message.setField(this, 10, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearLength = function() {
  jspb.Message.setField(this, 10, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasLength = function() {
  return jspb.Message.getField(this, 10) != null;
};


/**
 * optional uint32 flags = 11;
 * @return {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getFlags = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 11, 0));
};


/** @param {number} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setFlags = function(value) {
  jspb.Message.setField(this, 11, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearFlags = function() {
  jspb.Message.setField(this, 11, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasFlags = function() {
  return jspb.Message.getField(this, 11) != null;
};


/**
 * optional uint32 content_type = 12;
 * @return {number}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.getContentType = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 12, 0));
};


/** @param {number} value */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.setContentType = function(value) {
  jspb.Message.setField(this, 12, value);
};


proto.Mysqlx.Resultset.ColumnMetaData.prototype.clearContentType = function() {
  jspb.Message.setField(this, 12, undefined);
};


/**
 * Returns whether this field is set.
 * @return {!boolean}
 */
proto.Mysqlx.Resultset.ColumnMetaData.prototype.hasContentType = function() {
  return jspb.Message.getField(this, 12) != null;
};



/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Resultset.Row = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Resultset.Row.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Resultset.Row, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  proto.Mysqlx.Resultset.Row.displayName = 'proto.Mysqlx.Resultset.Row';
}
/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Resultset.Row.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto suitable for use in Soy templates.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     com.google.apps.jspb.JsClassTemplate.JS_RESERVED_WORDS.
 * @param {boolean=} opt_includeInstance Whether to include the JSPB instance
 *     for transitional soy proto support: http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Resultset.Row.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Resultset.Row.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Whether to include the JSPB
 *     instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Resultset.Row} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.Row.toObject = function(includeInstance, msg) {
  var f, obj = {
    fieldList: msg.getFieldList_asB64()
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Resultset.Row}
 */
proto.Mysqlx.Resultset.Row.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Resultset.Row;
  return proto.Mysqlx.Resultset.Row.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Resultset.Row} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Resultset.Row}
 */
proto.Mysqlx.Resultset.Row.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.addField(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Resultset.Row.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Resultset.Row.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Resultset.Row} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Resultset.Row.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getFieldList_asU8();
  if (f.length > 0) {
    writer.writeRepeatedBytes(
      1,
      f
    );
  }
};


/**
 * repeated bytes field = 1;
 * @return {!(Array<!Uint8Array>|Array<string>)}
 */
proto.Mysqlx.Resultset.Row.prototype.getFieldList = function() {
  return /** @type {!(Array<!Uint8Array>|Array<string>)} */ (jspb.Message.getRepeatedField(this, 1));
};


/**
 * repeated bytes field = 1;
 * This is a type-conversion wrapper around `getFieldList()`
 * @return {!Array.<string>}
 */
proto.Mysqlx.Resultset.Row.prototype.getFieldList_asB64 = function() {
  return /** @type {!Array.<string>} */ (jspb.Message.bytesListAsB64(
      this.getFieldList()));
};


/**
 * repeated bytes field = 1;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getFieldList()`
 * @return {!Array.<!Uint8Array>}
 */
proto.Mysqlx.Resultset.Row.prototype.getFieldList_asU8 = function() {
  return /** @type {!Array.<!Uint8Array>} */ (jspb.Message.bytesListAsU8(
      this.getFieldList()));
};


/** @param {!(Array<!Uint8Array>|Array<string>)} value */
proto.Mysqlx.Resultset.Row.prototype.setFieldList = function(value) {
  jspb.Message.setField(this, 1, value || []);
};


/**
 * @param {!(string|Uint8Array)} value
 * @param {number=} opt_index
 */
proto.Mysqlx.Resultset.Row.prototype.addField = function(value, opt_index) {
  jspb.Message.addToRepeatedField(this, 1, value, opt_index);
};


proto.Mysqlx.Resultset.Row.prototype.clearFieldList = function() {
  this.setFieldList([]);
};


/**
 * @enum {number}
 */
proto.Mysqlx.Resultset.ContentType_BYTES = {
  GEOMETRY: 1,
  JSON: 2,
  XML: 3
};

/**
 * @enum {number}
 */
proto.Mysqlx.Resultset.ContentType_DATETIME = {
  DATE: 1,
  DATETIME: 2
};

goog.object.extend(exports, proto.Mysqlx.Resultset);
