/*
 * Copyright (c) 2017, 2022, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

// source: mysqlx_datatypes.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

goog.exportSymbol('proto.Mysqlx.Datatypes.Any', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Any.Type', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Array', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Object', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Object.ObjectField', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Scalar', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Scalar.Octets', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Scalar.String', null, global);
goog.exportSymbol('proto.Mysqlx.Datatypes.Scalar.Type', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Scalar = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Scalar, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Scalar.displayName = 'proto.Mysqlx.Datatypes.Scalar';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Scalar.String = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Scalar.String, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Scalar.String.displayName = 'proto.Mysqlx.Datatypes.Scalar.String';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Scalar.Octets = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Scalar.Octets, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Scalar.Octets.displayName = 'proto.Mysqlx.Datatypes.Scalar.Octets';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Object = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Datatypes.Object.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Object, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Object.displayName = 'proto.Mysqlx.Datatypes.Object';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Object.ObjectField = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Object.ObjectField, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Object.ObjectField.displayName = 'proto.Mysqlx.Datatypes.Object.ObjectField';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Array = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Datatypes.Array.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Array, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Array.displayName = 'proto.Mysqlx.Datatypes.Array';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Datatypes.Any = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Datatypes.Any, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Datatypes.Any.displayName = 'proto.Mysqlx.Datatypes.Any';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Scalar.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Scalar} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.toObject = function(includeInstance, msg) {
  var f, obj = {
    type: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    vSignedInt: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f,
    vUnsignedInt: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f,
    vOctets: (f = msg.getVOctets()) && proto.Mysqlx.Datatypes.Scalar.Octets.toObject(includeInstance, f),
    vDouble: (f = jspb.Message.getOptionalFloatingPointField(msg, 6)) == null ? undefined : f,
    vFloat: (f = jspb.Message.getOptionalFloatingPointField(msg, 7)) == null ? undefined : f,
    vBool: (f = jspb.Message.getBooleanField(msg, 8)) == null ? undefined : f,
    vString: (f = msg.getVString()) && proto.Mysqlx.Datatypes.Scalar.String.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Scalar}
 */
proto.Mysqlx.Datatypes.Scalar.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Scalar;
  return proto.Mysqlx.Datatypes.Scalar.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Scalar} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Scalar}
 */
proto.Mysqlx.Datatypes.Scalar.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Datatypes.Scalar.Type} */ (reader.readEnum());
      msg.setType(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readSint64());
      msg.setVSignedInt(value);
      break;
    case 3:
      var value = /** @type {number} */ (reader.readUint64());
      msg.setVUnsignedInt(value);
      break;
    case 5:
      var value = new proto.Mysqlx.Datatypes.Scalar.Octets;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Scalar.Octets.deserializeBinaryFromReader);
      msg.setVOctets(value);
      break;
    case 6:
      var value = /** @type {number} */ (reader.readDouble());
      msg.setVDouble(value);
      break;
    case 7:
      var value = /** @type {number} */ (reader.readFloat());
      msg.setVFloat(value);
      break;
    case 8:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setVBool(value);
      break;
    case 9:
      var value = new proto.Mysqlx.Datatypes.Scalar.String;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Scalar.String.deserializeBinaryFromReader);
      msg.setVString(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Scalar.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Scalar} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Datatypes.Scalar.Type} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeSint64(
      2,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeUint64(
      3,
      f
    );
  }
  f = message.getVOctets();
  if (f != null) {
    writer.writeMessage(
      5,
      f,
      proto.Mysqlx.Datatypes.Scalar.Octets.serializeBinaryToWriter
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 6));
  if (f != null) {
    writer.writeDouble(
      6,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 7));
  if (f != null) {
    writer.writeFloat(
      7,
      f
    );
  }
  f = /** @type {boolean} */ (jspb.Message.getField(message, 8));
  if (f != null) {
    writer.writeBool(
      8,
      f
    );
  }
  f = message.getVString();
  if (f != null) {
    writer.writeMessage(
      9,
      f,
      proto.Mysqlx.Datatypes.Scalar.String.serializeBinaryToWriter
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Datatypes.Scalar.Type = {
  V_SINT: 1,
  V_UINT: 2,
  V_NULL: 3,
  V_OCTETS: 4,
  V_DOUBLE: 5,
  V_FLOAT: 6,
  V_BOOL: 7,
  V_STRING: 8
};




if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Scalar.String.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Scalar.String} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.String.toObject = function(includeInstance, msg) {
  var f, obj = {
    value: msg.getValue_asB64(),
    collation: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Scalar.String}
 */
proto.Mysqlx.Datatypes.Scalar.String.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Scalar.String;
  return proto.Mysqlx.Datatypes.Scalar.String.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Scalar.String} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Scalar.String}
 */
proto.Mysqlx.Datatypes.Scalar.String.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setValue(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readUint64());
      msg.setCollation(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Scalar.String.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Scalar.String} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.String.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeBytes(
      1,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeUint64(
      2,
      f
    );
  }
};


/**
 * required bytes value = 1;
 * @return {string}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.getValue = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * required bytes value = 1;
 * This is a type-conversion wrapper around `getValue()`
 * @return {string}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.getValue_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getValue()));
};


/**
 * required bytes value = 1;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getValue()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.getValue_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getValue()));
};


/**
 * @param {!(string|Uint8Array)} value
 * @return {!proto.Mysqlx.Datatypes.Scalar.String} returns this
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.setValue = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar.String} returns this
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.clearValue = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.hasValue = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional uint64 collation = 2;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.getCollation = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar.String} returns this
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.setCollation = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar.String} returns this
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.clearCollation = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.String.prototype.hasCollation = function() {
  return jspb.Message.getField(this, 2) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Scalar.Octets.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Scalar.Octets} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.Octets.toObject = function(includeInstance, msg) {
  var f, obj = {
    value: msg.getValue_asB64(),
    contentType: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Scalar.Octets;
  return proto.Mysqlx.Datatypes.Scalar.Octets.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Scalar.Octets} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setValue(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setContentType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Scalar.Octets.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Scalar.Octets} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Scalar.Octets.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeBytes(
      1,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeUint32(
      2,
      f
    );
  }
};


/**
 * required bytes value = 1;
 * @return {string}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.getValue = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * required bytes value = 1;
 * This is a type-conversion wrapper around `getValue()`
 * @return {string}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.getValue_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getValue()));
};


/**
 * required bytes value = 1;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getValue()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.getValue_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getValue()));
};


/**
 * @param {!(string|Uint8Array)} value
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets} returns this
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.setValue = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets} returns this
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.clearValue = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.hasValue = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional uint32 content_type = 2;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.getContentType = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets} returns this
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.setContentType = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar.Octets} returns this
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.clearContentType = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.Octets.prototype.hasContentType = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * required Type type = 1;
 * @return {!proto.Mysqlx.Datatypes.Scalar.Type}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getType = function() {
  return /** @type {!proto.Mysqlx.Datatypes.Scalar.Type} */ (jspb.Message.getFieldWithDefault(this, 1, 1));
};


/**
 * @param {!proto.Mysqlx.Datatypes.Scalar.Type} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setType = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearType = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasType = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional sint64 v_signed_int = 2;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVSignedInt = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setVSignedInt = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVSignedInt = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVSignedInt = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional uint64 v_unsigned_int = 3;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVUnsignedInt = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setVUnsignedInt = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVUnsignedInt = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVUnsignedInt = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional Octets v_octets = 5;
 * @return {?proto.Mysqlx.Datatypes.Scalar.Octets}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVOctets = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Scalar.Octets} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Scalar.Octets, 5));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Scalar.Octets|undefined} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
*/
proto.Mysqlx.Datatypes.Scalar.prototype.setVOctets = function(value) {
  return jspb.Message.setWrapperField(this, 5, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVOctets = function() {
  return this.setVOctets(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVOctets = function() {
  return jspb.Message.getField(this, 5) != null;
};


/**
 * optional double v_double = 6;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVDouble = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 6, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setVDouble = function(value) {
  return jspb.Message.setField(this, 6, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVDouble = function() {
  return jspb.Message.setField(this, 6, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVDouble = function() {
  return jspb.Message.getField(this, 6) != null;
};


/**
 * optional float v_float = 7;
 * @return {number}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVFloat = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 7, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setVFloat = function(value) {
  return jspb.Message.setField(this, 7, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVFloat = function() {
  return jspb.Message.setField(this, 7, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVFloat = function() {
  return jspb.Message.getField(this, 7) != null;
};


/**
 * optional bool v_bool = 8;
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVBool = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 8, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.setVBool = function(value) {
  return jspb.Message.setField(this, 8, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVBool = function() {
  return jspb.Message.setField(this, 8, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVBool = function() {
  return jspb.Message.getField(this, 8) != null;
};


/**
 * optional String v_string = 9;
 * @return {?proto.Mysqlx.Datatypes.Scalar.String}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.getVString = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Scalar.String} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Scalar.String, 9));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Scalar.String|undefined} value
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
*/
proto.Mysqlx.Datatypes.Scalar.prototype.setVString = function(value) {
  return jspb.Message.setWrapperField(this, 9, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Scalar} returns this
 */
proto.Mysqlx.Datatypes.Scalar.prototype.clearVString = function() {
  return this.setVString(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Scalar.prototype.hasVString = function() {
  return jspb.Message.getField(this, 9) != null;
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Datatypes.Object.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Object.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Object.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Object} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Object.toObject = function(includeInstance, msg) {
  var f, obj = {
    fldList: jspb.Message.toObjectList(msg.getFldList(),
    proto.Mysqlx.Datatypes.Object.ObjectField.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Object}
 */
proto.Mysqlx.Datatypes.Object.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Object;
  return proto.Mysqlx.Datatypes.Object.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Object} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Object}
 */
proto.Mysqlx.Datatypes.Object.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.Mysqlx.Datatypes.Object.ObjectField;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Object.ObjectField.deserializeBinaryFromReader);
      msg.addFld(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Object.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Object.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Object} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Object.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getFldList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.Mysqlx.Datatypes.Object.ObjectField.serializeBinaryToWriter
    );
  }
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Object.ObjectField.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Object.ObjectField} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Object.ObjectField.toObject = function(includeInstance, msg) {
  var f, obj = {
    key: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    value: (f = msg.getValue()) && proto.Mysqlx.Datatypes.Any.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Object.ObjectField;
  return proto.Mysqlx.Datatypes.Object.ObjectField.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Object.ObjectField} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setKey(value);
      break;
    case 2:
      var value = new proto.Mysqlx.Datatypes.Any;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Any.deserializeBinaryFromReader);
      msg.setValue(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Object.ObjectField.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Object.ObjectField} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Object.ObjectField.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getValue();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      proto.Mysqlx.Datatypes.Any.serializeBinaryToWriter
    );
  }
};


/**
 * required string key = 1;
 * @return {string}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.getKey = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField} returns this
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.setKey = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField} returns this
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.clearKey = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.hasKey = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * required Any value = 2;
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.getValue = function() {
  return /** @type{!proto.Mysqlx.Datatypes.Any} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Any, 2, 1));
};


/**
 * @param {!proto.Mysqlx.Datatypes.Any} value
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField} returns this
*/
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.setValue = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField} returns this
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.clearValue = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Object.ObjectField.prototype.hasValue = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * repeated ObjectField fld = 1;
 * @return {!Array<!proto.Mysqlx.Datatypes.Object.ObjectField>}
 */
proto.Mysqlx.Datatypes.Object.prototype.getFldList = function() {
  return /** @type{!Array<!proto.Mysqlx.Datatypes.Object.ObjectField>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.Mysqlx.Datatypes.Object.ObjectField, 1));
};


/**
 * @param {!Array<!proto.Mysqlx.Datatypes.Object.ObjectField>} value
 * @return {!proto.Mysqlx.Datatypes.Object} returns this
*/
proto.Mysqlx.Datatypes.Object.prototype.setFldList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.Mysqlx.Datatypes.Object.ObjectField=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Datatypes.Object.ObjectField}
 */
proto.Mysqlx.Datatypes.Object.prototype.addFld = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.Mysqlx.Datatypes.Object.ObjectField, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Mysqlx.Datatypes.Object} returns this
 */
proto.Mysqlx.Datatypes.Object.prototype.clearFldList = function() {
  return this.setFldList([]);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Datatypes.Array.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Array.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Array.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Array} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Array.toObject = function(includeInstance, msg) {
  var f, obj = {
    valueList: jspb.Message.toObjectList(msg.getValueList(),
    proto.Mysqlx.Datatypes.Any.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Array}
 */
proto.Mysqlx.Datatypes.Array.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Array;
  return proto.Mysqlx.Datatypes.Array.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Array} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Array}
 */
proto.Mysqlx.Datatypes.Array.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.Mysqlx.Datatypes.Any;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Any.deserializeBinaryFromReader);
      msg.addValue(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Array.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Array.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Array} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Array.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValueList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.Mysqlx.Datatypes.Any.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Any value = 1;
 * @return {!Array<!proto.Mysqlx.Datatypes.Any>}
 */
proto.Mysqlx.Datatypes.Array.prototype.getValueList = function() {
  return /** @type{!Array<!proto.Mysqlx.Datatypes.Any>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.Mysqlx.Datatypes.Any, 1));
};


/**
 * @param {!Array<!proto.Mysqlx.Datatypes.Any>} value
 * @return {!proto.Mysqlx.Datatypes.Array} returns this
*/
proto.Mysqlx.Datatypes.Array.prototype.setValueList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.Mysqlx.Datatypes.Any=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Datatypes.Array.prototype.addValue = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.Mysqlx.Datatypes.Any, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Mysqlx.Datatypes.Array} returns this
 */
proto.Mysqlx.Datatypes.Array.prototype.clearValueList = function() {
  return this.setValueList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Datatypes.Any.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Datatypes.Any.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Datatypes.Any} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Any.toObject = function(includeInstance, msg) {
  var f, obj = {
    type: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    scalar: (f = msg.getScalar()) && proto.Mysqlx.Datatypes.Scalar.toObject(includeInstance, f),
    obj: (f = msg.getObj()) && proto.Mysqlx.Datatypes.Object.toObject(includeInstance, f),
    array: (f = msg.getArray()) && proto.Mysqlx.Datatypes.Array.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Datatypes.Any.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Datatypes.Any;
  return proto.Mysqlx.Datatypes.Any.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Datatypes.Any} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Datatypes.Any}
 */
proto.Mysqlx.Datatypes.Any.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Datatypes.Any.Type} */ (reader.readEnum());
      msg.setType(value);
      break;
    case 2:
      var value = new proto.Mysqlx.Datatypes.Scalar;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Scalar.deserializeBinaryFromReader);
      msg.setScalar(value);
      break;
    case 3:
      var value = new proto.Mysqlx.Datatypes.Object;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Object.deserializeBinaryFromReader);
      msg.setObj(value);
      break;
    case 4:
      var value = new proto.Mysqlx.Datatypes.Array;
      reader.readMessage(value,proto.Mysqlx.Datatypes.Array.deserializeBinaryFromReader);
      msg.setArray(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Datatypes.Any.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Datatypes.Any.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Datatypes.Any} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Datatypes.Any.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Datatypes.Any.Type} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = message.getScalar();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      proto.Mysqlx.Datatypes.Scalar.serializeBinaryToWriter
    );
  }
  f = message.getObj();
  if (f != null) {
    writer.writeMessage(
      3,
      f,
      proto.Mysqlx.Datatypes.Object.serializeBinaryToWriter
    );
  }
  f = message.getArray();
  if (f != null) {
    writer.writeMessage(
      4,
      f,
      proto.Mysqlx.Datatypes.Array.serializeBinaryToWriter
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Datatypes.Any.Type = {
  SCALAR: 1,
  OBJECT: 2,
  ARRAY: 3
};

/**
 * required Type type = 1;
 * @return {!proto.Mysqlx.Datatypes.Any.Type}
 */
proto.Mysqlx.Datatypes.Any.prototype.getType = function() {
  return /** @type {!proto.Mysqlx.Datatypes.Any.Type} */ (jspb.Message.getFieldWithDefault(this, 1, 1));
};


/**
 * @param {!proto.Mysqlx.Datatypes.Any.Type} value
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
 */
proto.Mysqlx.Datatypes.Any.prototype.setType = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
 */
proto.Mysqlx.Datatypes.Any.prototype.clearType = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Any.prototype.hasType = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Scalar scalar = 2;
 * @return {?proto.Mysqlx.Datatypes.Scalar}
 */
proto.Mysqlx.Datatypes.Any.prototype.getScalar = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Scalar} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Scalar, 2));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Scalar|undefined} value
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
*/
proto.Mysqlx.Datatypes.Any.prototype.setScalar = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
 */
proto.Mysqlx.Datatypes.Any.prototype.clearScalar = function() {
  return this.setScalar(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Any.prototype.hasScalar = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional Object obj = 3;
 * @return {?proto.Mysqlx.Datatypes.Object}
 */
proto.Mysqlx.Datatypes.Any.prototype.getObj = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Object} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Object, 3));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Object|undefined} value
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
*/
proto.Mysqlx.Datatypes.Any.prototype.setObj = function(value) {
  return jspb.Message.setWrapperField(this, 3, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
 */
proto.Mysqlx.Datatypes.Any.prototype.clearObj = function() {
  return this.setObj(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Any.prototype.hasObj = function() {
  return jspb.Message.getField(this, 3) != null;
};


/**
 * optional Array array = 4;
 * @return {?proto.Mysqlx.Datatypes.Array}
 */
proto.Mysqlx.Datatypes.Any.prototype.getArray = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Array} */ (
    jspb.Message.getWrapperField(this, proto.Mysqlx.Datatypes.Array, 4));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Array|undefined} value
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
*/
proto.Mysqlx.Datatypes.Any.prototype.setArray = function(value) {
  return jspb.Message.setWrapperField(this, 4, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Datatypes.Any} returns this
 */
proto.Mysqlx.Datatypes.Any.prototype.clearArray = function() {
  return this.setArray(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Datatypes.Any.prototype.hasArray = function() {
  return jspb.Message.getField(this, 4) != null;
};


goog.object.extend(exports, proto.Mysqlx.Datatypes);
