/*
 * Copyright (c) 2017, 2022, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2.0, as
 * published by the Free Software Foundation.
 *
 * This program is also distributed with certain software (including
 * but not limited to OpenSSL) that is licensed under separate terms,
 * as designated in a particular file or component or in included license
 * documentation.  The authors of MySQL hereby grant you an
 * additional permission to link the program and your derivative works
 * with the separately licensed software that they have included with
 * MySQL.
 *
 * Without limiting anything contained in the foregoing, this file,
 * which is part of MySQL Connector/Node.js, is also subject to the
 * Universal FOSS Exception, version 1.0, a copy of which can be found at
 * http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
 */

// source: mysqlx_notice.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = require('google-protobuf');
var goog = jspb;
var global = Function('return this')();

var mysqlx_pb = require('./mysqlx_pb.js');
goog.object.extend(proto, mysqlx_pb);
var mysqlx_datatypes_pb = require('./mysqlx_datatypes_pb.js');
goog.object.extend(proto, mysqlx_datatypes_pb);
goog.exportSymbol('proto.Mysqlx.Notice.Frame', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.Frame.Scope', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.Frame.Type', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.GroupReplicationStateChanged', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.GroupReplicationStateChanged.Type', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.ServerHello', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.SessionStateChanged', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.SessionStateChanged.Parameter', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.SessionVariableChanged', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.Warning', null, global);
goog.exportSymbol('proto.Mysqlx.Notice.Warning.Level', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.Frame = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Notice.Frame, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.Frame.displayName = 'proto.Mysqlx.Notice.Frame';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.Warning = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Notice.Warning, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.Warning.displayName = 'proto.Mysqlx.Notice.Warning';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.SessionVariableChanged = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Notice.SessionVariableChanged, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.SessionVariableChanged.displayName = 'proto.Mysqlx.Notice.SessionVariableChanged';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.SessionStateChanged = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Mysqlx.Notice.SessionStateChanged.repeatedFields_, null);
};
goog.inherits(proto.Mysqlx.Notice.SessionStateChanged, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.SessionStateChanged.displayName = 'proto.Mysqlx.Notice.SessionStateChanged';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Notice.GroupReplicationStateChanged, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.GroupReplicationStateChanged.displayName = 'proto.Mysqlx.Notice.GroupReplicationStateChanged';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Mysqlx.Notice.ServerHello = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Mysqlx.Notice.ServerHello, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Mysqlx.Notice.ServerHello.displayName = 'proto.Mysqlx.Notice.ServerHello';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.Frame.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.Frame.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.Frame} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.Frame.toObject = function(includeInstance, msg) {
  var f, obj = {
    type: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    scope: jspb.Message.getFieldWithDefault(msg, 2, 1),
    payload: msg.getPayload_asB64()
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.Frame}
 */
proto.Mysqlx.Notice.Frame.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.Frame;
  return proto.Mysqlx.Notice.Frame.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.Frame} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.Frame}
 */
proto.Mysqlx.Notice.Frame.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setType(value);
      break;
    case 2:
      var value = /** @type {!proto.Mysqlx.Notice.Frame.Scope} */ (reader.readEnum());
      msg.setScope(value);
      break;
    case 3:
      var value = /** @type {!Uint8Array} */ (reader.readBytes());
      msg.setPayload(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.Frame.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.Frame.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.Frame} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.Frame.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {number} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = /** @type {!proto.Mysqlx.Notice.Frame.Scope} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeEnum(
      2,
      f
    );
  }
  f = /** @type {!(string|Uint8Array)} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeBytes(
      3,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Notice.Frame.Scope = {
  GLOBAL: 1,
  LOCAL: 2
};

/**
 * @enum {number}
 */
proto.Mysqlx.Notice.Frame.Type = {
  WARNING: 1,
  SESSION_VARIABLE_CHANGED: 2,
  SESSION_STATE_CHANGED: 3,
  GROUP_REPLICATION_STATE_CHANGED: 4,
  SERVER_HELLO: 5
};

/**
 * required uint32 type = 1;
 * @return {number}
 */
proto.Mysqlx.Notice.Frame.prototype.getType = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.setType = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.clearType = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Frame.prototype.hasType = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Scope scope = 2;
 * @return {!proto.Mysqlx.Notice.Frame.Scope}
 */
proto.Mysqlx.Notice.Frame.prototype.getScope = function() {
  return /** @type {!proto.Mysqlx.Notice.Frame.Scope} */ (jspb.Message.getFieldWithDefault(this, 2, 1));
};


/**
 * @param {!proto.Mysqlx.Notice.Frame.Scope} value
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.setScope = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.clearScope = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Frame.prototype.hasScope = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * optional bytes payload = 3;
 * @return {string}
 */
proto.Mysqlx.Notice.Frame.prototype.getPayload = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * optional bytes payload = 3;
 * This is a type-conversion wrapper around `getPayload()`
 * @return {string}
 */
proto.Mysqlx.Notice.Frame.prototype.getPayload_asB64 = function() {
  return /** @type {string} */ (jspb.Message.bytesAsB64(
      this.getPayload()));
};


/**
 * optional bytes payload = 3;
 * Note that Uint8Array is not supported on all browsers.
 * @see http://caniuse.com/Uint8Array
 * This is a type-conversion wrapper around `getPayload()`
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.Frame.prototype.getPayload_asU8 = function() {
  return /** @type {!Uint8Array} */ (jspb.Message.bytesAsU8(
      this.getPayload()));
};


/**
 * @param {!(string|Uint8Array)} value
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.setPayload = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Frame} returns this
 */
proto.Mysqlx.Notice.Frame.prototype.clearPayload = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Frame.prototype.hasPayload = function() {
  return jspb.Message.getField(this, 3) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.Warning.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.Warning.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.Warning} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.Warning.toObject = function(includeInstance, msg) {
  var f, obj = {
    level: jspb.Message.getFieldWithDefault(msg, 1, 2),
    code: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f,
    msg: (f = jspb.Message.getField(msg, 3)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.Warning}
 */
proto.Mysqlx.Notice.Warning.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.Warning;
  return proto.Mysqlx.Notice.Warning.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.Warning} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.Warning}
 */
proto.Mysqlx.Notice.Warning.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Notice.Warning.Level} */ (reader.readEnum());
      msg.setLevel(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setCode(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setMsg(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.Warning.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.Warning.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.Warning} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.Warning.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Notice.Warning.Level} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = /** @type {number} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeUint32(
      2,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 3));
  if (f != null) {
    writer.writeString(
      3,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Notice.Warning.Level = {
  NOTE: 1,
  WARNING: 2,
  ERROR: 3
};

/**
 * optional Level level = 1;
 * @return {!proto.Mysqlx.Notice.Warning.Level}
 */
proto.Mysqlx.Notice.Warning.prototype.getLevel = function() {
  return /** @type {!proto.Mysqlx.Notice.Warning.Level} */ (jspb.Message.getFieldWithDefault(this, 1, 2));
};


/**
 * @param {!proto.Mysqlx.Notice.Warning.Level} value
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.setLevel = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.clearLevel = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Warning.prototype.hasLevel = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * required uint32 code = 2;
 * @return {number}
 */
proto.Mysqlx.Notice.Warning.prototype.getCode = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.setCode = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.clearCode = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Warning.prototype.hasCode = function() {
  return jspb.Message.getField(this, 2) != null;
};


/**
 * required string msg = 3;
 * @return {string}
 */
proto.Mysqlx.Notice.Warning.prototype.getMsg = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.setMsg = function(value) {
  return jspb.Message.setField(this, 3, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.Warning} returns this
 */
proto.Mysqlx.Notice.Warning.prototype.clearMsg = function() {
  return jspb.Message.setField(this, 3, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.Warning.prototype.hasMsg = function() {
  return jspb.Message.getField(this, 3) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.SessionVariableChanged.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.SessionVariableChanged} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.SessionVariableChanged.toObject = function(includeInstance, msg) {
  var f, obj = {
    param: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    value: (f = msg.getValue()) && mysqlx_datatypes_pb.Scalar.toObject(includeInstance, f)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged}
 */
proto.Mysqlx.Notice.SessionVariableChanged.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.SessionVariableChanged;
  return proto.Mysqlx.Notice.SessionVariableChanged.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.SessionVariableChanged} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged}
 */
proto.Mysqlx.Notice.SessionVariableChanged.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setParam(value);
      break;
    case 2:
      var value = new mysqlx_datatypes_pb.Scalar;
      reader.readMessage(value,mysqlx_datatypes_pb.Scalar.deserializeBinaryFromReader);
      msg.setValue(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.SessionVariableChanged.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.SessionVariableChanged} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.SessionVariableChanged.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {string} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getValue();
  if (f != null) {
    writer.writeMessage(
      2,
      f,
      mysqlx_datatypes_pb.Scalar.serializeBinaryToWriter
    );
  }
};


/**
 * required string param = 1;
 * @return {string}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.getParam = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged} returns this
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.setParam = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged} returns this
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.clearParam = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.hasParam = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional Mysqlx.Datatypes.Scalar value = 2;
 * @return {?proto.Mysqlx.Datatypes.Scalar}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.getValue = function() {
  return /** @type{?proto.Mysqlx.Datatypes.Scalar} */ (
    jspb.Message.getWrapperField(this, mysqlx_datatypes_pb.Scalar, 2));
};


/**
 * @param {?proto.Mysqlx.Datatypes.Scalar|undefined} value
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged} returns this
*/
proto.Mysqlx.Notice.SessionVariableChanged.prototype.setValue = function(value) {
  return jspb.Message.setWrapperField(this, 2, value);
};


/**
 * Clears the message field making it undefined.
 * @return {!proto.Mysqlx.Notice.SessionVariableChanged} returns this
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.clearValue = function() {
  return this.setValue(undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.SessionVariableChanged.prototype.hasValue = function() {
  return jspb.Message.getField(this, 2) != null;
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Mysqlx.Notice.SessionStateChanged.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.SessionStateChanged.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.SessionStateChanged} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.SessionStateChanged.toObject = function(includeInstance, msg) {
  var f, obj = {
    param: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    valueList: jspb.Message.toObjectList(msg.getValueList(),
    mysqlx_datatypes_pb.Scalar.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.SessionStateChanged}
 */
proto.Mysqlx.Notice.SessionStateChanged.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.SessionStateChanged;
  return proto.Mysqlx.Notice.SessionStateChanged.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.SessionStateChanged} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.SessionStateChanged}
 */
proto.Mysqlx.Notice.SessionStateChanged.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {!proto.Mysqlx.Notice.SessionStateChanged.Parameter} */ (reader.readEnum());
      msg.setParam(value);
      break;
    case 2:
      var value = new mysqlx_datatypes_pb.Scalar;
      reader.readMessage(value,mysqlx_datatypes_pb.Scalar.deserializeBinaryFromReader);
      msg.addValue(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.SessionStateChanged.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.SessionStateChanged} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.SessionStateChanged.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {!proto.Mysqlx.Notice.SessionStateChanged.Parameter} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeEnum(
      1,
      f
    );
  }
  f = message.getValueList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      2,
      f,
      mysqlx_datatypes_pb.Scalar.serializeBinaryToWriter
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Notice.SessionStateChanged.Parameter = {
  CURRENT_SCHEMA: 1,
  ACCOUNT_EXPIRED: 2,
  GENERATED_INSERT_ID: 3,
  ROWS_AFFECTED: 4,
  ROWS_FOUND: 5,
  ROWS_MATCHED: 6,
  TRX_COMMITTED: 7,
  TRX_ROLLEDBACK: 9,
  PRODUCED_MESSAGE: 10,
  CLIENT_ID_ASSIGNED: 11,
  GENERATED_DOCUMENT_IDS: 12
};

/**
 * required Parameter param = 1;
 * @return {!proto.Mysqlx.Notice.SessionStateChanged.Parameter}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.getParam = function() {
  return /** @type {!proto.Mysqlx.Notice.SessionStateChanged.Parameter} */ (jspb.Message.getFieldWithDefault(this, 1, 1));
};


/**
 * @param {!proto.Mysqlx.Notice.SessionStateChanged.Parameter} value
 * @return {!proto.Mysqlx.Notice.SessionStateChanged} returns this
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.setParam = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.SessionStateChanged} returns this
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.clearParam = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.hasParam = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * repeated Mysqlx.Datatypes.Scalar value = 2;
 * @return {!Array<!proto.Mysqlx.Datatypes.Scalar>}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.getValueList = function() {
  return /** @type{!Array<!proto.Mysqlx.Datatypes.Scalar>} */ (
    jspb.Message.getRepeatedWrapperField(this, mysqlx_datatypes_pb.Scalar, 2));
};


/**
 * @param {!Array<!proto.Mysqlx.Datatypes.Scalar>} value
 * @return {!proto.Mysqlx.Notice.SessionStateChanged} returns this
*/
proto.Mysqlx.Notice.SessionStateChanged.prototype.setValueList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 2, value);
};


/**
 * @param {!proto.Mysqlx.Datatypes.Scalar=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Mysqlx.Datatypes.Scalar}
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.addValue = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 2, opt_value, proto.Mysqlx.Datatypes.Scalar, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Mysqlx.Notice.SessionStateChanged} returns this
 */
proto.Mysqlx.Notice.SessionStateChanged.prototype.clearValueList = function() {
  return this.setValueList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.GroupReplicationStateChanged.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.GroupReplicationStateChanged} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.toObject = function(includeInstance, msg) {
  var f, obj = {
    type: (f = jspb.Message.getField(msg, 1)) == null ? undefined : f,
    viewId: (f = jspb.Message.getField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.GroupReplicationStateChanged;
  return proto.Mysqlx.Notice.GroupReplicationStateChanged.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.GroupReplicationStateChanged} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readUint32());
      msg.setType(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setViewId(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.GroupReplicationStateChanged.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.GroupReplicationStateChanged} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = /** @type {number} */ (jspb.Message.getField(message, 1));
  if (f != null) {
    writer.writeUint32(
      1,
      f
    );
  }
  f = /** @type {string} */ (jspb.Message.getField(message, 2));
  if (f != null) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * @enum {number}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.Type = {
  MEMBERSHIP_QUORUM_LOSS: 1,
  MEMBERSHIP_VIEW_CHANGE: 2,
  MEMBER_ROLE_CHANGE: 3,
  MEMBER_STATE_CHANGE: 4
};

/**
 * required uint32 type = 1;
 * @return {number}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.getType = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged} returns this
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.setType = function(value) {
  return jspb.Message.setField(this, 1, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged} returns this
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.clearType = function() {
  return jspb.Message.setField(this, 1, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.hasType = function() {
  return jspb.Message.getField(this, 1) != null;
};


/**
 * optional string view_id = 2;
 * @return {string}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.getViewId = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged} returns this
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.setViewId = function(value) {
  return jspb.Message.setField(this, 2, value);
};


/**
 * Clears the field making it undefined.
 * @return {!proto.Mysqlx.Notice.GroupReplicationStateChanged} returns this
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.clearViewId = function() {
  return jspb.Message.setField(this, 2, undefined);
};


/**
 * Returns whether this field is set.
 * @return {boolean}
 */
proto.Mysqlx.Notice.GroupReplicationStateChanged.prototype.hasViewId = function() {
  return jspb.Message.getField(this, 2) != null;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Mysqlx.Notice.ServerHello.prototype.toObject = function(opt_includeInstance) {
  return proto.Mysqlx.Notice.ServerHello.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Mysqlx.Notice.ServerHello} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.ServerHello.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Mysqlx.Notice.ServerHello}
 */
proto.Mysqlx.Notice.ServerHello.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Mysqlx.Notice.ServerHello;
  return proto.Mysqlx.Notice.ServerHello.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Mysqlx.Notice.ServerHello} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Mysqlx.Notice.ServerHello}
 */
proto.Mysqlx.Notice.ServerHello.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Mysqlx.Notice.ServerHello.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Mysqlx.Notice.ServerHello.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Mysqlx.Notice.ServerHello} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Mysqlx.Notice.ServerHello.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};


goog.object.extend(exports, proto.Mysqlx.Notice);
