--TEST--
mysqli_connect()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";

    $tmp    = NULL;   
    $link   = NULL;
    
    
    if (false !== ($tmp = @mysqli_connect($link)))
        printf("[001a] Expecting false, got %s/%s\n", gettype($tmp), $tmp);
        
    if (false !== ($tmp = @mysqli_connect($link, $link)))
        printf("[001b] Expecting false, got %s/%s\n", gettype($tmp), $tmp);
        
    if (false !== ($tmp = @mysqli_connect($link, $link, $link)))
        printf("[001c] Expecting false, got %s/%s\n", gettype($tmp), $tmp);
        
    if (false !== ($tmp = @mysqli_connect($link, $link, $link, $link)))
        printf("[001d] Expecting false, got %s/%s\n", gettype($tmp), $tmp);
        
    if (false !== ($tmp = @mysqli_connect($link, $link, $link, $link, $link)))
        printf("[001e] Expecting false, got %s/%s\n", gettype($tmp), $tmp);

    if (false !== ($tmp = @mysqli_connect($link, $link, $link, $link, $link, $link)))
        printf("[001f] Expecting false, got %s/%s\n", gettype($tmp), $tmp);
                
    if (NULL !== ($tmp = @mysqli_connect($link, $link, $link, $link, $link, $link, $link)))
        printf("[001g] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!$link = mysqli_connect($host, $user, $passwd, $db, $port, $socket))
        printf("[002] Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);           
       
    mysqli_close($link);

    if ($link = mysqli_connect($host, $user . 'unknown_really', $passwd . 'non_empty', $db, $port, $socket))
        printf("[003] Can connect to the server using host=%s, user=%s, passwd=***non_empty, dbname=%s, port=%s, socket=%s\n",
            $host, $user . 'unknown_really', $db, $port, $socket);
            
    if (false !== $link)
        printf("[004] Expecting boolean/false, got %s/%s\n", gettype($link), $link);

    // Run the following tests without an anoynmous MySQL user and use a password for the test user!   
    ini_set('mysqli.default_socket', $socket);           
    if (!is_object($link = mysqli_connect($host, $user, $passwd, $db, $port))) {
        printf("[005] Usage of mysqli.default_socket failed\n") ;
    } else {
        mysqli_close($link);        
    }        
    
    ini_set('mysqli.default_port', $port);
    if (!is_object($link = mysqli_connect($host, $user, $passwd, $db))) {
        printf("[006] Usage of mysqli.default_port failed\n") ;
    } else {
        mysqli_close($link);        
    }
    
    ini_set('mysqli.default_pw', $passwd);
    if (!is_object($link = mysqli_connect($host, $user))) {
        printf("[007] Usage of mysqli.default_pw failed\n") ;
    } else {
        mysqli_close($link);        
    }
    
    ini_set('mysqli.default_user', $user);
    if (!is_object($link = mysqli_connect($host))) {
        printf("[008] Usage of mysqli.default_user failed\n") ;
    } else {
        mysqli_close($link);        
    }
    
    ini_set('mysqli.default_host', $host);
    if (!is_object($link = mysqli_connect())) {
        printf("[008] Usage of mysqli.default_host failed\n") ;
    } else {
        mysqli_close($link);        
    }           

    print "done!";   
?>
--EXPECTF--
Warning: mysqli_connect(): (%d/%d): Access denied for user '%s'@'%s' (using password: YES) in %s on line %d
done!