--TEST--
mysqli_more_results()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_more_results()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_more_results($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    require('table.inc');
    
    print "[004]\n";
    var_dump(mysqli_more_results($link));
    
    if (!mysqli_multi_query($link, "SELECT 1 AS a; SELECT 1 AS a, 2 AS b; SELECT id FROM test ORDER BY id LIMIT 3"))
        printf("[005] [%d] %s\n", mysqli_errno($link), mysqli_error($link));            
    print "[006]\n";
    $i = 0;
    if (mysqli_more_results($link)) 
            printf("%d\n", $i++);
    do {
        $res = mysqli_store_result($link);        
        mysqli_free_result($res);
        if (mysqli_more_results($link)) 
            printf("%d\n", $i++);
    } while (mysqli_next_result($link));    
     
    if (!mysqli_multi_query($link, "SELECT 1 AS a; SELECT 1 AS a, 2 AS b; SELECT id FROM test ORDER BY id LIMIT 3"))
        printf("[007] [%d] %s\n", mysqli_errno($link), mysqli_error($link));
    print "[008]\n";
    $i = 0;
    if (mysqli_more_results($link)) 
            printf("%d\n", $i++);
    do {
        $res = mysqli_use_result($link);  
        // NOTE: if you use mysqli_use_result() with mysqli_more_results() or any other info function, 
        // you must fetch all rows before you can loop to the next result set!
        // See also the MySQL Reference Manual: mysql_use_result()
        while ($row = mysqli_fetch_array($res))
            ;      
        mysqli_free_result($res);   
        if (mysqli_more_results($link)) 
            printf("%d\n", $i++);        
                    
    } while (mysqli_next_result($link));
        
    mysqli_close($link);
    
    var_dump(mysqli_more_results($link));
    print "done!";
?>
--EXPECTF--
[004]
bool(false)
[006]
0
1
2
[008]
0
1
2

Warning: mysqli_more_results(): Couldn't fetch mysqli in %s on line %d
NULL
done! 