--TEST--
mysqli_options()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;    
    
    if (!is_null($tmp = @mysqli_options()))
        printf("[001] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_options($link)))
        printf("[002] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);

    $link = mysqli_init();
    
    if (!is_null($tmp = @mysqli_options($link, MYSQLI_OPT_CONNECT_TIMEOUT)))
        printf("[003] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_options($link, "s", 'extra_my.cnf')))
        printf("[004] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
        
    if (!is_null($tmp = @mysqli_options($link, MYSQLI_INIT_COMMAND, 'SET AUTOCOMMIT=0', 'foo')))
        printf("[005] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);        

    // print "run_tests.php don't fool me with your 'ungreedy' expression '.+?'!\n";        
    var_dump(mysqli_options($link, MYSQLI_READ_DEFAULT_GROUP, 'extra_my.cnf'));
    var_dump(mysqli_options($link, MYSQLI_READ_DEFAULT_FILE, 'extra_my.cnf'));
    var_dump(mysqli_options($link, MYSQLI_OPT_CONNECT_TIMEOUT, 10));
    var_dump(mysqli_options($link, MYSQLI_OPT_LOCAL_INFILE, 1));
    var_dump(mysqli_options($link, MYSQLI_INIT_COMMAND, 'SET AUTOCOMMIT=0'));    
    var_dump(mysqli_real_connect($link, $host, $user, $passwd, $db));
    var_dump(mysqli_options($link, MYSQLI_READ_DEFAULT_GROUP, 'extra_my.cnf'));
    var_dump(mysqli_options($link, MYSQLI_READ_DEFAULT_FILE, 'extra_my.cnf'));
    var_dump(mysqli_options($link, MYSQLI_OPT_CONNECT_TIMEOUT, 10));
    var_dump(mysqli_options($link, MYSQLI_OPT_LOCAL_INFILE, 1));
    var_dump(mysqli_options($link, MYSQLI_INIT_COMMAND, 'SET AUTOCOMMIT=0'));
    
    var_dump(mysqli_options($link, MYSQLI_CLIENT_SSL, 'not an mysqli_option'));

    do {
        $flag = mt_rand(0, 1000);   
    } while (in_array($flag, 
        array(  MYSQLI_READ_DEFAULT_GROUP, MYSQLI_READ_DEFAULT_FILE, 
                MYSQLI_OPT_CONNECT_TIMEOUT, MYSQLI_OPT_LOCAL_INFILE,
                MYSQLI_INIT_COMMAND, MYSQLI_READ_DEFAULT_GROUP,
                MYSQLI_READ_DEFAULT_FILE, MYSQLI_OPT_CONNECT_TIMEOUT,
                MYSQLI_OPT_LOCAL_INFILE, MYSQLI_INIT_COMMAND)));
                
    var_dump(mysqli_options($link, $flag, 'definetly not an mysqli_option'));    
            
    mysqli_close($link);
    
    var_dump(mysqli_options($link, MYSQLI_INIT_COMMAND, 'SET AUTOCOMMIT=1'));
    var_dump(mysqli_options($link, $flag, 'definetly not an mysqli_option'));
    
    print "done!";
?>
--EXPECTF--
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(true)
bool(false)
bool(false)

Warning: mysqli_options(): Couldn't fetch mysqli in %s on line %d
NULL

Warning: mysqli_options(): Couldn't fetch mysqli in %s on line %d
NULL
done!