--TEST--
mysqli_commit()
--SKIPIF--
<?php require_once('skipif.inc'); ?>
<?php require_once('skipifemb.inc'); ?>
<?PHP
	if (!$mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket)) {
        printf("skip: [s001] Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);
        exit(1);            
	}
            
	if (!$res = $mysqli->query("SHOW VARIABLES LIKE 'have_innodb'")) {
	   printf("skip: [s002] Cannot fetch have_innodb variable\n");
	   exit(1);	   
	}
	
	$row = $res->fetch_row();
	$res->free();
	$mysqli->close();
	
	if ($row[1] == "DISABLED" || $row[1] == "NO") {
		printf ("skip: [s003] Innodb support is not installed or enabled.");
		die("skip: see above!");
	}
?>
--FILE--
<?php
    include "connect.inc";
    
    $tmp    = NULL;   
    $link   = NULL;   
        
    if (!$mysqli = new mysqli($host, $user, $passwd, $db, $port, $socket))
        printf("[001] Cannot connect to the server using host=%s, user=%s, passwd=***, dbname=%s, port=%s, socket=%s\n",
            $host, $user, $db, $port, $socket);      
            
    if (!is_null($tmp = @$mysqli->commit($link))) 
      printf("[002] Expecting NULL/NULL, got %s/%s, [%d] %s\n",
        gettype($tmp), $tmp, $mysqli->errno, $mysqli->error);
        
    if (true !== ($tmp = $mysqli->autocommit(false)))
        printf("[003] Cannot turn off autocommit, expecting true, got %s/%s\n", gettype($tmp), $tmp);

    if (!$mysqli->query('DROP TABLE IF EXISTS test'))    
        printf("[004] [%d] %s\n", $mysqli->errno, $mysqli->error);
        
    // TODO - WARNING
    // Note: we ignore $engine here        
    if (!$mysqli->query('CREATE TABLE test(id INT) ENGINE = InnoDB'))
        printf("[005] Cannot create test table, [%d] %s\n", $mysqli->errno, $mysqli->error);

    if (!$mysqli->query('INSERT INTO test(id) VALUES (1)'))
        printf("[006] [%d] %s\n", $mysqli->errno, $mysqli->error);

    $tmp = $mysqli->commit();
    if ($tmp !== true) 
        printf("[007] Expecting boolean/true, got %s/%s\n", gettype($tmp), $tmp);
   
    if (!$mysqli->query('ROLLBACK'))
        printf("[008] [%d] %s\n", $mysqli->errno, $mysqli->error);
        
    if (!$res = $mysqli->query('SELECT COUNT(*) AS num FROM test'))
        printf("[009] [%d] %s\n", $mysqli->errno, $mysqli->error);
    $tmp = $res->fetch_assoc();    
    if (1 != $tmp['num'])
        printf("[010] Expecting 1 row in table test, found %d rows\n", $tmp['num']);
    $res->free();
    
    if (!$mysqli->query('DROP TABLE IF EXISTS test'))
        printf("[011] [%d] %s\n", $mysqli->errno, $mysqli->error);
       
    $mysqli->close();
    
    if (NULL !== ($tmp = @$mysqli->commit()))
        printf("[012] Expecting NULL, got %s/%s\n", gettype($tmp), $tmp);
    
    print "done!\n";
?>
--EXPECTF--
done! 