package KAMXbase;
require 5.001;

use strict;
use Carp;
	
# $KAMXbase::debug=1;
# this line above was used for printing all sorts of junk while debugging :-)

$KAMXbase::fhd="FHD00";
$KAMXbase::fhi="FHI00";
$KAMXbase::fhm="FHM00";

sub new { 
    my ($self)= {};
    bless $self;
    $self->{'DBFH'}= ++$KAMXbase::fhd;
    $self->{'IDXH'}= ++$KAMXbase::fhi;
    $self->{'FPTH'}= ++$KAMXbase::fhm;
    $self;
};

sub dbf_type {
  my ($self)=shift;
  my ($out);

  if ($self->{'hasdbf'}){
    if ($self->{'file_type'}==0x03) { 
      $out="FoxBase+/dBase III Plus/Foxpro/dBase IV, no memo";
    } elsif ($self->{'file_type'}==0x83) { 
      $out="FoxBase+/dBase III Plus, with memo";
    } elsif ($self->{'file_type'}==0xF5) { 
      $out="Foxpro, with memo";
    } elsif ($self->{'file_type'}==0x8B) { 
      $out="dBase IV, with memo";
    } else { 
      $out="Unrecognized format";
    }
  } else {
    carp "DBF file has not been opened\n";
  }

  return $out;
}
	
sub last_update {
    my ($self)=shift;
    my ($out);
    if ($self->{'hasdbf'}){
	$out=$self->{'file_lupdmm'}."/".$self->{'file_lupddd'}."/".$self->{'file_lupdyy'};
    } else {
	carp "DBF file has not been opened\n";
    }
    $out;
}

sub lastrec {
    my ($self)=shift;
    my ($out);
    if ($self->{'hasdbf'}){
	$out=$self->{'file_numrec'};
    } else {
	carp "DBF file has not been opened\n";
    }
    $out;
}


sub open_dbf {
    my ($self)=shift;
    no strict qw(refs);
    ($self->{'dbf'},$self->{'idx'})=@_;
    if (open($self->{'DBFH'},$self->{'dbf'})){
	binmode($self->{'DBFH'});
        seek($self->{'DBFH'},0,0);
        my ($fixed_header)="";
        read($self->{'DBFH'},$fixed_header,32);
        ($self->{'file_type'}, $self->{'file_lupdyy'},
         $self->{'file_lupdmm'}, $self->{'file_lupddd'},
         $self->{'file_numrec'}, $self->{'file_datap'},
         $self->{'file_datal'})=unpack("CCCCVvv",$fixed_header);
         $self->{'num_fields'}=($self->{'file_datap'}-33)/32;

        my ($i, $field_header, $locn)=(0,"",1);  
	#print $self->{'num_fields'};
        for ($i=1;$i<=$self->{'num_fields'};$i++) {
            my ($fn, $ft, $fd, $fl, $fld) = ("f_name$i", "f_type$i","f_disp$i", "f_len$i", "f_ldec$i");
            seek($self->{'DBFH'},($i-1)*32+32,0);
            read($self->{'DBFH'},$field_header,31);
            my($fname)=unpack("A*",substr($field_header,0,10));
	    my($null_pos)=index($fname,chr(0));

	    #added sanity check for no null char 8/9/98 Kevin McGrail  Otherwise Field name stripped one char
	    if ($null_pos == -1) {
		$self->{$fn}=$fname;
	    } else {
		$self->{$fn}=substr($fname,0,$null_pos);
	    }
            $self->{$fname}=$i;
            my($junk);
            ($self->{$ft}, $junk, $junk, $junk, $junk, 
             $self->{$fl}, $self->{$fld})= 
                 unpack("A C CCC CC",substr($field_header,11));

            #
            # Since almost every xBase system treats the 'field data
            # address' differently, why not simply calculate it.  This
            # also gets around the >256 record length problem.
            #
            # Dick Sutton (suttond@federal.unisys.com)
            #
            #
            $self->{$fd} = $locn;  # set new computed location
            $locn += $self->{$fl}; # calculate running offset
        }
        $self->{'hasdbf'}=1;
        $self->{'DRF'}=1;
        $self->{'RECNO'}=1;
    } else {
        $self->{'hasdbf'}=0;
    }
       
# INDEX FILE HANDLING 
    
    $self->{'hasidx'}=0;
    if (defined($self->{'idx'})) {
        if (open($self->{'IDXH'},$self->{'idx'})){
	    binmode($self->{'IDXH'});
            seek($self->{'IDXH'},0,0);
            my ($idx_header)="";
            read($self->{'IDXH'},$idx_header,512);
            ($self->{'idx_root'}, $self->{'idx_free'},
             $self->{'idx_eof'}, $self->{'idx_keyl'},
             $self->{'idx_opt'}, $self->{'idx_key'})=unpack("VVVvCA*",$idx_header);
            $self->{'hasidx'}=1;
        } else {
	    carp "Could not open IDX file ".$self->{'idx'}.". \n";
	}
    }

    # Handle memo files too. Foxpro only right now without someone helping me.
    $self->{'hasfpt'}=0;
    #print "File Type $self->{'file_type'}\n";
    if ($self->{'file_type'}==0xF5) {
	$self->{'hasfpt'}=1;
	my($fptname)=$self->{'dbf'};
	$fptname=~ s/$\.dbf/\.fpt/;
	$fptname=~ s/$\.DBF/\.FPT/;
	$self->{'fpt'}=$fptname;
        #print "FPT $fptname\n";
	if (-f "$fptname") {
            print " Opening FPT Memo File... ";
	    if (open($self->{'FPTH'},$self->{'fpt'})){
		binmode($self->{'FPTH'});
		seek($self->{'FPTH'},0,0);
		my ($fpth)="";
		my ($junk);
		read($self->{'FPTH'},$fpth,16);
		$self->{'fpt_nextf'}=unpack("l",pack("L",unpack("V",substr($fpth,1,4))));
		$self->{'fpt_blksize'}=unpack("l",pack("L",unpack("V",substr($fpth,7,4))));
		$self->{'hasfpt'}=1;
	    } else {
		carp "Could not open FPT (memo) file ".$self->{'fpt'}.". \n";
	    }
	} else {
          print "File doesn't exist $fptname\n";
        }
    } else {
      #print "Not Trying FTP (memo) file\n";
    }
  KAMXbase::go_top($self);
  $self->{'hasdbf'};
}

    
sub dbf_stat {
    my ($self) = shift;
    my ($i);

    if ($self->{'hasdbf'}){
	print "No. Field     Type  Disp  Len  Dec\n";
	#for ($i=1;$i<=$self->{'num_fields'};$i++) {
	# Changed code to for loop to complete display of entire database header.  8/9/98KAM
	$i=1;
	while ($i<=$self->sql_num_fields("goodfields")) { #$self->{'num_fields'}) {
	    my ($fn, $ft, $fd, $fl, $fld) = ("f_name$i", "f_type$i","f_disp$i", "f_len$i", "f_ldec$i");
	    printf("%3d %-12s %1s  %4d  %3d  %3d\n", $i, $self->{$fn}, $self->{$ft}, $self->{$fd}, $self->{$fl}, $self->{$fld});
	    $i++;
	}
    } else {
	carp "DBF file has not been opened\n";
    }
}

#MODIFIED 8/9/98 KAM to ADD CREATE QUERY RETURN
sub sql_create {
	my ($self) = shift;
	my ($i);
	my($createquery)="";
	my ($tableto)=@_;

	if ($self->{'hasdbf'}) {
		#Create Code Modified/Hacked/Stolen from "dbf2mysql v1.05 Patched and enchanted to mysql by Michael Widenius"
		$createquery = "CREATE TABLE ".$tableto." (\n";
		my($length) = length($createquery);

		#print $self->{'$createquery'};
		#print $self->{'$length'};

		$i=1;
		while ($i <= $self->{'num_fields'}) {
			my ($fn, $ft, $fd, $fl, $fld) = ("f_name$i", "f_type$i","f_disp$i", "f_len$i", "f_ldec$i");
			#print "XBASE: Processing ".$self->{$fn}."\n";

			#Only add fields with length of name > 0
			if ((length($self->{$fn}) > 0) && ($self->{$fn} !~ /oms.dbc/) ) {
				#print "XBASE: Processing ".$self->{$fn}."\n";

				# Add a comma if we've added a query
				if (length($createquery) != $length) {
					$createquery .= ",\n";
				}

				#if (fieldlow) strtolower(dbh->db_fields[i].db_name);
				#OLD OPTION FOR FIELDS IN LOWER CASE -- Add Later?
				if (&is_reserved_word($self->{$fn})) {
                                  $self->{$fn} = "_$self->{$fn}";
                                }
				$createquery .= $self->{$fn};

				my ($switch) = $self->{$ft};
				if ($switch eq 'C') {
                                        # ALL CHARS TREATED AS VARCHARS BECAUSE I DON'T CARE, KAM
                                        $createquery .= " varchar (".$self->{$fl}.")";
                                } elsif ($switch eq 'D') { # Added Date handling with help from Maarten Boekhold KAM
                                        $createquery .= " date";
				} elsif ($switch eq 'M') {
					# MEMO FIELD BECOMES TEXT IN MYSQL, KAM
					$createquery .= " text";
				} elsif ($switch eq 'N') {
					if ($self->{$fld} != 0) {
	                        		$createquery .= " real";
					} else {
						$createquery .= " int";
					}
				} elsif ($switch eq 'L') {
					$createquery .= " char (1)";
				
				#Added Integer Field 10/21/98 KAM
                                } elsif ($switch eq 'I') {
                                        $createquery .= " int (4)";
                                }
			
				#ADD CHECKING FOR PRIMARY KEYS and NOT NULL SETTINGS
      		         	#if (strcmp(dbh->db_fields[i].db_name, primary) == 0) {
                               	#strcat(query, " not null primary key");
       	                	#}
	               	 	#else if (!null_fields)
                 		#strcat(query," NOT NULL");
			}
			$i++;
		}
		$createquery .= "\n)\n\n";
	} else { 
		carp "DBF file has not been opened\n";
	}
	#print "XBASE:".$createquery."\n";
	return $createquery;
}


sub is_reserved_word {
  my ($column_name) = @_; 

  my (%reserved_words);

  $reserved_words{'action'} = 1;
  $reserved_words{'add'} = 1;
  $reserved_words{'aggregate'} = 1;
  $reserved_words{'all'} = 1;
  $reserved_words{'alter'} = 1;
  $reserved_words{'after'} = 1;
  $reserved_words{'and'} = 1;
  $reserved_words{'as'} = 1;
  $reserved_words{'asc'} = 1;
  $reserved_words{'avg'} = 1;
  $reserved_words{'avg_row_length'} = 1;
  $reserved_words{'auto_increment'} = 1;
  $reserved_words{'between'} = 1;
  $reserved_words{'bigint'} = 1;
  $reserved_words{'bit'} = 1;
  $reserved_words{'binary'} = 1;
  $reserved_words{'blob'} = 1;
  $reserved_words{'bool'} = 1;
  $reserved_words{'both'} = 1;
  $reserved_words{'by'} = 1;
  $reserved_words{'cascade'} = 1;
  $reserved_words{'case'} = 1;
  $reserved_words{'char'} = 1;
  $reserved_words{'character'} = 1;
  $reserved_words{'change'} = 1;
  $reserved_words{'check'} = 1;
  $reserved_words{'checksum'} = 1;
  $reserved_words{'column'} = 1;
  $reserved_words{'columns'} = 1;
  $reserved_words{'comment'} = 1;
  $reserved_words{'constraint'} = 1;
  $reserved_words{'create'} = 1;
  $reserved_words{'cross'} = 1;
  $reserved_words{'current_date'} = 1;
  $reserved_words{'current_time'} = 1;
  $reserved_words{'current_timestamp'} = 1;
  $reserved_words{'data'} = 1;
  $reserved_words{'database'} = 1;
  $reserved_words{'databases'} = 1;
  $reserved_words{'date'} = 1;
  $reserved_words{'datetime'} = 1;
  $reserved_words{'day'} = 1;
  $reserved_words{'day_hour'} = 1;
  $reserved_words{'day_minute'} = 1;
  $reserved_words{'day_second'} = 1;
  $reserved_words{'dayofmonth'} = 1;
  $reserved_words{'dayofweek'} = 1;
  $reserved_words{'dayofyear'} = 1;
  $reserved_words{'dec'} = 1;
  $reserved_words{'decimal'} = 1;
  $reserved_words{'default'} = 1;
  $reserved_words{'delayed'} = 1;
  $reserved_words{'delay_key_write'} = 1;
  $reserved_words{'delete'} = 1;
  $reserved_words{'desc'} = 1;
  $reserved_words{'describe'} = 1;
  $reserved_words{'distinct'} = 1;
  $reserved_words{'distinctrow'} = 1;
  $reserved_words{'double'} = 1;
  $reserved_words{'drop'} = 1;
  $reserved_words{'end'} = 1;
  $reserved_words{'else'} = 1;
  $reserved_words{'escape'} = 1;
  $reserved_words{'escaped'} = 1;
  $reserved_words{'enclosed'} = 1;
  $reserved_words{'enum'} = 1;
  $reserved_words{'explain'} = 1;
  $reserved_words{'exists'} = 1;
  $reserved_words{'fields'} = 1;
  $reserved_words{'file'} = 1;
  $reserved_words{'first'} = 1;
  $reserved_words{'float'} = 1;
  $reserved_words{'float4'} = 1;
  $reserved_words{'float8'} = 1;
  $reserved_words{'flush'} = 1;
  $reserved_words{'foreign'} = 1;
  $reserved_words{'from'} = 1;
  $reserved_words{'for'} = 1;
  $reserved_words{'full'} = 1;
  $reserved_words{'fulltext'} = 1;
  $reserved_words{'function'} = 1;
  $reserved_words{'global'} = 1;
  $reserved_words{'grant'} = 1;
  $reserved_words{'grants'} = 1;
  $reserved_words{'group'} = 1;
  $reserved_words{'having'} = 1;
  $reserved_words{'heap'} = 1;
  $reserved_words{'high_priority'} = 1;
  $reserved_words{'hour'} = 1;
  $reserved_words{'hour_minute'} = 1;
  $reserved_words{'hour_second'} = 1;
  $reserved_words{'hosts'} = 1;
  $reserved_words{'identified'} = 1;
  $reserved_words{'ignore'} = 1;
  $reserved_words{'in'} = 1;
  $reserved_words{'index'} = 1;
  $reserved_words{'infile'} = 1;
  $reserved_words{'inner'} = 1;
  $reserved_words{'insert'} = 1;
  $reserved_words{'insert_id'} = 1;
  $reserved_words{'int'} = 1;
  $reserved_words{'integer'} = 1;
  $reserved_words{'interval'} = 1;
  $reserved_words{'int1'} = 1;
  $reserved_words{'int2'} = 1;
  $reserved_words{'int3'} = 1;
  $reserved_words{'int4'} = 1;
  $reserved_words{'int8'} = 1;
  $reserved_words{'into'} = 1;
  $reserved_words{'if'} = 1;
  $reserved_words{'is'} = 1;
  $reserved_words{'isam'} = 1;
  $reserved_words{'join'} = 1;
  $reserved_words{'key'} = 1;
  $reserved_words{'keys'} = 1;
  $reserved_words{'kill'} = 1;
  $reserved_words{'last_insert_id'} = 1;
  $reserved_words{'leading'} = 1;
  $reserved_words{'left'} = 1;
  $reserved_words{'length'} = 1;
  $reserved_words{'like'} = 1;
  $reserved_words{'lines'} = 1;
  $reserved_words{'limit'} = 1;
  $reserved_words{'load'} = 1;
  $reserved_words{'local'} = 1;
  $reserved_words{'lock'} = 1;
  $reserved_words{'logs'} = 1;
  $reserved_words{'long'} = 1;
  $reserved_words{'longblob'} = 1;
  $reserved_words{'longtext'} = 1;
  $reserved_words{'low_priority'} = 1;
  $reserved_words{'max'} = 1;
  $reserved_words{'max_rows'} = 1;
  $reserved_words{'match'} = 1;
  $reserved_words{'mediumblob'} = 1;
  $reserved_words{'mediumtext'} = 1;
  $reserved_words{'mediumint'} = 1;
  $reserved_words{'middleint'} = 1;
  $reserved_words{'min_rows'} = 1;
  $reserved_words{'minute'} = 1;
  $reserved_words{'minute_second'} = 1;
  $reserved_words{'modify'} = 1;
  $reserved_words{'month'} = 1;
  $reserved_words{'monthname'} = 1;
  $reserved_words{'myisam'} = 1;
  $reserved_words{'natural'} = 1;
  $reserved_words{'numeric'} = 1;
  $reserved_words{'no'} = 1;
  $reserved_words{'not'} = 1;
  $reserved_words{'null'} = 1;
  $reserved_words{'on'} = 1;
  $reserved_words{'optimize'} = 1;
  $reserved_words{'option'} = 1;
  $reserved_words{'optionally'} = 1;
  $reserved_words{'or'} = 1;
  $reserved_words{'order'} = 1;
  $reserved_words{'outer'} = 1;
  $reserved_words{'outfile'} = 1;
  $reserved_words{'pack_keys'} = 1;
  $reserved_words{'partial'} = 1;
  $reserved_words{'password'} = 1;
  $reserved_words{'precision'} = 1;
  $reserved_words{'primary'} = 1;
  $reserved_words{'procedure'} = 1;
  $reserved_words{'process'} = 1;
  $reserved_words{'processlist'} = 1;
  $reserved_words{'privileges'} = 1;
  $reserved_words{'read'} = 1;
  $reserved_words{'real'} = 1;
  $reserved_words{'references'} = 1;
  $reserved_words{'reload'} = 1;
  $reserved_words{'regexp'} = 1;
  $reserved_words{'rename'} = 1;
  $reserved_words{'replace'} = 1;
  $reserved_words{'restrict'} = 1;
  $reserved_words{'returns'} = 1;
  $reserved_words{'revoke'} = 1;
  $reserved_words{'right'} = 1;
  $reserved_words{'rlike'} = 1;
  $reserved_words{'row'} = 1;
  $reserved_words{'rows'} = 1;
  $reserved_words{'second'} = 1;
  $reserved_words{'select'} = 1;
  $reserved_words{'set'} = 1;
  $reserved_words{'show'} = 1;
  $reserved_words{'shutdown'} = 1;
  $reserved_words{'smallint'} = 1;
  $reserved_words{'soname'} = 1;
  $reserved_words{'sql_big_tables'} = 1;
  $reserved_words{'sql_big_selects'} = 1;
  $reserved_words{'sql_low_priority_updates'} = 1;
  $reserved_words{'sql_log_off'} = 1;
  $reserved_words{'sql_log_update'} = 1;
  $reserved_words{'sql_select_limit'} = 1;
  $reserved_words{'sql_small_result'} = 1;
  $reserved_words{'sql_big_result'} = 1;
  $reserved_words{'sql_warnings'} = 1;
  $reserved_words{'straight_join'} = 1;
  $reserved_words{'starting'} = 1;
  $reserved_words{'status'} = 1;
  $reserved_words{'string'} = 1;
  $reserved_words{'table'} = 1;
  $reserved_words{'tables'} = 1;
  $reserved_words{'temporary'} = 1;
  $reserved_words{'terminated'} = 1;
  $reserved_words{'text'} = 1;
  $reserved_words{'then'} = 1;
  $reserved_words{'time'} = 1;
  $reserved_words{'timestamp'} = 1;
  $reserved_words{'tinyblob'} = 1;
  $reserved_words{'tinytext'} = 1;
  $reserved_words{'tinyint'} = 1;
  $reserved_words{'trailing'} = 1;
  $reserved_words{'to'} = 1;
  $reserved_words{'type'} = 1;
  $reserved_words{'use'} = 1;
  $reserved_words{'using'} = 1;
  $reserved_words{'unique'} = 1;
  $reserved_words{'unlock'} = 1;
  $reserved_words{'unsigned'} = 1;
  $reserved_words{'update'} = 1;
  $reserved_words{'usage'} = 1;
  $reserved_words{'values'} = 1;
  $reserved_words{'varchar'} = 1;
  $reserved_words{'variables'} = 1;
  $reserved_words{'varying'} = 1;
  $reserved_words{'varbinary'} = 1;
  $reserved_words{'with'} = 1;
  $reserved_words{'write'} = 1;
  $reserved_words{'when'} = 1;
  $reserved_words{'where'} = 1;
  $reserved_words{'year'} = 1;
  $reserved_words{'year_month'} = 1;
  $reserved_words{'zerofill'} = 1;

  if ($reserved_words{lc($column_name)} == 1) {
    return 1;
  } 

  return 0;
}

#MODIFIED 8/11/98 KAM to ADD NUM_FIELDS QUERY RETURN
#MODIFIED 5/7/99 KAM to return a truncated integer!
#MODIFIED 5/16/01 KAM to fix oms.dbc format and more null column fixes
sub sql_num_fields {
  my ($format) = @_;
  my ($self) = shift;
  my ($i, $goodfields);

  if ($format eq "") {
    return int $self->{'num_fields'};
  } else {
    for ($i=1; $i <= $self->{'num_fields'}; $i++) {
      if ((length($self->{"f_name$i"}) > 0) && ( uc($self->{"f_name$i"}) ne uc("\r\noms.dbc")) ) {
        $goodfields++;
      }
    }
    return $goodfields;
  }
}

sub idx_stat {
    my ($self) = shift;
    if ($self->{'hasidx'}){
	print "IDX Root Node: $self->{'idx_root'}\n";
	print "IDX Free Node: $self->{'idx_free'}\n";
	print "IDX EOF: $self->{'idx_eof'}\n";
	print "IDX Key Length: $self->{'idx_keyl'}\n";
	print "IDX options: $self->{'idx_opt'}\n";
	print "IDX key: $self->{'idx_key'}\n";
    }
    else
    {
	print "No IDX file present\n";
    }
}


sub go_top {
    my ($self) = shift;
    if ($self->{'hasidx'}) {
      KAMXbase::go_top_idx($self);
    } else {
	$self->{'DRF'}=1;
	$self->{'RECNO'}=1;
    }
    $self->{'BOF'}=1;
    $self->{'EOF'}=0;
}

sub go_bot {
    my ($self) = shift;
    if ($self->{'hasidx'}) {
      KAMXbase::go_bot_idx($self);
    } else {
	$self->{'DRF'}=1;
	$self->{'RECNO'}=$self->{'file_numrec'};
    }
    $self->{'BOF'}=0;
    $self->{'EOF'}=1;
}


sub go_next {
    my ($self) = shift;
    if ($self->{'hasidx'}) {
      KAMXbase::go_next_idx($self);
    } else {
	$self->{'DRF'}=1;
	if ($self->{'RECNO'} < $self->{'file_numrec'}){
	    $self->{'RECNO'}++;
	    $self->{'EOF'}=0;
	} else {
	    $self->{'EOF'}=1;
	}
    }
}


sub go_prev {
    my ($self) = shift;
    if ($self->{'hasidx'}) {
      KAMXbase::go_prev_idx($self);
    } else {
	$self->{'DRF'}=1;
	if ($self->{'RECNO'}>1) {
	    $self->{'RECNO'}--;
	    $self->{'BOF'}=0;
	} else {
	    $self->{'BOF'}=1;
	}
    }
}



sub go_next_idx {
    my ($self) = shift;
    my ($node, $done, $to_node);
    if ($self->{'node_i'} < ($self->{'node_keys'}-1)){
	    $self->{'node_i'}++;
	    $self->{'EOF'}=0;
	} else {
	    $to_node=$self->{'node_right'};
	    if ($to_node > -1) {
	      KAMXbase::read_idx_leaf ($self, $to_node);
		$self->{'node_i'}=0;
		$self->{'EOF'}=0;
	    } else {
		$self->{'EOF'}=1;
	    }
	}
    $self->{'DRF'}=1;
    $self->{'RECNO'}=@{$self->{'nk_ptr'}}[$self->{'node_i'}];
    $self->{'BOF'}=0;
}


sub go_prev_idx {
    my ($self) = shift;
    my ($node, $done, $to_node);
    if ($self->{'node_i'} > 0){
	    $self->{'node_i'}--;
	    $self->{'BOF'}=0;
	} else {
	    $to_node=$self->{'node_left'};
	    if ($to_node > -1) {
	      KAMXbase::read_idx_leaf ($self, $to_node);
		$self->{'node_i'}=$self->{'node_keys'}-1;
		$self->{'BOF'}=0;
	    } else {
		$self->{'BOF'}=1;
	    }
	}
    $self->{'DRF'}=1;
    $self->{'RECNO'}=@{$self->{'nk_ptr'}}[$self->{'node_i'}];
    $self->{'EOF'}=0;
}



sub go_top_idx {
    my ($self) = shift;
    my ($node);
    $node=$self->{'idx_root'};
    do 
    {
      KAMXbase::read_idx_leaf ($self, $node);
	$node=@{$self->{'nk_ptr'}}[0];
    } until ($self->{'node_attr'}>=2 and $self->{'node_left'}==-1);
    $self->{'RECNO'}=@{$self->{'nk_ptr'}}[0];
    $self->{'node_i'}=0;
    $self->{'DRF'}=1;
}


sub go_bot_idx {
    my ($self) = shift;
    my ($node);
    $node=$self->{'idx_root'};
    do 
    {
      KAMXbase::read_idx_leaf ($self, $node);
	$node=@{$self->{'nk_ptr'}}[$self->{'node_keys'}-1];
    } until ($self->{'node_attr'}>=2 and $self->{'node_right'}==-1);
    $self->{'RECNO'}=@{$self->{'nk_ptr'}}[$self->{'node_keys'}-1];
    $self->{'node_i'}=$self->{'node_keys'}-1;
    $self->{'DRF'}=1;
}


sub bof {
    my ($self) = shift;
    return $self->{'BOF'};
}

sub eof {
    my ($self) = shift;
    return $self->{'EOF'};
}


sub read_idx_leaf {
    my ($self, $loc) = @_;
    my ($inr)="";
    my ($i, $ptr, @nk_val, @nk_ptr);
    no strict qw(refs);
    seek($self->{'IDXH'},$loc,0);
    read($self->{'IDXH'},$inr,512);
    $self->{'node_attr'}=unpack("v",substr($inr,0,2)); # S
    $self->{'node_keys'}=unpack("v",substr($inr,2,2)); # S

    # Messy below to produce little endian signed long :-)

    $self->{'node_left'}=unpack("l",pack("L",unpack("V",substr($inr,4,4))));
    $self->{'node_right'}=unpack("l",pack("L",unpack("V",substr($inr,8,4))));

    if (defined($KAMXbase::debug))
    {
	print "Node ATTR $self->{'node_attr'}\n";
	print "Node Keys $self->{'node_keys'}\n";
	print "Node Left $self->{'node_left'}\n"; # used for previous
	print "Node Right $self->{'node_right'}\n"; # used for next
    }
    my ($n_keys,$i_kl) = ($self->{'node_keys'}, $self->{'idx_keyl'});
    for ($i=0;$i<$n_keys;$i++)
    { 
	$ptr=12+$i*($i_kl+4);
	$nk_val[$i]=unpack("A*",substr($inr,$ptr,$i_kl));
	$ptr+=$i_kl;
	$nk_ptr[$i]=unpack("N",substr($inr,$ptr,4));
#    print "## $i of $n_keys $nk_val[$i] at $nk_ptr[$i]\n";
    }

    $self->{'nk_val'}=\@nk_val;
    $self->{'nk_ptr'}=\@nk_ptr;
}



sub seek_dbf {
    my ($self, $seeking) = @_;
# FIND IN INDEX
    if (not ($self->{'hasidx'})){
	carp "Cannot seek without a INDEX file \n";
	return undef;
    }
    my ($start_node)=$self->{'idx_root'};
    my ($done)=0;
    my ($found, $fail, $i, $nk_val, $nk_ptr);
    my ($rec_sought, $ni, $new_node, $field_data);
    do
    {

      KAMXbase::read_idx_leaf($self, $start_node);
	$nk_val=$self->{'nk_val'};
	$nk_ptr=$self->{'nk_ptr'};
	$found=0;
	for ($i=0;$i<=$self->{'node_keys'};$i++)
	{
	    if ($seeking eq substr(@$nk_val[$i],0,length($seeking)) && !$found)
	    { 
		if ($self->{'node_attr'}>=2)
		{
		    $done=1;
		    $found=1;
		    $rec_sought=@$nk_ptr[$i];
		    $ni=$i;
		}
		else
		{
		    $found=1;
		    $new_node=@$nk_ptr[$i];
		}
	    }
	    if ($self->{'node_attr'}<=1 && $seeking le @$nk_val[$i] && !$found)
	    {
		$found=1;
		$new_node=@$nk_ptr[$i];
	    }
	}
	$start_node=$new_node;
	$fail=!$found;
	
    } until $done || $fail;
    if (!$fail)
    {
	$self->{'DRF'}=1;
	$self->{'RECNO'}=$rec_sought;
	$self->{'node_i'}=$ni;
    } else {
	$self->{'DRF'}=0;
    }
    (! $fail);
}

sub recno {
    my ($self) = @_;
    return $self->{'RECNO'};
}

sub get_field {
    my ($self, $field) = @_;
    if ($self->{'DRF'}) {
	my ($i,$data)=(0, "");
	$i=$self->{'RECNO'};
	no strict qw(refs);
	seek($self->{'DBFH'},$self->{'file_datap'}+($i-1)*$self->{'file_datal'},0);
	read($self->{'DBFH'},$data,$self->{'file_datal'});
	$self->{'RECDATA'}=$data;
	$self->{'DRF'}=0;
    }
    if ($field eq "_DELETED") {
	return substr($self->{'RECDATA'},0,1);
    }
    my ($f)=$self->{$field};
    my ($fn, $ft, $fd, $fl, $fld) =
	("f_name$f", "f_type$f","f_disp$f", "f_len$f", "f_ldec$f");
    if ($self->{$ft} eq "M")
    {
	my($memo)=substr($self->{'RECDATA'}, $self->{$fd}, $self->{$fl});
	return KAMXbase::read_memo($self, $memo);
    } else {
	return substr($self->{'RECDATA'}, $self->{$fd}, $self->{$fl});
    }
}

sub read_memo {
    my ($self,$memblk)=@_;
    no strict qw(refs);
    seek($self->{'FPTH'},$self->{'fpt_blksize'}*$memblk,0);
    my($mblkhead)="";
    read($self->{'FPTH'},$mblkhead,8);
    my($blksig,$memo_len)=unpack("NN",$mblkhead);
    my($memo_data)="";
    read($self->{'FPTH'},$memo_data,$memo_len);
    return $memo_data;
}



# The following function was contributed by Leonard Samuelson.
# Fixed Scalar Values 6-8-99 KAM

sub get_record {
    my ($self, $field) = @_;
    if ($self->{'DRF'}) {
        my ($i,$data)=(0, "");
        $i=$self->{'RECNO'};
        no strict qw(refs);
        seek($self->{'DBFH'},$self->{'file_datap'}+($i-1)*$self->{'file_datal'},0);
        read($self->{'DBFH'},$data,$self->{'file_datal'});
        $self->{'RECDATA'}=$data;
        $self->{'DRF'}=0;
    }
    my $i = 0 ;
    my @fret ;
    for($i=1; $i <= $self->sql_num_fields("goodfields"); $i++) {  # $self->{'num_fields'}
	if ($self->{"f_type$i"} eq "M") {
	    my($memo)=substr($self->{'RECDATA'}, $self->{"f_disp$i"}, $self->{"f_len$i"});
	    #@fret[$i-1]=KAMXbase::read_memo($self, $memo);
	    $fret[$i-1]=KAMXbase::read_memo($self, $memo);
	} else {
	    #@fret[$i-1] = substr($self->{'RECDATA'}, $self->{"f_disp$i"}, $self->{"f_len$i"}) ;
	    $fret[$i-1] = substr($self->{'RECDATA'}, $self->{"f_disp$i"}, $self->{"f_len$i"});
	}
        if( $self->{"f_type$i"} eq 'C' ) {
            #@fret[$i-1] =~ s/^(.*?)\s*$/$1/ ;
	    $fret[$i-1] =~ s/^(.*?)\s*$/$1/;
        }
    }
    return @fret ;
}


# The following function DOES NOT WORK and just represents a stupid snapshot
# of my code to atleast write into existing records :-)
# Left here since I was too lazy to remove it.

#sub set_field {
#    my ($self, $field, $value) = @_;
#    no strict qw(refs);
#    my ($change) = 0;
#    my ($i)=0;
#    my ($data) = $self->{'RECDATA'};
#    print "before $data\n";
#    if ($field eq "_DELETED") {	# TOGGLE DELETE FLAG
#	if (substr($data,1,1) eq "*") {
#	    substr($data,1,1)=" ";
#	} else {
#	    substr($data,1,1)="*";
#	}
#    }
#    my ($f)=$self->{$field};
#    my ($fn, $ft, $fd, $fl, $fld) = 
#	("f_name$f", "f_type$f","f_disp$f", "f_len$f", "f_ldec$f");
#    my ($t)=substr($value,0,$self->{$fl});
#    print "$t\n";
#    substr($data, $self->{$fd}, $self->{$fl})=$t;
#    print "after $data\n";
#    $i=$self->{'RECNO'};
#    seek($self->{'DBFH'},$self->{'file_datap'}+($i-1)*$self->{'file_datal'},0);
#    write($self->{'DBFH'},$data,$self->{'file_datal'});
#    $self->{'RECDATA'}=$data;
#}



sub close_dbf
{
    my ($self) = @_;
    no strict qw(refs);
    if ($self->{'hasdbf'}){
	close($self->{'DBFH'});
    }
    if ($self->{'hasidx'}){
	close($self->{'IDXH'});
    }
    if ($self->{'hasfpt'}){
	close($self->{'FPTH'});
    }
    undef $self;
}

1;

__END__

=head1 NAME

KAMXbase - PERL Module to Read DBF/IDX Files and import them to mySQL

=head1 SYNOPSIS

KAMXbase - PERL Module to Read DBF/IDX Files and import them to mySQL
additions/modifications by Kevin A. McGrail
original module by Pratap Pereira

=head1 ABSTRACT

This is a perl module to access xbase files with simple IDX indexes.
At the moment only read access to the files are provided by this package
Writing is tougher with IDX updates etc and is being worked on. Since the
read functionality is useful in itself this version is being released.

=head1 INSTALLATION

To install this package, change to the directory where this file is present
and type

	perl Makefile.PL
	make
	make install

This will copy Xbase.pm to the perl library directory provided you have the
permissions to do so. To use the module in your programs you will use the
line:

	use Xbase;

If you cannot install it in the system directory, put it whereever you like
and tell perl where to find it by using the following in the beginning of
your script:

	BEGIN {
		unshift(@INC,'/usr/underprivileged/me/lib');
	}
	use Xbase;

=head1 DESCRIPTION

The various methods that are supported by this module are given
below. There is a very distinct xbase like flavour to most of the
commands.

=head2 CREATING A NEW XBASE OBJECT:

    $database = new Xbase;

This will create an object $database that will be used to interact with the
various methods the module provides.

=head2 OPENING A DATABASE

    $database->open_dbf($dbf_name, $idx_name);

Associates the DBF file and optionally the IDX file with the object. It
opens the files and if a associated MEMO file is present automatically
opens it. Only Foxpro Memo files are currently supported and assumes the
same filename as the DBF with a FPT extension.

=head2 DATABASE TYPE

	print $database->dbf_type;

Returns a string telling you if the xbase file opened is DBF3, DBF4 or FOX

=head2 LAST UPDATE DATE

	print $database->last_update;

Returns a date string telling you when the database was last updated.

=head2 LAST RECORD NUMBER

	$end=$database->lastrec;

Returns the record number of the last record in the database file.

=head2 DATABASE STATUS INFORMATION

	$database->dbf_stat;

This prints out on to STDOUT a display of the status/structure of the
database. It is similar to the xbase command DISPLAY STATUS. Since it
prints field names and structure it is commonly used to see if the module
is reading the database as intended and finding out the field names.

=head2 INDEX FILE STATUS INFORMATION

	$database->idx_stat;

Prints on to STDOUT the status information of an open IDX file.

=head2 GO TOP

	$database->go_top;

Moves the record pointer to the top of the database. Physical top of
database if no index is present else first record according to index order.

=head2 GO BOTTOM

	$database->go_bottom;

Moves the record pointer to the bottom of the database. Physical bottom of
database if no index is present else last record according to index order.

=head2 GO NEXT

	$database->go_next;

Equivalent to the xbase command SKIP 1 which moves the record pointer to
the next record.

=head2 GO PREVIOUS

	$database->go_prev;

Equivalent to the xbase command SKIP -1 which moves the record pointer to
the previous record.

=head2 SEEK

	$stat=$database->seek($keyvalue);

This command positions the record pointer on the first matching record that
has the key value specified. The database should be opened with an
associated index. Seek without an available index will print an error
message and abort. The return value indicates whether the key value was
found or not.

=head2 RECORD NUMBER

	$current_rec=$database->recno;

Returns the record number that the record pointer is currently at.

=head2 BEGINNING OF FILE

	if ($database->bof) {
		print "At the very top of the file \n";
	}

Tells you whether you are at the beginning of the file. Like in xbase it is
not true when you are at record number one but rather it is set when you
try to $database->go_prev when you are at the top of the file.

=head2 END OF FILE
 
	if ($database->eof) {
		print "At the very end of the file \n";
	}

Tells you whether you are at the end of the file. Like in xbase it is
not true when you are at the last record but rather it is set when you
try to $database->go_next from the last record.

=head2 READ INDIVIDUAL FIELD VALUES

	print $database->get_field("NAME");

Returns as a string the contents of a field name specified from the current
record. Using the pseudo field name _DELETED will tell you if the current
record is marked for deletion.

=head2 READ FIELD VALUES INTO ARRAY

	@fields = $database->get_record;

Returns as an array all the fields from the current record. The fields are
in the same order as in the database.

=head2 CLOSE DATABASE

	$database->close_dbf;

This closes the database files, index files and memo files that are
associated with the $database object with $database->open_dbf

=head1 COPYRIGHT 

Copyright (c) 1995 Pratap Pereira. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

I request that if you use this module at a web site to make a
link to 
	
	http://eewww.eng.ohio-state.edu/~pereira/software/xbase/

This is just so that others might find it. This is however not
required of you.

=head1 AUTHOR INFORMATION

Please send your comments, suggestions, gripes, bug-reports to 

	Pratap Pereira
	pereira@ee.eng.ohio-state.edu

=head1 UPDATE HISTORY

=over 4

=item Original perl 4 script done in March 1994

=item Perl 5 module done in February 1995

=item RELEASE 2 was first public release now called xbase12.pm

=item RELEASE 3 was done 6/22/95 called xbase13.pm

	Fixed problem with GO_PREV & GO_NEXT after SEEK.
	Fixed problem with parsing headers of dbfs with 
        record length > 255.
	Added Memo file support.

=item RELEASE 4 was done 9/29/95

	Fixed problem with certain IDX failing completely, 
        was a stupid
	indexing mistake.

=item RELEASE 5 was done 11/14/95 (called xbase.pm 1.05)

	Fixed field length inconsistency errors by changing 
        way header is decoded. Should work with more xbase 
        variants. (Dick Sutton & Andrew Vasquez)

=item Version 1.06  was done 11/17/95

        Added binmode command to file handles to support 
        Windows NT 

=item Version 1.07 was done 01/23/96

	Made documentation in pod format, installation 
        automated. Fixed problem with deleted status being 
        improperly read (Chung Huynh). Renamed to Xbase 
        (previously xbase) to be consistent with other perl
        modules. Released in CPAN.
	Prettied up dbf_stat output (Gilbert Ramirez).    

=back

=head1 CREDITS

Thanks are due to Chung Huynh (chuynh@nero.finearts.uvic.ca), Jim
Esposito (jgespo@exis.net), Dick Sutton (suttond@federal.unisys.com),
Andrew Vasquez (praka@ophelia.fullcoll.edu), Leonard Samuelson
(lcs@synergy.smartpages.com) and Gilbert Ramirez Jr
(gram@merece.uthscsa.edu)

=cut
