/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: StrUtils.c,v $
    Module Description:	String utility functions

Description:

Edit History:

	$Log: StrUtils.c,v $
 * Revision 1.4  1995/12/21  18:05:50  V
 * latest revision
 *
 * Revision 1.3  1995/02/27  17:40:04  V
 * cleaned up unused warnings
 *
 * Revision 1.2  1995/02/03  18:26:52  V
 * added StringToArgvector()
 *
 * Revision 1.1  1995/01/09  18:21:23  V
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: StrUtils.c,v 1.4 1995/12/21 18:05:50 V Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 *  system header files
 */
#include <stdio.h>
#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>


#include "Vlib.h"



/*++ ****************  function  StripLTBlanks *********************/
/*
    Purpose:  Removes leading and trailing blanks from a text string in-situ

    Parameters:
    char    *str    == string to strip

    Return Values: void

*/
/*********************************************************************** ++*/

#ifdef  vansi_1
void 
StripLTBlanks (char *s)
#else
void 
StripLTBlanks (s)
     char *s;
#endif
{
  char *p;
  char *t;

  if (!s)
    return;

  /*-- determine the end of the string */
  t = EndOfString (s);
  p = s;

  /*-- skip over any leading spaces */
  while ((p <= t) && isspace (*p))
    p++;

  /*-- set any trailing spaces to null */
  while (isspace (*t) && (t >= p))
    *t-- = '\0';

  /*-- if there was no leading spaces return */
  if (p == s)
    return;

  /*-- else copy the rest of the string over the leading spaces */
  if (p <= t)
    strcpy (s, p);
  else
    *s = '\0';

  return;
}


/*++ ***************  function PosStringDiff **************

	Purpose:
	Determine the length of similarity between two strings
	
	Globals changed:
	none

	Parameters:
	char *str1, char *str2

	Return Values:
	int len  ordinal position of first differing character

	Dependencies:


********************************************************************** ++*/

#ifdef VANSI_1
int 
PosStringDiff (char *str1, char *str2)
#else
int 
PosStringDiff (str1, str2)
     char *str1, *str2;
#endif
{
  int i = 0;

  if (!str1 || !str2)
    return -1;

  while (str1[i] && str2[i])
    {
      if (str1[i] != str2[i])
	break;
      i++;
    }

  return i;
}



/*++ ***************  function TerminateAtNextChar ****************/
/*
	Purpose:  insert a null char at the next seperator character
	
	Globals changed: none

	Parameters:
	char     *str  == string to terminate
	char     *seps  == list of valid seperator chars

	Return Values:
	char    *p   == pointer to next string after null byte or NULL if
	                at end of string
	
	Dependencies:

*/
/************************************************************************ ++**/

#ifdef VANSI_1
char *
TerminateAtNextChar (char *str, char *seps)
#else
char *
TerminateAtNextChar (str, seps)
     char *str;
     char *seps;
#endif
{
  char *p;

  if (!str || !seps)
    return NULL;

  p = str;

  /*-- seek first char that occurs in the seperators */
  while (*p && (strchr (seps, *p) == NULL))
    p++;

  /*-- null terminate if not at end of string */
  if (*p)
    *p++ = '\0';

  /*-- return pointer to next word after seperator or null if at end */
  return p;
}


/*++ ****************  function  EndOfString *********************/
/*
    Purpose:  determine the last character poistion in a string

    Parameters:
    char     *str

    Return Values:  char    *end   == pointer to last char in string

*/
/*********************************************************************** ++*/

#ifdef VANSI_1
char *
EndOfString (char *str)
#else
char *
EndOfString (str)
     char *str;
#endif
{
  if (str == NULL)
    return NULL;
  /*-- use strlen(string) as an index into the string */
  return &str[strlen (str) - 1];
}


/*++ **********************  function StringToArgVector ***************

	Purpose: break a string into argument vectors

	Return Values:  0 on success

******************************************************************* ++*/
#ifdef VANSI_1
int
StringToArgVector (char *str, char *argv[])
#else
int
StringToArgVector (str, argv)
     char *str;
     char *argv[];
#endif
{
  int i;

  if (!str || !argv)
    return -1;

  argv[0] = strtok (str, " \n");
  i = 1;
  while ((argv[i] = strtok (NULL, " \n")) != NULL)
    i++;

  return 0;

}
