%{
 #include <stdio.h>
 #include <stdlib.h>
 #include <string>
 #include <ctype.h>
 #include "parse.h"
 #include "cgi++.h"
 

 static string cgi_input_val;
 static string cur_param_name;
 static string str;
 static string q_str;
 static vector <CgiForm> cgi_form_list;
 static CgiInput cgi_input;
 extern CgiMacroEnv macro_env;
 CgiForm cgi_form;

 int save_yylineno = 0;
 YY_BUFFER_STATE save_yyin;
 int default_html_state;

%}

%option yylineno

%x SQL
%x HTML
%x CONFIG
%x FORM_TAG
%x FORM_INPUT
%x FORM_NAME
%x FORM_METHOD
%x FORM
%x INPUT_NAME
%x INPUT_TYPE
%x INPUT_STORAGE
%x INPUT_VALUE
%x INPUT_PARAM
%x MACRO_PARAMS
%x MACRO_PARAMS_FIND_FIRST
%x MACRO_PARAMS_Q_STR
%x MACRO_PARAMS_Q_STR_ESC
%x INPUT_PARAM_Q_STR
%x INPUT_PARAM_Q_STR_ESC
%x INPUT_STORAGE_Q_STR
%x INPUT_STORAGE_Q_STR_ESC
%x INPUT_VALUE_Q_STR
%x INPUT_VALUE_Q_STR_ESC
%x OPTION_VALUE_Q_STR
%x OPTION_VALUE_Q_STR_ESC
%x FORM_OPTION
%x OPTION_VALUE
%x START_FORM_INPUT
%x HTML_INCLUDE_FIND_ARG
%x HTML_INCLUDE_CLEAN_UP
%x HTML_INCLUDE

%x MAIL

WHITE	[ \n\t]
LETTER	[a-zA-Z]
IDENT_CHAR [a-zA-Z0-9_$]
%%

<INITIAL>"HTML_START" {BEGIN HTML; 
 default_html_state = HTML;
 str =""; 
 cgi_form_list = vector<CgiForm>();
 return HTML_START; 
 }

<INITIAL>"HTML_INCLUDE" { 
 BEGIN HTML_INCLUDE_FIND_ARG;
 str =""; 
 cgi_form_list = vector<CgiForm>();
 }

<HTML_INCLUDE_FIND_ARG>[\(\)\" \n\t]+ 

<HTML_INCLUDE_FIND_ARG>[^\(\)\" \n\t]+  {
   save_yyin = YY_CURRENT_BUFFER;
   save_yylineno = yylineno;
   yyin = fopen(yytext, "r");
   if(!yyin) 
    {
      fprintf(stderr, "Could not open file %s in HTML_INCLUDE\n", yytext);
      yyterminate();
      exit(1);
    }
  
  
   yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
   default_html_state = HTML_INCLUDE;
   BEGIN HTML_INCLUDE;
   return HTML_START;
 }

<HTML_INCLUDE_CLEAN_UP>.+

<HTML_INCLUDE_CLEAN_UP>\n {
 BEGIN 0;
}


<INITIAL>"MAIL_START" {BEGIN MAIL; 
 str =""; 
 return MAIL_START; 
 }

<CONFIG>"CONFIG_END" {BEGIN 0; return CONFIG_END;}
<HTML,HTML_INCLUDE>"<form"|"<FORM" { 
   BEGIN FORM_TAG;
   cgi_form = CgiForm(); 
   str += yytext;  
   }
<FORM_TAG>"name="|"NAME=" {str += yytext; 
 BEGIN FORM_NAME;}

<FORM_TAG>"method="|"METHOD=" {
 str += yytext; 
 BEGIN FORM_METHOD;
 }

<FORM_NAME>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_form.name = yytext;
 BEGIN FORM_TAG; }
<FORM_NAME,FORM_METHOD,FORM_TAG,INPUT_NAME,INPUT_TYPE>\" {
 str += yytext; 
}

<FORM_METHOD>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_form.set_method(yytext);
 BEGIN FORM_TAG; }

<FORM_TAG>">" {str += yytext; BEGIN FORM;}

<FORM>"<textarea"|"<TEXTAREA"  {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.form_name = cgi_form.name;
  cgi_input.type = "textarea";
  str += yytext;
 }

<FORM>"<select"|"<SELECT"  {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.form_name = cgi_form.name;
  cgi_input.type = "select";
  str += yytext;
 }

<FORM>"<sql-fill-options"|"<SQL-FILL-OPTIONS"  {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.form_name = cgi_form.name;
  cgi_input.type = "sql-fill-options";
  str += yytext;
 }

<FORM>"<input"|"<INPUT" {
  BEGIN START_FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.type = "text";
  cgi_input.form_name = cgi_form.name;
  yylval.str = &str; 
  return STRING;  
 }

<START_FORM_INPUT>.  {
  str = "<input ";
  str += yytext;
  BEGIN FORM_INPUT;
 }

<FORM_INPUT>">" {
 str += yytext; 
 if(cgi_input.name.length())
  if(cgi_input.type == "textarea")
    str += "$" + cgi_input.form_name + "." +  cgi_input.name 
     + "$";
 
 if(cgi_input.name.length() || cgi_input.type == "pragma")
  cgi_form.add_input(cgi_input, cgi_input_val.c_str());
 BEGIN FORM;
  yylval.cgi_html_input = new CgiHtmlInput(str.c_str(), cgi_input);
  str = "";
  return HTML_INPUT;
 }

<FORM>"<option"|"<OPTION" {
  BEGIN FORM_OPTION;
  cgi_input_val = "";
  // here we are re-using the last value of cgi_input
  str += yytext;
 }


<FORM_OPTION>">" {
 if(cgi_input.name.length())
  str += " $((" + cgi_input.form_name + "." + cgi_input.name + 
  " == \"" + cgi_input_val + "\") ? \"selected\":\"\")$";

 str += yytext; 
 //cerr << "CgiInput name = " << cgi_input.name 
 // << " val = " << cgi_input_val << endl;
 if(cgi_input.name.length())
  cgi_form.add_input(cgi_input, cgi_input_val.c_str());
 BEGIN FORM;
 }

<FORM_INPUT>"name="|"NAME="  {
  BEGIN INPUT_NAME;
  str += yytext;
  cgi_input_val = "";
 }

<FORM_INPUT>"type="|"TYPE="  {
  BEGIN INPUT_TYPE;
  str += yytext;
 }

<FORM_INPUT>"storage="|"STORAGE="  {
  BEGIN INPUT_STORAGE;
 }

<FORM_INPUT>{IDENT_CHAR}+= {
 BEGIN INPUT_PARAM;
 str += yytext;
 yytext[strlen(yytext) - 1] = 0;
 {
  char* p = yytext;
  while(*p)
   {
    *p = tolower(*p);
    p++;
   }
  cur_param_name = yytext;
 }
}


<INPUT_PARAM>\" {
 q_str = "";
 BEGIN INPUT_PARAM_Q_STR;
}
<INPUT_PARAM_Q_STR>[^\\\"] {
 q_str += yytext;
}
<INPUT_PARAM_Q_STR>\\ {
 BEGIN INPUT_PARAM_Q_STR_ESC;
}
<INPUT_PARAM_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN INPUT_PARAM_Q_STR;
}

<INPUT_PARAM_Q_STR>\" {
 cgi_input.param_hash[cur_param_name] = q_str;
 str += "\"" + q_str + "\"";
 BEGIN FORM_INPUT;
}
<INPUT_PARAM>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input.param_hash[cur_param_name]  = yytext;
 BEGIN FORM_INPUT;
  }


<INPUT_STORAGE>\" {
 q_str = "";
 BEGIN INPUT_STORAGE_Q_STR;
}
<INPUT_STORAGE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<INPUT_STORAGE_Q_STR>\\ {
 BEGIN INPUT_STORAGE_Q_STR_ESC;
}
<INPUT_STORAGE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN INPUT_STORAGE_Q_STR;
}

<INPUT_STORAGE_Q_STR>\" {
 cgi_input.storage = q_str;
 BEGIN FORM_INPUT;
}

 

<FORM_INPUT>"value="|"VALUE="  {
  str += yytext;
  BEGIN INPUT_VALUE;
 }
<INPUT_VALUE>\" {
 q_str = "";
 BEGIN INPUT_VALUE_Q_STR;
}
<INPUT_VALUE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<INPUT_VALUE_Q_STR>\\ {
 BEGIN INPUT_VALUE_Q_STR_ESC;
}
<INPUT_VALUE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN INPUT_VALUE_Q_STR;
}

<INPUT_VALUE_Q_STR>\" {
 cgi_input_val = q_str;
 str += "\"" + q_str + "\"";
 BEGIN FORM_INPUT;
}
<INPUT_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_INPUT;
  }

<FORM_OPTION>"value="|"VALUE="  {
  str += yytext;
  BEGIN OPTION_VALUE;
 }

<OPTION_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_OPTION;
  }

<OPTION_VALUE>\" {
 q_str = "";
 BEGIN OPTION_VALUE_Q_STR;
}
<OPTION_VALUE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<OPTION_VALUE_Q_STR>\\ {
 BEGIN OPTION_VALUE_Q_STR_ESC;
}
<OPTION_VALUE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN OPTION_VALUE_Q_STR;
}

<OPTION_VALUE_Q_STR>\" {
 cgi_input_val = q_str;
 str += "\"" + q_str + "\"";
 BEGIN FORM_OPTION;
}

  

<INPUT_NAME>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input.name = yytext;
 BEGIN FORM_INPUT; }
<INPUT_TYPE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
  {
   int i;
   for(i = 0; yytext[i]; i++)
    yytext[i] = tolower(yytext[i]);
  }
 cgi_input.type = yytext;
 BEGIN FORM_INPUT;
  }

<OPTION_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_INPUT;
  }

<FORM>"</form"|"</FORM" { 
   BEGIN default_html_state;
   str += yytext;  
   if(cgi_form.name.length())
    cgi_form_list.insert(cgi_form_list.end(), cgi_form);
   }

<HTML,FORM_TAG,FORM_INPUT,FORM>"HTML_END" {
 BEGIN 0; 
 yylval.cgi_form_list = &cgi_form_list;
 return HTML_END;
 }

<FORM_TAG,FORM_INPUT,FORM><<EOF>> {
 if(default_html_state == HTML_INCLUDE)
   {
    yy_delete_buffer(YY_CURRENT_BUFFER);
    yy_switch_to_buffer(save_yyin);
    yylval.cgi_form_list = &cgi_form_list;
    BEGIN HTML_INCLUDE_CLEAN_UP;
    return HTML_END;
   }
  else
   {
    yyterminate();
    fprintf(stderr, "Unexpected end of file\n");
    exit(1);
   }

 }

<HTML_INCLUDE><<EOF>>  {
  yy_delete_buffer(YY_CURRENT_BUFFER);
  yy_switch_to_buffer(save_yyin);
  yylval.cgi_form_list = &cgi_form_list;
  BEGIN HTML_INCLUDE_CLEAN_UP;
  return HTML_END;
 }

<MAIL>"MAIL_END" {BEGIN 0; 
 return MAIL_END;}

<FORM_INPUT,FORM_OPTION>\n |
<HTML,FORM_TAG,FORM_INPUT,HTML_INCLUDE,FORM_OPTION,FORM,INITIAL,MAIL>. { 
 str += yytext; 
}

<HTML,HTML_INCLUDE,FORM_TAG,FORM,INITIAL,MAIL>\n { 
 yylval.str = &str; 
 return STRING;}

<INITIAL>HTTP_COOKIE_AUTH|MAIL_CLOSE|HTML_DO_HASH_PARSE |
<INITIAL>MAIN_START|MAIN_END|SQL_DISCONNECT|SQL_CURSOR_DONE {
  str = yytext; 
   
  if(str == "HTML_DO_HASH_PARSE")
   {
    macro_env.html_do_hash_parse = 1;
   }

  yylval.cgi_c_macro = new CgiCMacro(str); 
  yylval.cgi_c_macro->set_line_num (yylineno);
  str = "";
  return MACRO;
 }

<INITIAL>MAIL_INIT|MAIL_ON_ERROR|MAIL_APP |
<INITIAL>SQL_CLIENT_APP|SQL_SCHEMA_FILE|SQL_FORM_TO_TABLE |
<INITIAL>SQL_FORM_DB_WRITE|SQL_FORM_DB_READ|SQL_TABLE_EXPORT |
<INITIAL>SQL_CURSOR_DO|SQL_DECL_DBH|SQL_USE_DBH|HTTP_COOKIE_MAKER |
<INITIAL>HTTP_COOKIE_CLASS |

<INITIAL>SQL_DB_DRIVER|SQL_ON_ERROR|SQL_CONNECT|SQL_DO  {// cerr << "Found macro" << endl;
  str = yytext; 
  if(str == "MAIL_INIT")
   {
    macro_env.has_mailer = 1;
   }
  yylval.cgi_c_macro = new CgiCMacro(str); 
  yylval.cgi_c_macro->set_line_num (yylineno);
  str = "";
  BEGIN MACRO_PARAMS_FIND_FIRST;
}

<MACRO_PARAMS_FIND_FIRST>\( {
// cerr << "looking for (" << " matched '" <<
 // yytext << "'" << endl;
 BEGIN MACRO_PARAMS;
}
<MACRO_PARAMS>\" {
 q_str = "";
 BEGIN MACRO_PARAMS_Q_STR;
}
<MACRO_PARAMS_Q_STR>[^\\\"] {
 q_str += yytext;
}
<MACRO_PARAMS_Q_STR>\\ {
 BEGIN MACRO_PARAMS_Q_STR_ESC;
}
<MACRO_PARAMS_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN MACRO_PARAMS_Q_STR;
}

<MACRO_PARAMS_Q_STR>\" {
 yylval.cgi_c_macro->add_param(q_str.c_str());
 BEGIN MACRO_PARAMS;
}

<MACRO_PARAMS>{IDENT_CHAR}+ {
 yylval.cgi_c_macro->add_param(yytext);
}
<MACRO_PARAMS>\) {
  BEGIN INITIAL;
  return MACRO;
}

<MACRO_PARAMS>\n {}


  /* <INITIAL>[^\n]+ { str = yytext; yylval.str = &str; return STRING; } */
\n 	{}
<*>.	{}

%%

int yywrap(void) 
 {
    return 1;
 }


