#include <ctype.h>
#include "cgi++-lib.h"

ostream *active_os = NULL;

void write_cgi_encoded(ostream& os, string& s)
 {
  int i;
  int old_flags, old_fill, old_width;
  old_flags = os.flags();
  os << hex;
  old_fill = os.fill('0');
  old_width = os.width(2);

  for(i = 0; i < s.length(); i++)
   {
    unsigned char c = s[i];
    if(isalnum(c))
      os << c;
    else if(c == ' ')
     os << '+';
    else
     {
      os << '%' <<  (int)c;
     }
   }
 
   os.fill(old_fill);
   os.width(old_width);
   os.flags(old_flags);
 }

char* sql_quote(const string& s)
 {
  return sql_quote(s.c_str());
 }

char* sql_quote(const char* s)
 {
  int i;
  char c;

  for(i = 0; c = s[i]; ++i)
   {
    if(c == '\'')
     *active_os << '\'';
    *active_os << c;
   }

  return "";
 }

