%{
 #include <stdio.h>
 #include <stdlib.h>
 #include <iostream.h>
 #include <unistd.h>
 #include <stdarg.h>
 #include <errno.h>

 #include "parse.h"
 
 extern char* yytext;
 extern FILE *yyin ;
 extern int yylineno;
 extern CgiMacroEnv macro_env;
 extern char *q_str_buf;
 static const char* input_fname = NULL;
 static const char* output_fname = NULL;
 static vector <CgiForm> cgi_form_list;
 static int sect_start_line = 0;
 static int sect_end_line = 0;

 void yyerror(char*);
 int yyparse();
 int yylex();
 void build_cgi_app(CgiApp* cgi_app);
 static void usage();
%}

%token SQL_START
%token SQL_END
%token C_START
%token C_END
%token CONFIG_START
%token CONFIG_END
%token HTML_START
%token HTML_END
%token STRING
%token MACRO
%token MAIL_START
%token MAIL_END

%union
 {
  CgiApp* cgi_app;
  vector <CgiAppSection*> *cgi_app_sect_list;
  CgiMailSection* cgi_mail_section;
  CgiAppSection* cgi_app_section;
  CgiHtmlSection* cgi_html_section;
  vector <CgiHtmlElem*> *cgi_html_elem_list;
  CgiHtmlElem* cgi_html_elem;
  CgiHtmlStr* cgi_html_str;
  CgiCSection* cgi_c_sect;
  string* string_ptr;
  vector <string*> *string_ptr_list;
  string *str;
  vector<CgiForm> *cgi_form_list;
  vector<CgiCLine*> *cgi_c_line_list;
  vector<CgiMailLine*> *cgi_mail_line_list;
  CgiCLine* cgi_c_line;
  CgiCMacro* cgi_c_macro;
  CgiMailLine* cgi_mail_line;
 };

%type <cgi_app> cgi_app
%type <cgi_app_sect_list> cgi_app_sect_list
%type <cgi_app_section> cgi_app_sect
%type <cgi_html_section> cgi_html_sect
%type <cgi_html_elem_list> cgi_html_elem_list
%type <cgi_html_elem> cgi_html_elem
%type <cgi_html_str> cgi_html_str
%type <cgi_c_line> cgi_c_line
%type <cgi_c_sect> cgi_c_sect
%type <cgi_mail_section> cgi_mail_sect
%type <cgi_c_line_list> cgi_c_lines
%type <cgi_mail_line_list> cgi_mail_lines
%type <str> STRING
%type <cgi_c_macro> MACRO
%type <cgi_form_list> HTML_END
%type <cgi_mail_line> cgi_mail_line

%start program

%%

program : cgi_app
 {
  build_cgi_app($1);
  delete $1;
 }
 ;
cgi_app : cgi_app_sect_list
 {
  $$ = new CgiApp($1);
  $$->set_cgi_form_list(cgi_form_list);
 }
 ;

cgi_app_sect_list : cgi_app_sect_list cgi_app_sect
 {
  $1->insert($1->end(), $2);
  $$ = $1;
 }
 | cgi_app_sect
 {
  $$ = new vector<CgiAppSection*>;
  $$->insert($$->end(), $1);
 } 
 ;

cgi_app_sect : 
 cgi_html_sect
  {
   $$ = $1;
  }
  |
 cgi_c_sect
  {
   $$ = $1;
  }
  |
 cgi_mail_sect
  {
   $$ = $1;
  }
  ;

cgi_html_sect :  {sect_start_line = yylineno;} HTML_START  
  cgi_html_elem_list {sect_end_line = yylineno;} HTML_END
 {
  $$ = new CgiHtmlSection($3);
  $$->set_start_line_num(sect_start_line);
  $$->set_end_line_num(sect_end_line);

  unsigned int i;
  for(i = 0; i < $5->size(); i++)
   cgi_form_list.insert(cgi_form_list.end(), (*$5)[i]);
 }
 ;

cgi_mail_sect : {sect_start_line = yylineno;}  MAIL_START
  cgi_mail_lines {sect_end_line = yylineno;}  MAIL_END
 {
  $$ = new CgiMailSection($3);
 }
 ;

cgi_c_sect : cgi_c_lines
 {
  $$ = new CgiCSection($1);
 }
 ;

cgi_c_lines : cgi_c_lines cgi_c_line
  {
   $$ = $1;
   $$->insert($$->end(), $2);
  }
  |
 cgi_c_line
  {
   $$ = new vector<CgiCLine*>;
   $$->insert($$->end(), $1);
  }
  ;

cgi_mail_lines : cgi_mail_lines cgi_mail_line
  {
   $$ = $1;
   $$->insert($$->end(), $2);
  }
  |
 cgi_mail_line
  {
   $$ = new vector<CgiMailLine*>;
   $$->insert($$->end(), $1);
  }
  ;

cgi_mail_line : STRING
 {
  $$ = new CgiMailLine($1->c_str());
  *$1 = ""; 
 }
 ;

cgi_c_line : STRING
 {
  $$ = new CgiCCode(*$1);
  *$1 = ""; 
 }
 | MACRO
  {
   $$ = $1;
  }
 ;

cgi_html_elem_list : cgi_html_elem_list cgi_html_elem
 {
  $$ = $1;
  $$->insert($$->end(), $2);
 }
 |
  cgi_html_elem
 {
  $$ = new vector<CgiHtmlElem*>;
  $$->insert($$->end(), $1);
 } 
 ;

cgi_html_elem : cgi_html_str
 {
  $$ = $1;
 }
 ;

cgi_html_str: STRING
 {
  $$ = new CgiHtmlStr($1->c_str());
  *$1 = "" ;
 }
 ;

%%

void yyerror(char *s) 
{
    //fprintf(stderr, "yyerror:");
    fprintf(stderr, "line %d: %s:  %s\n", yylineno, s, yytext); 
}

void build_cgi_app(CgiApp* cgi_app)
 {
  ofstream os(output_fname);
  if(!os)
   die("Could not open %s: %s", output_fname, strerror(errno));

  cgi_app->write_c(os);
 } 


void usage()
 {
  die("Usage: dbapp_builder [-o output_file] [input_file]");
 } 

int main(int c, char** argv) 
{
  int done = 0;

  while(!done)
   {
    int opt = getopt(c, argv, "o");

    switch(opt)
     {
      case '?': usage();  break;
      case 'o': output_fname = argv[optind]; break;
      case EOF: done = 1; break;
     }
   }
 
  if(optind + 1 < c) 
    input_fname = argv[optind + 1];
 
  if(input_fname)
    {
     yyin = fopen(input_fname, "r");
     if(!yyin)
      die("Could not open input file %s", input_fname);
     macro_env.source_file = input_fname;
    }
  else
   yyin = stdin;

  if(!output_fname)
   output_fname = "cgi++.out";

  yyparse();
  return 0;
}

