#ifndef CGI_FORM_H
#define CGI_FORM_H

#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <string>
#include <vector>

#include "cgi_die.h"

class CgiInput
 {
  public:

  string name;
  string type;
  mutable string storage;
  mutable vector<string> values;

  int operator == (const CgiInput& other) const
   {
    return name == other.name;
   }
  void write_sql_create(ofstream& os) const;
  void infer_storage() const;
 };


class CgiForm
 {
  protected:
   vector <CgiInput> inputs;

  public:
   string name;
   string method;
   static int num_post_forms;
   static int num_get_forms;

   CgiForm();
   ~CgiForm();
   
   int input_found(const CgiInput& in) const;
   const CgiInput* find_input(const CgiInput& in) const;

   void add_input(const char* name, const char* type, const char* val = "")
    {
     CgiInput cgi_in;
     cgi_in.name = name;
     cgi_in.type = type;
     add_input(cgi_in, val);
    }
   
   void add_input(const CgiInput& cgi_in, const char* val = "" );

   void set_method(const char* init_method)
    {
     method = init_method;
     if(!strcasecmp("post", init_method))
      num_post_forms++;
     else
      num_get_forms++;
    }

   const CgiInput& operator[] (int i) { return inputs[i]; } 
   unsigned int size()	{ return inputs.size(); }
   void write_c(ofstream& os);
   void write_c_parse(ofstream& os);
   void write_c_parse_get(ofstream& os);
   void write_c_parse_post(ofstream& os);
   void write_c_parse_assign(ofstream& os, unsigned int i);
 
   void write_sql_create_table(ofstream& os) const;
   void write_sql_drop_table(ofstream& os) const;
 };

#endif
