// $Id: gweMysqlDatabaseMetaData.java,v 1.5 1997/09/16 14:05:54 xzhu Exp $
// Java Interface to Mysql
// $Id: gweMysqlDatabaseMetaData.java,v 1.5 1997/09/16 14:05:54 xzhu Exp $

// Modified from postgres95 jdbc driver version 0.6
// By	Xiaokun Kelvin ZHU
//      1997/09/01

// Copyright (c) 1996 Bradley McLean / Jeffrey Medeiros
// Modifications Copyright (c) 1996/1997 Martin Rode
// Copyright (c) 1997 Peter T Mount
//
// You may distribute under the terms of the GNU Public License as
// specified in the README file that comes with the JavaPostgres95 Kit
// Copyright (c) 1996 Bradley McLean / Jeffrey Medeiros
//

package gwe.sql;

import java.sql.*;
import java.net.*;
import java.io.*;
import java.util.Vector;

/**
 * JDBC Interface to Mysql functions
 */

// This class provides information about the database as a whole.
//
// Many of the methods here return lists of information in ResultSets.
// You can use the normal ResultSet methods such as getString and getInt
// to retrieve the data from these ResultSets.  If a given form of
// metadata is not available, these methods show throw a SQLException.
//
// Some of these methods take arguments that are String patterns.  These
// methods all have names such as fooPattern.  Within a pattern String "%"
// means match any substring of 0 or more characters and "_" means match
// any one character.
//

public class gweMysqlDatabaseMetaData implements DatabaseMetaData
{
   gweMysqlConnection conn;

   public gweMysqlDatabaseMetaData(gweMysqlConnection conn) {
      this.conn = conn;
   }
    //----------------------------------------------------------------------
	// First, a variety of minor information about the target database.

    /**
     * Can all the procedures returned by getProcedures be called by the
     * current user?
     *
     * @return true if so
     */
	public boolean allProceduresAreCallable() throws SQLException {
	   return false;  // not likely we will ever check
	}

    /**
     * Can all the tables returned by getTable be SELECTed by the
     * current user?
     *
     * @return true if so
     */
	public boolean allTablesAreSelectable() throws SQLException {
	   return false;  // not likely we will ever check
	}

    /**
     * What's the url for this database?
     *
     * @return the url or null if it can't be generated
     */
	public String getURL() throws SQLException {
	   return "jdbc:mysql://"+conn.getHost() + ":" + conn.getPort() + "/" + conn.getDbName();
	}

    /**
     * What's our user name as known to the database?
     *
     * @return our database user name
     */
	public String getUserName() throws SQLException {
	   return conn.getUser();
	}

    /**
     * Is the database in read-only mode?
     *
     * @return true if so
     */
	public boolean isReadOnly() throws SQLException {
	   return false; // will this ever be true?
	}

    /**
     * Are NULL values sorted high?
     *
     * @return true if so
     */
	public boolean nullsAreSortedHigh() throws SQLException {
	   return false;
	}

    /**
     * Are NULL values sorted low?
     *
     * @return true if so
     */
	public boolean nullsAreSortedLow() throws SQLException {
	   return true; // a guess!?
	}

    /**
     * Are NULL values sorted at the start regardless of sort order?
     *
     * @return true if so
     */
	public boolean nullsAreSortedAtStart() throws SQLException {
	   return false; // maybe true?
    }
    /**
     * Are NULL values sorted at the end regardless of sort order?
     *
     * @return true if so
     */
	public boolean nullsAreSortedAtEnd() throws SQLException {
	   return false;
	}

    /**
     * What's the name of this database product?
     *
     * @return database product name
     */
	public String getDatabaseProductName() throws SQLException {
	   return "Mysql";
	}

    /**
     * What's the version of this database product?
     *
     * @return database version
     */
  public String getDatabaseProductVersion() throws SQLException 
  {
    return conn.getDbVersion(); // how to get this?
  }

    /**
     * What's the name of this JDBC driver?
     *
     * @return JDBC driver name
     */
	public String getDriverName() throws SQLException {
	   return "gweMysqlDriver";
	}

    /**
     * What's the version of this JDBC driver?
     *
     * @return JDBC driver version
     */
	public String getDriverVersion() throws SQLException {
	   return conn.getMajorVersion()+"."+conn.getMinorVersion();
	}

    /**
     * What's this JDBC driver's major version number?
     *
     * @return JDBC driver major version
     */
	public int getDriverMajorVersion() {
	   return conn.getMajorVersion();
	}
    /**
     * What's this JDBC driver's minor version number?
     *
     * @return JDBC driver minor version number
     */
	public int getDriverMinorVersion() {
	   return conn.getMinorVersion();
	}
    /**
     * Does the database store tables in a local file?
     *
     * @return true if so
     */
	public boolean usesLocalFiles() throws SQLException {
	   return false;
	}

    /**
     * Does the database use a file for each table?
     *
     * @return true if the database uses a local file for each table
     */
	public boolean usesLocalFilePerTable() throws SQLException {
	   return false;
	}

    /**
     * Does the database support mixed case unquoted SQL identifiers?
     *
     * @return true if so
     */
	public boolean supportsMixedCaseIdentifiers() throws SQLException {
	   return true; // I think
	}

    /**
     * Does the database store mixed case unquoted SQL identifiers in
     * upper case?
     *
     * @return true if so
     */
	public boolean storesUpperCaseIdentifiers() throws SQLException {
	   return false;
	}

    /**
     * Does the database store mixed case unquoted SQL identifiers in
     * lower case?
     *
     * @return true if so
     */
	public boolean storesLowerCaseIdentifiers() throws SQLException {
	   return false;
	}

    /**
     * Does the database store mixed case unquoted SQL identifiers in
     * mixed case?
     *
     * @return true if so
     */
	public boolean storesMixedCaseIdentifiers() throws SQLException {
	   return true; // I think
	}

    /**
     * Does the database support mixed case quoted SQL identifiers?
     *
     * A JDBC compliant driver will always return true.
     *
     * @return true if so
     */
	public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
	   return true;
	}

    /**
     * Does the database store mixed case quoted SQL identifiers in
     * upper case?
     *
     * A JDBC compliant driver will always return true.
     *
     * @return true if so
     */
	public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
	   return true; // don't know
	}

    /**
     * Does the database store mixed case quoted SQL identifiers in
     * lower case?
     *
     * A JDBC compliant driver will always return false.
     *
     * @return true if so
     */
	public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
	   return false;
	}

    /**
     * Does the database store mixed case quoted SQL identifiers in
     * mixed case?
     *
     * A JDBC compliant driver will always return false.
     *
     * @return true if so
     */
	public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
	   return false; // don't really know.
	}

    /**
     * What's the string used to quote SQL identifiers?
     * This returns a space " " if identifier quoting isn't supported.
     *
     * A JDBC compliant driver always uses a double quote character.
     *
     * @return the quoting string
     */
	public String getIdentifierQuoteString() throws SQLException {
	   return "\"";
	}

    /**
     * Get a comma separated list of all a database's SQL keywords
     * that are NOT also SQL92 keywords.
     *
     * @return the list
     */
	public String getSQLKeywords() throws SQLException {
	   return "";
	}

    /**
     * Get a comma separated list of math functions.
     *
     * @return the list
     */
	public String getNumericFunctions() throws SQLException {
	    return "";
	}

    /**
     * Get a comma separated list of string functions.
     *
     * @return the list
     */
	public String getStringFunctions() throws SQLException {
	    return "";
	}

    /**
     * Get a comma separated list of system functions.
     *
     * @return the list
     */
	public String getSystemFunctions() throws SQLException {
	    return "";
	}

    /**
     * Get a comma separated list of time and date functions.
     *
     * @return the list
     */
	public String getTimeDateFunctions() throws SQLException {
	    return "";
	}

    /**
     * This is the string that can be used to escape '_' or '%' in
     * the string pattern style catalog search parameters.
     *
     * <P>The '_' character represents any single character.
     * <P>The '%' character represents any sequence of zero or
     * more characters.
     * @return the string used to escape wildcard characters
     */
	public String getSearchStringEscape() throws SQLException {
	    return "\\";
	}

    /**
     * Get all the "extra" characters that can be used in unquoted
     * identifier names (those beyond a-z, 0-9 and _).
     *
     * @return the string containing the extra characters
     */
	public String getExtraNameCharacters() throws SQLException {
	    return "";
	}

    //--------------------------------------------------------------------
    // Functions describing which features are supported.

    /**
     * Is "ALTER TABLE" with add column supported?
     *
     * @return true if so
     */
	public boolean supportsAlterTableWithAddColumn() throws SQLException {
	    return true;
	}


    /**
     * Is "ALTER TABLE" with drop column supported?
     *
     * @return true if so
     */
	public boolean supportsAlterTableWithDropColumn() throws SQLException {
	    return false;
	}

    /**
     * Is column aliasing supported?
     *
     * <P>If so, the SQL AS clause can be used to provide names for
     * computed columns or to provide alias names for columns as
     * required.
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsColumnAliasing() throws SQLException {
	    return true;
	}

    /**
     * Are concatenations between NULL and non-NULL values NULL?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean nullPlusNonNullIsNull() throws SQLException {
	    return true;  // not sure
	}

    /**
     * Is the CONVERT function between SQL types supported?
     *
     * @return true if so
     */
	public boolean supportsConvert() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is CONVERT between the given SQL types supported?
     *
     * @param fromType the type to convert from
     * @param toType the type to convert to
     * @return true if so
     * @see Types
     */
	public boolean supportsConvert(int fromType, int toType) throws SQLException {
	    return false; // not sure
	}

    /**
     * Are table correlation names supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsTableCorrelationNames() throws SQLException {
	    return true; // not sure
	}

    /**
     * If table correlation names are supported, are they restricted
     * to be different from the names of the tables?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsDifferentTableCorrelationNames() throws SQLException {
	    return true; // not sure
	}

    /**
     * Are expressions in "ORDER BY" lists supported?
     *
     * @return true if so
     */
	public boolean supportsExpressionsInOrderBy() throws SQLException {
	    return true;
	}

    /**
     * Can an "ORDER BY" clause use columns not in the SELECT?
     *
     * @return true if so
     */
	public boolean supportsOrderByUnrelated() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is some form of "GROUP BY" clause supported?
     *
     * @return true if so
     */
	public boolean supportsGroupBy() throws SQLException {
	    return true;
	}

    /**
     * Can a "GROUP BY" clause use columns not in the SELECT?
     *
     * @return true if so
     */
	public boolean supportsGroupByUnrelated() throws SQLException {
	    return false; // not sure
	}

    /**
     * Can a "GROUP BY" clause add columns not in the SELECT
     * provided it specifies all the columns in the SELECT?
     *
     * @return true if so
     */
	public boolean supportsGroupByBeyondSelect() throws SQLException {
	    return true; // not sure
	}

    /**
     * Is the escape character in "LIKE" clauses supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsLikeEscapeClause() throws SQLException {
	    return true;
	}

    /**
     * Are multiple ResultSets from a single execute supported?
     *
     * @return true if so
     */
	public boolean supportsMultipleResultSets() throws SQLException {
	    return true; // not sure
	}

    /**
     * Can we have multiple transactions open at once (on different
     * connections)?
     *
     * @return true if so
     */
	public boolean supportsMultipleTransactions() throws SQLException {
	    return true;
	}

    /**
     * Can columns be defined as non-nullable?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsNonNullableColumns() throws SQLException {
	    return true;
	}

    /**
     * Is the ODBC Minimum SQL grammar supported?
     *
     * All JDBC compliant drivers must return true.
     *
     * @return true if so
     */
	public boolean supportsMinimumSQLGrammar() throws SQLException {
	    return true;
	}

    /**
     * Is the ODBC Core SQL grammar supported?
     *
     * @return true if so
     */
	public boolean supportsCoreSQLGrammar() throws SQLException {
	    return true;
	}

    /**
     * Is the ODBC Extended SQL grammar supported?
     *
     * @return true if so
     */
	public boolean supportsExtendedSQLGrammar() throws SQLException {
	    return false; // not sure at all
	}

    /**
     * Is the ANSI92 entry level SQL grammar supported?
     *
     * All JDBC compliant drivers must return true.
     *
     * @return true if so
     */
	public boolean supportsANSI92EntryLevelSQL() throws SQLException {
	    return true;
	}

    /**
     * Is the ANSI92 intermediate SQL grammar supported?
     *
     * @return true if so
     */
	public boolean supportsANSI92IntermediateSQL() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is the ANSI92 full SQL grammar supported?
     *
     * @return true if so
     */
	public boolean supportsANSI92FullSQL() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is the SQL Integrity Enhancement Facility supported?
     *
     * @return true if so
     */
	public boolean supportsIntegrityEnhancementFacility() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is some form of outer join supported?
     *
     * @return true if so
     */
	public boolean supportsOuterJoins() throws SQLException {
	    return false; // not sure
	}

    /**
     * Are full nested outer joins supported?
     *
     * @return true if so
     */
	public boolean supportsFullOuterJoins() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is there limited support for outer joins?  (This will be true
     * if supportFullOuterJoins is true.)
     *
     * @return true if so
     */
	public boolean supportsLimitedOuterJoins() throws SQLException {
	    return false; // not sure
	}

    /**
     * What's the database vendor's preferred term for "schema"?
     *
     * @return the vendor term
     */
	public String getSchemaTerm() throws SQLException {
	    return "schema";
	}

    /**
     * What's the database vendor's preferred term for "procedure"?
     *
     * @return the vendor term
     */
	public String getProcedureTerm() throws SQLException {
	    return "procedure";
	}

    /**
     * What's the database vendor's preferred term for "catalog"?
     *
     * @return the vendor term
     */
	public String getCatalogTerm() throws SQLException {
	    return "catalog";
	}

    /**
     * Does a catalog appear at the start of a qualified table name?
     * (Otherwise it appears at the end)
     *
     * @return true if it appears at the start
     */
	public boolean isCatalogAtStart() throws SQLException {
	    return true; // doesn't appear,  don't think.
	}

    /**
     * What's the separator between catalog and table name?
     *
     * @return the separator string
     */
	public String getCatalogSeparator() throws SQLException {
	    return ".";
	}

    /**
     * Can a schema name be used in a data manipulation statement?
     *
     * @return true if so
     */
	public boolean supportsSchemasInDataManipulation() throws SQLException {
	    return false;
	}

    /**
     * Can a schema name be used in a procedure call statement?
     *
     * @return true if so
     */
	public boolean supportsSchemasInProcedureCalls() throws SQLException {
	    return false;
	}

    /**
     * Can a schema name be used in a table definition statement?
     *
     * @return true if so
     */
	public boolean supportsSchemasInTableDefinitions() throws SQLException {
	    return false;
	}

    /**
     * Can a schema name be used in an index definition statement?
     *
     * @return true if so
     */
	public boolean supportsSchemasInIndexDefinitions() throws SQLException {
	    return false;
	}

    /**
     * Can a schema name be used in a privilege definition statement?
     *
     * @return true if so
     */
	public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
	    return false;
	}

    /**
     * Can a catalog name be used in a data manipulation statement?
     *
     * @return true if so
     */
	public boolean supportsCatalogsInDataManipulation() throws SQLException {
	    return false;
	}

    /**
     * Can a catalog name be used in a procedure call statement?
     *
     * @return true if so
     */
	public boolean supportsCatalogsInProcedureCalls() throws SQLException {
	    return false;
	}

    /**
     * Can a catalog name be used in a table definition statement?
     *
     * @return true if so
     */
	public boolean supportsCatalogsInTableDefinitions() throws SQLException {
	    return false;
	}

    /**
     * Can a catalog name be used in a index definition statement?
     *
     * @return true if so
     */
	public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
	    return false;
	}

    /**
     * Can a catalog name be used in a privilege definition statement?
     *
     * @return true if so
     */
	public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
	    return false;
	}


    /**
     * Is positioned DELETE supported?
     *
     * @return true if so
     */
	public boolean supportsPositionedDelete() throws SQLException {
	    return false;
	}

    /**
     * Is positioned UPDATE supported?
     *
     * @return true if so
     */
	public boolean supportsPositionedUpdate() throws SQLException {
	    return false;
	}

    /**
     * Is SELECT for UPDATE supported?
     *
     * @return true if so
     */
	public boolean supportsSelectForUpdate() throws SQLException {
	    return false;
	}

    /**
     * Are stored procedure calls using the stored procedure escape
     * syntax supported?
     *
     * @return true if so
     */
	public boolean supportsStoredProcedures() throws SQLException {
	    return false;
	}

    /**
     * Are subqueries in comparison expressions supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsSubqueriesInComparisons() throws SQLException {
	    return true; // not sure
	}

    /**
     * Are subqueries in exists expressions supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsSubqueriesInExists() throws SQLException {
	    return true;  // not sure
	}

    /**
     * Are subqueries in "in" statements supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsSubqueriesInIns() throws SQLException {
	    return true; // not sure
	}

    /**
     * Are subqueries in quantified expressions supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsSubqueriesInQuantifieds() throws SQLException {
	    return true; // not sure
	}

    /**
     * Are correlated subqueries supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsCorrelatedSubqueries() throws SQLException {
	    return true; // not sure
	}

    /**
     * Is SQL UNION supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsUnion() throws SQLException {
	    return false; // not sure
	}

    /**
     * Is SQL UNION ALL supported?
     *
     * A JDBC compliant driver always returns true.
     *
     * @return true if so
     */
	public boolean supportsUnionAll() throws SQLException {
	    return false; // not sure
	}

    /**
     * Can cursors remain open across commits?
     *
     * @return true if so
     * @see Connection#disableAutoClose
     */
	public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
	    return false;
	}

    /**
     * Can cursors remain open across rollbacks?
     *
     * @return true if so
     * @see Connection#disableAutoClose
     */
	public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
	    return false;
	}

    /**
     * Can statements remain open across commits?
     *
     * @return true if so
     * @see Connection#disableAutoClose
     */
	public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
	    return false;
	}

    /**
     * Can statements remain open across rollbacks?
     *
     * @return true if so
     * @see Connection#disableAutoClose
     */
	public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
	    return false;
	}



    //----------------------------------------------------------------------
    // The following group of methods exposes various limitations
    // based on the target database with the current driver.
    // Unless otherwise specified, a result of zero means there is no
    // limit, or the limit is not known.

    /**
     * How many hex characters can you have in an inline binary literal?
     *
     * @return max literal length
     */
	public int getMaxBinaryLiteralLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the max length for a character literal?
     *
     * @return max literal length
     */
	public int getMaxCharLiteralLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the limit on column name length?
     *
     * @return max literal length
     */
	public int getMaxColumnNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum number of columns in a "GROUP BY" clause?
     *
     * @return max number of columns
     */
	public int getMaxColumnsInGroupBy() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum number of columns allowed in an index?
     *
     * @return max columns
     */
	public int getMaxColumnsInIndex() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum number of columns in an "ORDER BY" clause?
     *
     * @return max columns
     */
	public int getMaxColumnsInOrderBy() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum number of columns in a "SELECT" list?
     *
     * @return max columns
     */
	public int getMaxColumnsInSelect() throws SQLException {
	    return 0;
	}

    /**
     * What's maximum number of columns in a table?
     *
     * @return max columns
     */
	public int getMaxColumnsInTable() throws SQLException {
	    return 0;
	}

    /**
     * How many active connections can we have at a time to this database?
     *
     * @return max connections
     */
	public int getMaxConnections() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum cursor name length?
     *
     * @return max cursor name length in bytes
     */
	public int getMaxCursorNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of an index (in bytes)?
     *
     * @return max index length in bytes
     */
	public int getMaxIndexLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length allowed for a schema name?
     *
     * @return max name length in bytes
     */
	public int getMaxSchemaNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of a procedure name?
     *
     * @return max name length in bytes
     */
	public int getMaxProcedureNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of a catalog name?
     *
     * @return max name length in bytes
     */
	public int getMaxCatalogNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of a single row?
     *
     * @return max row size in bytes
     */
	public int getMaxRowSize() throws SQLException {
	    return 0;
	}

    /**
     * Did getMaxRowSize() include LONGVARCHAR and LONGVARBINARY
     * blobs?
     *
     * @return true if so
     */
	public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
	    return true;
	}

    /**
     * What's the maximum length of a SQL statement?
     *
     * @return max length in bytes
     */
	public int getMaxStatementLength() throws SQLException {
	    return 0;
	}

    /**
     * How many active statements can we have open at one time to this
     * database?
     *
     * @return the maximum
     */
	public int getMaxStatements() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of a table name?
     *
     * @return max name length in bytes
     */
	public int getMaxTableNameLength() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum number of tables in a SELECT?
     *
     * @return the maximum
     */
	public int getMaxTablesInSelect() throws SQLException {
	    return 0;
	}

    /**
     * What's the maximum length of a user name?
     *
     * @return max name length  in bytes
     */
	public int getMaxUserNameLength() throws SQLException {
	    return 0;
	}

    //----------------------------------------------------------------------

    /**
     * What's the database's default transaction isolation level?  The
     * values are defined in java.sql.Connection.
     *
     * @return the default isolation level
     * @see Connection
     */
	public int getDefaultTransactionIsolation() throws SQLException {
	    return 0;
	}

    /**
     * Are transactions supported? If not, commit is a noop and the
     * isolation level is TRANSACTION_NONE.
     *
     * @return true if transactions are supported
     */
	public boolean supportsTransactions() throws SQLException {
	    return false;
	}

    /**
     * Does the database support the given transaction isolation level?
     *
     * @param level the values are defined in java.sql.Connection
     * @return true if so
     * @see Connection
     */
	public boolean supportsTransactionIsolationLevel(int level)
							throws SQLException {
		return false;
    }

    /**
     * Are both data definition and data manipulation statements
     * within a transaction supported?
     *
     * @return true if so
     */
	public boolean supportsDataDefinitionAndDataManipulationTransactions()
							 throws SQLException {
       return false;
       }

    /**
     * Are only data manipulation statements within a transaction
     * supported?
     *
     * @return true if so
     */
	public boolean supportsDataManipulationTransactionsOnly()
							throws SQLException {
							    return false;
							}
    /**
     * Does a data definition statement within a transaction force the
     * transaction to commit?
     *
     * @return true if so
     */
	public boolean dataDefinitionCausesTransactionCommit()
							throws SQLException {
							    return false;
							}
    /**
     * Is a data definition statement within a transaction ignored?
     *
     * @return true if so
     */
	public boolean dataDefinitionIgnoredInTransactions()
							throws SQLException {
							    return false;
							}


    /**
     * Get a description of stored procedures available in a
     * catalog.
     *
     * <P>Only procedure descriptions matching the schema and
     * procedure name criteria are returned.  They are ordered by
     * PROCEDURE_SCHEM, and PROCEDURE_NAME.
     *
     * <P>Each procedure description has the the following columns:
     *  <OL>
     *	<LI><B>PROCEDURE_CAT</B> String => procedure catalog (may be null)
     *	<LI><B>PROCEDURE_SCHEM</B> String => procedure schema (may be null)
     *	<LI><B>PROCEDURE_NAME</B> String => procedure name
     *  <LI> reserved for future use
     *  <LI> reserved for future use
     *  <LI> reserved for future use
     *	<LI><B>REMARKS</B> String => explanatory comment on the procedure
     *	<LI><B>PROCEDURE_TYPE</B> short => kind of procedure:
     *      <UL>
     *      <LI> procedureResultUnknown - May return a result
     *      <LI> procedureNoResult - Does not return a result
     *      <LI> procedureReturnsResult - Returns a result
     *      </UL>
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param procedureNamePattern a procedure name pattern
     * @return ResultSet each row is a procedure description
     * @see #getSearchStringEscape
     */
	public ResultSet getProcedures(String catalog, String schemaPattern,
			String procedureNamePattern) throws SQLException {
			    return null;
			}

    /**
     * PROCEDURE_TYPE - May return a result.
     */
	int procedureResultUnknown	= 0;
    /**
     * PROCEDURE_TYPE - Does not return a result.
     */
	int procedureNoResult		= 1;
    /**
     * PROCEDURE_TYPE - Returns a result.
     */
	int procedureReturnsResult	= 2;

    /**
     * Get a description of a catalog's stored procedure parameters
     * and result columns.
     *
     * <P>Only descriptions matching the schema, procedure and
     * parameter name criteria are returned.  They are ordered by
     * PROCEDURE_SCHEM and PROCEDURE_NAME. Within this, the return value,
     * if any, is first. Next are the parameter descriptions in call
     * order. The column descriptions follow in column number order.
     *
     * <P>Each row in the ResultSet is a parameter desription or
     * column description with the following fields:
     *  <OL>
     *	<LI><B>PROCEDURE_CAT</B> String => procedure catalog (may be null)
     *	<LI><B>PROCEDURE_SCHEM</B> String => procedure schema (may be null)
     *	<LI><B>PROCEDURE_NAME</B> String => procedure name
     *	<LI><B>COLUMN_NAME</B> String => column/parameter name
     *	<LI><B>COLUMN_TYPE</B> Short => kind of column/parameter:
     *      <UL>
     *      <LI> procedureColumnUnknown - nobody knows
     *      <LI> procedureColumnIn - IN parameter
     *      <LI> procedureColumnInOut - INOUT parameter
     *      <LI> procedureColumnOut - OUT parameter
     *      <LI> procedureColumnReturn - procedure return value
     *      <LI> procedureColumnResult - result column in ResultSet
     *      </UL>
     *  <LI><B>DATA_TYPE</B> short => SQL type from java.sql.Types
     *	<LI><B>TYPE_NAME</B> String => SQL type name
     *	<LI><B>PRECISION</B> int => precision
     *	<LI><B>LENGTH</B> int => length in bytes of data
     *	<LI><B>SCALE</B> short => scale
     *	<LI><B>RADIX</B> short => radix
     *	<LI><B>NULLABLE</B> short => can it contain NULL?
     *      <UL>
     *      <LI> procedureNoNulls - does not allow NULL values
     *      <LI> procedureNullable - allows NULL values
     *      <LI> procedureNullableUnknown - nullability unknown
     *      </UL>
     *	<LI><B>REMARKS</B> String => comment describing parameter/column
     *  </OL>
     *
     * <P><B>Note:</B> Some databases may not return the column
     * descriptions for a procedure. Additional columns beyond
     * REMARKS can be defined by the database.
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param procedureNamePattern a procedure name pattern
     * @param columnNamePattern a column name pattern
     * @return ResultSet each row is a stored procedure parameter or
     *      column description
     * @see #getSearchStringEscape
     */
	public ResultSet getProcedureColumns(String catalog,
			String schemaPattern,
			String procedureNamePattern,
			String columnNamePattern) throws SQLException {
			    return null;
			}

    /**
     * COLUMN_TYPE - nobody knows.
     */
	int procedureColumnUnknown = 0;

    /**
     * COLUMN_TYPE - IN parameter.
     */
	int procedureColumnIn = 1;

    /**
     * COLUMN_TYPE - INOUT parameter.
     */
	int procedureColumnInOut = 2;

    /**
     * COLUMN_TYPE - OUT parameter.
     */
	int procedureColumnOut = 4;
    /**
     * COLUMN_TYPE - procedure return value.
     */
	int procedureColumnReturn = 5;

    /**
     * COLUMN_TYPE - result column in ResultSet.
     */
	int procedureColumnResult = 3;

    /**
     * TYPE NULLABLE - does not allow NULL values.
     */
    int procedureNoNulls = 0;

    /**
     * TYPE NULLABLE - allows NULL values.
     */
    int procedureNullable = 1;

    /**
     * TYPE NULLABLE - nullability unknown.
     */
    int procedureNullableUnknown = 2;


    /**
     * Get a description of tables available in a catalog.
     *
     * <P>Only table descriptions matching the catalog, schema, table
     * name and type criteria are returned.  They are ordered by
     * TABLE_TYPE, TABLE_SCHEM and TABLE_NAME.
     *
     * <P>Each table description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>TABLE_TYPE</B> String => table type.  Typical types are "TABLE",
     *			"VIEW",	"SYSTEM TABLE", "GLOBAL TEMPORARY",
     *			"LOCAL TEMPORARY", "ALIAS", "SYNONYM".
     *	<LI><B>REMARKS</B> String => explanatory comment on the table
     *  </OL>
     *
     * <P><B>Note:</B> Some databases may not return information for
     * all tables.
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param tableNamePattern a table name pattern
     * @param types a list of table types to include; null returns all types
     * @return ResultSet each row is a table description
     * @see #getSearchStringEscape
     */
  public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String types[]) throws SQLException
  {
    ResultSet rs = conn.createStatement().executeQuery("show tables like '" +
    		tableNamePattern + "'");
    ResultSetMetaData rsmd = rs.getMetaData ();
    int colNum = rsmd.getColumnCount();
    //
    // change the column name to the JDBC standard name.
    //
    String[] colName = new String[colNum];
    int i;
    for (i=1; i<=colNum; ++i)
    {
      colName[i-1] = rsmd.getColumnName(i);
      //System.out.println("Old Name: " + colName[i-1]);
    }
    colName[0] = new String("TABLE_NAME"); // JDBC ask for
    ((gweMysqlResultSet)rs).modifyColumnHead(colName);

    //
    // Create pseudo column
    //
    // In mysql, SQL command "show tables" only get 1 column for TABLE_NAME
    // and other 3 columns need be created as pseudo column.
    //
    colName = new String[3];
    int[] colType = new int[3];
    String[] colValue = new String[3];
    int[] realColMap = new int[colNum];
    int[] pseudoColMap = new int[3];
    int[] pseudoColMode = new int[3];
    //
    // the position in the logic view
    //     0             1           2            3
    //  TABLE_CAT   TABLE_SCHEM  TABLE_NAME   TABLE_TYPE
    //   ps-fix       ps-fix        real         ps-fix
    //
    realColMap[0] = 2;
    pseudoColMap[0] = 0;
    pseudoColMap[1] = 1;
    pseudoColMap[2] = 3;
    colName[0] = new String("TABLE_CAT");
    colName[1] = new String("TABLE_SCHEM");
    colName[2] = new String("TABLE_TYPE");
    colType[0] = 6; // for NULL
    colType[1] = 6; // for NULL
    colType[2] = 254; // for VARCHAR
    colValue[0] = null;
    colValue[1] = null;
    colValue[2] = new String("TABLE");
    pseudoColMode[0] = -1; // for pseudo fix column
    pseudoColMode[1] = -1;
    pseudoColMode[2] = -1;
    ((gweMysqlResultSet)rs).addPseudoColumn("", realColMap, pseudoColMap,
      colName, colType, colValue, pseudoColMode);

    return rs;
  }
  
    /**
     * Get the schema names available in this database.  The results
     * are ordered by schema name.
     *
     * <P>The schema column is:
     *  <OL>
     *	<LI><B>TABLE_SCHEM</B> String => schema name
     *  </OL>
     *
     * @return ResultSet each row has a single String column that is a
     * schema name
     */
  public ResultSet getSchemas() throws SQLException
  {
    return null;
  }
  
    /**
     * Get the catalog names available in this database.  The results
     * are ordered by catalog name.
     *
     * <P>The catalog column is:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => catalog name
     *  </OL>
     *
     * @return ResultSet each row has a single String column that is a
     * catalog name
     */
  public ResultSet getCatalogs() throws SQLException
  {
    // PM Jun 1 97: Added spaces to some lines. This was generating
    // SQLExceptions every time it was called.
    return null;
  }
  
  /**
   * Get the table types available in this database.  The results
   * are ordered by table type.
   *
   * <P>The table type is:
   *  <OL>
   *	<LI><B>TABLE_TYPE</B> String => table type.  Typical types are "TABLE",
   *			"VIEW",	"SYSTEM TABLE", "GLOBAL TEMPORARY",
   *			"LOCAL TEMPORARY", "ALIAS", "SYNONYM".
   *  </OL>
   *
   * @return ResultSet each row has a single String column that is a
   * table type
   */
  public ResultSet getTableTypes() throws SQLException
  {
    return null;
  }
  
    /**
     * Get a description of table columns available in a catalog.
     *
     * <P>Only column descriptions matching the catalog, schema, table
     * and column name criteria are returned.  They are ordered by
     * TABLE_SCHEM, TABLE_NAME and ORDINAL_POSITION.
     *
     * <P>Each column description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>DATA_TYPE</B> short => SQL type from java.sql.Types
     *	<LI><B>TYPE_NAME</B> String => Data source dependent type name
     *	<LI><B>COLUMN_SIZE</B> int => column size.  For char or date
     *	    types this is the maximum number of characters, for numeric or
     *	    decimal types this is precision.
     *	<LI><B>BUFFER_LENGTH</B> is not used.
     *	<LI><B>DECIMAL_DIGITS</B> int => the number of fractional digits
     *	<LI><B>NUM_PREC_RADIX</B> int => Radix (typically either 10 or 2)
     *	<LI><B>NULLABLE</B> int => is NULL allowed?
     *      <UL>
     *      <LI> columnNoNulls - might not allow NULL values
     *      <LI> columnNullable - definitely allows NULL values
     *      <LI> columnNullableUnknown - nullability unknown
     *      </UL>
     *	<LI><B>REMARKS</B> String => comment describing column (may be null)
     * 	<LI><B>COLUMN_DEF</B> String => default value (may be null)
     *	<LI><B>SQL_DATA_TYPE</B> int => unused
     *	<LI><B>SQL_DATETIME_SUB</B> int => unused
     *	<LI><B>CHAR_OCTET_LENGTH</B> int => for char types the
     *       maximum number of bytes in the column
     *	<LI><B>ORDINAL_POSITION</B> int	=> index of column in table
     *      (starting at 1)
     *	<LI><B>IS_NULLABLE</B> String => "NO" means column definitely
     *      does not allow NULL values; "YES" means the column might
     *      allow NULL values.  An empty string means nobody knows.
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param tableNamePattern a table name pattern
     * @param columnNamePattern a column name pattern
     * @return ResultSet each row is a column description
     * @see #getSearchStringEscape
     */
  // PM May 11 1997 - modified this so that the DATA_TYPE column returns the correct values
  //                  the TYPE_NAME is left to the postgres type
  public ResultSet getColumns(String catalog, String schemaPattern,
			      String tableNamePattern, String columnNamePattern)
       throws SQLException
  {
    ResultSet rs = conn.createStatement().executeQuery("show columns from " +
    	tableNamePattern + " like '" + columnNamePattern + "'");

    ResultSetMetaData rsmd = rs.getMetaData ();
    int colNum = rsmd.getColumnCount();
    //
    // change the column name to the JDBC standard name.
    //
    String[] colName = new String[colNum];
    int i;
    for (i=1; i<=colNum; ++i)
    {
      colName[i-1] = rsmd.getColumnName(i);
    //  System.out.println("Old Name: " + colName[i-1]);
    }
    colName[0] = new String("COLUMN_NAME"); // JDBC ask for
    colName[1] = null;
    colName[2] = new String("IS_NULLABLE"); // JDBC ask for
    colName[3] = null;
    colName[4] = new String("COLUMN_DEF"); // JDBC ask for
    colName[5] = new String("REMARK"); // JDBC ask for
    ((gweMysqlResultSet)rs).modifyColumnHead(colName);

    //
    // Create pseudo column
    //
    // In mysql, SQL command "show columns from table" get 6 column 
    // There are 4 column be needed and the other 14 columns need 
    // be created as pseudo column. 
    // Among these login columns,
    // 6 columns is "fix" and 1 column is "auto_increase" and 
    // 7 columns are "create_from_other_column".
    //
    colName = new String[14];
    int[] colType = new int[14];
    String[] colValue = new String[14];
    int[] realColMap = new int[colNum];
    int[] pseudoColMap = new int[14];
    int[] pseudoColMode = new int[14];
    //
    // the position in the logic view
    //     0             1           2          3           4         5
    //  TABLE_CAT  TABLE_SCHEM  TABLE_NAME  COLUMN_NAME  DATA_TYPE TYPE_NAME 
    //   ps-fix       ps-fix       ps-fix      real        ps-cr     ps-cr
    //
    //     6             7              8                9            10
    //  COLUMN_SIZE  BUFFER_LENGTH  DECIMAL_DIGITS  NUM_PREC_RADIX  NULLABLE
    //    ps-cr        ps-fix         ps-cr            ps-cr          ps-cr
    //
    //    11        12           13               14               15
    //  REMARK  COLUMN_DEF  SQL_DATA_TYPE  SQL_DATETIME_SUB  CHAR_OCTET_LENGTH
    //    real     real         ps-fix           ps-fix          ps-cr
    //
    //       16               17
    //  ORDINAL_POSITION  IS_NULLABLE
    //      ps-inc            real
    //
    realColMap[0] = 3;
    realColMap[1] = -1;
    realColMap[2] = 17;
    realColMap[3] = -1;
    realColMap[4] = 12;
    realColMap[5] = 11;
    pseudoColMap[0] = 0;
    pseudoColMap[1] = 1;
    pseudoColMap[2] = 2;
    pseudoColMap[3] = 4;
    pseudoColMap[4] = 5;
    pseudoColMap[5] = 6;
    pseudoColMap[6] = 7;
    pseudoColMap[7] = 8;
    pseudoColMap[8] = 9;
    pseudoColMap[9] = 10;
    pseudoColMap[10] = 13;
    pseudoColMap[11] = 14;
    pseudoColMap[12] = 15;
    pseudoColMap[13] = 16;
    colName[0] = new String("TABLE_CAT");
    colName[1] = new String("TABLE_SCHEM");
    colName[2] = new String("TABLE_NAME");
    colName[3] = new String("DATA_TYPE");
    colName[4] = new String("TYPE_NAME");
    colName[5] = new String("COLUMN_SIZE");
    colName[6] = new String("BUFFER_LENGTH");
    colName[7] = new String("DECIMAL_DIGITS");
    colName[8] = new String("NUM_PREC_PADIX");
    colName[9] = new String("NULLABLE");
    colName[10] = new String("SQL_DATA_TYPE");
    colName[11] = new String("SQL_DATETIME_SUB");
    colName[12] = new String("CHAR_OCTET_LENGTH");
    colName[13] = new String("ORDINAL_POSITION");
    colType[0] = 6; // for NULL
    colType[1] = 6; // for NULL
    colType[2] = 254; // for VARCHAR
    colType[3] = 2; // for SMALLINT
    colType[4] = 254; // for VARCHAR
    colType[5] = 9; // for INTEGER
    colType[6] = 6; // for NULL
    colType[7] = 9; // for INTEGER
    colType[8] = 9; // for INTEGER
    colType[9] = 9; // for INTEGER
    colType[10] = 6; // for NULL
    colType[11] = 6; // for NULL
    colType[12] = 9; // for INTEGER
    colType[13] = 9; // for INTEGER
    colValue[0] = null;
    colValue[1] = null;
    colValue[2] = new String(tableNamePattern);
    colValue[3] = null;
    colValue[4] = null;
    colValue[5] = null;
    colValue[6] = null;
    colValue[7] = null;
    colValue[8] = null;
    colValue[9] = null;
    colValue[10] = null;
    colValue[11] = null;
    colValue[12] = null;
    colValue[13] = null;
    pseudoColMode[0] = -1; // for pseudo fix
    pseudoColMode[1] = -1;
    pseudoColMode[2] = -1;
    pseudoColMode[3] = 1; // for pseudo created from other column
    pseudoColMode[4] = 0; // for pseudo created from other column
    pseudoColMode[5] = 2; // for pseudo created from other column
    pseudoColMode[6] = -1;
    pseudoColMode[7] = 3; // for pseudo created from other column
    pseudoColMode[8] = 4; // for pseudo created from other column
    pseudoColMode[9] = 6; // for pseudo created from other column
    pseudoColMode[10] = -1;
    pseudoColMode[11] = -1;
    pseudoColMode[12] = 5; // for pseudo created from other column
    pseudoColMode[13] = -2; // for pseudo auto increase
    ((gweMysqlResultSet)rs).addPseudoColumn(tableNamePattern, realColMap, 
      pseudoColMap, colName, colType, colValue, pseudoColMode);

    return rs;
  }

    /**
     * COLUMN NULLABLE - might not allow NULL values.
     */
    int columnNoNulls = 0;

    /**
     * COLUMN NULLABLE - definitely allows NULL values.
     */
    int columnNullable = 1;

    /**
     * COLUMN NULLABLE - nullability unknown.
     */
    int columnNullableUnknown = 2;

    /**
     * Get a description of the access rights for a table's columns.
     *
     * <P>Only privileges matching the column name criteria are
     * returned.  They are ordered by COLUMN_NAME and PRIVILEGE.
     *
     * <P>Each privilige description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>GRANTOR</B> => grantor of access (may be null)
     *	<LI><B>GRANTEE</B> String => grantee of access
     *	<LI><B>PRIVILEGE</B> String => name of access (SELECT,
     *      INSERT, UPDATE, REFRENCES, ...)
     *	<LI><B>IS_GRANTABLE</B> String => "YES" if grantee is permitted
     *      to grant to others; "NO" if not; null if unknown
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name; "" retrieves those without a schema
     * @param table a table name
     * @param columnNamePattern a column name pattern
     * @return ResultSet each row is a column privilege description
     * @see #getSearchStringEscape
     */
	public ResultSet getColumnPrivileges(String catalog, String schema,
		String table, String columnNamePattern) throws SQLException {
		    return null;
		}

    /**
     * Get a description of the access rights for each table available
     * in a catalog.
     *
     * <P>Only privileges matching the schema and table name
     * criteria are returned.  They are ordered by TABLE_SCHEM,
     * TABLE_NAME, and PRIVILEGE.
     *
     * <P>Each privilige description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>GRANTOR</B> => grantor of access (may be null)
     *	<LI><B>GRANTEE</B> String => grantee of access
     *	<LI><B>PRIVILEGE</B> String => name of access (SELECT,
     *      INSERT, UPDATE, REFRENCES, ...)
     *	<LI><B>IS_GRANTABLE</B> String => "YES" if grantee is permitted
     *      to grant to others; "NO" if not; null if unknown
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param tableNamePattern a table name pattern
     * @return ResultSet each row is a table privilege description
     * @see #getSearchStringEscape
     */
	public ResultSet getTablePrivileges(String catalog, String schemaPattern,
				String tableNamePattern) throws SQLException {
				    return null;
				}

    /**
     * Get a description of a table's optimal set of columns that
     * uniquely identifies a row. They are ordered by SCOPE.
     *
     * <P>Each column description has the following columns:
     *  <OL>
     *	<LI><B>SCOPE</B> short => actual scope of result
     *      <UL>
     *      <LI> bestRowTemporary - very temporary, while using row
     *      <LI> bestRowTransaction - valid for remainder of current transaction
     *      <LI> bestRowSession - valid for remainder of current session
     *      </UL>
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>DATA_TYPE</B> short => SQL data type from java.sql.Types
     *	<LI><B>TYPE_NAME</B> String => Data source dependent type name
     *	<LI><B>COLUMN_SIZE</B> int => precision
     *	<LI><B>BUFFER_LENGTH</B> int => not used
     *	<LI><B>DECIMAL_DIGITS</B> short	 => scale
     *	<LI><B>PSEUDO_COLUMN</B> short => is this a pseudo column
     *      like an Oracle ROWID
     *      <UL>
     *      <LI> bestRowUnknown - may or may not be pseudo column
     *      <LI> bestRowNotPseudo - is NOT a pseudo column
     *      <LI> bestRowPseudo - is a pseudo column
     *      </UL>
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name; "" retrieves those without a schema
     * @param table a table name
     * @param scope the scope of interest; use same values as SCOPE
     * @param nullable include columns that are nullable?
     * @return ResultSet each row is a column description
     */
	public ResultSet getBestRowIdentifier(String catalog, String schema,
		String table, int scope, boolean nullable) throws SQLException {
		    return null;
		}

    /**
     * BEST ROW SCOPE - very temporary, while using row.
     */
	int bestRowTemporary   = 0;

    /**
     * BEST ROW SCOPE - valid for remainder of current transaction.
     */
	int bestRowTransaction = 1;

    /**
     * BEST ROW SCOPE - valid for remainder of current session.
     */
	int bestRowSession     = 2;

    /**
     * BEST ROW PSEUDO_COLUMN - may or may not be pseudo column.
     */
	int bestRowUnknown	= 0;

    /**
     * BEST ROW PSEUDO_COLUMN - is NOT a pseudo column.
     */
	int bestRowNotPseudo	= 1;

    /**
     * BEST ROW PSEUDO_COLUMN - is a pseudo column.
     */
	int bestRowPseudo	= 2;

    /**
     * Get a description of a table's columns that are automatically
     * updated when any value in a row is updated.  They are
     * unordered.
     *
     * <P>Each column description has the following columns:
     *  <OL>
     *	<LI><B>SCOPE</B> short => is not used
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>DATA_TYPE</B> short => SQL data type from java.sql.Types
     *	<LI><B>TYPE_NAME</B> String => Data source dependent type name
     *	<LI><B>COLUMN_SIZE</B> int => precision
     *	<LI><B>BUFFER_LENGTH</B> int => length of column value in bytes
     *	<LI><B>DECIMAL_DIGITS</B> short	 => scale
     *	<LI><B>PSEUDO_COLUMN</B> short => is this a pseudo column
     *      like an Oracle ROWID
     *      <UL>
     *      <LI> versionColumnUnknown - may or may not be pseudo column
     *      <LI> versionColumnNotPseudo - is NOT a pseudo column
     *      <LI> versionColumnPseudo - is a pseudo column
     *      </UL>
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name; "" retrieves those without a schema
     * @param table a table name
     * @return ResultSet each row is a column description
     */
	public ResultSet getVersionColumns(String catalog, String schema,
				String table) throws SQLException {
				    return null;
				}

    /**
     * VERSION COLUMNS PSEUDO_COLUMN - may or may not be pseudo column.
     */
	int versionColumnUnknown	= 0;

    /**
     *  VERSION COLUMNS PSEUDO_COLUMN - is NOT a pseudo column.
     */
	int versionColumnNotPseudo	= 1;

    /**
     *  VERSION COLUMNS PSEUDO_COLUMN - is a pseudo column.
     */
	int versionColumnPseudo	= 2;

    /**
     * Get a description of a table's primary key columns.  They
     * are ordered by COLUMN_NAME.
     *
     * <P>Each column description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>COLUMN_NAME</B> String => column name
     *	<LI><B>KEY_SEQ</B> short => sequence number within primary key
     *	<LI><B>PK_NAME</B> String => primary key name (may be null)
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name pattern; "" retrieves those
     * without a schema
     * @param table a table name
     * @return ResultSet each row is a primary key column description
     */
  public ResultSet getPrimaryKeys(String catalog, String schema,String table) throws SQLException
  {
    ResultSet rs = conn.createStatement().executeQuery("show keys from " +
                                                       table);
    ResultSetMetaData rsmd = rs.getMetaData ();
    int colNum = rsmd.getColumnCount();
    //
    // change the column name to the JDBC standard name.
    //
    String[] colName = new String[colNum];
    int i;
    for (i=1; i<=colNum; ++i)
    {
      colName[i-1] = rsmd.getColumnName(i);
    //  System.out.println("Old Name: " + colName[i-1]);
    }
    colName[0] = new String("TABLE_NAME"); // JDBC ask for
    colName[1] = null;
    colName[2] = new String("PK_NAME"); // JDBC ask for
    colName[3] = new String("KEY_SEQ"); // JDBC ask for
    colName[4] = new String("COLUMN_NAME"); // JDBC ask for
    colName[5] = null;
    colName[6] = null;
    colName[7] = null;
    ((gweMysqlResultSet)rs).modifyColumnHead(colName);

    //
    // Create pseudo column
    //
    // In mysql, SQL command "show keys from table" get 8 column 
    // There are 4 column be needed and the other 2 columns need 
    // be created as pseudo column.
    //
    colName = new String[2];
    int[] colType = new int[2];
    String[] colValue = new String[2];
    int[] realColMap = new int[colNum];
    int[] pseudoColMap = new int[2];
    int[] pseudoColMode = new int[2];
    //
    // the position in the logic view
    //     0             1           2          3           4       5
    //  TABLE_CAT  TABLE_SCHEM  TABLE_NAME  COLUMN_NAME  KEY_SEQ  PK_NAME
    //   ps-fix       ps-fix       real        real        real     real
    //
    realColMap[0] = 2;
    realColMap[1] = -1;
    realColMap[2] = 5;
    realColMap[3] = 4;
    realColMap[4] = 3;
    realColMap[5] = -1;
    realColMap[6] = -1;
    realColMap[7] = -1;
    pseudoColMap[0] = 0;
    pseudoColMap[1] = 1;
    colName[0] = new String("TABLE_CAT");
    colName[1] = new String("TABLE_SCHEM");
    colType[0] = 6; // for NULL
    colType[1] = 6; // for NULL
    colValue[0] = null;
    colValue[1] = null;
    pseudoColMode[0] = -1; // for pseudo fix column
    pseudoColMode[1] = -1;

    ((gweMysqlResultSet)rs).addPseudoColumn(table, realColMap, pseudoColMap,
      colName, colType, colValue, pseudoColMode);

    int filterColPos = 2;
    String filterString = new String("PRIMARY");
    ((gweMysqlResultSet)rs).setRowFilter(filterColPos, filterString);

    return rs;
  }
  
    /**
     * Get a description of the primary key columns that are
     * referenced by a table's foreign key columns (the primary keys
     * imported by a table).  They are ordered by PKTABLE_CAT,
     * PKTABLE_SCHEM, PKTABLE_NAME, and KEY_SEQ.
     *
     * <P>Each primary key column description has the following columns:
     *  <OL>
     *	<LI><B>PKTABLE_CAT</B> String => primary key table catalog
     *      being imported (may be null)
     *	<LI><B>PKTABLE_SCHEM</B> String => primary key table schema
     *      being imported (may be null)
     *	<LI><B>PKTABLE_NAME</B> String => primary key table name
     *      being imported
     *	<LI><B>PKCOLUMN_NAME</B> String => primary key column name
     *      being imported
     *	<LI><B>FKTABLE_CAT</B> String => foreign key table catalog (may be null)
     *	<LI><B>FKTABLE_SCHEM</B> String => foreign key table schema (may be null)
     *	<LI><B>FKTABLE_NAME</B> String => foreign key table name
     *	<LI><B>FKCOLUMN_NAME</B> String => foreign key column name
     *	<LI><B>KEY_SEQ</B> short => sequence number within foreign key
     *	<LI><B>UPDATE_RULE</B> short => What happens to
     *       foreign key when primary is updated:
     *      <UL>
     *      <LI> importedKeyCascade - change imported key to agree
     *               with primary key update
     *      <LI> importedKeyRestrict - do not allow update of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been updated
     *      </UL>
     *	<LI><B>DELETE_RULE</B> short => What happens to
     *      the foreign key when primary is deleted.
     *      <UL>
     *      <LI> importedKeyCascade - delete rows that import a deleted key
     *      <LI> importedKeyRestrict - do not allow delete of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been deleted
     *      </UL>
     *	<LI><B>FK_NAME</B> String => foreign key name (may be null)
     *	<LI><B>PK_NAME</B> String => primary key name (may be null)
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name pattern; "" retrieves those
     * without a schema
     * @param table a table name
     * @return ResultSet each row is a primary key column description
     * @see #getExportedKeys
     */
	public ResultSet getImportedKeys(String catalog, String schema,
				String table) throws SQLException {
				    return null;
				}

    /**
     * IMPORT KEY UPDATE_RULE and DELETE_RULE - for update, change
     * imported key to agree with primary key update; for delete,
     * delete rows that import a deleted key.
     */
	int importedKeyCascade	= 0;

    /**
     * IMPORT KEY UPDATE_RULE and DELETE_RULE - do not allow update or
     * delete of primary key if it has been imported.
     */
	int importedKeyRestrict = 1;

    /**
     * IMPORT KEY UPDATE_RULE and DELETE_RULE - change imported key to
     * NULL if its primary key has been updated or deleted.
     */
	int importedKeySetNull  = 2;

    /**
     * Get a description of a foreign key columns that reference a
     * table's primary key columns (the foreign keys exported by a
     * table).  They are ordered by FKTABLE_CAT, FKTABLE_SCHEM,
     * FKTABLE_NAME, and KEY_SEQ.
     *
     * <P>Each foreign key column description has the following columns:
     *  <OL>
     *	<LI><B>PKTABLE_CAT</B> String => primary key table catalog (may be null)
     *	<LI><B>PKTABLE_SCHEM</B> String => primary key table schema (may be null)
     *	<LI><B>PKTABLE_NAME</B> String => primary key table name
     *	<LI><B>PKCOLUMN_NAME</B> String => primary key column name
     *	<LI><B>FKTABLE_CAT</B> String => foreign key table catalog (may be null)
     *      being exported (may be null)
     *	<LI><B>FKTABLE_SCHEM</B> String => foreign key table schema (may be null)
     *      being exported (may be null)
     *	<LI><B>FKTABLE_NAME</B> String => foreign key table name
     *      being exported
     *	<LI><B>FKCOLUMN_NAME</B> String => foreign key column name
     *      being exported
     *	<LI><B>KEY_SEQ</B> short => sequence number within foreign key
     *	<LI><B>UPDATE_RULE</B> short => What happens to
     *       foreign key when primary is updated:
     *      <UL>
     *      <LI> importedKeyCascade - change imported key to agree
     *               with primary key update
     *      <LI> importedKeyRestrict - do not allow update of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been updated
     *      </UL>
     *	<LI><B>DELETE_RULE</B> short => What happens to
     *      the foreign key when primary is deleted.
     *      <UL>
     *      <LI> importedKeyCascade - delete rows that import a deleted key
     *      <LI> importedKeyRestrict - do not allow delete of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been deleted
     *      </UL>
     *	<LI><B>FK_NAME</B> String => foreign key identifier (may be null)
     *	<LI><B>PK_NAME</B> String => primary key identifier (may be null)
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name pattern; "" retrieves those
     * without a schema
     * @param table a table name
     * @return ResultSet each row is a foreign key column description
     * @see #getImportedKeys
     */
	public ResultSet getExportedKeys(String catalog, String schema,
				String table) throws SQLException {
				    return null;
				}

    /**
     * Get a description of the foreign key columns in the foreign key
     * table that reference the primary key columns of the primary key
     * table (describe how one table imports another's key.) This
     * should normally return a single foreign key/primary key pair
     * (most tables only import a foreign key from a table once.)  They
     * are ordered by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, and
     * KEY_SEQ.
     *
     * <P>Each foreign key column description has the following columns:
     *  <OL>
     *	<LI><B>PKTABLE_CAT</B> String => primary key table catalog (may be null)
     *	<LI><B>PKTABLE_SCHEM</B> String => primary key table schema (may be null)
     *	<LI><B>PKTABLE_NAME</B> String => primary key table name
     *	<LI><B>PKCOLUMN_NAME</B> String => primary key column name
     *	<LI><B>FKTABLE_CAT</B> String => foreign key table catalog (may be null)
     *      being exported (may be null)
     *	<LI><B>FKTABLE_SCHEM</B> String => foreign key table schema (may be null)
     *      being exported (may be null)
     *	<LI><B>FKTABLE_NAME</B> String => foreign key table name
     *      being exported
     *	<LI><B>FKCOLUMN_NAME</B> String => foreign key column name
     *      being exported
     *	<LI><B>KEY_SEQ</B> short => sequence number within foreign key
     *	<LI><B>UPDATE_RULE</B> short => What happens to
     *       foreign key when primary is updated:
     *      <UL>
     *      <LI> importedKeyCascade - change imported key to agree
     *               with primary key update
     *      <LI> importedKeyRestrict - do not allow update of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been updated
     *      </UL>
     *	<LI><B>DELETE_RULE</B> short => What happens to
     *      the foreign key when primary is deleted.
     *      <UL>
     *      <LI> importedKeyCascade - delete rows that import a deleted key
     *      <LI> importedKeyRestrict - do not allow delete of primary
     *               key if it has been imported
     *      <LI> importedKeySetNull - change imported key to NULL if
     *               its primary key has been deleted
     *      </UL>
     *	<LI><B>FK_NAME</B> String => foreign key identifier (may be null)
     *	<LI><B>PK_NAME</B> String => primary key identifier (may be null)
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name pattern; "" retrieves those
     * without a schema
     * @param table a table name
     * @return ResultSet each row is a foreign key column description
     * @see #getImportedKeys
     */
	public ResultSet getCrossReference(
		String primaryCatalog, String primarySchema, String primaryTable,
		String foreignCatalog, String foreignSchema, String foreignTable
		) throws SQLException {
		    return null;
		}

    /**
     * Get a description of all the standard SQL types supported by
     * this database. They are ordered by DATA_TYPE and then by how
     * closely the data type maps to the corresponding JDBC SQL type.
     *
     * <P>Each type description has the following columns:
     *  <OL>
     *	<LI><B>TYPE_NAME</B> String => Type name
     *	<LI><B>DATA_TYPE</B> short => SQL data type from java.sql.Types
     *	<LI><B>PRECISION</B> int => maximum precision
     *	<LI><B>LITERAL_PREFIX</B> String => prefix used to quote a literal
     *      (may be null)
     *	<LI><B>LITERAL_SUFFIX</B> String => suffix used to quote a literal
            (may be null)
     *	<LI><B>CREATE_PARAMS</B> String => parameters used in creating
     *      the type (may be null)
     *	<LI><B>NULLABLE</B> short => can you use NULL for this type?
     *      <UL>
     *      <LI> typeNoNulls - does not allow NULL values
     *      <LI> typeNullable - allows NULL values
     *      <LI> typeNullableUnknown - nullability unknown
     *      </UL>
     *	<LI><B>CASE_SENSITIVE</B> boolean=> is it case sensitive?
     *	<LI><B>SEARCHABLE</B> short => can you use "WHERE" based on this type:
     *      <UL>
     *      <LI> typePredNone - No support
     *      <LI> typePredChar - Only supported with WHERE .. LIKE
     *      <LI> typePredBasic - Supported except for WHERE .. LIKE
     *      <LI> typeSearchable - Supported for all WHERE ..
     *      </UL>
     *	<LI><B>UNSIGNED_ATTRIBUTE</B> boolean => is it unsigned?
     *	<LI><B>FIXED_PREC_SCALE</B> boolean => can it be a money value?
     *	<LI><B>AUTO_INCREMENT</B> boolean => can it be used for an
     *      auto-increment value?
     *	<LI><B>LOCAL_TYPE_NAME</B> String => localized version of type name
     *      (may be null)
     *	<LI><B>MINIMUM_SCALE</B> short => minimum scale supported
     *	<LI><B>MAXIMUM_SCALE</B> short => maximum scale supported
     *	<LI><B>SQL_DATA_TYPE</B> int => unused
     *	<LI><B>SQL_DATETIME_SUB</B> int => unused
     *	<LI><B>NUM_PREC_RADIX</B> int => usually 2 or 10
     *  </OL>
     *
     * @return ResultSet each row is a SQL type description
     */
	public ResultSet getTypeInfo() throws SQLException {
	    throw new SQLException("getTypeInfo does not implement");
	    //return null;
	}

    /**
     * TYPE NULLABLE - does not allow NULL values.
     */
    int typeNoNulls = 0;

    /**
     * TYPE NULLABLE - allows NULL values.
     */
    int typeNullable = 1;

    /**
     * TYPE NULLABLE - nullability unknown.
     */
    int typeNullableUnknown = 2;

    /**
     * TYPE INFO SEARCHABLE - No support.
     */
	int typePredNone = 0;

    /**
     * TYPE INFO SEARCHABLE - Only supported with WHERE .. LIKE.
     */
	int typePredChar = 1;

    /**
     * TYPE INFO SEARCHABLE -  Supported except for WHERE .. LIKE.
     */
	int typePredBasic = 2;

    /**
     * TYPE INFO SEARCHABLE - Supported for all WHERE ...
     */
	int typeSearchable  = 3;

    /**
     * Get a description of a table's indices and statistics. They are
     * ordered by NON_UNIQUE, TYPE, INDEX_NAME, and ORDINAL_POSITION.
     *
     * <P>Each index column description has the following columns:
     *  <OL>
     *	<LI><B>TABLE_CAT</B> String => table catalog (may be null)
     *	<LI><B>TABLE_SCHEM</B> String => table schema (may be null)
     *	<LI><B>TABLE_NAME</B> String => table name
     *	<LI><B>NON_UNIQUE</B> boolean => Can index values be non-unique?
     *      false when TYPE is tableIndexStatistic
     *	<LI><B>INDEX_QUALIFIER</B> String => index catalog (may be null);
     *      null when TYPE is tableIndexStatistic
     *	<LI><B>INDEX_NAME</B> String => index name; null when TYPE is
     *      tableIndexStatistic
     *	<LI><B>TYPE</B> short => index type:
     *      <UL>
     *      <LI> tableIndexStatistic - this identifies table statistics that are
     *           returned in conjuction with a table's index descriptions
     *      <LI> tableIndexClustered - this is a clustered index
     *      <LI> tableIndexHashed - this is a hashed index
     *      <LI> tableIndexOther - this is some other style of index
     *      </UL>
     *	<LI><B>ORDINAL_POSITION</B> short => column sequence number
     *      within index; zero when TYPE is tableIndexStatistic
     *	<LI><B>COLUMN_NAME</B> String => column name; null when TYPE is
     *      tableIndexStatistic
     *	<LI><B>ASC_OR_DESC</B> String => column sort sequence, "A" => ascending,
     *      "D" => descending, may be null if sort sequence is not supported;
     *      null when TYPE is tableIndexStatistic
     *	<LI><B>CARDINALITY</B> int => When TYPE is tableIndexStatisic then
     *      this is the number of rows in the table; otherwise it is the
     *      number of unique values in the index.
     *	<LI><B>PAGES</B> int => When TYPE is  tableIndexStatisic then
     *      this is the number of pages used for the table, otherwise it
     *      is the number of pages used for the current index.
     *	<LI><B>FILTER_CONDITION</B> String => Filter condition, if any.
     *      (may be null)
     *  </OL>
     *
     * @param catalog a catalog name; "" retrieves those without a catalog
     * @param schema a schema name pattern; "" retrieves those without a schema
     * @param table a table name
     * @param unique when true, return only indices for unique values;
     *     when false, return indices regardless of whether unique or not
     * @param approximate when true, result is allowed to reflect approximate
     *     or out of data values; when false, results are requested to be
     *     accurate
     * @return ResultSet each row is an index column description
     */
	public ResultSet getIndexInfo(String catalog, String schema, String table,
			boolean unique, boolean approximate)
					throws SQLException 
  {
    //
    // only support TYPE == tableIndexStatistics
    //
    ResultSet rs = conn.createStatement().executeQuery("show keys from " +
                                                       table);
    ResultSetMetaData rsmd = rs.getMetaData ();
    int colNum = rsmd.getColumnCount();
    //
    // change the column name to the JDBC standard name.
    //
    String[] colName = new String[colNum];
    int i;
    for (i=1; i<=colNum; ++i)
    {
      colName[i-1] = rsmd.getColumnName(i);
    //  System.out.println("Old Name: " + colName[i-1]);
    }
    colName[0] = new String("TABLE_NAME"); // JDBC ask for
    colName[1] = new String("NON_UNIQUE"); // JDBC ask for
    colName[2] = new String("INDEX_NAME"); // JDBC ask for
    colName[3] = null; 
    colName[4] = new String("COLUMN_NAME"); // JDBC ask for
    colName[5] = new String("ASC_OR_DESC"); // JDBC ask for
    colName[6] = new String("CARDINALITY"); // JDBC ask for
    colName[7] = new String("PAGES"); // JDBC ask for
    ((gweMysqlResultSet)rs).modifyColumnHead(colName);

    //
    // Create pseudo column
    //
    // In mysql, SQL command "show keys from table" get 8 column 
    // There are 7 column be needed and the other 6 columns need 
    // be created as pseudo column.
    //
    colName = new String[6];
    int[] colType = new int[6];
    String[] colValue = new String[6];
    int[] realColMap = new int[colNum];
    int[] pseudoColMap = new int[6];
    int[] pseudoColMode = new int[6];
    //
    // the position in the logic view
    //     0             1           2          3           4       
    //  TABLE_CAT  TABLE_SCHEM  TABLE_NAME  NON_UNIQUE  INDEX_QUALIFIER 
    //   ps-fix       ps-fix       real        real        ps-fix    
    //
    //     5         6            7              8          9
    //  INDEX_NAME  TYPE  ORDINAL_POSITION  COLUMN_NAME ASC_OR_DESC
    //    real      ps-fix     ps-fix           real       real
    //
    //    10          11           12
    //  CARDINALITY  PAGES  FILTER_CONDITION
    //   real         real      ps-fix
    //
    realColMap[0] = 2;
    realColMap[1] = 3;
    realColMap[2] = 5;
    realColMap[3] = -1;
    realColMap[4] = 8;
    realColMap[5] = 9;
    realColMap[6] = 10;
    realColMap[7] = 11;
    pseudoColMap[0] = 0;
    pseudoColMap[1] = 1;
    pseudoColMap[2] = 4;
    pseudoColMap[3] = 6;
    pseudoColMap[4] = 7;
    pseudoColMap[5] = 12;
    colName[0] = new String("TABLE_CAT");
    colName[1] = new String("TABLE_SCHEM");
    colName[2] = new String("INDEX_QUALIFIER");
    colName[3] = new String("TYPE");
    colName[4] = new String("ORDINAL_POSITION");
    colName[5] = new String("FILTER_CONDITION");
    colType[0] = 6; // for NULL
    colType[1] = 6; // for NULL
    colType[2] = 6; // for NULL
    colType[3] = 2; // for NULL
    colType[4] = 2; // for NULL
    colType[5] = 6; // for NULL
    colValue[0] = null;
    colValue[1] = null;
    colValue[2] = null;
    colValue[3] = new String(new StringBuffer().append(0)); // for tableIndexStatistics
    colValue[4] = new String(new StringBuffer().append(0));
    colValue[5] = null;
    pseudoColMode[0] = -1; // for pseudo fix column
    pseudoColMode[1] = -1;
    pseudoColMode[2] = -1; // for pseudo fix column
    pseudoColMode[3] = -1; // for pseudo fix column
    pseudoColMode[4] = -1;
    pseudoColMode[5] = -1;
    pseudoColMode[5] = -1;

    ((gweMysqlResultSet)rs).addPseudoColumn(table, realColMap, pseudoColMap,
      colName, colType, colValue, pseudoColMode);

    if (unique == true)
    {
      int filterColPos = 1;
      String filterString = new String("0");
      ((gweMysqlResultSet)rs).setRowFilter(filterColPos, filterString);
    }

    return rs;
        }

    /**
     * INDEX INFO TYPE - this identifies table statistics that are
     * returned in conjuction with a table's index descriptions
     */
	short tableIndexStatistic = 0;

    /**
     * INDEX INFO TYPE - this identifies a clustered index
     */
	short tableIndexClustered = 1;

    /**
     * INDEX INFO TYPE - this identifies a hashed index
     */
	short tableIndexHashed    = 2;

    /**
     * INDEX INFO TYPE - this identifies some other form of index
     */
	short tableIndexOther     = 3;

}

