#ifndef MYSQLSERVER_H
#define MYSQLSERVER_H

#include <kmysql/ISqlServer.h>
#include "MySql++.h"
#include <qstring.h>

class MySqlServer : public ISqlServer
  {
  public:
  	MySqlServer(void);
    virtual ~MySqlServer(void);
    QueryResult connect(QString, QString, QString);
    void close(void);
    QueryResult selectBase(QString);
    QueryResult getBases(void);
    QueryResult getTables(QString, QString = 0);
    QueryResult query(QString);
    QueryResult createBase(QString);
    QueryResult dropBase(QString);
    QueryResult reload(void);
    QueryResult shutdown(void);
    QString serverInfo(void);
    bool isConnected(void) { return connected; }
    IObject *queryInterface(UIID);
  private:
    MySqlClient mysql;	
    bool connected;
  };


#endif
