// -*-Mode: C++;-*-  
/*
 * $Id: TableView.h,v 2.6 1999/11/07 15:42:05 ral Exp $
 */

#ifndef CTableView_included
#define CTableView_included

#include "TableViewData.h"
#include <qlist.h>
#include "tabledescr.h"
#include <qmsgbox.h>
#include "PatternPair.h"
#include "stringlist.h"

class CMySql;

class CTableView : public CTableViewData
{
    Q_OBJECT

public:

    CTableView (CMySql*_sql_server,QWidget* parent = NULL, const char* name = NULL);

    virtual ~CTableView();
protected slots:
    void MakeRequest();
    void OffsetSet(int);
    void CountSet(int);
    void db_select(int);
    void table_select(int);
    void search_rows();
    void entrySelected(int);
    void entrySelected(int col,int){entrySelected(col);}
    void addRow();
    void OutputSelected(int);
    void modifyRow();
    void delete_row();
    void emptyTable();
    void saveResult();

public slots:
    void show();
    void RefreshLists();

protected:
    CMySql*sql_server;
    ColumnList Current_Table_Fields;
    ColumnList Current_Displayed_Fields;
    KeyList CurrentKeys;
    stringlist SelectFields;
 
    void set_buttons(bool how);
    bool KeyDisplayed();
    CColumnDescriptor*FindTableItem(const char*what,bool all_fields=true);
    int BreakIntoParts(PatternList*BreakList,PatternList*KeyList=0,
		       int count = -1,bool no_auto_filter = false);
    void saveAscii(const char*filename);
    void saveHtml(const char*filename);
    void saveLatex(const char*filename);
    
    void build_relevant_keys();
    void _make_fetch_request(bool search_it=false);
};

#endif // CTableView_included
