#include "TextViewData.h"

#ifndef rcsid
static const char rcsid[]="$Id: TextViewData.cpp,v 2.3 1999/10/13 00:51:20 ral Exp $";
//const char*textviewdata_rcs(){return rcsid;}
#endif

#define Inherited QDialog

#include <kapp.h>
#include <qlayout.h>

CTextViewData::CTextViewData(QWidget* parent,const char* name)
	:Inherited( parent, name, FALSE, WStyle_NormalBorder|WStyle_Title|WStyle_SysMenu
		   |WStyle_Minimize|WStyle_Maximize)
{
	OutputArea = new QMultiLineEdit( this, "OutputArea" );
	OutputArea->setGeometry( 0, 0, 454, 156 );
	OutputArea->setMinimumSize( 10, 10 );
	OutputArea->setMaximumSize( 32767, 32767 );
	OutputArea->setReadOnly( TRUE );
	OutputArea->setOverwriteMode( FALSE );

	ClearButton = new QPushButton( this, "ClearButton" );
	ClearButton->setGeometry( 0, 0, 151, 25 );
	ClearButton->setMinimumSize( 10, 25 );
	ClearButton->setMaximumSize( 32767, 25 );
	connect( ClearButton, SIGNAL(clicked()), OutputArea, SLOT(clear()) );
	ClearButton->setText( i18n("Clear Output") );
	ClearButton->setAutoRepeat( FALSE );
	ClearButton->setAutoResize( FALSE );

	RefreshButton = new QPushButton( this, "RefreshButton" );
	RefreshButton->setGeometry( 151, 0, 152, 25 );
	RefreshButton->setMinimumSize( 10, 25 );
	RefreshButton->setMaximumSize( 32767, 25 );
	connect( RefreshButton, SIGNAL(clicked()), SLOT(RefreshOutput()) );
	RefreshButton->setText( i18n("Refresh") );
	RefreshButton->setAutoRepeat( FALSE );
	RefreshButton->setAutoResize( FALSE );

	CloseButton = new QPushButton( this, "CloseButton" );
	CloseButton->setGeometry( 303, 0, 151, 25 );
	CloseButton->setMinimumSize( 10, 25 );
	CloseButton->setMaximumSize( 32767, 25 );
	connect( CloseButton, SIGNAL(clicked()), SLOT(accept()) );
	CloseButton->setText( i18n("Close") );
	CloseButton->setAutoRepeat( FALSE );
	CloseButton->setAutoResize( FALSE );

	QBoxLayout* dlgedit_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 3, 3, NULL );
	dlgedit_layout_1->addStrut( 0 );
	QBoxLayout* dlgedit_layout_1_1 = new QBoxLayout( QBoxLayout::TopToBottom, 0, NULL );
	dlgedit_layout_1->addLayout( dlgedit_layout_1_1, 1 );
	dlgedit_layout_1_1->addStrut( 0 );
	dlgedit_layout_1_1->addWidget( OutputArea, 1, 36 );

	QBoxLayout* dlgedit_layout_1_2 = new QBoxLayout( QBoxLayout::LeftToRight, 0, NULL );
	dlgedit_layout_1->addLayout( dlgedit_layout_1_2, 0 );
	dlgedit_layout_1_2->addStrut( 0 );
	dlgedit_layout_1_2->addWidget( ClearButton, 1, 36 );
	dlgedit_layout_1_2->addWidget( RefreshButton, 1, 36 );
	dlgedit_layout_1_2->addWidget( CloseButton, 1, 36 );


	resize( 460,190 );
	setMinimumSize( 250, 170 );
	setMaximumSize( 32767, 32767 );
}


CTextViewData::~CTextViewData()
{
}
void CTextViewData::RefreshOutput()
{
}
void CTextViewData::clear()
{
}
