// -*- Mode: C++; -*-
// $Id: change_type.h,v 2.5 1999/10/16 04:18:31 ral Exp $

#include "pairs.h"
#include "liste.h"
#include "stringlist.h"
#include "specials.h"

#ifndef change_type_included
#define change_type_included

struct change_type : public string_pair{
    enum c_type{none,add,mod,del};
    string_pair columns;
    c_type typ;

    change_type():columns(){typ = none;}
};

typedef my_vector<change_type> base_change_list;

class change_list:public base_change_list
{

public:
    iterator find_second(const change_type&what,iterator start_pos=0);
    iterator find(const change_type&what,iterator start_pos=0);
    
    iterator find_second(const std::string&what,iterator start_pos=0);
    iterator find(const std::string&what,iterator start_pos=0);

    iterator find_second(const char*what,iterator start_pos=0);
    iterator find(const char*what,iterator start_pos=0);
};

inline change_list::iterator
change_list::find_second(const change_type&what,const iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.columns.second.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find(const change_type&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.columns.first.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find_second(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.second.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find(const std::string&what,iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for (;_search_pos<end();++_search_pos) {
	if (strcasecmp(_search_pos->columns.first.c_str(),what.c_str()) == 0) {
	    return _search_pos;
	}
    }
    return 0;
}

inline change_list::iterator
change_list::find_second(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find_second(t);
}

inline change_list::iterator
change_list::find(const char*what,iterator start_pos)
{
    std::string t =what?what:"";
    return find(t);
}

#endif
