#ifndef rcsid
static const char rcsid[]="$Id: compoundkeydlg.cpp,v 2.10 1999/10/16 16:23:16 ral Exp $";
//const char*compoundkeydlg_rcs(){return rcsid;}
#endif

#include <qpixmap.h>

#include "compoundkeydlg.h"
#include "pfeile.h"
#include "qmessagebox.h"
#include "kapp.h"

#define Inherited CCompoundKeyData

CCompoundKeyDlg::CCompoundKeyDlg(QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    setCaption( "Create compound key" );
    QPixmap Icon;
    Icon.loadFromData(pfeil1_xbm_data,pfeil1_xbm_len);
    ToKeyButton->setPixmap(Icon);
    Icon.loadFromData(pfeil2_xbm_data,pfeil2_xbm_len);
    FromKeyButton->setPixmap(Icon);
    int_col_list = 0;
    int_key_list = 0;
    CurrentKey=0;
    AddKeyButton->setEnabled(FALSE);
    DeleteKeyButton->setEnabled(FALSE);
    ToKeyButton->setEnabled(FALSE);
    FromKeyButton->setEnabled(FALSE);
}

CCompoundKeyDlg::~CCompoundKeyDlg()
{
}

void CCompoundKeyDlg::set_Columns(ColumnList*col_list,KeyList*key_list)
{
    int_col_list = col_list;
    int_key_list = key_list;
    KeyList_iterator key_iterator;
    if (!col_list || !key_list)
	return;
    for (key_iterator = int_key_list->begin();key_iterator != int_key_list->end();++key_iterator) {
	if (key_iterator->is_compound()) {
	    KeysList->insertItem(key_iterator->get_name());
	}
    }
    ColumnList_iterator col_iterator;
    for (col_iterator = int_col_list->begin();col_iterator != int_col_list->end();++col_iterator) {
	TableColumns->insertItem(col_iterator->get_name());
    }
}

void CCompoundKeyDlg::AddKey()
{
    QString name;
    name = KeyNameEdit->text();
    CKeyDescriptor temp_key;

    if (name.isEmpty())
	return;
    temp_key.set_name(name);

    if (int_key_list->find(temp_key)) {
	QString info;
	info = i18n("The key");
	info+=" ";
	info+=name;
	info+=" ";
	info+=i18n("is already in the keylist");
	QMessageBox::warning(this,i18n("Adding key"),info);
	return;
    }
    temp_key.set_compound(true);
    int_key_list->push_back(temp_key);
    CurrentKey = int_key_list->end()-1;
    KeysList->insertItem(name);
    
    KeysList->setCurrentItem(KeysList->count()-1);
    UniqueSelected();
    UniqueType->setChecked(TRUE);
}

void CCompoundKeyDlg::DeleteKey()
{
    if (!CurrentKey)
	return;
    CKeyDescriptor* find_key;
    QString name;
    int pos;
    pos = KeysList->currentItem();
    if (pos == -1)
	return;
    name = KeysList->text(pos);
    if (name.isEmpty())
	return;
    KeyList_iterator key_iterator;
    for (key_iterator = int_key_list->begin(); key_iterator != int_key_list->end();++key_iterator) {
	find_key = key_iterator;
	if (*find_key == name) {
	    key_iterator = int_key_list->erase(key_iterator);
	    KeysList->removeItem(pos);
	    return;
	}
    }
}

void CCompoundKeyDlg::KeyTextReturn()
{
    if (AddKeyButton->isEnabled() == FALSE)
	return;
    AddKey();
}

void CCompoundKeyDlg::IndexSelected()
{
    if (!CurrentKey)
	return;
    CurrentKey->setType(CKeyDescriptor::INDEX);
    PrimaryType->setChecked(FALSE);
    UniqueType->setChecked(FALSE);
}

void CCompoundKeyDlg::UniqueSelected()
{
    if (!CurrentKey)
	return;
    CurrentKey->setType(CKeyDescriptor::UNIQUE);
    PrimaryType->setChecked(FALSE);
    IndexType->setChecked(FALSE);
}

void CCompoundKeyDlg::KeyFieldSelected(int which)
{
    CurrentKey = 0;
    KeyColumns->clear();
    DeleteKeyButton->setEnabled(FALSE); 
    if (which < 0) {
	return;
    }
    QString Item;
    Item = KeysList->text(which);
    if (Item.length() == 0)
	return;
    KeyList_iterator key_iterator;
    for (key_iterator = int_key_list->begin();key_iterator != int_key_list->end();++key_iterator) {
	if (*key_iterator == Item.data()) {
	    break;
	}
    }
    CurrentKey = key_iterator;
    if (key_iterator == int_key_list->end()) {
	CurrentKey = 0;
	return;
    }
    DeleteKeyButton->setEnabled(TRUE);
    switch(key_iterator->getType()) {
    case CKeyDescriptor::PRIMARY:
	PrimaryType->setChecked(TRUE);
	UniqueType->setChecked(FALSE);
	IndexType->setChecked(FALSE);
	break;
    case CKeyDescriptor::UNIQUE:
	PrimaryType->setChecked(FALSE);
	UniqueType->setChecked(TRUE);
	IndexType->setChecked(FALSE);
	break;
    case CKeyDescriptor::INDEX:
	PrimaryType->setChecked(FALSE);
	UniqueType->setChecked(FALSE);
	IndexType->setChecked(TRUE);
	break;
    default:
	PrimaryType->setChecked(FALSE);
	UniqueType->setChecked(FALSE);
	IndexType->setChecked(FALSE);
	break;
    }
    if (key_iterator->column_count() != 0) {
	pairIlist col_list = key_iterator->get_ColList();
	pairIlist::iterator iter = col_list.begin();
	for (;iter!=col_list.end();++iter) {
	    KeyColumns->insertItem(iter->first.c_str());
	}
    }
    int i = TableColumns->currentItem();
    TableColumnsSelected(i);
}

void CCompoundKeyDlg::TableColumnsSelected(int which)
{
    if (which < 0 || !CurrentKey) {
	ToKeyButton->setEnabled(FALSE);
	return;
    }
    QString text;
    text = TableColumns->text(which);
    for (unsigned int i = 0; i < KeyColumns->count();i++){
	if (strcasecmp(text,KeyColumns->text(i)) == 0) {
	    ToKeyButton->setEnabled(FALSE);
	    return;
	}
    }
    ToKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::KeyColumnsSelected(int which)
{
    if (!CurrentKey || which <0) {
	FromKeyButton->setEnabled(FALSE);
	return;
    }
    FromKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::AddToKey()
{
    if (!CurrentKey)
	return;
    int pos;
    QString text;
    pos = TableColumns->currentItem();
    if (pos == -1)
	return;
    text = TableColumns->text(pos);
    if (CurrentKey->contains_column_name(text))
	return;
    KeyColumns->insertItem(text);
    CurrentKey->add_column_name(text);
}

void CCompoundKeyDlg::KeyNameChanged(const char*text)
{
    if (!text || strlen(text) == 0) {
	AddKeyButton->setEnabled(FALSE);
	return;
    }
    for (unsigned int i = 0; i < KeysList->count();i++){
	if (strcasecmp(text,KeysList->text(i)) == 0) {
	    AddKeyButton->setEnabled(FALSE);
	    return;
	}
    }
    AddKeyButton->setEnabled(TRUE);
}

void CCompoundKeyDlg::PrimarySelected()
{
    if (!CurrentKey)
	return;
    CurrentKey->setType(CKeyDescriptor::PRIMARY);
    UniqueType->setChecked(FALSE);
    IndexType->setChecked(FALSE);
}

void CCompoundKeyDlg::RemoveFromKey()
{
    if (!CurrentKey)
	return;
    int pos;
    QString text;
    pos = KeyColumns->currentItem();
    if (pos == -1)
	return;
    text = KeyColumns->text(pos);
    KeyColumns->removeItem(pos);
    CurrentKey->remove_column_name(text);
}
