//-*-Mode: C++;-*-
/*
 * $Id: granttable.h,v 2.6 1999/11/07 15:42:05 ral Exp $
 */

#ifndef CGrantTable_included
#define CGrantTable_included

#include "granttabledata.h"
#include "PatternPair.h"
#include <qlist.h>
#include "stringlist.h"

class CMySql;

class CGrantTable : public CGrantTableData
{
    Q_OBJECT

public:
    CGrantTable(CMySql*_sql_server,QWidget* parent = NULL,const char* name = NULL);
    virtual ~CGrantTable();
    virtual void show();

protected slots:
    void hosthilighted(int);
    void userhilighted(int);
    void dbhighlighted(int);
    void hostselected(int);
    void userselected(int);
    void dbselected(int);
    void ModifyUser();
    void ModifyHost();
    void ModifyDb();
    void AddHost();
    void AddUser();
    void AddDb();
    void Refresh();
    void DeleteUser();
    void DeleteHost();
    void DeleteDb();

protected:
    CMySql*sql_server;
    void ReadHostTable();
    void ReadUserTable(const char*Host);
    void ReadDBTable(const char*Host,const char*User);
    void DisableButtons();
    void append_Sel(stringlist*List);
    void append_Add(PatternList*List);
    void pass_error();
    void user_error();
    int Ask_delete();
    void Error();
    void UpdateGrants(int count);
    PatternList*break_dbstring();
    PatternList*break_userstring();
    PatternList*break_hoststring();

    static const char*Se_Str;
    static const char*In_Str;
    static const char*Up_Str;
    static const char*De_Str;
    static const char*Cr_Str;
    static const char*Dr_Str;
    static const char*Re_Str;
    static const char*Sh_Str;
    static const char*Pr_Str;
    static const char*Fi_Str;
    static const char*No;
    
    static const char*DB_Name;
    static const char*Host_Table;
    static const char*User_Table;
    static const char*DB_Table;
    static const char*Pass_Entry;
    static const char*Host_Title;
    
    const char* User_Title;
    const char* DB_Title;
    const char* P_Title;
    const char* P2_Title;
};
#endif // CGrantTable_included
