/*
 * MM JDBC Drivers for MySQL
 *
 * $Id: Statement.java,v 1.2 1998/08/25 00:53:48 mmatthew Exp $
 *
 * Copyright (C) 1998 Mark Matthews <mmatthew@worldserver.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * See the COPYING file located in the top-level-directory of
 * the archive of this library for complete text of license.
 *
 * Some portions:
 *
 * Copyright (c) 1996 Bradley McLean / Jeffrey Medeiros
 * Modifications Copyright (c) 1996/1997 Martin Rode
 * Copyright (c) 1997 Peter T Mount
 */

/**
 * A Statement object is used for executing a static SQL statement and
 * obtaining the results produced by it.
 *
 * <p>Only one ResultSet per Statement can be open at any point in time.
 * Therefore, if the reading of one ResultSet is interleaved with the
 * reading of another, each must have been generated by different
 * Statements.  All statement execute methods implicitly close a
 * statement's current ResultSet if an open one exists.
 *
 * @see java.sql.Statement
 * @see ResultSet
 * @author Mark Matthews <mmatthew@worldserver.com>
 * @version $Id$
 */

package org.gjt.mm.mysql.jdbc2;

import java.sql.*;

public class Statement extends org.gjt.mm.mysql.Statement 
    implements java.sql.Statement
{
    /**
     * Constructor for a Statement.  It simply sets the connection
     * that created us.
     *
     * @param c the Connection instantation that creates us
     */

    public Statement(Connection C, String Catalog)
    {
	super(C, Catalog);
    }

    /**
     * Execute a SQL statement that retruns a single ResultSet
     *
     * @param Sql typically a static SQL SELECT statement
     * @return a ResulSet that contains the data produced by the query
     * @exception java.sql.SQLException if a database access error occurs
     */

    public java.sql.ResultSet executeQuery(String Sql) throws java.sql.SQLException
    {
	return super.executeQuery(Sql);
    }

    /**
     * Execute a SQL INSERT, UPDATE or DELETE statement.  In addition
     * SQL statements that return nothing such as SQL DDL statements
     * can be executed
     *
     * Any IDs generated for AUTO_INCREMENT fields can be retrieved
     * by casting this Statement to org.gjt.mm.mysql.Statement and
     * calling the getLastInsertID() method.
     *
     * @param Sql a SQL statement
     * @return either a row count, or 0 for SQL commands
     * @exception java.sql.SQLException if a database access error occurs
     */

    public int executeUpdate(String Sql) throws java.sql.SQLException
    {
	return super.executeUpdate(Sql);
    }

    /**
     * Execute a SQL statement that may return multiple results. We
     * don't have to worry about this since we do not support multiple
     * ResultSets.   You can use getResultSet or getUpdateCount to
     * retrieve the result.
     *
     * @param sql any SQL statement
     * @return true if the next result is a ResulSet, false if it is
     *      an update count or there are no more results
     * @exception java.sql.SQLException if a database access error occurs
     */

    public boolean execute(String Sql) throws java.sql.SQLException
    {
	return super.execute(Sql);
    }
};
